/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.impexp;

import java.util.HashMap;
import java.util.Properties;
import org.adempiere.impexp.AbstractExcelExporter;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.Lookup;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.util.Env;

public class GridTabExcelExporter
extends AbstractExcelExporter {
    private GridTab m_tab = null;
    private HashMap<String, MLookup> m_buttonLookups = new HashMap();

    public GridTabExcelExporter(Properties ctx, GridTab tab) {
        this.m_tab = tab;
        this.setFreezePane(0, 1);
    }

    public GridTabExcelExporter(Properties ctx, GridTab tab, boolean isXLSX) {
        this.m_tab = tab;
        this.isXLSX = isXLSX;
        this.setFreezePane(0, 1);
    }

    @Override
    public int getColumnCount() {
        return this.m_tab.getFieldCount();
    }

    @Override
    public int getDisplayType(int row, int col) {
        return this.m_tab.getField(col).getDisplayType();
    }

    @Override
    public String getHeaderName(int col) {
        return this.m_tab.getField(col).getHeader();
    }

    @Override
    public String getFormatPattern(int col) {
        return null;
    }

    @Override
    public int getRowCount() {
        return this.m_tab.getRowCount();
    }

    @Override
    public Object getValueAt(int row, int col) {
        Object key;
        GridField f = this.m_tab.getField(col);
        Object value = key = this.m_tab.getValue(row, f.getColumnName());
        Lookup lookup = f.getLookup();
        if (lookup == null && f.getDisplayType() == 28) {
            lookup = this.getButtonLookup(f);
        }
        if (lookup != null) {
            value = lookup.getDisplay(key);
        }
        return value;
    }

    @Override
    public boolean isColumnPrinted(int col) {
        GridField f = this.m_tab.getField(col);
        if (!f.isDisplayed() || !f.isDisplayedGrid()) {
            return false;
        }
        if (f.isEncrypted()) {
            return false;
        }
        return f.getDisplayType() != 28 || f.getAD_Reference_Value_ID() != 0;
    }

    @Override
    public boolean isFunctionRow() {
        return false;
    }

    @Override
    public boolean isPageBreak(int row, int col) {
        return false;
    }

    @Override
    protected void setCurrentRow(int row) {
    }

    private MLookup getButtonLookup(GridField mField) {
        MLookup lookup = this.m_buttonLookups.get(mField.getColumnName());
        if (lookup != null) {
            return lookup;
        }
        if (mField.getColumnName().endsWith("_ID") && !mField.getColumnName().equals("Record_ID")) {
            lookup = MLookupFactory.get(Env.getCtx(), mField.getWindowNo(), 0, mField.getAD_Column_ID(), 30);
        } else if (mField.getAD_Reference_Value_ID() != 0) {
            lookup = MLookupFactory.get(Env.getCtx(), mField.getWindowNo(), 0, mField.getAD_Column_ID(), 17);
        }
        this.m_buttonLookups.put(mField.getColumnName(), lookup);
        return lookup;
    }
}

