/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pdf;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Element;
import com.itextpdf.text.ExceptionConverter;
import com.itextpdf.text.Font;
import com.itextpdf.text.FontFactory;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfPageEventHelper;
import com.itextpdf.text.pdf.PdfTemplate;
import com.itextpdf.text.pdf.PdfWriter;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.logging.Level;
import org.adempiere.pdf.Document;
import org.adempiere.util.StringUtils;
import org.compiere.model.MImage;
import org.compiere.model.ReportTO;
import org.compiere.report.MReportColumn;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class SmjPdfReport
extends PdfPageEventHelper {
    public CLogger log = CLogger.getCLogger(SmjPdfReport.class);
    private ByteArrayOutputStream baosPDF;
    private Font titleFont = new Font(Font.FontFamily.HELVETICA, 15.0f, 3);
    private Font titleTableFont = new Font(Font.FontFamily.HELVETICA, 12.0f, 3);
    private Font catFont = new Font(Font.FontFamily.HELVETICA, 12.0f, 1);
    private Font subFont = new Font(Font.FontFamily.HELVETICA, 10.0f, 0);
    private int cols = 0;
    private LinkedList<ReportTO> data = null;
    private com.itextpdf.text.Document document = null;
    private PdfWriter writer = null;
    private PdfPTable table = null;
    private BaseFont helv;
    private PdfTemplate total;

    public ByteArrayOutputStream generate(LinkedList<ReportTO> dataReport, String nameTrx, String[] generalTitle, String clientName, String clientNIT, String periodName, String currencyName, MReportColumn[] m_columns, String codeFont, String city, Integer logoId) {
        this.baosPDF = new ByteArrayOutputStream();
        this.data = dataReport;
        String[] fontPar = codeFont.split("-");
        Integer lFont = Integer.parseInt(fontPar[2]);
        this.titleFont = FontFactory.getFont((String)fontPar[0], (float)(lFont + 5), (int)3);
        this.titleTableFont = FontFactory.getFont((String)fontPar[0], (float)(lFont + 2), (int)3);
        this.catFont = FontFactory.getFont((String)fontPar[0], (float)(lFont + 2), (int)1);
        this.subFont = FontFactory.getFont((String)fontPar[0], (float)lFont.intValue(), (int)0);
        try {
            this.document = new com.itextpdf.text.Document(PageSize.LETTER, 20.0f, 20.0f, 20.0f, 40.0f);
            this.writer = PdfWriter.getInstance((com.itextpdf.text.Document)this.document, (OutputStream)this.baosPDF);
            this.document.open();
            this.document.addTitle(generalTitle[0]);
            this.document.addAuthor("SmartJSP S.A.S.");
            this.document.addCreator("SmartJSP S.A.S.");
            this.onOpenDocument(this.writer, this.document);
            this.onEndPage(this.writer, this.document);
            if (logoId > 0) {
                MImage mimage = MImage.get(Env.getCtx(), logoId);
                byte[] imageData = mimage.getData();
                Image img = Toolkit.getDefaultToolkit().createImage(imageData);
                com.itextpdf.text.Image logo = com.itextpdf.text.Image.getInstance((Image)img, null);
                logo.scaleToFit(100.0f, 30.0f);
                this.document.add((Element)logo);
            }
            Paragraph genTitle = new Paragraph(this.dataNull(generalTitle[0]).toUpperCase(), this.titleFont);
            genTitle.setAlignment(1);
            this.document.add((Element)genTitle);
            Paragraph clitName = new Paragraph(this.dataNull(clientName).toUpperCase(), this.titleFont);
            clitName.setAlignment(1);
            this.document.add((Element)clitName);
            Paragraph cliCity = new Paragraph(this.dataNull(city).toUpperCase(), this.titleFont);
            cliCity.setAlignment(1);
            this.document.add((Element)cliCity);
            Paragraph cliNIT = new Paragraph(this.dataNull(clientNIT).toUpperCase(), this.titleFont);
            cliNIT.setAlignment(1);
            this.document.add((Element)cliNIT);
            Object pn = "";
            pn = generalTitle[1] != null && generalTitle[1].length() > 0 ? generalTitle[1] + " " + periodName : periodName;
            if (generalTitle[2] != null && generalTitle[2].length() > 0) {
                pn = (String)pn + " " + generalTitle[2];
            }
            Paragraph perName = new Paragraph(this.dataNull((String)pn).toUpperCase(), this.titleTableFont);
            perName.setAlignment(1);
            this.document.add((Element)perName);
            Paragraph currency = new Paragraph(this.dataNull(currencyName), this.titleTableFont);
            currency.setAlignment(1);
            this.addEmptyLine(currency, 2);
            this.document.add((Element)currency);
            this.cols = m_columns.length + 2;
            float[] columnWidths = new float[this.cols];
            columnWidths[0] = 1.0f;
            columnWidths[1] = 3.0f;
            for (int i = 2; i < this.cols; ++i) {
                columnWidths[i] = 1.0f;
            }
            this.table = new PdfPTable(columnWidths);
            PdfPCell cellTitle = new PdfPCell((Phrase)new Paragraph(Msg.translate(Env.getCtx(), "name").toUpperCase(), this.catFont));
            cellTitle.setHorizontalAlignment(2);
            cellTitle.setBackgroundColor(BaseColor.LIGHT_GRAY);
            this.table.addCell(cellTitle);
            cellTitle = new PdfPCell((Phrase)new Paragraph(Msg.translate(Env.getCtx(), "description").toUpperCase(), this.catFont));
            cellTitle.setHorizontalAlignment(0);
            cellTitle.setBackgroundColor(BaseColor.LIGHT_GRAY);
            this.table.addCell(cellTitle);
            for (MReportColumn mcol : m_columns) {
                String colName = mcol.getName();
                cellTitle = new PdfPCell((Phrase)new Paragraph(colName.toUpperCase(), this.catFont));
                cellTitle.setHorizontalAlignment(2);
                cellTitle.setBackgroundColor(BaseColor.LIGHT_GRAY);
                this.table.addCell(cellTitle);
            }
            this.reportTable();
            this.document.add((Element)this.table);
            this.onEndPage(this.writer, this.document);
            this.onCloseDocument(this.writer, this.document);
            this.document.close();
        }
        catch (Exception e) {
            System.out.println("SMpdfReport(generar)ERROR:: al crear el documento PDF");
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
        return this.baosPDF;
    }

    public void reportTable() {
        for (ReportTO rpt : this.data) {
            PdfPCell tableCell;
            if (rpt.getReportlinestyle() != null && rpt.getReportlinestyle().equals("T")) {
                PdfPCell title = new PdfPCell((Phrase)new Paragraph(this.dataNull(rpt.getDescription()), this.titleTableFont));
                title.setColspan(this.cols);
                title.setHorizontalAlignment(1);
                title.setBorder(0);
                this.table.addCell(title);
                continue;
            }
            if (rpt.getReportlinestyle() != null && rpt.getReportlinestyle().equals("L")) {
                PdfPCell line = new PdfPCell((Phrase)new Paragraph("", this.subFont));
                line.setColspan(this.cols);
                line.setBorderWidthLeft(0.0f);
                line.setBorderWidthRight(0.0f);
                line.setBorderWidthTop(0.0f);
                line.setBorderColorBottom(BaseColor.BLACK);
                this.table.addCell(line);
                continue;
            }
            if (rpt.getReportlinestyle() != null && rpt.getReportlinestyle().equals("X")) {
                this.simpleLine();
                continue;
            }
            if (rpt.getReportlinestyle() != null && rpt.getReportlinestyle().equals("Z")) {
                for (int j = 0; j < 2; ++j) {
                    this.simpleLine();
                }
                continue;
            }
            if (rpt.getReportlinestyle() != null && rpt.getReportlinestyle().equals("D")) {
                tableCell = new PdfPCell(new Phrase(""));
                tableCell.setBorder(0);
                this.table.addCell(tableCell);
                tableCell = new PdfPCell(new Phrase(""));
                tableCell.setBorderWidthLeft(0.0f);
                tableCell.setBorderWidthRight(0.0f);
                tableCell.setBorderWidthTop(0.0f);
                tableCell.setBorderColorBottom(BaseColor.BLACK);
                this.table.addCell(tableCell);
                for (int i = 0; i < this.cols - 2; ++i) {
                    tableCell = new PdfPCell(new Phrase(""));
                    tableCell.setBorder(0);
                    this.table.addCell(tableCell);
                }
                continue;
            }
            if (rpt.getReportlinestyle() != null && rpt.getReportlinestyle().equals("S")) {
                PdfPCell line = new PdfPCell((Phrase)new Paragraph("         "));
                line.setColspan(this.cols);
                line.setBorder(0);
                this.table.addCell(line);
                continue;
            }
            if (rpt.getTablevel() != null && rpt.getTablevel() > 0) {
                Object jerarchy = "";
                for (int i = 1; i <= rpt.getTablevel(); ++i) {
                    jerarchy = (String)jerarchy + "   ";
                }
                PdfPCell line = new PdfPCell((Phrase)new Paragraph((String)jerarchy + this.dataNull(rpt.getDescription()), this.catFont));
                line.setColspan(this.cols);
                line.setHorizontalAlignment(0);
                line.setBorder(0);
                this.table.addCell(line);
                continue;
            }
            if (rpt.getDescription() == null) continue;
            tableCell = new PdfPCell(new Phrase(this.dataNull(rpt.getName()), this.subFont));
            tableCell.setBorder(0);
            tableCell.setHorizontalAlignment(0);
            this.table.addCell(tableCell);
            tableCell = new PdfPCell(new Phrase(this.dataNull(rpt.getDescription()), this.subFont));
            tableCell.setBorder(0);
            this.table.addCell(tableCell);
            if (this.cols >= 3) {
                tableCell = new PdfPCell(new Phrase(this.formatValue(rpt.getCol_0()), this.subFont));
                tableCell.setBorder(0);
                tableCell.setHorizontalAlignment(2);
                this.table.addCell(tableCell);
            }
            if (this.cols >= 4) {
                tableCell = new PdfPCell(new Phrase(this.formatValue(rpt.getCol_1()), this.subFont));
                tableCell.setBorder(0);
                tableCell.setHorizontalAlignment(2);
                this.table.addCell(tableCell);
            }
            if (this.cols >= 5) {
                tableCell = new PdfPCell(new Phrase(this.formatValue(rpt.getCol_2()), this.subFont));
                tableCell.setBorder(0);
                tableCell.setHorizontalAlignment(2);
                this.table.addCell(tableCell);
            }
            if (this.cols >= 6) {
                tableCell = new PdfPCell(new Phrase(this.formatValue(rpt.getCol_3()), this.subFont));
                tableCell.setBorder(0);
                tableCell.setHorizontalAlignment(2);
                this.table.addCell(tableCell);
            }
            if (this.cols >= 7) {
                tableCell = new PdfPCell(new Phrase(this.formatValue(rpt.getCol_4()), this.subFont));
                tableCell.setBorder(0);
                tableCell.setHorizontalAlignment(2);
                this.table.addCell(tableCell);
            }
            if (this.cols >= 8) {
                tableCell = new PdfPCell(new Phrase(this.formatValue(rpt.getCol_5()), this.subFont));
                tableCell.setBorder(0);
                tableCell.setHorizontalAlignment(2);
                this.table.addCell(tableCell);
            }
            if (this.cols >= 9) {
                tableCell = new PdfPCell(new Phrase(this.formatValue(rpt.getCol_6()), this.subFont));
                tableCell.setBorder(0);
                tableCell.setHorizontalAlignment(2);
                this.table.addCell(tableCell);
            }
            if (this.cols >= 10) {
                tableCell = new PdfPCell(new Phrase(this.formatValue(rpt.getCol_7()), this.subFont));
                tableCell.setBorder(0);
                tableCell.setHorizontalAlignment(2);
                this.table.addCell(tableCell);
            }
            if (this.cols >= 11) {
                tableCell = new PdfPCell(new Phrase(this.formatValue(rpt.getCol_8()), this.subFont));
                tableCell.setBorder(0);
                tableCell.setHorizontalAlignment(2);
                this.table.addCell(tableCell);
            }
            if (this.cols >= 12) {
                tableCell = new PdfPCell(new Phrase(this.formatValue(rpt.getCol_9()), this.subFont));
                tableCell.setBorder(0);
                tableCell.setHorizontalAlignment(2);
                this.table.addCell(tableCell);
            }
            if (this.cols >= 13) {
                tableCell = new PdfPCell(new Phrase(this.formatValue(rpt.getCol_10()), this.subFont));
                tableCell.setBorder(0);
                tableCell.setHorizontalAlignment(2);
                this.table.addCell(tableCell);
            }
            if (this.cols >= 14) {
                tableCell = new PdfPCell(new Phrase(this.formatValue(rpt.getCol_11()), this.subFont));
                tableCell.setBorder(0);
                tableCell.setHorizontalAlignment(2);
                this.table.addCell(tableCell);
            }
            if (this.cols >= 15) {
                tableCell = new PdfPCell(new Phrase(this.formatValue(rpt.getCol_12()), this.subFont));
                tableCell.setBorder(0);
                tableCell.setHorizontalAlignment(2);
                this.table.addCell(tableCell);
            }
            if (this.cols >= 16) {
                tableCell = new PdfPCell(new Phrase(this.formatValue(rpt.getCol_13()), this.subFont));
                tableCell.setBorder(0);
                tableCell.setHorizontalAlignment(2);
                this.table.addCell(tableCell);
            }
            if (this.cols >= 17) {
                tableCell = new PdfPCell(new Phrase(this.formatValue(rpt.getCol_14()), this.subFont));
                tableCell.setBorder(0);
                tableCell.setHorizontalAlignment(2);
                this.table.addCell(tableCell);
            }
            if (this.cols >= 18) {
                tableCell = new PdfPCell(new Phrase(this.formatValue(rpt.getCol_15()), this.subFont));
                tableCell.setBorder(0);
                tableCell.setHorizontalAlignment(2);
                this.table.addCell(tableCell);
            }
            if (this.cols >= 19) {
                tableCell = new PdfPCell(new Phrase(this.formatValue(rpt.getCol_16()), this.subFont));
                tableCell.setBorder(0);
                tableCell.setHorizontalAlignment(2);
                this.table.addCell(tableCell);
            }
            if (this.cols >= 20) {
                tableCell = new PdfPCell(new Phrase(this.formatValue(rpt.getCol_17()), this.subFont));
                tableCell.setBorder(0);
                tableCell.setHorizontalAlignment(2);
                this.table.addCell(tableCell);
            }
            if (this.cols >= 21) {
                tableCell = new PdfPCell(new Phrase(this.formatValue(rpt.getCol_18()), this.subFont));
                tableCell.setBorder(0);
                tableCell.setHorizontalAlignment(2);
                this.table.addCell(tableCell);
            }
            if (this.cols >= 22) {
                tableCell = new PdfPCell(new Phrase(this.formatValue(rpt.getCol_19()), this.subFont));
                tableCell.setBorder(0);
                tableCell.setHorizontalAlignment(2);
                this.table.addCell(tableCell);
            }
            if (this.cols < 23) continue;
            tableCell = new PdfPCell(new Phrase(this.formatValue(rpt.getCol_20()), this.subFont));
            tableCell.setBorder(0);
            tableCell.setHorizontalAlignment(2);
            this.table.addCell(tableCell);
        }
    }

    private void simpleLine() {
        PdfPCell tableCell = new PdfPCell(new Phrase(""));
        tableCell.setBorder(0);
        this.table.addCell(tableCell);
        tableCell = new PdfPCell(new Phrase(""));
        tableCell.setBorder(0);
        this.table.addCell(tableCell);
        for (int i = 0; i < this.cols - 2; ++i) {
            tableCell = new PdfPCell(new Phrase(""));
            tableCell.setBorderWidthLeft(0.0f);
            tableCell.setBorderWidthRight(0.0f);
            tableCell.setBorderWidthTop(0.0f);
            tableCell.setBorderColorBottom(BaseColor.BLACK);
            this.table.addCell(tableCell);
        }
    }

    public void onOpenDocument(PdfWriter writer, com.itextpdf.text.Document document) {
        this.total = writer.getDirectContent().createTemplate(100.0f, 100.0f);
        this.total.setBoundingBox(new Rectangle(-20.0f, -20.0f, 100.0f, 100.0f));
        try {
            this.helv = BaseFont.createFont((String)"Helvetica", (String)"Cp1252", (boolean)false);
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
    }

    public void onEndPage(PdfWriter writer, com.itextpdf.text.Document document) {
        PdfContentByte cb = writer.getDirectContent();
        cb.saveState();
        Date date = new Date();
        String textLeft = "Page " + writer.getPageNumber() + " of ";
        String textRight = date + "            Page " + writer.getPageNumber() + " of ";
        float textBase = document.bottom() - 20.0f;
        float textSizeLeft = this.helv.getWidthPoint(textLeft, 8.0f);
        float textSizeRigth = this.helv.getWidthPoint(textRight, 8.0f);
        cb.beginText();
        cb.setFontAndSize(this.helv, 8.0f);
        if (writer.getPageNumber() % 2 == 1) {
            cb.setTextMatrix(document.left(), textBase);
            cb.showText(textLeft + "            " + date);
            cb.endText();
            cb.addTemplate(this.total, document.left() + textSizeLeft, textBase);
        } else {
            float adjust = this.helv.getWidthPoint("", 8.0f);
            cb.setTextMatrix(document.right() - textSizeRigth - adjust, textBase);
            cb.showText(textRight);
            cb.endText();
            cb.addTemplate(this.total, document.right() - adjust, textBase);
        }
        cb.restoreState();
    }

    public void onCloseDocument(PdfWriter writer, Document document) {
        this.total.beginText();
        this.total.setFontAndSize(this.helv, 8.0f);
        this.total.setTextMatrix(0.0f, 0.0f);
        this.total.showText(String.valueOf(writer.getPageNumber()));
        this.total.endText();
    }

    public File tofile(byte[] buf, String[] generalTitle) {
        byte[] bytes = buf;
        Object path = System.getProperty("java.io.tmpdir");
        if (!((String)path).endsWith("/") && !((String)path).endsWith("\\")) {
            path = (String)path + System.getProperty("file.separator");
        }
        String prefix = StringUtils.makePrefix(generalTitle[0]);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.log(Level.FINE, "Path=" + (String)path + " Prefix=" + prefix);
        }
        File file = new File((String)path + prefix + ".pdf");
        try {
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "file", e);
            return null;
        }
        try {
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(bytes);
            fos.flush();
            fos.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return file;
    }

    private void addEmptyLine(Paragraph paragraph, int number) {
        for (int i = 0; i < number; ++i) {
            paragraph.add((Element)new Paragraph(" "));
        }
    }

    private String dataNull(String data) {
        if (data == null) {
            return "";
        }
        return data;
    }

    private String formatValue(BigDecimal data) {
        if (data == null) {
            return "";
        }
        DecimalFormat frm = new DecimalFormat("###,###,###,##0.00");
        return frm.format(data.setScale(2, RoundingMode.HALF_UP));
    }
}

