/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.print.export;

import java.sql.Timestamp;
import java.util.Date;
import javax.print.attribute.standard.MediaSizeName;
import org.adempiere.impexp.AbstractExcelExporter;
import org.apache.poi.ss.usermodel.Sheet;
import org.compiere.print.MPrintFormat;
import org.compiere.print.MPrintFormatItem;
import org.compiere.print.MPrintPaper;
import org.compiere.print.PrintData;
import org.compiere.print.PrintDataElement;

public class PrintDataExcelExporter
extends AbstractExcelExporter {
    private PrintData m_printData;
    private MPrintFormat m_printFormat;

    public PrintDataExcelExporter(PrintData printData, MPrintFormat printFormat) {
        this.m_printData = printData;
        this.m_printFormat = printFormat;
    }

    public PrintDataExcelExporter(PrintData printData, MPrintFormat printFormat, boolean isXLSX) {
        this(printData, printFormat);
        this.isXLSX = isXLSX;
    }

    @Override
    public int getColumnCount() {
        return this.m_printFormat.getItemCount();
    }

    private PrintDataElement getPDE(int row, int col) {
        if (this.m_printData.getRowIndex() != row) {
            this.m_printData.setRowIndex(row);
        }
        MPrintFormatItem item = this.m_printFormat.getItem(col);
        int AD_Column_ID = item.getAD_Column_ID();
        Object obj = null;
        if (!item.isDisplayed(this.m_printData)) {
            return null;
        }
        if (AD_Column_ID > 0) {
            obj = this.m_printData.getNode((Integer)AD_Column_ID);
        }
        if (obj != null && obj instanceof PrintDataElement) {
            return (PrintDataElement)obj;
        }
        return null;
    }

    @Override
    public int getDisplayType(int row, int col) {
        PrintDataElement pde = this.getPDE(row, col);
        if (pde != null) {
            return pde.getDisplayType();
        }
        return -1;
    }

    @Override
    public Object getValueAt(int row, int col) {
        PrintDataElement pde = this.getPDE(row, col);
        Object value = null;
        if (pde != null) {
            if (pde.isDate()) {
                Object o = pde.getValue();
                value = o instanceof Date ? new Timestamp(((Date)o).getTime()) : (Timestamp)pde.getValue();
            } else if (pde.isNumeric()) {
                Object o = pde.getValue();
                if (o instanceof Number) {
                    value = ((Number)o).doubleValue();
                }
            } else {
                value = pde.isYesNo() ? pde.getValue() : (pde.isPKey() ? pde.getValueAsString() : pde.getValueDisplay(this.getLanguage()));
            }
        }
        return value;
    }

    @Override
    public String getHeaderName(int col) {
        return this.m_printFormat.getItem(col).getPrintName(this.getLanguage());
    }

    @Override
    public String getFormatPattern(int col) {
        return this.m_printFormat.getItem(col).getFormatPattern();
    }

    @Override
    public int getRowCount() {
        return this.m_printData.getRowCount();
    }

    @Override
    public boolean isColumnPrinted(int col) {
        MPrintFormatItem item = this.m_printFormat.getItem(col);
        return item.isPrinted();
    }

    @Override
    public boolean isPageBreak(int row, int col) {
        PrintDataElement pde = this.getPDE(row, col);
        return pde != null ? pde.isPageBreak() : false;
    }

    @Override
    protected void setCurrentRow(int row) {
        this.m_printData.setRowIndex(row);
    }

    @Override
    public boolean isFunctionRow() {
        return this.m_printData.isFunctionRow();
    }

    @Override
    protected void formatPage(Sheet sheet) {
        super.formatPage(sheet);
        MPrintPaper paper = MPrintPaper.get(this.m_printFormat.getAD_PrintPaper_ID());
        int paperSize = -1;
        MediaSizeName mediaSizeName = paper.getMediaSize().getMediaSizeName();
        if (MediaSizeName.NA_LETTER.equals(mediaSizeName)) {
            paperSize = 1;
        } else if (MediaSizeName.NA_LEGAL.equals(mediaSizeName)) {
            paperSize = 5;
        } else if (MediaSizeName.EXECUTIVE.equals(mediaSizeName)) {
            paperSize = 7;
        } else if (MediaSizeName.ISO_A4.equals(mediaSizeName)) {
            paperSize = 9;
        } else if (MediaSizeName.ISO_A5.equals(mediaSizeName)) {
            paperSize = 11;
        } else if (MediaSizeName.NA_NUMBER_10_ENVELOPE.equals(mediaSizeName)) {
            paperSize = 20;
        } else if (MediaSizeName.MONARCH_ENVELOPE.equals(mediaSizeName)) {
            paperSize = 37;
        }
        if (paperSize != -1) {
            sheet.getPrintSetup().setPaperSize((short)paperSize);
        }
        sheet.getPrintSetup().setLandscape(paper.isLandscape());
        sheet.setMargin((short)2, (double)paper.getMarginTop() / 72.0);
        sheet.setMargin((short)1, (double)paper.getMarginRight() / 72.0);
        sheet.setMargin((short)0, (double)paper.getMarginLeft() / 72.0);
        sheet.setMargin((short)3, (double)paper.getMarginBottom() / 72.0);
    }
}

