/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.process;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.logging.Level;
import org.adempiere.core.domains.models.X_C_Invoice;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.process.InvoiceGenerateFromShipmentAbstract;
import org.compiere.model.MBPartner;
import org.compiere.model.MClient;
import org.compiere.model.MDocType;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MInvoiceSchedule;
import org.compiere.model.MLocation;
import org.compiere.model.MOrder;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.Msg;

public class InvoiceGenerateFromShipment
extends InvoiceGenerateFromShipmentAbstract {
    private MInOut m_ship = null;
    private int m_created = 0;
    private int m_line = 0;
    private MBPartner m_bp = null;

    @Override
    protected void prepare() {
        super.prepare();
        if (this.getDateInvoiced() == null) {
            this.setDateInvoiced(Env.getContextAsDate(this.getCtx(), "#Date"));
            if (this.getDateInvoiced() == null) {
                this.setDateInvoiced(new Timestamp(System.currentTimeMillis()));
            }
        }
        if (this.getDocAction() == null) {
            this.setDocAction("CO");
        } else if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("PR");
        }
    }

    @Override
    protected String doIt() throws Exception {
        this.log.info("Selection=" + this.isSelection() + ", DateInvoiced=" + this.getDateInvoiced() + ", AD_Org_ID=" + this.getOrgId() + ", C_BPartner_ID=" + this.getBPartnerId() + ", M_InOut_ID=" + this.getInOutId() + ", DocAction=" + this.getDocAction() + ", Consolidate=" + this.isConsolidateDocument());
        Object sql = null;
        if (this.isSelection()) {
            sql = "SELECT M_InOut.* FROM M_InOut, T_Selection WHERE M_InOut.DocStatus='CO' AND M_InOut.IsSOTrx='Y'  AND M_InOut.M_InOut_ID = T_Selection.T_Selection_ID  AND T_Selection.AD_PInstance_ID=? ORDER BY M_InOut.M_InOut_ID";
        } else {
            sql = "SELECT * FROM M_InOut o WHERE DocStatus IN('CO','CL') AND IsSOTrx='Y'";
            if (this.getInOutId() != 0) {
                sql = (String)sql + " AND M_InOut_ID=?";
            } else {
                if (this.getOrgId() != 0) {
                    sql = (String)sql + " AND AD_Org_ID=?";
                }
                if (this.getBPartnerId() != 0) {
                    sql = (String)sql + " AND C_BPartner_ID=?";
                }
            }
            sql = (String)sql + " AND EXISTS (SELECT 1 FROM M_InOutLine ol WHERE o.M_InOut_ID=ol.M_InOut_ID AND ol.IsInvoiced='N') ORDER BY M_InOut_ID";
        }
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, this.get_TrxName());
            int index = 1;
            if (this.isSelection()) {
                pstmt.setInt(index, this.getAD_PInstance_ID());
            } else if (this.getInOutId() != 0) {
                pstmt.setInt(index++, this.getInOutId());
            } else {
                if (this.getOrgId() != 0) {
                    pstmt.setInt(index++, this.getOrgId());
                }
                if (this.getBPartnerId() != 0) {
                    pstmt.setInt(index++, this.getBPartnerId());
                }
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, (String)sql, e);
        }
        this.log.config((String)sql);
        return this.generate(pstmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String generate(PreparedStatement pstmt) {
        int rs_cnt = 0;
        ResultSet rs = null;
        X_C_Invoice invoice = null;
        try {
            rs = pstmt.executeQuery();
            while (rs.next()) {
                ++rs_cnt;
                MInOut inOut = new MInOut(this.getCtx(), rs, this.get_TrxName());
                if (!inOut.isComplete() || inOut.getDocStatus().equals("RE")) continue;
                MOrder order = new MOrder(this.getCtx(), inOut.getC_Order_ID(), this.get_TrxName());
                this.log.config("inOut " + inOut);
                this.log.config("order " + order + " InvoiceRule=" + order.getInvoiceRule());
                if (!this.isConsolidateDocument() || invoice != null && invoice.getC_BPartner_Location_ID() != order.getBill_Location_ID()) {
                    invoice = this.completeInvoice((MInvoice)invoice);
                }
                boolean doInvoice = false;
                this.log.config("InvoiceRule=" + order.getInvoiceRule() + " order " + order);
                if ("S".equals(order.getInvoiceRule())) {
                    this.m_bp = new MBPartner(this.getCtx(), order.getBill_BPartner_ID(), null);
                    if (this.m_bp.getC_InvoiceSchedule_ID() == 0) {
                        this.log.warning("BPartner has no Schedule - set to After Delivery");
                        order.setInvoiceRule("D");
                        order.saveEx();
                    } else {
                        MInvoiceSchedule is = MInvoiceSchedule.get(this.getCtx(), this.m_bp.getC_InvoiceSchedule_ID(), this.get_TrxName());
                        if (!is.canInvoice(order.getDateOrdered(), order.getGrandTotal())) continue;
                        doInvoice = true;
                    }
                }
                if (doInvoice || "D".equals(order.getInvoiceRule())) {
                    MInOutLine[] shipLines = inOut.getLines(false);
                    for (int j = 0; j < shipLines.length; ++j) {
                        MInOutLine inOutLine = shipLines[j];
                        if (inOutLine.isInvoiced()) continue;
                        invoice = this.createInvoiceLineFromShipmentLine((MInvoice)invoice, order, inOut, inOutLine);
                    }
                    this.m_line += 1000;
                    continue;
                }
                throw new AdempiereException(Msg.getMsg(this.getCtx(), "GenerateInvoiceFromInOut.InvoiceRule.NotSupported"));
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "", e);
        }
        finally {
            DB.close(rs, pstmt);
            pstmt = null;
        }
        this.completeInvoice((MInvoice)invoice);
        return "@Created@ = " + this.m_created + " @of@ " + rs_cnt;
    }

    private MInvoice createInvoiceLineFromShipmentLine(MInvoice invoice, MOrder order, MInOut inOut, MInOutLine inOutLine) {
        if (invoice == null) {
            invoice = new MInvoice(inOut, this.getDateInvoiced());
            if (this.getOrgTrxId() != 0) {
                invoice.setAD_Org_ID(this.getOrgTrxId());
            }
            invoice.saveEx();
        }
        if (this.isAddInvoiceReferenceLine() && (this.m_ship == null || this.m_ship.getM_InOut_ID() != inOut.getM_InOut_ID())) {
            MDocType dt = MDocType.get(this.getCtx(), inOut.getC_DocType_ID());
            if (this.m_bp == null || this.m_bp.getC_BPartner_ID() != inOut.getC_BPartner_ID()) {
                this.m_bp = new MBPartner(this.getCtx(), inOut.getC_BPartner_ID(), this.get_TrxName());
            }
            MClient client = MClient.get(this.getCtx(), order.getAD_Client_ID());
            String AD_Language = client.getAD_Language();
            if (client.isMultiLingualDocument() && this.m_bp.getAD_Language() != null) {
                AD_Language = this.m_bp.getAD_Language();
            }
            if (AD_Language == null) {
                AD_Language = Language.getBaseAD_Language();
            }
            SimpleDateFormat format = DisplayType.getDateFormat(15, Language.getLanguage(AD_Language));
            String referenceDescr = dt.getPrintName(this.m_bp.getAD_Language()) + ": " + inOut.getDocumentNo() + " - " + format.format(inOut.getMovementDate());
            this.m_ship = inOut;
            MInvoiceLine descInvLine = new MInvoiceLine(invoice);
            descInvLine.setIsDescription(true);
            descInvLine.setDescription(referenceDescr);
            descInvLine.setLine(this.m_line + inOutLine.getLine() - 2);
            descInvLine.saveEx();
            if (order.getBill_Location_ID() != inOut.getC_BPartner_Location_ID()) {
                MLocation addr = MLocation.getBPLocation(this.getCtx(), inOut.getC_BPartner_Location_ID(), null);
                descInvLine = new MInvoiceLine(invoice);
                descInvLine.setIsDescription(true);
                descInvLine.setDescription(addr.toString());
                descInvLine.setLine(this.m_line + inOutLine.getLine() - 1);
                descInvLine.saveEx();
            }
        }
        MInvoiceLine invLine = new MInvoiceLine(invoice);
        invLine.setShipLine(inOutLine);
        if (inOutLine.sameOrderLineUOM()) {
            invLine.setQtyEntered(inOutLine.getQtyEntered());
        } else {
            invLine.setQtyEntered(inOutLine.getMovementQty());
        }
        invLine.setQtyInvoiced(inOutLine.getMovementQty());
        invLine.setLine(this.m_line + inOutLine.getLine());
        if (!inOutLine.isToBeInvoiced()) {
            invLine.setPriceEntered(Env.ZERO);
            invLine.setPriceActual(Env.ZERO);
            invLine.setPriceList(Env.ZERO);
            invLine.setPriceLimit(Env.ZERO);
            invLine.setLineNetAmt(Env.ZERO);
            invLine.setIsDescription(true);
        }
        invLine.saveEx();
        inOutLine.setIsInvoiced(true);
        inOutLine.saveEx();
        this.log.fine(invLine.toString());
        return invoice;
    }

    private MInvoice completeInvoice(MInvoice invoice) {
        if (invoice != null) {
            if (!invoice.processIt(this.getDocAction())) {
                this.log.warning("completeInvoice - failed: " + invoice);
                this.addLog(Msg.getMsg(this.getCtx(), "GenerateInvoiceFromInOut.completeInvoice.Failed") + invoice);
            }
            invoice.saveEx();
            this.addLog(invoice.getC_Invoice_ID(), invoice.getDateInvoiced(), null, invoice.getDocumentNo());
            ++this.m_created;
        }
        invoice = null;
        this.m_ship = null;
        this.m_line = 0;
        return invoice;
    }
}

