/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.process;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.Adempiere;
import org.compiere.model.Query;
import org.compiere.process.GardenWorldCleanup;
import org.compiere.process.MigrationFromXML;
import org.compiere.process.ProcessInfo;
import org.compiere.process.RoleAccessUpdate;
import org.compiere.process.SequenceCheck;
import org.compiere.process.SynchronizeTerminology;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.Util;
import org.eevolution.services.dsl.ProcessBuilder;

public class MigrationLoader {
    private static CLogger log = CLogger.getCLogger(MigrationLoader.class);

    public static void main(String[] args) {
        boolean isClean = false;
        boolean isForce = false;
        List<String> arguments = Arrays.asList(args);
        isClean = arguments.stream().filter(arg -> !Util.isEmpty(arg) && arg.equals("clean")).findFirst().isPresent();
        isForce = arguments.stream().filter(arg -> !Util.isEmpty(arg) && arg.equals("force")).findFirst().isPresent();
        Optional<String> optionalPath = arguments.stream().filter(arg -> !Util.isEmpty(arg) && !arg.equals("force") && !arg.equals("clean")).findFirst();
        Object fileName = null;
        if (optionalPath.isPresent() && new File(optionalPath.get()).exists()) {
            fileName = optionalPath.get();
        }
        Adempiere.startupEnvironment(true);
        CLogMgt.setLevel(Level.INFO);
        if (!DB.isConnected()) {
            log.warning("No DB Connection");
            System.exit(1);
        }
        Ini.setProperty("LogMigrationScript", false);
        if (Util.isEmpty((String)fileName)) {
            fileName = Adempiere.getAdempiereHome() + File.separator + "migration";
        }
        boolean apply = true;
        boolean failOnError = true;
        Properties context = Env.getCtx();
        try {
            ProcessInfo processInfo = ProcessBuilder.create(context).process(MigrationFromXML.class).withTitle("Import Migration from XML").withParameter("FailOnError", failOnError).withParameter("FilePathOrName", fileName).withParameter("FileName", fileName).withParameter("Apply", apply).withParameter("IsForce", isForce).withParameter("Clean", isClean).execute();
            log.log(Level.INFO, "Process=" + processInfo.getTitle() + " Error=" + processInfo.isError() + " Summary=" + processInfo.getSummary());
            if (failOnError && processInfo.isError()) {
                throw new AdempiereException(processInfo.getSummary());
            }
            processInfo = ProcessBuilder.create(context).process(SequenceCheck.class).withTitle("Sequence Check").execute();
            log.log(Level.INFO, "Process=" + processInfo.getTitle() + " Error=" + processInfo.isError() + " Summary=" + processInfo.getSummary());
            processInfo = ProcessBuilder.create(context).process(SynchronizeTerminology.class).withTitle("Synchronize Terminology").withParameter("IsCreateElement", false).withParameter("IsDeletingUnusedElement", false).execute();
            log.log(Level.INFO, "Process=" + processInfo.getTitle() + " Error=" + processInfo.isError() + " Summary=" + processInfo.getSummary());
            new Query(context, "AD_Client", null, null).setOrderBy("AD_Client_ID").list().forEach(client -> {
                ProcessInfo processInfoRoleAccessUpdate = ProcessBuilder.create(context).process(RoleAccessUpdate.class).withTitle("Role Access Update").withParameter("AD_Client_ID", client.getAD_Client_ID()).executeUsingSystemRole();
                log.log(Level.INFO, "Process=" + processInfoRoleAccessUpdate.getTitle() + " Client=(" + client.getValue() + " - " + client.getName() + ") Error=" + processInfoRoleAccessUpdate.isError() + " Summary=" + processInfoRoleAccessUpdate.getSummary());
            });
            processInfo = ProcessBuilder.create(context).process(GardenWorldCleanup.class).withTitle("Updating Garden World").executeUsingSystemRole();
            log.log(Level.INFO, "Process=" + processInfo.getTitle() + " Error=" + processInfo.isError() + " Summary=" + processInfo.getSummary());
        }
        catch (AdempiereException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

