/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.process;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import org.adempiere.core.domains.models.X_M_InOutLine;
import org.adempiere.process.SB_InOutGenerateFromOrderLineAbstract;
import org.compiere.model.MAttributeSet;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.MStorage;
import org.compiere.util.Env;

public class SB_InOutGenerateFromOrderLine
extends SB_InOutGenerateFromOrderLineAbstract {
    private MInOut m_shipment = null;
    private int m_created = 0;
    private int m_line = 0;
    private int m_lastC_BPartner_Location_ID = -1;
    private String m_sql = null;
    private HashMap<SParameter, MStorage[]> m_map = new HashMap();
    private SParameter m_lastPP = null;
    private MStorage[] m_lastStorages = null;
    protected List<MOrder> ordersToShip = null;
    StringBuffer resultMsg = new StringBuffer();

    @Override
    protected void prepare() {
        super.prepare();
        if (this.getMovementDate() == null) {
            this.setMovementDate(Env.getContextAsDate(this.getCtx(), "#Date"));
            if (this.getMovementDate() == null) {
                this.setMovementDate(new Timestamp(System.currentTimeMillis()));
            }
        }
        if (this.getDocAction() == null) {
            this.setDocAction("CO");
        } else if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("PR");
        }
    }

    @Override
    protected String doIt() throws Exception {
        this.ordersToShip = new ArrayList<MOrder>();
        for (Integer key : this.getSelectionKeys()) {
            MOrderLine orderLine = new MOrderLine(this.getCtx(), key, this.get_TrxName());
            Boolean isadded = false;
            for (MOrder order : this.ordersToShip) {
                if (order.getC_Order_ID() != orderLine.getC_Order_ID()) continue;
                isadded = true;
                break;
            }
            if (isadded.booleanValue()) continue;
            this.ordersToShip.add(orderLine.getParent());
        }
        StringBuffer msg = new StringBuffer();
        for (MOrder order : this.ordersToShip) {
            if (msg.length() > 0) {
                msg.append(", ");
            }
            msg.append(this.generate(order));
        }
        return msg.toString();
    }

    private String generate(MOrder order) {
        try {
            BigDecimal toDeliver;
            MOrderLine[] lines;
            if (!this.isConsolidateDocument() || this.m_shipment != null && (this.m_shipment.getC_BPartner_Location_ID() != order.getC_BPartner_Location_ID() || this.m_shipment.getM_Shipper_ID() != order.getM_Shipper_ID())) {
                this.completeShipment();
            }
            this.log.fine("check: " + order + " - DeliveryRule=" + order.getDeliveryRule());
            Timestamp minGuaranteeDate = this.getMovementDate();
            boolean completeOrder = "O".equals(order.getDeliveryRule());
            Object where = "";
            if (!"F".equals(order.getDeliveryRule())) {
                where = (String)where + " AND (C_OrderLine.M_Product_ID IS NULL OR EXISTS (SELECT * FROM M_Product p WHERE C_OrderLine.M_Product_ID=p.M_Product_ID AND IsExcludeAutoDelivery='N'))";
            }
            for (MOrderLine oLine : lines = order.getLines((String)where, "C_BPartner_Location_ID, M_Product_ID")) {
                BigDecimal deliver;
                boolean fullLine;
                MProduct product;
                if (!this.getSelectionKeys().contains(oLine.getC_OrderLine_ID())) continue;
                this.log.fine("check: " + oLine);
                BigDecimal onHand = Env.ZERO;
                toDeliver = this.getQtyToDeliver(oLine);
                if (toDeliver.compareTo(Env.ZERO) == 0 || (product = oLine.getProduct()) != null && toDeliver.signum() == 0 || oLine.getC_Charge_ID() != 0 && toDeliver.signum() == 0) continue;
                BigDecimal unconfirmedShippedQty = Env.ZERO;
                if (!(product != null && product.isStocked() || oLine.getQtyOrdered().signum() != 0 && toDeliver.signum() == 0)) {
                    if ("O".equals(order.getDeliveryRule())) continue;
                    this.createLine(order, oLine, toDeliver, null, false);
                    continue;
                }
                String MMPolicy = product.getMMPolicy();
                MStorage[] storages = this.getStorages(oLine.getM_Warehouse_ID(), oLine.getM_Product_ID(), oLine.getM_AttributeSetInstance_ID(), minGuaranteeDate, "F".equals(MMPolicy));
                for (int j = 0; j < storages.length; ++j) {
                    MStorage storage = storages[j];
                    onHand = onHand.add(storage.getQtyOnHand());
                }
                boolean bl = fullLine = onHand.compareTo(toDeliver) >= 0 || toDeliver.signum() < 0;
                if (completeOrder && !fullLine) {
                    this.log.fine("Failed CompleteOrder - OnHand=" + onHand + " (Unconfirmed=" + unconfirmedShippedQty + "), ToDeliver=" + toDeliver + " - " + oLine);
                    completeOrder = false;
                    break;
                }
                if (fullLine && "L".equals(order.getDeliveryRule())) {
                    this.log.fine("CompleteLine - OnHand=" + onHand + " (Unconfirmed=" + unconfirmedShippedQty + ", ToDeliver=" + toDeliver + " - " + oLine);
                    this.createLine(order, oLine, toDeliver, storages, false);
                    continue;
                }
                if ("A".equals(order.getDeliveryRule()) && (onHand.signum() > 0 || toDeliver.signum() < 0)) {
                    deliver = toDeliver;
                    if (deliver.compareTo(onHand) > 0) {
                        deliver = onHand;
                    }
                    this.log.fine("Available - OnHand=" + onHand + " (Unconfirmed=" + unconfirmedShippedQty + "), ToDeliver=" + toDeliver + ", Delivering=" + deliver + " - " + oLine);
                    this.createLine(order, oLine, deliver, storages, false);
                    continue;
                }
                if ("F".equals(order.getDeliveryRule())) {
                    deliver = toDeliver;
                    this.log.fine("Force - OnHand=" + onHand + " (Unconfirmed=" + unconfirmedShippedQty + "), ToDeliver=" + toDeliver + ", Delivering=" + deliver + " - " + oLine);
                    this.createLine(order, oLine, deliver, storages, true);
                    continue;
                }
                if ("M".equals(order.getDeliveryRule())) {
                    this.log.fine("Manual - OnHand=" + onHand + " (Unconfirmed=" + unconfirmedShippedQty + ") - " + oLine);
                    continue;
                }
                this.log.fine("Failed: " + order.getDeliveryRule() + " - OnHand=" + onHand + " (Unconfirmed=" + unconfirmedShippedQty + "), ToDeliver=" + toDeliver + " - " + oLine);
            }
            if (completeOrder && "O".equals(order.getDeliveryRule())) {
                for (MOrderLine oLine : lines) {
                    MProduct product = oLine.getProduct();
                    toDeliver = oLine.getQtyOrdered().subtract(oLine.getQtyDelivered());
                    MStorage[] storages = null;
                    if (product != null && product.isStocked()) {
                        String MMPolicy = product.getMMPolicy();
                        storages = this.getStorages(oLine.getM_Warehouse_ID(), oLine.getM_Product_ID(), oLine.getM_AttributeSetInstance_ID(), minGuaranteeDate, "F".equals(MMPolicy));
                    }
                    this.createLine(order, oLine, toDeliver, storages, false);
                }
            }
            this.m_line += 1000;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, this.m_sql, e);
        }
        this.completeShipment();
        return "@C_Order_ID@: " + order.getDocumentNo() + "[@M_InOut_ID@ @Created@: " + this.m_created + "]";
    }

    private void createLine(MOrder order, MOrderLine orderLine, BigDecimal qty, MStorage[] storages, boolean force) {
        if (this.m_lastC_BPartner_Location_ID != orderLine.getC_BPartner_Location_ID()) {
            this.completeShipment();
        }
        this.m_lastC_BPartner_Location_ID = orderLine.getC_BPartner_Location_ID();
        if (this.m_shipment == null) {
            this.m_shipment = new MInOut(order, 0, this.getMovementDate());
            if (this.getDocTypeId() != 0) {
                this.m_shipment.setC_DocType_ID(this.getDocTypeId());
            }
            this.m_shipment.setM_Warehouse_ID(orderLine.getM_Warehouse_ID());
            if (order.getC_BPartner_ID() != orderLine.getC_BPartner_ID()) {
                this.m_shipment.setC_BPartner_ID(orderLine.getC_BPartner_ID());
            }
            if (order.getC_BPartner_Location_ID() != orderLine.getC_BPartner_Location_ID()) {
                this.m_shipment.setC_BPartner_Location_ID(orderLine.getC_BPartner_Location_ID());
            }
            if (!this.m_shipment.save()) {
                throw new IllegalStateException("Could not create Shipment");
            }
        }
        if (storages == null) {
            MInOutLine line = new MInOutLine(this.m_shipment);
            line.setOrderLine(orderLine, 0, Env.ZERO);
            line.setQty(qty);
            if (orderLine.getQtyEntered().compareTo(orderLine.getQtyOrdered()) != 0) {
                line.setQtyEntered(qty.multiply(orderLine.getQtyEntered()).divide(orderLine.getQtyOrdered(), 12, RoundingMode.HALF_UP));
            }
            line.setLine(this.m_line + orderLine.getLine());
            line.saveEx();
            this.log.fine(line.toString());
            return;
        }
        ArrayList<X_M_InOutLine> list = new ArrayList<X_M_InOutLine>();
        MProduct product = (MProduct)orderLine.getM_Product();
        BigDecimal toDeliver = qty;
        for (int i = 0; i < storages.length; ++i) {
            MStorage storage = storages[i];
            BigDecimal deliver = toDeliver;
            if (storage.getQtyOnHand().signum() < 0) continue;
            if (deliver.compareTo(storage.getQtyOnHand()) > 0 && storage.getQtyOnHand().signum() >= 0 && (!force || force && i + 1 != storages.length)) {
                deliver = storage.getQtyOnHand();
            }
            if (deliver.signum() == 0) continue;
            int M_Locator_ID = storage.getM_Locator_ID();
            X_M_InOutLine line = null;
            if (orderLine.getM_AttributeSetInstance_ID() == 0) {
                for (int ll = 0; ll < list.size(); ++ll) {
                    MInOutLine test = (MInOutLine)list.get(ll);
                    if (test.getM_Locator_ID() != M_Locator_ID || test.getM_AttributeSetInstance_ID() != 0) continue;
                    line = test;
                    break;
                }
            }
            if (line == null) {
                line = new MInOutLine(this.m_shipment);
                ((MInOutLine)line).setOrderLine(orderLine, M_Locator_ID, order.isSOTrx() ? deliver : Env.ZERO);
                ((MInOutLine)line).setQty(deliver);
                MAttributeSet.validateAttributeSetInstanceMandatory(product, MInOutLine.Table_ID, ((MInOutLine)line).isSOTrx(), line.getM_AttributeSetInstance_ID());
                list.add(line);
            } else {
                ((MInOutLine)line).setQty(line.getMovementQty().add(deliver));
            }
            if (orderLine.getQtyEntered().compareTo(orderLine.getQtyOrdered()) != 0) {
                ((MInOutLine)line).setQtyEntered(line.getMovementQty().multiply(orderLine.getQtyEntered()).divide(orderLine.getQtyOrdered(), 12, RoundingMode.HALF_UP));
            }
            line.setLine(this.m_line + orderLine.getLine());
            line.saveEx();
            this.log.fine("ToDeliver=" + qty + "/" + deliver + " - " + (MInOutLine)line);
            toDeliver = toDeliver.subtract(deliver);
            storage.setQtyOnHand(storage.getQtyOnHand().subtract(deliver));
            if (toDeliver.signum() == 0) break;
        }
        if (toDeliver.signum() != 0) {
            if (!force) {
                throw new IllegalStateException("Not All Delivered - Remainder=" + toDeliver);
            }
            MInOutLine line = new MInOutLine(this.m_shipment);
            line.setOrderLine(orderLine, 0, order.isSOTrx() ? toDeliver : Env.ZERO);
            line.setQty(toDeliver);
            line.saveEx();
        }
    }

    private MStorage[] getStorages(int M_Warehouse_ID, int M_Product_ID, int M_AttributeSetInstance_ID, Timestamp minGuaranteeDate, boolean FiFo) {
        this.m_lastPP = new SParameter(M_Warehouse_ID, M_Product_ID, M_AttributeSetInstance_ID, minGuaranteeDate, FiFo);
        this.m_lastStorages = this.m_map.get(this.m_lastPP);
        if (this.m_lastStorages == null) {
            this.m_lastStorages = MStorage.getWarehouse(this.getCtx(), M_Warehouse_ID, M_Product_ID, M_AttributeSetInstance_ID, minGuaranteeDate, FiFo, false, 0, this.get_TrxName());
            this.m_map.put(this.m_lastPP, this.m_lastStorages);
        }
        return this.m_lastStorages;
    }

    private void completeShipment() {
        if (this.m_shipment != null) {
            if (!this.m_shipment.processIt(this.getDocAction())) {
                this.log.warning("Failed: " + this.m_shipment);
            }
            this.m_shipment.saveEx();
            this.addLog(this.m_shipment.getM_InOut_ID(), this.m_shipment.getMovementDate(), null, this.m_shipment.getDocumentNo());
            ++this.m_created;
            this.m_map = new HashMap();
            this.m_lastPP = null;
            this.m_lastStorages = null;
        }
        this.m_shipment = null;
        this.m_line = 0;
    }

    private BigDecimal getQtyToDeliver(MOrderLine oLine) {
        BigDecimal toDeliver = this.getSelectionAsBigDecimal(oLine.getC_OrderLine_ID(), "IO_QtyToDeliver");
        return toDeliver;
    }

    class SParameter {
        public int M_Warehouse_ID;
        public int M_Product_ID;
        public int M_AttributeSetInstance_ID;
        public int M_AttributeSet_ID;
        public boolean allAttributeInstances;
        public Timestamp minGuaranteeDate;
        public boolean FiFo;

        protected SParameter(int p_Warehouse_ID, int p_Product_ID, int p_AttributeSetInstance_ID, Timestamp p_minGuaranteeDate, boolean p_FiFo) {
            this.M_Warehouse_ID = p_Warehouse_ID;
            this.M_Product_ID = p_Product_ID;
            this.M_AttributeSetInstance_ID = p_AttributeSetInstance_ID;
            this.minGuaranteeDate = p_minGuaranteeDate;
            this.FiFo = p_FiFo;
        }

        public boolean equals(Object obj) {
            if (obj != null && obj instanceof SParameter) {
                boolean eq;
                SParameter cmp = (SParameter)obj;
                boolean bl = eq = cmp.M_Warehouse_ID == this.M_Warehouse_ID && cmp.M_Product_ID == this.M_Product_ID && cmp.M_AttributeSetInstance_ID == this.M_AttributeSetInstance_ID && cmp.M_AttributeSet_ID == this.M_AttributeSet_ID && cmp.allAttributeInstances == this.allAttributeInstances && cmp.FiFo == this.FiFo;
                if (!(!eq || cmp.minGuaranteeDate == null && this.minGuaranteeDate == null || cmp.minGuaranteeDate != null && this.minGuaranteeDate != null && cmp.minGuaranteeDate.equals(this.minGuaranteeDate))) {
                    eq = false;
                }
                return eq;
            }
            return false;
        }

        public int hashCode() {
            long hash = this.M_Warehouse_ID + this.M_Product_ID * 2 + this.M_AttributeSetInstance_ID * 3 + this.M_AttributeSet_ID * 4;
            if (this.allAttributeInstances) {
                hash *= -1L;
            }
            if (this.FiFo) {
                hash *= -2L;
            }
            if (hash < 0L) {
                hash = -hash + 7L;
            }
            while (hash > Integer.MAX_VALUE) {
                hash -= Integer.MAX_VALUE;
            }
            if (this.minGuaranteeDate != null) {
                hash += (long)this.minGuaranteeDate.hashCode();
                while (hash > Integer.MAX_VALUE) {
                    hash -= Integer.MAX_VALUE;
                }
            }
            return (int)hash;
        }
    }
}

