/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.process;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.adempiere.process.YearEndClosingAbstract;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MConversionType;
import org.compiere.model.MElementValue;
import org.compiere.model.MJournal;
import org.compiere.model.MJournalBatch;
import org.compiere.model.MJournalLine;
import org.compiere.model.MPeriod;
import org.compiere.model.Query;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class YearEndClosing
extends YearEndClosingAbstract {
    private int closingAccountId = 0;

    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        MAcctSchema acctSchema = new MAcctSchema(this.getCtx(), this.getAcctSchemaId(), this.get_TrxName());
        this.closingAccountId = this.createAccount(this.getElementValueId());
        if (this.closingAccountId == 0) {
            return "";
        }
        MJournalBatch journalBatch = new MJournalBatch(this.getCtx(), 0, this.get_TrxName());
        BigDecimal balance = Env.ZERO;
        String documentNo = Msg.translate(Env.getCtx(), "Closing") + "_" + this.getDateAcct().toString();
        journalBatch.setAD_Org_ID(this.getOrgId());
        journalBatch.setDateAcct(this.getDateAcct());
        journalBatch.setDateDoc(this.getDateAcct());
        journalBatch.setDescription(documentNo);
        journalBatch.setC_DocType_ID(this.getDocTypeId());
        journalBatch.setDocumentNo(documentNo);
        journalBatch.setGL_Category_ID(this.getCategoryId());
        journalBatch.setControlAmt(Env.ZERO);
        journalBatch.setC_Currency_ID(acctSchema.getC_Currency_ID());
        journalBatch.save();
        String whereClause = "accounttype IN ('E', 'R')  AND ISSUMMARY = 'N' AND c_Element_ID=?";
        int elementId = DB.getSQLValueEx(this.get_TrxName(), "SELECT C_Element_ID FROM C_AcctSchema_Element WHERE elementtype = 'AC' AND C_AcctSchema_ID=?", this.getAcctSchemaId());
        List elementValues = new Query(this.getCtx(), "C_ElementValue", whereClause, this.get_TrxName()).setClient_ID().setParameters(elementId).setOrderBy("value").list();
        for (MElementValue elementValue : elementValues) {
            this.log.info(elementValue.getValue());
            balance = this.searchBalance(elementValue.getC_ElementValue_ID());
            if (balance.equals(Env.ZERO)) continue;
            this.createJournal(elementValue, journalBatch, acctSchema, balance);
        }
        return "@Created@: " + journalBatch.getDocumentNo();
    }

    private int createAccount(int elementValueId) {
        MAccount account = MAccount.get(this.getCtx(), this.getAD_Client_ID(), this.getOrgId(), this.getAcctSchemaId(), elementValueId, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, this.get_TrxName());
        if (account == null) {
            return 0;
        }
        return account.get_ID();
    }

    private Boolean createJournal(MElementValue elementValue, MJournalBatch journalBatch, MAcctSchema acctSchema, BigDecimal balance) {
        MJournal journal = new MJournal(journalBatch);
        int accountId = this.createAccount(elementValue.getC_ElementValue_ID());
        this.log.info(elementValue.getValue());
        journal.setC_Currency_ID(acctSchema.getC_Currency_ID());
        journal.setC_AcctSchema_ID(acctSchema.get_ID());
        journal.setC_ConversionType_ID(MConversionType.getDefault(this.getAD_Client_ID()));
        journal.setDescription(Msg.translate(Env.getCtx(), "Closing") + " " + elementValue.getValue() + " " + elementValue.getName());
        journal.setDocumentNo(DB.getDocumentNo(this.getAD_Client_ID(), "GL_Journal", this.get_TrxName()));
        journal.setGL_Category_ID(this.getCategoryId());
        journal.save();
        if (!this.createLines(accountId, journal, elementValue, balance).booleanValue()) {
            return false;
        }
        return true;
    }

    private Boolean createLines(int accountID, MJournal journal, MElementValue elementValue, BigDecimal balance) {
        String accountType = elementValue.getAccountType();
        MJournalLine journalLine_debit = new MJournalLine(journal);
        MJournalLine journalLine_credit = new MJournalLine(journal);
        if (balance.signum() == 0) {
            return true;
        }
        if (accountType.equals("R")) {
            journalLine_debit.setC_ValidCombination_ID(this.closingAccountId);
            journalLine_debit.setAmtSourceDr(balance.negate());
            journalLine_debit.save();
            journalLine_credit.setC_ValidCombination_ID(accountID);
            journalLine_credit.setAmtSourceCr(balance.negate());
            journalLine_credit.save();
        } else {
            journalLine_debit.setC_ValidCombination_ID(this.closingAccountId);
            journalLine_debit.setAmtSourceDr(balance);
            journalLine_debit.save();
            journalLine_credit.setC_ValidCombination_ID(accountID);
            journalLine_credit.setAmtSourceCr(balance);
            journalLine_credit.save();
        }
        return true;
    }

    private BigDecimal searchBalance(int elementValueId) {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(MPeriod.getFirstInYear(this.getCtx(), this.getDateAcct(), 0).getStartDate());
        params.add(this.getDateAcct());
        params.add(elementValueId);
        String sql = " SELECT COALESCE(sum(amtacctDr - amtacctCr), 0) FROM fact_acct f WHERE (dateacct BETWEEN ? AND ? ) AND f.account_ID = ? ";
        BigDecimal balance = DB.getSQLValueBDEx(this.get_TrxName(), sql, params);
        return balance;
    }
}

