/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.process.rpl.exp;

import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.process.rpl.IExportProcessorAsWrapper;
import org.adempiere.process.rpl.IExportProcessorDefinition;
import org.adempiere.util.rpl.EntityWrapper;
import org.adempiere.util.rpl.EntityWrapperFactory;
import org.compiere.model.MClient;
import org.compiere.model.MEXPFormat;
import org.compiere.model.MEXPProcessor;
import org.compiere.model.MEXPProcessorType;
import org.compiere.model.MReplicationStrategy;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.CLogger;
import org.compiere.util.Util;

public class WrapperUtil {
    private static CLogger log = CLogger.getCLogger(WrapperUtil.class);

    public static String exportRecord(PO entity, MClient client, Integer replicationMode, String replicationType, Integer replicationEvent, MReplicationStrategy replicationStrategy, MEXPFormat exportFormat) {
        try {
            EntityWrapper wrapper = EntityWrapperFactory.create().withClient(client).withExportFormat(exportFormat).withReplicationEvent(replicationEvent).withReplicationMode(replicationMode).withReplicationType(replicationType).withEntity(entity).buildWrapper();
            MEXPProcessor exportProcessor = new MEXPProcessor(entity.getCtx(), replicationStrategy.getEXP_Processor_ID(), entity.get_TrxName());
            log.fine("ExportProcessor = " + exportProcessor);
            MEXPProcessorType expProcessorType = new MEXPProcessorType(entity.getCtx(), exportProcessor.getEXP_Processor_Type_ID(), entity.get_TrxName());
            IExportProcessorDefinition processorInstance = expProcessorType.getProcessorInstance();
            if (IExportProcessorAsWrapper.class.isAssignableFrom(processorInstance.getClass())) {
                IExportProcessorAsWrapper exportProcessorInstance = (IExportProcessorAsWrapper)processorInstance;
                exportProcessorInstance.process(entity.getCtx(), exportProcessor, wrapper, entity.get_TrxName());
            }
            return wrapper.toString();
        }
        catch (Exception e) {
            throw new AdempiereException(e.getLocalizedMessage());
        }
    }

    public static void importWrapper(Properties context, EntityWrapper wrapper, String trxName) {
        try {
            if (wrapper == null) {
                throw new AdempiereException("@Wrapper@ @NotFound@");
            }
            wrapper.setContext(context);
            wrapper.setTransactionName(trxName);
            if (Util.isEmpty(wrapper.getExportFormatVersion())) {
                throw new AdempiereException("@EXP_Format_ID@ @Version@ @NotFound@");
            }
            if (Util.isEmpty(wrapper.getExportFormatUuid()) && Util.isEmpty(wrapper.getExportFormatValue())) {
                throw new AdempiereException("@EXP_Format_ID@ (@UUID@ / @Value@) @NotFound@");
            }
            if (Util.isEmpty(wrapper.getClientUuid()) && Util.isEmpty(wrapper.getClientValue())) {
                throw new AdempiereException("@AD_Client_ID@ (@UUID@ / @Value@) @NotFound@");
            }
            MClient client = null;
            client = !Util.isEmpty(wrapper.getClientUuid()) ? (MClient)new Query(context, "AD_Client", "UUID = ?", trxName).setParameters(wrapper.getClientUuid()).first() : (MClient)new Query(context, "AD_Client", "Value = ?", trxName).setParameters(wrapper.getClientValue()).first();
            if (client == null) {
                throw new AdempiereException("@AD_Client_ID@ (@UUID@ / @Value@) @NotFound@");
            }
            log.info("EXP_Format_Value = " + wrapper.getExportFormatValue());
            MEXPFormat exportFormat = null;
            exportFormat = !Util.isEmpty(wrapper.getExportFormatUuid()) ? MEXPFormat.getFormatByUuid(context, wrapper.getExportFormatUuid(), trxName) : MEXPFormat.getFormatByValueAD_Client_IDAndVersion(context, wrapper.getExportFormatValue(), client.getAD_Client_ID(), wrapper.getExportFormatVersion(), trxName);
            if (exportFormat == null || exportFormat.getEXP_Format_ID() == 0) {
                MClient systemClient = null;
                systemClient = MClient.get(context, 0);
                if (systemClient == null) {
                    throw new AdempiereException("@XMLClientNotFound@");
                }
                log.info("SYSTEM Client = " + systemClient.toString());
                exportFormat = MEXPFormat.getFormatByValueAD_Client_IDAndVersion(context, wrapper.getExportFormatValue(), systemClient.getAD_Client_ID(), wrapper.getExportFormatVersion(), trxName);
            }
            if (exportFormat == null || exportFormat.getEXP_Format_ID() == 0) {
                throw new AdempiereException("@EXPFormatNotFound@");
            }
            log.info("exportFormat = " + exportFormat.toString());
            EntityWrapperFactory.create().withClient(client).withExportFormat(exportFormat).withWrapper(wrapper).buildEntity().saveEntity();
        }
        catch (Exception e) {
            throw new AdempiereException(e.getLocalizedMessage());
        }
    }
}

