/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.util;

import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import org.adempiere.util.Services;
import org.adempiere.util.api.IMsgBL;

public final class Check {
    private static Class<? extends RuntimeException> defaultExClazz = RuntimeException.class;

    private Check() {
    }

    public static void setDefaultExClass(Class<? extends RuntimeException> clazz) {
        defaultExClazz = clazz;
    }

    private static RuntimeException mkEx(Class<? extends RuntimeException> exClazz, String msg) {
        try {
            Constructor<? extends RuntimeException> c = exClazz.getConstructor(String.class);
            RuntimeException ex = c.newInstance(msg);
            return ex;
        }
        catch (Exception e) {
            throw new RuntimeException("Failure throwing exception with class '" + exClazz + "' and message '" + msg + "'", e);
        }
    }

    public static void assume(boolean cond, String errMsg, Object ... params) {
        if (!cond) {
            String errMsgFormated = Services.get(IMsgBL.class).formatMessage(errMsg, params);
            throw Check.mkEx(defaultExClazz, "Assumption failure: " + errMsgFormated);
        }
    }

    public static void assumeNotNull(Object object, String assumptionMessage, Object ... params) {
        boolean cond = object != null;
        Check.assume(cond, assumptionMessage, params);
    }

    public static void assumeNull(Object object, String assumptionMessage, Object ... params) {
        boolean cond = object == null;
        Check.assume(cond, assumptionMessage, params);
    }

    public static void errorUnless(boolean cond, String errMsg, Object ... params) {
        if (!cond) {
            String errMsgFormated = Services.get(IMsgBL.class).formatMessage(errMsg, params);
            throw Check.mkEx(defaultExClazz, "Error: " + errMsgFormated);
        }
    }

    public static void errorIf(boolean cond, String errMsg, Object ... params) {
        if (cond) {
            String errMsgFormated = Services.get(IMsgBL.class).formatMessage(errMsg, params);
            throw Check.mkEx(defaultExClazz, "Error: " + errMsgFormated);
        }
    }

    public static boolean isEmpty(String str) {
        return Check.isEmpty(str, false);
    }

    public static boolean isEmpty(String str, boolean trimWhitespaces) {
        if (str == null) {
            return true;
        }
        if (trimWhitespaces) {
            return str.trim().length() == 0;
        }
        return str.length() == 0;
    }

    public static boolean isEmpty(BigDecimal bd) {
        return bd == null || bd.signum() == 0;
    }

    public static <T> boolean isEmpty(T[] arr) {
        return arr == null || arr.length == 0;
    }
}

