/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.util;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;

public class EMailOAuth2SaslClient
implements SaslClient {
    private final String token;
    private final CallbackHandler callback;
    private boolean isComplete;
    public static final String MECHANISM_NAME = "XOAUTH2";

    public EMailOAuth2SaslClient(String oauthToken, CallbackHandler callbackHandler) {
        this.token = oauthToken;
        this.callback = callbackHandler;
    }

    @Override
    public String getMechanismName() {
        return MECHANISM_NAME;
    }

    @Override
    public boolean hasInitialResponse() {
        return true;
    }

    @Override
    public boolean isComplete() {
        return this.isComplete;
    }

    @Override
    public void dispose() throws SaslException {
    }

    @Override
    public Object getNegotiatedProperty(String propName) {
        if (!this.isComplete()) {
            throw new IllegalStateException();
        }
        return null;
    }

    @Override
    public byte[] wrap(byte[] outgoing, int offset, int len) throws SaslException {
        throw new IllegalStateException();
    }

    @Override
    public byte[] unwrap(byte[] incoming, int offset, int len) throws SaslException {
        throw new IllegalStateException();
    }

    @Override
    public byte[] evaluateChallenge(byte[] challenge) throws SaslException {
        if (this.isComplete) {
            return new byte[0];
        }
        NameCallback nameCallback = new NameCallback("Enter name");
        Callback[] callbacks = new Callback[]{nameCallback};
        try {
            this.callback.handle(callbacks);
        }
        catch (UnsupportedCallbackException e) {
            throw new SaslException("Unsupported callback: " + e);
        }
        catch (IOException e) {
            throw new SaslException("Failed to execute callback: " + e);
        }
        String email = nameCallback.getName();
        byte[] response = String.format("user=%s\u0001auth=Bearer %s\u0001\u0001", email, this.token).getBytes();
        this.isComplete = true;
        return response;
    }
}

