/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.acct;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.acct.Doc;
import org.compiere.acct.Fact;
import org.compiere.acct.FactLine;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MAcctSchemaElement;
import org.compiere.model.MConversionRate;
import org.compiere.model.MCostDetail;
import org.compiere.model.MCostElement;
import org.compiere.model.MCostType;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MMatchPO;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.MTransaction;
import org.compiere.model.ProductCost;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class Doc_MatchPO
extends Doc {
    private int m_C_OrderLine_ID = 0;
    private MOrderLine m_oLine = null;
    private int m_M_InOutLine_ID = 0;
    private MInOutLine m_ioLine = null;
    private int m_C_InvoiceLine_ID = 0;
    private ProductCost m_pc;
    private int m_M_AttributeSetInstance_ID = 0;

    public Doc_MatchPO(MAcctSchema[] ass, ResultSet rs, String trxName) {
        super(ass, MMatchPO.class, rs, "MXP", trxName);
    }

    @Override
    protected String loadDocumentDetails() {
        this.setC_Currency_ID(-2);
        MMatchPO matchPO = (MMatchPO)this.getPO();
        this.setDateDoc(matchPO.getDateTrx());
        this.m_M_AttributeSetInstance_ID = matchPO.getM_AttributeSetInstance_ID();
        this.setQty(matchPO.getQty());
        this.m_C_OrderLine_ID = matchPO.getC_OrderLine_ID();
        this.m_oLine = new MOrderLine(this.getCtx(), this.m_C_OrderLine_ID, this.getTrxName());
        this.m_M_InOutLine_ID = matchPO.getM_InOutLine_ID();
        this.m_ioLine = new MInOutLine(this.getCtx(), this.m_M_InOutLine_ID, this.getTrxName());
        this.m_C_InvoiceLine_ID = matchPO.getC_InvoiceLine_ID();
        this.m_pc = new ProductCost(Env.getCtx(), this.getM_Product_ID(), this.m_M_AttributeSetInstance_ID, this.getTrxName());
        this.m_pc.setQty(this.getQty());
        return null;
    }

    @Override
    public BigDecimal getBalance() {
        return Env.ZERO;
    }

    @Override
    public ArrayList<Fact> createFacts(MAcctSchema as) {
        ArrayList<Fact> facts = new ArrayList<Fact>();
        if (this.getM_Product_ID() == 0 || this.getQty().signum() == 0 || this.m_M_InOutLine_ID == 0) {
            this.log.fine("No Product/Qty - M_Product_ID=" + this.getM_Product_ID() + ",Qty=" + this.getQty());
            return facts;
        }
        Fact fact = new Fact(this, as, "A");
        this.setC_Currency_ID(as.getC_Currency_ID());
        boolean isInterOrg = this.isInterOrg(as);
        BigDecimal poCost = this.m_oLine.getPriceCost();
        if (poCost == null || poCost.signum() == 0) {
            poCost = this.m_oLine.getPriceActual();
        }
        MInOutLine receiptLine = new MInOutLine(this.getCtx(), this.m_M_InOutLine_ID, this.getTrxName());
        MInOut inOut = receiptLine.getParent();
        boolean isReturnTrx = inOut.getMovementType().equals("V-");
        poCost = poCost.multiply(this.getQty());
        if (this.m_oLine.getC_Currency_ID() != as.getC_Currency_ID()) {
            MOrder order = this.m_oLine.getParent();
            Timestamp dateAcct = order.getDateAcct();
            BigDecimal rate = MConversionRate.getRate(order.getC_Currency_ID(), as.getC_Currency_ID(), dateAcct, order.getC_ConversionType_ID(), this.m_oLine.getAD_Client_ID(), this.m_oLine.getAD_Org_ID());
            if (rate == null) {
                this.p_Error = "Purchase Order not convertible - " + as.getName();
                return null;
            }
            if ((poCost = poCost.multiply(rate)).scale() > as.getCostingPrecision()) {
                poCost = poCost.setScale(as.getCostingPrecision(), RoundingMode.HALF_UP);
            }
        }
        MProduct product = MProduct.get(this.getCtx(), this.getM_Product_ID());
        MCostType ct = MCostType.get(as, this.getM_Product_ID(), this.getAD_Org_ID());
        String costingMethod = ct.getCostingMethod();
        MInOutLine ioLine = new MInOutLine(this.getCtx(), this.m_M_InOutLine_ID, this.getTrxName());
        BigDecimal costs = Env.ZERO;
        for (MTransaction transaction : MTransaction.getByInOutLine(ioLine)) {
            MCostElement element = MCostElement.getByMaterialCostElementType(transaction);
            MCostDetail cd = MCostDetail.getByTransaction(ioLine, transaction, as.getC_AcctSchema_ID(), ct.getM_CostType_ID(), element.getM_CostElement_ID());
            if (cd == null) continue;
            costs = costs.add(MCostDetail.getTotalCost(cd, as));
        }
        if ("S".equals(costingMethod)) {
            BigDecimal credit;
            BigDecimal debit;
            FactLine dr;
            if (costs == null || costs.signum() == 0) {
                this.p_Error = "No Standard Cost information was found for " + product.getName() + ".  Please add a standard cost for material and repost this document.";
                this.log.log(Level.SEVERE, this.p_Error);
                return null;
            }
            BigDecimal difference = poCost.subtract(costs.setScale(as.getCostingPrecision(), RoundingMode.HALF_UP));
            if (difference.signum() == 0) {
                this.log.log(Level.FINE, "No Cost Difference for M_Product_ID=" + this.getM_Product_ID());
                return facts;
            }
            FactLine cr = fact.createLine(null, this.m_pc.getAccount(5, as), as.getC_Currency_ID(), isReturnTrx ? difference.negate() : difference);
            if (cr != null) {
                cr.setQty(isReturnTrx ? this.getQty().negate() : this.getQty());
                cr.setC_BPartner_ID(this.m_oLine.getC_BPartner_ID());
                cr.setC_Activity_ID(this.m_oLine.getC_Activity_ID());
                cr.setC_Campaign_ID(this.m_oLine.getC_Campaign_ID());
                cr.setC_Project_ID(this.m_oLine.getC_Project_ID());
                cr.setC_ProjectPhase_ID(this.m_oLine.getC_ProjectPhase_ID());
                cr.setC_ProjectTask_ID(this.m_oLine.getC_ProjectTask_ID());
                cr.setC_UOM_ID(this.m_oLine.getC_UOM_ID());
                cr.setUser1_ID(this.m_oLine.getUser1_ID());
                cr.setUser2_ID(this.m_oLine.getUser2_ID());
                cr.setUser3_ID(this.m_oLine.getUser3_ID());
                cr.setUser4_ID(this.m_oLine.getUser4_ID());
            }
            if ((dr = fact.createLine(null, this.getAccount(101, as), as.getC_Currency_ID(), isReturnTrx ? difference : difference.negate())) != null) {
                dr.setQty(isReturnTrx ? this.getQty() : this.getQty().negate());
                dr.setC_BPartner_ID(this.m_oLine.getC_BPartner_ID());
                dr.setC_Activity_ID(this.m_oLine.getC_Activity_ID());
                dr.setC_Campaign_ID(this.m_oLine.getC_Campaign_ID());
                dr.setC_Project_ID(this.m_oLine.getC_Project_ID());
                dr.setC_ProjectPhase_ID(this.m_oLine.getC_ProjectPhase_ID());
                dr.setC_ProjectTask_ID(this.m_oLine.getC_ProjectTask_ID());
                dr.setC_UOM_ID(this.m_oLine.getC_UOM_ID());
                dr.setUser1_ID(this.m_oLine.getUser1_ID());
                dr.setUser2_ID(this.m_oLine.getUser2_ID());
                dr.setUser3_ID(this.m_oLine.getUser3_ID());
                dr.setUser4_ID(this.m_oLine.getUser4_ID());
            }
            MAccount acct_db = dr.getAccount();
            MAccount acct_cr = cr.getAccount();
            if (!as.isPostIfClearingEqual() && acct_db.equals(acct_cr) && !isInterOrg && (debit = dr.getAmtSourceDr()).compareTo(credit = cr.getAmtSourceCr()) == 0) {
                fact.remove(dr);
                fact.remove(cr);
            }
            facts.add(fact);
            return facts;
        }
        return facts;
    }

    private boolean isInterOrg(MAcctSchema as) {
        MAcctSchemaElement elementorg = as.getAcctSchemaElement("OO");
        if (elementorg == null || !elementorg.isBalanced()) {
            return false;
        }
        return this.m_ioLine != null && this.m_oLine != null && this.m_ioLine.getAD_Org_ID() != this.m_oLine.getAD_Org_ID();
    }

    private void updateProductInfo(int C_AcctSchema_ID) {
        this.log.fine("M_MatchPO_ID=" + this.get_ID());
        StringBuffer sql = new StringBuffer("UPDATE M_Product_Costing pc SET (CostStandardPOQty,CostStandardPOAmt) = (SELECT CostStandardPOQty + m.Qty, CostStandardPOAmt + currencyConvert(ol.PriceActual,ol.C_Currency_ID,a.C_Currency_ID,ol.DateOrdered,null,ol.AD_Client_ID,ol.AD_Org_ID)*m.Qty FROM M_MatchPO m, C_OrderLine ol, C_AcctSchema a WHERE m.C_OrderLine_ID=ol.C_OrderLine_ID AND pc.M_Product_ID=ol.M_Product_ID AND pc.C_AcctSchema_ID=a.C_AcctSchema_ID AND m.M_MatchPO_ID=").append(this.get_ID()).append(") ").append("WHERE pc.C_AcctSchema_ID=").append(C_AcctSchema_ID).append(" AND pc.M_Product_ID=").append(this.getM_Product_ID());
        int no = DB.executeUpdate(sql.toString(), this.getTrxName());
        this.log.fine("M_Product_Costing - Updated=" + no);
    }
}

