/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.db;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Optional;
import java.util.Properties;
import java.util.logging.Level;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import oracle.jdbc.OracleDriver;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.DBException;
import org.compiere.Adempiere;
import org.compiere.db.AdempiereDatabase;
import org.compiere.db.CConnection;
import org.compiere.db.Database;
import org.compiere.dbPort.Convert;
import org.compiere.dbPort.Convert_Oracle;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Ini;
import org.compiere.util.Language;
import org.compiere.util.Util;

public class DB_Oracle
implements AdempiereDatabase {
    private static OracleDriver s_driver = null;
    public static final String DRIVER = "oracle.jdbc.OracleDriver";
    public static final int DEFAULT_PORT = 1521;
    public static final int DEFAULT_CM_PORT = 1630;
    private String m_connectionURL;
    public static final String MAX_STATEMENTS = "200";
    private DataSource datasourceLongRunning = null;
    private DataSource datasourceShortRunning = null;
    private String m_userName = null;
    private Convert m_convert = new Convert_Oracle();
    private static CLogger log = CLogger.getCLogger(DB_Oracle.class);
    private static int m_maxbusyconnections = 0;

    public DB_Oracle() {
        try {
            System.setProperty("oracle.jdbc.V8Compatible", "true");
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage());
        }
    }

    @Override
    public String getName() {
        return Database.DB_ORACLE;
    }

    @Override
    public String getDescription() {
        try {
            if (s_driver == null) {
                this.getDriver();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (s_driver != null) {
            return s_driver.toString();
        }
        return "No Driver";
    }

    @Override
    public int getStandardPort() {
        return 1521;
    }

    @Override
    public Driver getDriver() throws SQLException {
        if (s_driver == null) {
            System.setProperty("oracle.jdbc.TcpNoDelay", "true");
            System.setProperty("oracle.jdbc.defaultNChar", "true");
            s_driver = new OracleDriver();
            DriverManager.registerDriver((Driver)s_driver);
            DriverManager.setLoginTimeout(Database.CONNECTION_TIMEOUT);
        }
        return s_driver;
    }

    @Override
    public String getConnectionURL(CConnection connection) {
        StringBuffer sb = null;
        if (connection.isBequeath()) {
            sb = new StringBuffer("jdbc:oracle:oci8:@");
        } else {
            sb = new StringBuffer("jdbc:oracle:thin:@");
            if (connection.isViaFirewall()) {
                sb.append("(DESCRIPTION=(ADDRESS_LIST=").append("(SOURCE_ROUTE=YES)").append("(ADDRESS=(PROTOCOL=TCP)(HOST=").append(connection.getFwHost()).append(")(PORT=").append(connection.getFwPort()).append("))").append("(ADDRESS=(PROTOCOL=TCP)(HOST=").append(connection.getDbHost()).append(")(PORT=").append(connection.getDbPort()).append(")))").append("(CONNECT_DATA=(SERVICE_NAME=").append(connection.getDbName()).append(")))");
            } else {
                sb.append("//").append(connection.getDbHost()).append(":").append(connection.getDbPort()).append("/").append(connection.getDbName());
            }
        }
        this.m_connectionURL = sb.toString();
        this.m_userName = connection.getDbUid();
        return this.m_connectionURL;
    }

    @Override
    public String getConnectionURL(String dbHost, int dbPort, String dbName, String userName) {
        this.m_userName = userName;
        this.m_connectionURL = "jdbc:oracle:thin:@//" + dbHost + ":" + dbPort + "/" + dbName;
        return this.m_connectionURL;
    }

    @Override
    public String getConnectionURL(String connectionURL, String userName) {
        this.m_userName = userName;
        this.m_connectionURL = connectionURL;
        return this.m_connectionURL;
    }

    @Override
    public String getCatalog() {
        return null;
    }

    @Override
    public String getSchema() {
        if (this.m_userName == null) {
            CConnection cconn = CConnection.get(Adempiere.getCodeBaseHost());
            this.m_userName = cconn.getDbUid();
        }
        if (this.m_userName == null) {
            log.severe("User Name not set (yet) - call getConnectionURL first");
            return null;
        }
        return this.m_userName.toUpperCase();
    }

    @Override
    public boolean supportsBLOB() {
        return true;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("DB_Oracle[");
        sb.append(this.m_connectionURL);
        try {
            StringBuffer logBuffer = new StringBuffer(50);
            logBuffer.append("# Connections: ").append(this.datasourceLongRunning.toString());
        }
        catch (Exception e) {
            sb.append("=").append(e.getLocalizedMessage());
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public String getStatus() {
        if (this.datasourceLongRunning == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        try {
            sb.append("# Connections: ").append(this.datasourceLongRunning.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sb.toString();
    }

    @Override
    public String convertStatement(String oraStatement) {
        Convert.logMigrationScript(oraStatement, null, null);
        return oraStatement;
    }

    @Override
    public boolean isSupported(String sql) {
        return true;
    }

    @Override
    public String getConstraintType(Connection conn, String tableName, String IXName) {
        if (IXName == null || IXName.length() == 0) {
            return "0";
        }
        if (IXName.endsWith("_KEY")) {
            return "1" + IXName;
        }
        return "0";
    }

    @Override
    public String getSystemUser() {
        return "system";
    }

    @Override
    public String getSystemDatabase(String databaseName) {
        return databaseName;
    }

    @Override
    public String TO_DATE(Timestamp time, boolean dayOnly) {
        if (time == null) {
            if (dayOnly) {
                return "TRUNC(SysDate)";
            }
            return "SysDate";
        }
        StringBuffer dateString = new StringBuffer("TO_DATE('");
        String myDate = time.toString();
        if (dayOnly) {
            dateString.append(myDate.substring(0, 10));
            dateString.append("','YYYY-MM-DD')");
        } else {
            dateString.append(myDate.substring(0, myDate.indexOf(46)));
            dateString.append("','YYYY-MM-DD HH24:MI:SS')");
        }
        return dateString.toString();
    }

    @Override
    public String TO_CHAR(String columnName, int displayType, String AD_Language) {
        StringBuffer retValue = new StringBuffer("TRIM(TO_CHAR(");
        retValue.append(columnName);
        if (DisplayType.isNumeric(displayType)) {
            if (displayType == 12) {
                retValue.append(",'999G999G999G990D00'");
            } else {
                retValue.append(",'TM9'");
            }
            if (!Language.isDecimalPoint(AD_Language)) {
                retValue.append(",'NLS_NUMERIC_CHARACTERS='',.'''");
            }
        } else if (DisplayType.isDate(displayType)) {
            retValue.append(",'").append(Language.getLanguage(AD_Language).getDBdatePattern()).append("'");
        }
        retValue.append("))");
        return retValue.toString();
    }

    @Override
    public String TO_NUMBER(BigDecimal number, int displayType) {
        if (number == null) {
            return "NULL";
        }
        BigDecimal result = number;
        int scale = DisplayType.getDefaultPrecision(displayType);
        if (scale > number.scale()) {
            try {
                result = number.setScale(scale, RoundingMode.HALF_UP);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result.toString();
    }

    @Override
    public String[] getCommands(int cmdType) {
        if (0 == cmdType) {
            return new String[0];
        }
        if (1 == cmdType) {
            return new String[0];
        }
        if (2 == cmdType) {
            return new String[0];
        }
        return null;
    }

    @Override
    public DataSource getDataSource(CConnection connection) {
        if (this.datasourceLongRunning != null) {
            return this.datasourceLongRunning;
        }
        try {
            if (Ini.isClient()) {
                log.warning("Config Hikari Connection Pool Datasource");
                HikariConfig config = new HikariConfig();
                config.setDriverClassName(DRIVER);
                config.setJdbcUrl(this.getConnectionURL(connection));
                config.setUsername(connection.getDbUid());
                config.setPassword(connection.getDbPwd());
                config.setConnectionTestQuery("SELECT Version FROM AD_System");
                config.setIdleTimeout(0L);
                config.setMinimumIdle(15);
                config.setMaximumPoolSize(150);
                config.setPoolName("AdempiereDS");
                config.addDataSourceProperty("cachePrepStmts", (Object)"true");
                config.addDataSourceProperty("prepStmtCacheSize", (Object)"250");
                config.addDataSourceProperty("prepStmtCacheSqlLimit", (Object)"2048");
                this.datasourceLongRunning = new HikariDataSource(config);
                log.warning("Starting Client Hikari Connection Pool");
            } else {
                Optional<String> maybeApplicationType = Optional.ofNullable(System.getenv("ADEMPIERE_APPS_TYPE"));
                this.datasourceLongRunning = maybeApplicationType.map(applicationType -> {
                    if ("wildfly".equals(applicationType)) {
                        try {
                            InitialContext initCtx = new InitialContext();
                            DataSource dataSource = (DataSource)initCtx.lookup("java:/AdempiereDS");
                            log.warning("Connection Lookup JNDI Datasource for java:/AdempiereDS Hikari Connection Pool");
                            return dataSource;
                        }
                        catch (Exception namingException) {
                            this.datasourceLongRunning = null;
                            log.log(Level.SEVERE, "Could not initialise Hikari Connection Pool", namingException);
                            namingException.printStackTrace();
                        }
                    }
                    try {
                        DataSource dataSource = (DataSource)InitialContext.doLookup("java:comp/env/java/AdempiereDS");
                        log.warning("Connection Lookup JNDI Datasource for java:comp/env/java/AdempiereDS Hikari Connection Pool");
                        return dataSource;
                    }
                    catch (Exception namingException) {
                        this.datasourceLongRunning = null;
                        log.log(Level.SEVERE, "Application Server does not exist Could not initialise Hikari Connection Pool", namingException);
                        namingException.printStackTrace();
                        log.warning("Connection successful using Standalone Hikari Config Connection Pool");
                        HikariConfig config = new HikariConfig();
                        config.setDriverClassName(DRIVER);
                        config.setJdbcUrl(this.getConnectionURL(connection));
                        config.setUsername(connection.getDbUid());
                        config.setPassword(connection.getDbPwd());
                        config.setConnectionTestQuery("SELECT Version FROM AD_System");
                        config.setIdleTimeout(60000L);
                        config.setKeepaliveTime(30000L);
                        config.setMinimumIdle(15);
                        config.setMaximumPoolSize(150);
                        config.setPoolName("AdempiereDS");
                        config.addDataSourceProperty("cachePrepStmts", (Object)"true");
                        config.addDataSourceProperty("prepStmtCacheSize", (Object)"250");
                        config.addDataSourceProperty("prepStmtCacheSqlLimit", (Object)"2048");
                        return new HikariDataSource(config);
                    }
                }).orElseThrow(() -> new AdempiereException("The ADEMPIERE_APPS_TYPE environment variable is not set, so it is not possible to initialize the Hikari Connection Pool"));
            }
        }
        catch (Exception exception) {
            this.datasourceLongRunning = null;
            log.log(Level.SEVERE, "Application Server does not exist, no is possible to initialize the initialise Hikari Connection Pool", exception);
            exception.printStackTrace();
        }
        return this.datasourceLongRunning;
    }

    public DataSource getDataSourceShortRunning(CConnection connection) {
        if (this.datasourceShortRunning != null) {
            return this.datasourceShortRunning;
        }
        try {
            if (Ini.isClient()) {
                log.warning("Config Hikari Connection Pool Short Running Datasource");
                HikariConfig config = new HikariConfig();
                config.setDriverClassName(DRIVER);
                config.setJdbcUrl(this.getConnectionURL(connection));
                config.setUsername(connection.getDbUid());
                config.setPassword(connection.getDbPwd());
                config.addDataSourceProperty("poolName", (Object)"AdempiereSRDS");
                config.addDataSourceProperty("cachePrepStmts", (Object)"true");
                config.addDataSourceProperty("prepStmtCacheSize", (Object)"250");
                config.addDataSourceProperty("prepStmtCacheSqlLimit", (Object)"2048");
                config.addDataSourceProperty("connectionTestQuery", (Object)"SELECT Version FROM AD_System");
                config.addDataSourceProperty("idleTimeout", (Object)"1200");
                config.addDataSourceProperty("maximumPoolSize", (Object)"10");
                HikariDataSource cpds = new HikariDataSource(config);
                this.datasourceShortRunning = cpds;
                log.warning("Starting Client Hikari Connection Pool");
            } else {
                Optional<String> maybeApplicationType = Optional.ofNullable(System.getenv("ADEMPIERE_APPS_TYPE"));
                this.datasourceShortRunning = maybeApplicationType.map(applicationType -> {
                    if ("wildfly".equals(applicationType)) {
                        try {
                            InitialContext initCtx = new InitialContext();
                            DataSource dataSource = (DataSource)initCtx.lookup("java:/AdempiereSRDS");
                            log.warning("Connection Lookup JNDI Short Running Datasource for java:/AdempiereSRDS Hikari Connection Pool");
                            return dataSource;
                        }
                        catch (Exception namingException) {
                            this.datasourceShortRunning = null;
                            log.log(Level.SEVERE, "Could not initialise Short Running Hikari Connection Pool", namingException);
                            namingException.printStackTrace();
                        }
                    }
                    try {
                        DataSource dataSource = (DataSource)InitialContext.doLookup("java:comp/env/java/AdempiereSRDS");
                        log.warning("Connection Lookup JNDI Short Running Datasource for java:comp/env/java/AdempiereSRDS Hikari Connection Pool");
                        return dataSource;
                    }
                    catch (Exception namingException) {
                        this.datasourceShortRunning = null;
                        log.log(Level.SEVERE, "Application Server does not exist Could not initialise Short Running Hikari Connection Pool", namingException);
                        namingException.printStackTrace();
                        log.warning("Connection successful using Standalone Short Running Hikari Config Connection Pool");
                        HikariConfig config = new HikariConfig();
                        config.setDriverClassName(DRIVER);
                        config.setJdbcUrl(this.getConnectionURL(connection));
                        config.setUsername(connection.getDbUid());
                        config.setPassword(connection.getDbPwd());
                        config.addDataSourceProperty("poolName", (Object)"AdempiereSRDS");
                        config.addDataSourceProperty("cachePrepStmts", (Object)"true");
                        config.addDataSourceProperty("prepStmtCacheSize", (Object)"250");
                        config.addDataSourceProperty("prepStmtCacheSqlLimit", (Object)"2048");
                        config.addDataSourceProperty("connectionTestQuery", (Object)"SELECT Version FROM AD_System");
                        config.addDataSourceProperty("idleTimeout", (Object)"1200");
                        config.addDataSourceProperty("maximumPoolSize", (Object)"5");
                        return new HikariDataSource(config);
                    }
                }).orElseThrow(() -> new AdempiereException("The ADEMPIERE_APPS_TYPE environment variable is not set, so it is not possible to initialize the Short Running Hikari Connection Pool"));
            }
        }
        catch (Exception exception) {
            this.datasourceShortRunning = null;
            log.log(Level.SEVERE, "Application Server does not exist, no is possible to initialize the Short Running initialise Short Running Hikari Connection Pool", exception);
            exception.printStackTrace();
        }
        return this.datasourceShortRunning;
    }

    @Override
    public Connection getFromConnectionPool(CConnection connection, boolean autoCommit, int transactionIsolation) throws Exception {
        Connection conn = null;
        Exception exception = null;
        try {
            block10: {
                if (this.datasourceLongRunning == null) {
                    this.getDataSource(connection);
                }
                try {
                    conn = this.datasourceLongRunning.getConnection();
                    if (conn != null) {
                        if (conn.getTransactionIsolation() != transactionIsolation) {
                            conn.setTransactionIsolation(transactionIsolation);
                        }
                        if (conn.getAutoCommit() != autoCommit) {
                            conn.setAutoCommit(autoCommit);
                        }
                    }
                }
                catch (Exception e) {
                    exception = e;
                    conn = null;
                    if (!DBException.isInvalidUserPassError(e)) break block10;
                    System.err.println("Cannot connect to database: " + this.getConnectionURL(connection) + " - UserID=" + connection.getDbUid());
                }
            }
            if (conn == null && exception != null) {
                System.err.println(exception.toString());
            }
        }
        catch (Exception e) {
            exception = e;
        }
        if (exception != null) {
            throw exception;
        }
        return conn;
    }

    @Override
    public Connection getFromConnectionPoolShortRunning(CConnection connection, boolean autoCommit, int transactionIsolation) throws Exception {
        Connection localConnection = null;
        Exception exception = null;
        try {
            block10: {
                if (this.datasourceShortRunning == null) {
                    this.getDataSource(connection);
                }
                try {
                    localConnection = this.datasourceShortRunning.getConnection();
                    if (localConnection != null) {
                        if (localConnection.getTransactionIsolation() != transactionIsolation) {
                            localConnection.setTransactionIsolation(transactionIsolation);
                        }
                        if (localConnection.getAutoCommit() != autoCommit) {
                            localConnection.setAutoCommit(autoCommit);
                        }
                    }
                }
                catch (Exception e) {
                    exception = e;
                    localConnection = null;
                    if (!DBException.isInvalidUserPassError(e)) break block10;
                    System.err.println("Cannot connect to database: " + this.getConnectionURL(connection) + " - UserID=" + connection.getDbUid());
                }
            }
            if (localConnection == null && exception != null) {
                System.err.println(exception.toString());
            }
        }
        catch (Exception e) {
            exception = e;
        }
        if (exception != null) {
            throw exception;
        }
        return localConnection;
    }

    @Override
    public Connection getDriverConnection(CConnection connection) throws SQLException {
        this.getDriver();
        return DriverManager.getConnection(this.getConnectionURL(connection), connection.getDbUid(), connection.getDbPwd());
    }

    @Override
    public Connection getDriverConnection(String dbUrl, String dbUid, String dbPwd) throws SQLException {
        this.getDriver();
        return DriverManager.getConnection(dbUrl, dbUid, dbPwd);
    }

    @Override
    public void close() {
        log.config(this.toString());
        if (this.datasourceLongRunning != null) {
            try {
                this.datasourceLongRunning.getConnection().close();
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Could not close Data Source");
            }
        }
        this.datasourceLongRunning = null;
    }

    public void cleanup() {
    }

    public String getDataType(String columnName, int displayType, int precision, boolean defaultValue) {
        Object retValue = null;
        if (columnName != null && displayType == 28 && columnName.endsWith("_ID")) {
            retValue = "NUMBER(10)";
        }
        if (retValue == null) {
            switch (displayType) {
                case 13: 
                case 18: 
                case 19: 
                case 21: 
                case 25: 
                case 27: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 35: {
                    retValue = "NUMBER(10)";
                    break;
                }
                case 12: {
                    retValue = "NUMBER";
                    if (!defaultValue) break;
                    retValue = (String)retValue + " DEFAULT 0";
                    break;
                }
                case 23: {
                    retValue = "BLOB";
                    break;
                }
                case 28: {
                    retValue = "CHAR(1)";
                    break;
                }
                case 37: {
                    retValue = "NUMBER";
                    if (!defaultValue) break;
                    retValue = (String)retValue + " DEFAULT 0";
                    break;
                }
                case 15: 
                case 16: 
                case 24: {
                    retValue = "DATE";
                    if (!defaultValue) break;
                    retValue = (String)retValue + " DEFAULT SYSDATE";
                    break;
                }
                case 11: {
                    retValue = "NUMBER(10)";
                    break;
                }
                case 17: {
                    retValue = "CHAR(" + precision + ")";
                    break;
                }
                case 10: 
                case 14: 
                case 34: {
                    retValue = "NVARCHAR(" + precision + ")";
                    break;
                }
                case 36: {
                    retValue = "CLOB";
                    break;
                }
                case 29: {
                    retValue = "NUMBER";
                    break;
                }
                case 20: {
                    retValue = "CHAR(1)";
                    break;
                }
                default: {
                    log.severe("Unknown: " + displayType);
                }
            }
        }
        return retValue;
    }

    @Override
    public String getAlternativeSQL(int reExNo, String msg, String sql) {
        return null;
    }

    public static void main(String[] args) {
        Adempiere.startupEnvironment(true);
        CConnection cc = CConnection.get();
        DB_Oracle db = (DB_Oracle)cc.getDatabase();
        db.cleanup();
        try {
            Connection conn = null;
            DataSource ds = db.getDataSource(cc);
            System.out.println("DS=" + ds.getConnection());
            conn = db.getFromConnectionPool(cc, true, 2);
            System.out.println("Cached=" + conn);
            System.out.println(db);
            System.out.println("JAVA classpath: [\n" + System.getProperty("java.class.path") + "\n]");
            DatabaseMetaData dmd = conn.getMetaData();
            System.out.println("DriverVersion: [" + dmd.getDriverVersion() + "]");
            System.out.println("DriverMajorVersion: [" + dmd.getDriverMajorVersion() + "]");
            System.out.println("DriverMinorVersion: [" + dmd.getDriverMinorVersion() + "]");
            System.out.println("DriverName: [" + dmd.getDriverName() + "]");
            System.out.println("ProductName: [" + dmd.getDatabaseProductName() + "]");
            System.out.println("ProductVersion: [\n" + dmd.getDatabaseProductVersion() + "\n]");
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        db.cleanup();
        System.out.println("--------------------------------------------------");
        try {
            String myString1 = "123456789 12345678";
            Object myString = "";
            for (int i2 = 0; i2 < 99; ++i2) {
                myString = (String)myString + myString1 + (char)(97 + i2) + "\n";
            }
            System.out.println(((String)myString).length());
            System.out.println(Util.size((String)myString));
            myString = Util.trimSize((String)myString, 2000);
            System.out.println(((String)myString).length());
            System.out.println(Util.size((String)myString));
            Connection conn2 = db.getFromConnectionPool(cc, true, 2);
            PreparedStatement pstmt = conn2.prepareStatement("INSERT INTO X_Test(Text1, Text2) values(?,?)");
            pstmt.setString(1, (String)myString);
            pstmt.setString(2, (String)myString);
            System.out.println(pstmt.executeUpdate());
            Statement stmt = conn2.createStatement();
            System.out.println(stmt.executeUpdate("INSERT INTO X_Test(Text1, Text2) values('" + (String)myString + "','" + (String)myString + "')"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        db.cleanup();
        System.out.println("--------------------------------------------------");
        System.exit(0);
        System.out.println("--------------------------------------------------");
        try {
            Connection conn1 = db.getFromConnectionPool(cc, false, 2);
            Connection conn2 = db.getFromConnectionPool(cc, true, 2);
            Connection conn3 = db.getFromConnectionPool(cc, false, 2);
            System.out.println("3 -> " + db);
            conn1.close();
            conn2.close();
            conn1 = db.getFromConnectionPool(cc, true, 2);
            conn2 = db.getFromConnectionPool(cc, true, 2);
            System.out.println("3 -> " + db);
            conn1.close();
            conn2.close();
            conn3.close();
            System.out.println("0 -> " + db);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        db.cleanup();
        System.out.println("--------------------------------------------------");
        System.out.println(DB.getConnectionRO());
        System.out.println(DB.getConnectionRW());
        System.out.println(DB.createConnection(false, 2));
        System.out.println(DB.getConnectionRO());
        System.out.println(DB.getConnectionRW());
        System.out.println(DB.createConnection(false, 2));
        System.out.println(DB.getConnectionRO());
        System.out.println(DB.getConnectionRW());
        System.out.println(DB.createConnection(false, 2));
        System.out.println(DB.getConnectionRO());
        System.out.println(DB.getConnectionRW());
        System.out.println(DB.createConnection(false, 2));
        System.out.println(DB.getConnectionRO());
        System.out.println(DB.getConnectionRW());
        System.out.println(DB.createConnection(false, 2));
        System.out.println(DB.getConnectionRO());
        System.out.println(DB.getConnectionRW());
        System.out.println(DB.createConnection(false, 2));
        System.out.println(DB.getConnectionRO());
        System.out.println(DB.getConnectionRW());
        System.out.println(DB.createConnection(false, 2));
        System.out.println(DB.getConnectionRO());
        System.out.println(DB.getConnectionRW());
        System.out.println(DB.createConnection(false, 2));
        System.out.println(DB.createConnection(false, 2));
        System.out.println(DB.createConnection(false, 2));
        System.out.println(DB.createConnection(false, 2));
        System.out.println(DB.createConnection(false, 2));
        System.out.println(DB.createConnection(false, 2));
        System.out.println(db);
        try {
            System.out.println("-- Sleeping --");
            Thread.sleep(60000L);
            System.out.println(db);
            db.close();
            db.cleanup();
            System.out.println(db);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public Convert getConvert() {
        return this.m_convert;
    }

    @Override
    public int getNextID(String Name2) {
        int m_sequence_id = DB.getSQLValue(null, "SELECT " + Name2.toUpperCase() + ".nextval FROM DUAL");
        return m_sequence_id;
    }

    @Override
    public boolean createSequence(String name, int increment, int minvalue, int maxvalue, int start, String trxName) {
        int no = DB.executeUpdate("DROP SEQUENCE " + name.toUpperCase(), trxName);
        no = DB.executeUpdateEx("CREATE SEQUENCE " + name.toUpperCase() + " MINVALUE " + minvalue + " MAXVALUE " + maxvalue + " START WITH " + start + " INCREMENT BY " + increment + " CACHE 20", trxName);
        return no != -1;
    }

    @Override
    public boolean isQueryTimeoutSupported() {
        return true;
    }

    @Override
    public String addPagingSQL(String sql, int start, int end) {
        return sql;
    }

    @Override
    public boolean isPagingSupported() {
        return false;
    }

    private int getIntProperty(Properties properties, String key, int defaultValue) {
        int i2 = defaultValue;
        try {
            String s = properties.getProperty(key);
            if (s != null && s.trim().length() > 0) {
                i2 = Integer.parseInt(s);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return i2;
    }

    private boolean getBooleanProperty(Properties properties, String key, boolean defaultValue) {
        boolean b2 = defaultValue;
        try {
            String s = properties.getProperty(key);
            if (s != null && s.trim().length() > 0) {
                b2 = Boolean.valueOf(s);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return b2;
    }

    private String getStringProperty(Properties properties, String key, String defaultValue) {
        String b2 = defaultValue;
        try {
            String s = properties.getProperty(key);
            if (s != null && s.trim().length() > 0) {
                b2 = s.trim();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return b2;
    }

    @Override
    public boolean forUpdate(PO po, int timeout) {
        if (po.get_TrxName() == null) {
            return false;
        }
        String[] keyColumns = po.get_KeyColumns();
        if (keyColumns != null && keyColumns.length > 0 && !po.is_new()) {
            int i2;
            ResultSet rs;
            CPreparedStatement stmt;
            block13: {
                StringBuilder sqlBuffer = new StringBuilder(" SELECT ");
                sqlBuffer.append(keyColumns[0]).append(" FROM ").append(po.get_TableName()).append(" WHERE ");
                for (int i3 = 0; i3 < keyColumns.length; ++i3) {
                    if (i3 > 0) {
                        sqlBuffer.append(" AND ");
                    }
                    sqlBuffer.append(keyColumns[i3]).append("=?");
                }
                sqlBuffer.append(" FOR UPDATE WAIT ").append(timeout > 0 ? timeout : 60);
                Object[] parameters = new Object[keyColumns.length];
                for (int i4 = 0; i4 < keyColumns.length; ++i4) {
                    Object parameter = po.get_Value(keyColumns[i4]);
                    if (parameter != null && parameter instanceof Boolean) {
                        parameter = (Boolean)parameter != false ? "Y" : "N";
                    }
                    parameters[i4] = parameter;
                }
                stmt = null;
                rs = null;
                stmt = DB.prepareStatement(sqlBuffer.toString(), 1003, 1008, po.get_TrxName());
                for (i2 = 0; i2 < keyColumns.length; ++i2) {
                    stmt.setObject(i2 + 1, parameters[i2]);
                }
                rs = stmt.executeQuery();
                if (!rs.next()) break block13;
                i2 = 1;
                DB.close(rs, stmt);
                rs = null;
                stmt = null;
                return i2 != 0;
            }
            try {
                i2 = 0;
            }
            catch (Exception e) {
                try {
                    if (log.isLoggable(Level.INFO)) {
                        log.log(Level.INFO, e.getLocalizedMessage(), e);
                    }
                    throw new DBException("Could not lock record for " + po.toString() + " caused by " + e.getLocalizedMessage());
                }
                catch (Throwable throwable) {
                    DB.close(rs, stmt);
                    rs = null;
                    stmt = null;
                    throw throwable;
                }
            }
            DB.close(rs, stmt);
            rs = null;
            stmt = null;
            return i2 != 0;
        }
        return false;
    }

    @Override
    public String getNameOfUniqueConstraintError(Exception e) {
        String info = e.getMessage();
        int fromIndex = info.indexOf(".");
        if (fromIndex == -1) {
            return info;
        }
        int toIndex = info.indexOf(")", fromIndex + 1);
        if (toIndex == -1) {
            return info;
        }
        return info.substring(fromIndex + 1, toIndex);
    }
}

