/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.db;

import org.compiere.db.AdempiereDatabase;
import org.compiere.db.DB_MariaDB;
import org.compiere.db.DB_MySQL;
import org.compiere.db.DB_Oracle;
import org.compiere.db.DB_PostgreSQL;
import org.compiere.util.CLogger;

public class Database {
    private static CLogger log = CLogger.getCLogger(Database.class);
    public static String DB_ORACLE = "Oracle";
    public static String DB_POSTGRESQL = "PostgreSQL";
    public static String DB_MYSQL = "MySQL";
    public static String DB_MARIADB = "MariaDB";
    public static String[] DB_NAMES = new String[]{DB_ORACLE, DB_POSTGRESQL, DB_MYSQL, DB_MARIADB};
    protected static Class<?>[] DB_CLASSES = new Class[]{DB_Oracle.class, DB_PostgreSQL.class, DB_MySQL.class, DB_MariaDB.class};
    public static int CONNECTION_TIMEOUT = 10;

    public static AdempiereDatabase getDatabase(String type) throws Exception {
        AdempiereDatabase db = null;
        for (int i2 = 0; i2 < DB_NAMES.length; ++i2) {
            if (!DB_NAMES[i2].equals(type)) continue;
            db = (AdempiereDatabase)DB_CLASSES[i2].newInstance();
            break;
        }
        return db;
    }

    public static AdempiereDatabase getDatabaseFromURL(String url) {
        if (url == null) {
            log.severe("No Database URL");
            return null;
        }
        if (url.indexOf("oracle") != -1) {
            return new DB_Oracle();
        }
        if (url.indexOf("postgresql") != -1) {
            return new DB_PostgreSQL();
        }
        if (url.indexOf("mysql") != -1) {
            return new DB_MySQL();
        }
        if (url.indexOf("mariadb") != -1) {
            return new DB_MariaDB();
        }
        log.severe("No Database for " + url);
        return null;
    }
}

