/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.dbPort;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.compiere.dbPort.Convert_MySQL;
import org.compiere.dbPort.Convert_PostgreSQL;
import org.compiere.dbPort.Convert_SQL92;
import org.compiere.model.MSysConfig;
import org.compiere.util.CLogger;
import org.compiere.util.DisplayType;
import org.compiere.util.Ini;

public abstract class Convert {
    public static final int REGEX_FLAGS = 34;
    protected Statement m_stmt = null;
    protected String m_conversionError = null;
    protected Exception m_exception = null;
    protected boolean m_verbose = true;
    private static CLogger log = CLogger.getCLogger(Convert.class);
    private static FileOutputStream tempFileOr = null;
    private static Writer writerOr;
    private static FileOutputStream tempFilePg;
    private static Writer writerPg;
    private static FileOutputStream tempFileMySQL;
    private static Writer writerMySQL;

    public void setVerbose(boolean verbose) {
        this.m_verbose = verbose;
    }

    public boolean execute(String sqlStatements, Connection conn) {
        if (conn == null) {
            throw new IllegalStateException("Require connection");
        }
        String[] sql = this.convert(sqlStatements);
        this.m_exception = null;
        if (this.m_conversionError != null || sql == null) {
            return false;
        }
        boolean ok = true;
        int i2 = 0;
        String statement = null;
        try {
            if (this.m_stmt == null) {
                this.m_stmt = conn.createStatement();
            }
            for (i2 = 0; ok && i2 < sql.length; ++i2) {
                statement = sql[i2];
                if (statement.length() == 0) {
                    if (!this.m_verbose) continue;
                    log.finer("Skipping empty (" + i2 + ")");
                    continue;
                }
                if (this.m_verbose) {
                    log.info("Executing (" + i2 + ") <<" + statement + ">>");
                } else {
                    log.info("Executing " + i2);
                }
                try {
                    this.m_stmt.clearWarnings();
                    int no = this.m_stmt.executeUpdate(statement);
                    SQLWarning warn = this.m_stmt.getWarnings();
                    if (warn != null) {
                        if (this.m_verbose) {
                            log.info("- " + warn);
                        } else {
                            log.info("Executing (" + i2 + ") <<" + statement + ">>");
                            log.info("- " + warn);
                        }
                    }
                    if (!this.m_verbose) continue;
                    log.fine("- ok " + no);
                    continue;
                }
                catch (SQLException ex) {
                    if (!statement.startsWith("DROP ")) {
                        ok = false;
                        this.m_exception = ex;
                    }
                    if (!this.m_verbose) {
                        log.info("Executing (" + i2 + ") <<" + statement + ">>");
                    }
                    log.info("Error executing " + i2 + "/" + sql.length + " = " + ex);
                }
            }
        }
        catch (SQLException e) {
            this.m_exception = e;
            if (!this.m_verbose) {
                log.info("Executing (" + i2 + ") <<" + statement + ">>");
            }
            log.info("Error executing " + i2 + "/" + sql.length + " = " + e);
            return false;
        }
        return ok;
    }

    public Exception getException() {
        return this.m_exception;
    }

    public boolean hasError() {
        return this.m_exception != null | this.m_conversionError != null;
    }

    public String convertAll(String sqlStatements) {
        String[] sql = this.convert(sqlStatements);
        StringBuffer sb = new StringBuffer(sqlStatements.length() + 10);
        for (int i2 = 0; i2 < sql.length; ++i2) {
            sb.append(sql[i2]).append("\n/\n");
            if (!this.m_verbose) continue;
            log.info("Statement " + i2 + ": " + sql[i2]);
        }
        return sb.toString();
    }

    public String[] convert(String sqlStatements) {
        this.m_conversionError = null;
        if (sqlStatements == null || sqlStatements.length() == 0) {
            this.m_conversionError = "SQL_Statement is null or has zero length";
            log.info(this.m_conversionError);
            return null;
        }
        return this.convertIt(sqlStatements);
    }

    public String getConversionError() {
        return this.m_conversionError;
    }

    protected String[] convertIt(String sqlStatements) {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(this.convertStatement(sqlStatements));
        String[] sql = new String[result.size()];
        result.toArray(sql);
        return sql;
    }

    protected String cleanUpStatement(String statement) {
        String clean = statement.trim();
        Matcher m = Pattern.compile("\\s+").matcher(clean);
        clean = m.replaceAll(" ");
        clean = clean.trim();
        return clean;
    }

    protected String replaceQuotedStrings(String inputValue, Map<String, String> retVars) {
        retVars.clear();
        Long quoteMarkerRandom = this.getQuotedKey();
        String quoteMarker = "<--" + quoteMarkerRandom + "-->";
        inputValue = inputValue.replace("''", quoteMarker);
        Pattern p2 = Pattern.compile("'[[^']*]*'");
        Matcher m = p2.matcher(inputValue);
        StringBuffer retValue = new StringBuffer(inputValue.length());
        while (m.find()) {
            Long l = quoteMarkerRandom;
            Long l2 = quoteMarkerRandom = Long.valueOf(quoteMarkerRandom - 1L);
            String key = "<--" + quoteMarkerRandom + "-->";
            String var = inputValue.substring(m.start(), m.end()).replace(quoteMarker, "''");
            retVars.put(key, var);
            m.appendReplacement(retValue, key);
        }
        m.appendTail(retValue);
        return retValue.toString().replace(quoteMarker, "''");
    }

    protected Long getQuotedKey() {
        return ThreadLocalRandom.current().nextLong(100000000000000000L, 999999999999999999L);
    }

    protected String recoverQuotedStrings(String retValue, Map<String, String> retVars) {
        AtomicReference<String> retValueReference = new AtomicReference<String>(retValue);
        retVars.forEach((key, value) -> retValueReference.getAndUpdate(sql -> sql.replace((CharSequence)key, this.escapeQuotedString((String)value))));
        return retValueReference.get();
    }

    protected String escapeQuotedString(String in) {
        return in;
    }

    private String applyConvertMap(String sqlStatement) {
        if (sqlStatement.toUpperCase().indexOf("EXCEPTION WHEN") != -1) {
            String error = "Exception clause needs to be converted: " + sqlStatement;
            log.info(error);
            this.m_conversionError = error;
            return sqlStatement;
        }
        String retValue = sqlStatement;
        Map convertMap = this.getConvertMap();
        if (convertMap != null) {
            for (String regex : convertMap.keySet()) {
                String replacement = (String)convertMap.get(regex);
                try {
                    Pattern p2 = Pattern.compile(regex, 34);
                    Matcher m = p2.matcher(retValue);
                    retValue = m.replaceAll(replacement);
                }
                catch (Exception e) {
                    String error = "Error expression: " + regex + " - " + e;
                    log.info(error);
                    this.m_conversionError = error;
                }
            }
        }
        return retValue;
    }

    protected String convertWithConvertMap(String sqlStatement) {
        try {
            sqlStatement = this.applyConvertMap(this.cleanUpStatement(sqlStatement));
        }
        catch (RuntimeException e) {
            log.warning(e.getLocalizedMessage());
            this.m_exception = e;
        }
        return sqlStatement;
    }

    protected Map getConvertMap() {
        return null;
    }

    protected abstract ArrayList<String> convertStatement(String var1);

    public abstract boolean isOracle();

    public static void logMigrationScript(String oraStatement, String pgStatement, String mySQLStatement) {
        boolean logMigrationScript = Ini.isPropertyBool("LogMigrationScript");
        if (logMigrationScript) {
            String[] r;
            Convert_SQL92 convert;
            if (Convert.dontLog(oraStatement)) {
                return;
            }
            try {
                if (tempFileOr == null) {
                    File fileNameOr = File.createTempFile("migration_script_", "_oracle.sql");
                    tempFileOr = new FileOutputStream(fileNameOr, true);
                    writerOr = new BufferedWriter(new OutputStreamWriter((OutputStream)tempFileOr, "UTF8"));
                }
                Convert.writeLogMigrationScript(writerOr, oraStatement);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (pgStatement == null) {
                    convert = new Convert_PostgreSQL();
                    r = convert.convert(oraStatement);
                    pgStatement = r[0];
                }
                if (tempFilePg == null) {
                    File fileNamePg = File.createTempFile("migration_script_", "_postgresql.sql");
                    tempFilePg = new FileOutputStream(fileNamePg, true);
                    writerPg = new BufferedWriter(new OutputStreamWriter((OutputStream)tempFilePg, "UTF8"));
                }
                Convert.writeLogMigrationScript(writerPg, pgStatement);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (mySQLStatement == null) {
                    convert = new Convert_MySQL();
                    r = convert.convert(oraStatement);
                    mySQLStatement = r[0];
                }
                if (tempFileMySQL == null) {
                    File fileNameMySQL = File.createTempFile("migration_script_", "_mysql.sql");
                    tempFileMySQL = new FileOutputStream(fileNameMySQL, true);
                    writerMySQL = new BufferedWriter(new OutputStreamWriter((OutputStream)tempFileMySQL, "UTF8"));
                }
                Convert.writeLogMigrationScript(writerMySQL, mySQLStatement);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static boolean dontLog(String statement) {
        String[] exceptionTables = new String[]{"AD_ACCESSLOG", "AD_ALERTPROCESSORLOG", "AD_CHANGELOG", "AD_ISSUE", "AD_LDAPPROCESSORLOG", "AD_PACKAGE_IMP", "AD_PACKAGE_IMP_BACKUP", "AD_PACKAGE_IMP_DETAIL", "AD_PACKAGE_IMP_INST", "AD_PACKAGE_IMP_PROC", "AD_PINSTANCE", "AD_PINSTANCE_LOG", "AD_PINSTANCE_PARA", "AD_REPLICATION_LOG", "AD_SCHEDULERLOG", "AD_SESSION", "AD_WORKFLOWPROCESSORLOG", "CM_WEBACCESSLOG", "C_ACCTPROCESSORLOG", "K_INDEXLOG", "R_REQUESTPROCESSORLOG", "T_AGING", "T_ALTER_COLUMN", "T_DISTRIBUTIONRUNDETAIL", "T_INVENTORYVALUE", "T_INVOICEGL", "T_REPLENISH", "T_REPORT", "T_REPORTSTATEMENT", "T_SELECTION", "T_SELECTION2", "T_SPOOL", "T_TRANSACTION", "T_TRIALBALANCE", "AD_PROCESS_ACCESS", "AD_WINDOW_ACCESS", "AD_WORKFLOW_ACCESS", "AD_FORM_ACCESS", "AD_MIGRATION", "AD_MIGRATIONSTEP", "AD_MIGRATIONDATA", "AD_RECENTITEM"};
        String uppStmt = statement.toUpperCase().trim();
        if (uppStmt.startsWith("SELECT ")) {
            return true;
        }
        if (uppStmt.startsWith("UPDATE AD_PROCESS SET STATISTIC_")) {
            return true;
        }
        if (uppStmt.startsWith("DELETE FROM ") && uppStmt.endsWith(" WHERE AD_TABLE_ID=? AND RECORD_ID=?")) {
            return true;
        }
        for (int i2 = 0; i2 < exceptionTables.length; ++i2) {
            if (uppStmt.startsWith("INSERT INTO " + exceptionTables[i2] + " ")) {
                return true;
            }
            if (uppStmt.startsWith("DELETE FROM " + exceptionTables[i2] + " ")) {
                return true;
            }
            if (uppStmt.startsWith("DELETE " + exceptionTables[i2] + " ")) {
                return true;
            }
            if (uppStmt.startsWith("UPDATE " + exceptionTables[i2] + " ")) {
                return true;
            }
            if (!uppStmt.startsWith("INSERT INTO " + exceptionTables[i2] + "(")) continue;
            return true;
        }
        return false;
    }

    private static void writeLogMigrationScript(Writer w, String statement) throws IOException {
        String prm_COMMENT = MSysConfig.getValue("DICTIONARY_ID_COMMENTS");
        SimpleDateFormat format = DisplayType.getDateFormat(16);
        String dateTimeText = format.format(new Timestamp(System.currentTimeMillis()));
        w.append("-- ");
        w.append(dateTimeText);
        w.append("\n");
        w.append("-- ");
        w.append(prm_COMMENT);
        w.append("\n");
        w.append(statement);
        w.append("\n;\n\n");
        w.flush();
    }

    static {
        tempFilePg = null;
        tempFileMySQL = null;
    }
}

