/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.impexp;

import java.math.BigDecimal;
import java.util.logging.Level;
import org.compiere.impexp.MImpFormat;
import org.compiere.impexp.MImpFormatRow;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;

public class CopyImportFormat
extends SvrProcess {
    private int from_AD_ImpFormat_ID = 0;
    private int to_AD_ImpFormat_ID = 0;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i = 0; i < para.length; ++i) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() == null) continue;
            if (name.equals("AD_ImpFormat_ID")) {
                this.from_AD_ImpFormat_ID = ((BigDecimal)para[i].getParameter()).intValue();
                continue;
            }
            this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + name);
        }
        this.to_AD_ImpFormat_ID = this.getRecord_ID();
    }

    @Override
    protected String doIt() throws Exception {
        this.log.info("doIt = From=" + this.from_AD_ImpFormat_ID + " To=" + this.to_AD_ImpFormat_ID);
        MImpFormat from = new MImpFormat(this.getCtx(), this.from_AD_ImpFormat_ID, this.get_TrxName());
        if (from.getAD_ImpFormat_ID() != this.from_AD_ImpFormat_ID) {
            throw new Exception("From Format not found - " + this.from_AD_ImpFormat_ID);
        }
        MImpFormat to = new MImpFormat(this.getCtx(), this.to_AD_ImpFormat_ID, this.get_TrxName());
        if (to.getAD_ImpFormat_ID() != this.to_AD_ImpFormat_ID) {
            throw new Exception("To Format not found - " + this.from_AD_ImpFormat_ID);
        }
        if (from.getAD_Table_ID() != to.getAD_Table_ID()) {
            throw new Exception("From-To do Not have same Format Table");
        }
        MImpFormatRow[] rows = from.getRows();
        for (int i = 0; i < rows.length; ++i) {
            MImpFormatRow row = rows[i];
            MImpFormatRow copy = new MImpFormatRow(to, row);
            if (copy.save()) continue;
            throw new Exception("Copy error");
        }
        String msg = "#" + rows.length;
        if (!from.getFormatType().equals(to.getFormatType())) {
            return msg + " - Note: Format Type different!";
        }
        return msg;
    }
}

