/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.compiere.model.GridFieldVO;
import org.compiere.model.GridWindowVO;
import org.compiere.model.MField;
import org.compiere.model.MRole;
import org.compiere.model.MTab;
import org.compiere.model.MTable;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Evaluatee;
import org.compiere.util.Evaluator;
import org.compiere.util.Util;
import org.spin.util.ASPUtil;

public class GridTabVO
implements Evaluatee,
Serializable {
    static final long serialVersionUID = 9160212869277319305L;
    public Properties ctx;
    public int WindowNo;
    public int AD_Window_ID;
    public int TabNo;
    public int AD_Tab_ID;
    public String Name = "";
    public String Description = "";
    public String Help = "";
    public boolean IsSingleRow = false;
    public boolean IsReadOnly = false;
    public boolean IsInsertRecord = true;
    public boolean HasTree = false;
    public int AD_Table_ID;
    public int AD_Column_ID = 0;
    public int Parent_Column_ID = 0;
    public String TableName;
    public boolean IsView = false;
    public String AccessLevel;
    public boolean IsSecurityEnabled = false;
    public boolean IsDeleteable = false;
    public boolean IsHighVolume = false;
    public int AD_Process_ID = 0;
    public String CommitWarning;
    public String WhereClause;
    public String OrderByClause;
    public String ReadOnlyLogic;
    public String DisplayLogic;
    public int TabLevel = 0;
    public int AD_Image_ID = 0;
    public int Included_Tab_ID = 0;
    public String ReplicationType = "L";
    public boolean IsSortTab = false;
    public int AD_ColumnSortOrder_ID = 0;
    public int AD_ColumnSortYesNo_ID = 0;
    public boolean onlyCurrentRows = true;
    public int onlyCurrentDays = 0;
    private ArrayList<GridFieldVO> Fields = null;
    private boolean initFields = false;

    public static GridTabVO create(GridWindowVO wVO, int tabNo, MTab tab, boolean isRO, boolean onlyCurrentRows) {
        CLogger.get().config("#" + tabNo);
        GridTabVO vo = new GridTabVO(wVO.ctx, wVO.WindowNo);
        vo.AD_Window_ID = wVO.AD_Window_ID;
        vo.TabNo = tabNo;
        if (!GridTabVO.loadTabDetails(vo, tab)) {
            return null;
        }
        if (isRO) {
            CLogger.get().fine("Tab is ReadOnly");
            vo.IsReadOnly = true;
        }
        vo.onlyCurrentRows = onlyCurrentRows;
        if (vo.IsSortTab) {
            vo.Fields = new ArrayList();
        }
        return vo;
    }

    private static boolean loadTabDetails(GridTabVO vo, MTab tab) {
        MRole role = MRole.getDefault(vo.ctx, false);
        boolean showTrl = "Y".equals(Env.getContext(vo.ctx, "#ShowTrl"));
        boolean showAcct = "Y".equals(Env.getContext(vo.ctx, "#ShowAcct"));
        boolean showAdvanced = "Y".equals(Env.getContext(vo.ctx, "#ShowAdvanced"));
        vo.AD_Tab_ID = tab.getAD_Tab_ID();
        Env.setContext(vo.ctx, vo.WindowNo, vo.TabNo, "_TabInfo_AD_Tab_ID", String.valueOf(vo.AD_Tab_ID));
        vo.Name = tab.getName();
        Env.setContext(vo.ctx, vo.WindowNo, vo.TabNo, "_TabInfo_Name", vo.Name);
        MTable table2 = MTable.get(vo.ctx, tab.getAD_Table_ID());
        if (tab.isTranslationTab()) {
            vo.TableName = table2.getTableName();
            if (!Env.isBaseTranslation(vo.TableName) && !Env.isMultiLingualDocument(vo.ctx)) {
                showTrl = false;
            }
            if (!showTrl) {
                CLogger.get().config("TrlTab Not displayed - AD_Tab_ID=" + vo.AD_Tab_ID + "=" + vo.Name + ", Table=" + vo.TableName + ", BaseTrl=" + Env.isBaseTranslation(vo.TableName) + ", MultiLingual=" + Env.isMultiLingualDocument(vo.ctx));
                return false;
            }
        }
        if (!showAdvanced && tab.isAdvancedTab()) {
            CLogger.get().config("AdvancedTab Not displayed - AD_Tab_ID=" + vo.AD_Tab_ID + " " + vo.Name);
            return false;
        }
        if (!showAcct && tab.isInfoTab()) {
            CLogger.get().fine("AcctTab Not displayed - AD_Tab_ID=" + vo.AD_Tab_ID + " " + vo.Name);
            return false;
        }
        vo.DisplayLogic = tab.getDisplayLogic();
        vo.AccessLevel = table2.getAccessLevel();
        if (!role.canView(vo.ctx, vo.AccessLevel)) {
            CLogger.get().fine("No Role Access - AD_Tab_ID=" + vo.AD_Tab_ID + " " + vo.Name);
            return false;
        }
        Env.setContext(vo.ctx, vo.WindowNo, vo.TabNo, "_TabInfo_AccessLevel", vo.AccessLevel);
        vo.AD_Table_ID = tab.getAD_Table_ID();
        Env.setContext(vo.ctx, vo.WindowNo, vo.TabNo, "_TabInfo_AD_Table_ID", String.valueOf(vo.AD_Table_ID));
        if (!role.isTableAccess(vo.AD_Table_ID, true)) {
            CLogger.get().config("No Table Access - AD_Tab_ID=" + vo.AD_Tab_ID + " " + vo.Name);
            return false;
        }
        if (tab.isReadOnly()) {
            vo.IsReadOnly = true;
        }
        vo.ReadOnlyLogic = tab.getReadOnlyLogic();
        if (!vo.IsReadOnly && vo.ReadOnlyLogic != null) {
            vo.IsReadOnly = Evaluator.evaluateLogic(vo, vo.ReadOnlyLogic);
        }
        if (!tab.isInsertRecord()) {
            vo.IsInsertRecord = false;
        }
        vo.Description = tab.getDescription();
        if (vo.Description == null) {
            vo.Description = "";
        }
        vo.Help = tab.getHelp();
        if (vo.Help == null) {
            vo.Help = "";
        }
        if (tab.isSingleRow()) {
            vo.IsSingleRow = true;
        }
        if (tab.isHasTree()) {
            vo.HasTree = true;
        }
        vo.AD_Table_ID = tab.getAD_Table_ID();
        vo.TableName = table2.getTableName();
        if (table2.isView()) {
            vo.IsView = true;
        }
        vo.AD_Column_ID = tab.getAD_Column_ID();
        vo.Parent_Column_ID = tab.getParent_Column_ID();
        if (table2.isSecurityEnabled()) {
            vo.IsSecurityEnabled = true;
        }
        if (table2.isDeleteable()) {
            vo.IsDeleteable = true;
        }
        if (table2.isHighVolume()) {
            vo.IsHighVolume = true;
        }
        vo.CommitWarning = tab.getCommitWarning();
        if (vo.CommitWarning == null) {
            vo.CommitWarning = "";
        }
        vo.WhereClause = tab.getWhereClause();
        if (vo.WhereClause == null) {
            vo.WhereClause = "";
        }
        if (vo.WhereClause.indexOf("=null") > 0) {
            vo.WhereClause.replaceAll("=null", " IS NULL ");
        }
        if (vo.WhereClause.trim().length() > 0) {
            vo.WhereClause = "(" + vo.WhereClause + ")";
        }
        vo.OrderByClause = tab.getOrderByClause();
        if (vo.OrderByClause == null) {
            vo.OrderByClause = "";
        }
        vo.AD_Process_ID = tab.getAD_Process_ID();
        vo.AD_Image_ID = tab.getAD_Image_ID();
        vo.Included_Tab_ID = tab.getIncluded_Tab_ID();
        vo.TabLevel = tab.getTabLevel();
        vo.IsSortTab = tab.isSortTab();
        if (vo.IsSortTab) {
            vo.AD_ColumnSortOrder_ID = tab.getAD_ColumnSortOrder_ID();
            vo.AD_ColumnSortYesNo_ID = tab.getAD_ColumnSortYesNo_ID();
        }
        vo.ReplicationType = table2.getReplicationType();
        if (!Util.isEmpty(vo.ReplicationType) && "R".equals(vo.ReplicationType)) {
            vo.IsReadOnly = true;
        }
        return true;
    }

    private static boolean createFields(GridTabVO gridTabVO) {
        Optional<GridTabVO> maybeGridTabVO = Optional.ofNullable(gridTabVO);
        ArrayList gridFieldVOList = new ArrayList();
        maybeGridTabVO.ifPresent(gridTabValueObject -> {
            Optional<ASPUtil> maybeInstance = Optional.ofNullable(ASPUtil.getInstance(gridTabValueObject.ctx));
            maybeInstance.ifPresent(instance -> {
                List<MField> fields = instance.getWindowFields(gridTabValueObject.AD_Tab_ID).stream().filter(Objects::nonNull).collect(Collectors.toList());
                fields.forEach(field -> {
                    GridFieldVO gridFieldVO = GridFieldVO.create(gridTabValueObject.ctx, gridTabValueObject.WindowNo, gridTabValueObject.TabNo, gridTabValueObject.AD_Window_ID, gridTabValueObject.AD_Tab_ID, gridTabValueObject.IsReadOnly, field);
                    gridFieldVOList.add(gridFieldVO);
                });
                gridTabVO.Fields = gridFieldVOList;
                gridTabVO.initFields = true;
            });
        });
        return gridFieldVOList.size() != 0;
    }

    private GridTabVO(Properties Ctx, int windowNo) {
        this.ctx = Ctx;
        this.WindowNo = windowNo;
    }

    public ArrayList<GridFieldVO> getFields() {
        if (!this.initFields) {
            GridTabVO.createFields(this);
        }
        return this.Fields;
    }

    public void setCtx(Properties newCtx) {
        this.ctx = newCtx;
        if (this.Fields != null) {
            for (int i2 = 0; i2 < this.Fields.size(); ++i2) {
                GridFieldVO field = this.Fields.get(i2);
                field.setCtx(newCtx);
            }
        }
    }

    @Override
    public String get_ValueAsString(String variableName) {
        return Env.getContext(this.ctx, this.WindowNo, variableName, false);
    }

    protected GridTabVO clone(Properties Ctx, int windowNo) {
        GridTabVO clone = new GridTabVO(Ctx, windowNo);
        clone.AD_Window_ID = this.AD_Window_ID;
        clone.TabNo = this.TabNo;
        Env.setContext(Ctx, windowNo, clone.TabNo, "_TabInfo_AD_Tab_ID", String.valueOf(clone.AD_Tab_ID));
        clone.AD_Tab_ID = this.AD_Tab_ID;
        clone.Name = this.Name;
        Env.setContext(Ctx, windowNo, clone.TabNo, "_TabInfo_Name", clone.Name);
        clone.Description = this.Description;
        clone.Help = this.Help;
        clone.IsSingleRow = this.IsSingleRow;
        clone.IsReadOnly = this.IsReadOnly;
        clone.IsInsertRecord = this.IsInsertRecord;
        clone.HasTree = this.HasTree;
        clone.AD_Table_ID = this.AD_Table_ID;
        clone.AD_Column_ID = this.AD_Column_ID;
        clone.Parent_Column_ID = this.Parent_Column_ID;
        clone.TableName = this.TableName;
        clone.IsView = this.IsView;
        clone.AccessLevel = this.AccessLevel;
        clone.IsSecurityEnabled = this.IsSecurityEnabled;
        clone.IsDeleteable = this.IsDeleteable;
        clone.IsHighVolume = this.IsHighVolume;
        clone.AD_Process_ID = this.AD_Process_ID;
        clone.CommitWarning = this.CommitWarning;
        clone.WhereClause = this.WhereClause;
        clone.OrderByClause = this.OrderByClause;
        clone.ReadOnlyLogic = this.ReadOnlyLogic;
        clone.DisplayLogic = this.DisplayLogic;
        clone.TabLevel = this.TabLevel;
        clone.AD_Image_ID = this.AD_Image_ID;
        clone.Included_Tab_ID = this.Included_Tab_ID;
        clone.ReplicationType = this.ReplicationType;
        Env.setContext(Ctx, windowNo, clone.TabNo, "_TabInfo_AccessLevel", clone.AccessLevel);
        Env.setContext(Ctx, windowNo, clone.TabNo, "_TabInfo_AD_Table_ID", String.valueOf(clone.AD_Table_ID));
        clone.IsSortTab = this.IsSortTab;
        clone.AD_ColumnSortOrder_ID = this.AD_ColumnSortOrder_ID;
        clone.AD_ColumnSortYesNo_ID = this.AD_ColumnSortYesNo_ID;
        clone.onlyCurrentRows = true;
        clone.onlyCurrentDays = 0;
        clone.Fields = new ArrayList();
        for (int i2 = 0; i2 < this.Fields.size(); ++i2) {
            GridFieldVO field = this.Fields.get(i2);
            GridFieldVO cloneField = field.clone(Ctx, windowNo, this.TabNo, this.AD_Window_ID, this.AD_Tab_ID, this.IsReadOnly);
            if (cloneField == null) {
                return null;
            }
            clone.Fields.add(cloneField);
        }
        return clone;
    }

    public boolean isInitFields() {
        return this.initFields;
    }
}

