/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.awt.Dimension;
import java.awt.Image;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.Icon;
import org.adempiere.legacy.apache.ecs.Element;
import org.adempiere.legacy.apache.ecs.xhtml.a;
import org.adempiere.legacy.apache.ecs.xhtml.h2;
import org.adempiere.legacy.apache.ecs.xhtml.h3;
import org.adempiere.legacy.apache.ecs.xhtml.h4;
import org.adempiere.legacy.apache.ecs.xhtml.i;
import org.adempiere.legacy.apache.ecs.xhtml.p;
import org.adempiere.legacy.apache.ecs.xhtml.strong;
import org.adempiere.legacy.apache.ecs.xhtml.table;
import org.adempiere.legacy.apache.ecs.xhtml.td;
import org.adempiere.legacy.apache.ecs.xhtml.th;
import org.adempiere.legacy.apache.ecs.xhtml.tr;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.GridTabVO;
import org.compiere.model.GridWindowVO;
import org.compiere.model.MImage;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.WebDoc;

public class GridWindow
implements Serializable {
    private static final long serialVersionUID = 3342733142743698614L;
    private GridWindowVO m_vo;
    private boolean m_virtual;
    private ArrayList<GridTab> m_tabs = new ArrayList();
    private Timestamp m_modelUpdated = null;
    private Set<GridTab> initTabs = new HashSet<GridTab>();
    private static CLogger log = CLogger.getCLogger(GridWindow.class);

    public static GridWindow get(Properties ctx, int WindowNo, int AD_Window_ID) {
        return GridWindow.get(ctx, WindowNo, AD_Window_ID, false);
    }

    public static GridWindow get(Properties ctx, int WindowNo, int AD_Window_ID, boolean virtual) {
        log.config("Window=" + WindowNo + ", AD_Window_ID=" + AD_Window_ID);
        GridWindowVO mWindowVO = GridWindowVO.create(Env.getCtx(), WindowNo, AD_Window_ID);
        if (mWindowVO == null) {
            return null;
        }
        return new GridWindow(mWindowVO, virtual);
    }

    public GridWindow(GridWindowVO vo) {
        this(vo, false);
    }

    public GridWindow(GridWindowVO vo, boolean virtual) {
        this.m_vo = vo;
        this.m_virtual = virtual;
        if (this.loadTabData()) {
            this.enableEvents();
        }
    }

    public void dispose() {
        log.info("AD_Window_ID=" + this.m_vo.AD_Window_ID);
        for (int i = 0; i < this.getTabCount(); ++i) {
            this.getTab(i).dispose();
        }
        this.m_tabs.clear();
        this.m_tabs = null;
    }

    public void loadCompete() {
        for (int i = 0; i < this.getTabCount(); ++i) {
            this.getTab(i).getMTable().loadComplete();
        }
    }

    private boolean loadTabData() {
        log.config("");
        if (this.m_vo.Tabs == null) {
            return false;
        }
        for (int t = 0; t < this.m_vo.Tabs.size(); ++t) {
            GridTabVO mTabVO = this.m_vo.Tabs.get(t);
            if (mTabVO == null) continue;
            GridTab mTab = new GridTab(mTabVO, this, this.m_virtual);
            this.m_tabs.add(mTab);
        }
        return true;
    }

    public boolean isTabInitialized(int index) {
        GridTab mTab = this.m_tabs.get(index);
        return this.initTabs.contains(mTab);
    }

    public void initTab(int index) {
        ArrayList<String> parents;
        GridTab mTab = this.m_tabs.get(index);
        if (this.initTabs.contains(mTab)) {
            return;
        }
        mTab.initTab(false);
        if (mTab.getLinkColumnName().length() == 0 && (parents = mTab.getParentColumnNames()).size() != 0) {
            if (parents.size() == 1) {
                mTab.setLinkColumnName(parents.get(0));
            } else {
                block0: for (int i = 0; i < index; ++i) {
                    GridTab tab = this.m_tabs.get(i);
                    String tabKey = tab.getKeyColumnName();
                    block1: for (int j = 0; j < parents.size(); ++j) {
                        String parent = parents.get(j);
                        if (parent.equals(tabKey)) {
                            mTab.setLinkColumnName(parent);
                            continue block0;
                        }
                        if (!tabKey.equals("")) continue;
                        for (int k = 0; k < tab.getParentColumnNames().size(); ++k) {
                            if (!parent.equals(tab.getParentColumnNames().get(k))) continue;
                            mTab.setLinkColumnName(parent);
                            continue block1;
                        }
                    }
                }
            }
        }
        mTab.setLinkColumnName(null);
        this.initTabs.add(mTab);
    }

    public Image getImage() {
        if (this.m_vo.AD_Image_ID == 0) {
            return null;
        }
        MImage mImage = MImage.get(Env.getCtx(), this.m_vo.AD_Image_ID);
        return mImage.getImage();
    }

    public Icon getIcon() {
        if (this.m_vo.AD_Image_ID == 0) {
            return null;
        }
        MImage mImage = MImage.get(Env.getCtx(), this.m_vo.AD_Image_ID);
        return mImage.getIcon();
    }

    public int getColorId() {
        return this.m_vo.AD_Color_ID;
    }

    public boolean isSOTrx() {
        return this.m_vo.IsSOTrx;
    }

    public void query() {
        log.info("");
        GridTab tab = this.getTab(0);
        tab.query(false, 0, 0);
        if (tab.getRowCount() > 0) {
            tab.navigate(0);
        }
    }

    private void enableEvents() {
        for (int i = 0; i < this.getTabCount(); ++i) {
            this.getTab(i).enableEvents();
        }
    }

    public int getTabCount() {
        return this.m_tabs.size();
    }

    public GridTab getTab(int i) {
        if (i < 0 || i + 1 > this.m_tabs.size()) {
            return null;
        }
        return this.m_tabs.get(i);
    }

    public int getTabIndex(GridTab tab) {
        return this.m_tabs.indexOf(tab);
    }

    public int getAD_Window_ID() {
        return this.m_vo.AD_Window_ID;
    }

    public int getWindowNo() {
        return this.m_vo.WindowNo;
    }

    public String getName() {
        return this.m_vo.Name;
    }

    public String getDescription() {
        return this.m_vo.Description;
    }

    public String getHelp() {
        return this.m_vo.Help;
    }

    public String getWindowType() {
        return this.m_vo.WindowType;
    }

    public boolean isTransaction() {
        return this.m_vo.WindowType.equals("T");
    }

    public Dimension getWindowSize() {
        if (this.m_vo.WinWidth != 0 && this.m_vo.WinHeight != 0) {
            return new Dimension(this.m_vo.WinWidth, this.m_vo.WinHeight);
        }
        return null;
    }

    public String toString() {
        return "MWindow[" + this.m_vo.WindowNo + "," + this.m_vo.Name + " (" + this.m_vo.AD_Window_ID + ")]";
    }

    public WebDoc getHelpDoc(boolean javaClient) {
        int i2;
        String title = Msg.getMsg(Env.getCtx(), "Window") + ": " + this.getName();
        WebDoc doc = null;
        if (javaClient) {
            doc = WebDoc.create(false, title, javaClient);
        } else {
            doc = WebDoc.createPopup(title);
            doc.addPopupClose(Env.getCtx());
        }
        td center = doc.addPopupCenter(false);
        if (this.getDescription().length() != 0) {
            center.addElement((Element)new p().addElement((Element)new i(this.getDescription())));
        }
        if (this.getHelp().length() != 0) {
            center.addElement((Element)new p().addElement(this.getHelp()));
        }
        center.addElement((Element)new a().setName("Tabs")).addElement(new h3("Tabs").addAttribute("ALIGN", "left"));
        int size = this.getTabCount();
        p p2 = new p();
        for (i2 = 0; i2 < size; ++i2) {
            GridTab tab = this.getTab(i2);
            if (i2 > 0) {
                p2.addElement(" | ");
            }
            p2.addElement((Element)new a("#Tab" + i2).addElement(tab.getName()));
        }
        center.addElement((Element)p2).addElement((Element)new p().addElement("&nbsp;"));
        for (i2 = 0; i2 < size; ++i2) {
            String hdr;
            GridField field;
            int j;
            table table2 = new table("1", "5", "5", "100%", null);
            table2.setBorder("1px").setCellSpacing(0);
            GridTab tab = this.getTab(i2);
            table tabHeader = new table();
            tabHeader.setBorder("0").setCellPadding(0).setCellSpacing(0);
            tabHeader.addElement((Element)new tr().addElement((Element)new td().addElement((Element)new a().setName("Tab" + i2)).addElement((Element)new h2(Msg.getMsg(Env.getCtx(), "Tab") + ": " + tab.getName()))).addElement((Element)new td().addElement("&nbsp;").addElement("&nbsp;").addElement(new a("#Tabs").addElement("..").addAttribute("title", "Up one level"))));
            tr tr2 = new tr().addElement((Element)new th().addElement((Element)tabHeader));
            if (tab.getDescription().length() != 0) {
                tr2.addElement((Element)new th().addElement((Element)new i(tab.getDescription())));
            } else {
                tr2.addElement((Element)new th().addElement("&nbsp;"));
            }
            table2.addElement((Element)tr2);
            td td2 = new td().setColSpan(2);
            if (tab.getHelp().length() != 0) {
                td2.addElement((Element)new p().addElement(tab.getHelp()));
            }
            td2.addElement((Element)new a().setName("Fields" + i2));
            td2.addElement(new h4("Fields").addAttribute("ALIGN", "left"));
            p2 = new p();
            if (!tab.isLoadComplete()) {
                this.initTab(i2);
            }
            for (j = 0; j < tab.getFieldCount(); ++j) {
                field = tab.getField(j);
                if (!field.isDisplayed(false) || (hdr = field.getHeader()) == null || hdr.length() <= 0) continue;
                if (j > 0) {
                    p2.addElement(" | ");
                }
                p2.addElement((Element)new a("#Field" + i2 + "-" + j, hdr));
            }
            td2.addElement((Element)p2);
            table2.addElement((Element)new tr().addElement((Element)td2));
            for (j = 0; j < tab.getFieldCount(); ++j) {
                field = tab.getField(j);
                if (!field.isDisplayed(false) || (hdr = field.getHeader()) == null || hdr.length() <= 0) continue;
                table fieldHeader = new table();
                fieldHeader.setBorder("0").setCellPadding(0).setCellSpacing(0);
                fieldHeader.addElement((Element)new tr().addElement((Element)new td().addElement((Element)new a().setName("Field" + i2 + "-" + j)).addElement((Element)new h3(Msg.getMsg(Env.getCtx(), "Field") + ": " + hdr))).addElement((Element)new td().addElement("&nbsp;").addElement("&nbsp;").addElement((Element)new strong().addElement(new a("#Fields" + i2).addElement("..").addAttribute("title", "Up one level")))));
                td2 = new td().setColSpan(2).addElement((Element)fieldHeader);
                if (field.getDescription().length() != 0) {
                    td2.addElement((Element)new i(field.getDescription()));
                }
                if (field.getHelp().length() != 0) {
                    td2.addElement((Element)new p().addElement(field.getHelp()));
                }
                table2.addElement((Element)new tr().addElement((Element)td2));
            }
            center.addElement((Element)table2);
            center.addElement((Element)new p().addElement("&nbsp;"));
        }
        if (!javaClient) {
            doc.addPopupClose(Env.getCtx());
        }
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timestamp getModelUpdated(boolean recalc) {
        if (recalc || this.m_modelUpdated == null) {
            String sql = "SELECT MAX(w.Updated), MAX(t.Updated), MAX(tt.Updated), MAX(f.Updated), MAX(c.Updated) FROM AD_Window w INNER JOIN AD_Tab t ON (w.AD_Window_ID=t.AD_Window_ID) INNER JOIN AD_Table tt ON (t.AD_Table_ID=tt.AD_Table_ID) INNER JOIN AD_Field f ON (t.AD_Tab_ID=f.AD_Tab_ID) INNER JOIN AD_Column c ON (f.AD_Column_ID=c.AD_Column_ID) WHERE w.AD_Window_ID=?";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                pstmt = DB.prepareStatement(sql, null);
                pstmt.setInt(1, this.getAD_Window_ID());
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    this.m_modelUpdated = rs.getTimestamp(1);
                    Timestamp ts = rs.getTimestamp(2);
                    if (ts.after(this.m_modelUpdated)) {
                        this.m_modelUpdated = ts;
                    }
                    if ((ts = rs.getTimestamp(3)).after(this.m_modelUpdated)) {
                        this.m_modelUpdated = ts;
                    }
                    if ((ts = rs.getTimestamp(4)).after(this.m_modelUpdated)) {
                        this.m_modelUpdated = ts;
                    }
                    if ((ts = rs.getTimestamp(5)).after(this.m_modelUpdated)) {
                        this.m_modelUpdated = ts;
                    }
                }
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
            }
            catch (Exception e) {
                log.log(Level.SEVERE, sql, e);
            }
            finally {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
            }
        }
        return this.m_modelUpdated;
    }
}

