/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import org.adempiere.core.domains.models.X_C_AcctProcessor;
import org.compiere.model.AdempiereProcessor;
import org.compiere.model.AdempiereProcessorLog;
import org.compiere.model.MAcctProcessorLog;
import org.compiere.model.MClient;
import org.compiere.model.Query;
import org.compiere.util.DB;
import org.compiere.util.Msg;

public class MAcctProcessor
extends X_C_AcctProcessor
implements AdempiereProcessor {
    private static final long serialVersionUID = 6558688522646469260L;

    public static MAcctProcessor[] getActive(Properties ctx) {
        List<MAcctProcessor> list = new Query(ctx, "C_AcctProcessor", null, null).setOnlyActiveRecords(true).list();
        return list.toArray(new MAcctProcessor[list.size()]);
    }

    public MAcctProcessor(Properties ctx, int C_AcctProcessor_ID, String trxName) {
        super(ctx, C_AcctProcessor_ID, trxName);
        if (C_AcctProcessor_ID == 0) {
            this.setFrequencyType("H");
            this.setFrequency(1);
            this.setKeepLogDays(7);
        }
    }

    public MAcctProcessor(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MAcctProcessor(MClient client, int Supervisor_ID) {
        this(client.getCtx(), 0, client.get_TrxName());
        this.setClientOrg(client);
        this.setName(client.getName() + " - " + Msg.translate(this.getCtx(), "C_AcctProcessor_ID"));
        this.setSupervisor_ID(Supervisor_ID);
    }

    @Override
    public String getServerID() {
        return "AcctProcessor" + this.get_ID();
    }

    @Override
    public Timestamp getDateNextRun(boolean requery) {
        if (requery) {
            this.load(this.get_TrxName());
        }
        return this.getDateNextRun();
    }

    @Override
    public AdempiereProcessorLog[] getLogs() {
        String whereClause = "C_AcctProcessor_ID=? ";
        List<MAcctProcessorLog> list = new Query(this.getCtx(), "C_AcctProcessorLog", whereClause, this.get_TrxName()).setParameters(this.getC_AcctProcessor_ID()).setOrderBy("Created DESC").list();
        return list.toArray(new MAcctProcessorLog[list.size()]);
    }

    public int deleteLog() {
        if (this.getKeepLogDays() < 1) {
            return 0;
        }
        String sql = "DELETE C_AcctProcessorLog WHERE C_AcctProcessor_ID=" + this.getC_AcctProcessor_ID() + " AND (Created+" + this.getKeepLogDays() + ") < SysDate";
        int no = DB.executeUpdate(sql, this.get_TrxName());
        return no;
    }
}

