/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import java.util.logging.Level;
import org.compiere.util.CLogger;
import org.compiere.util.MimeType;

public class MAttachmentEntry {
    private String m_name = "?";
    private byte[] m_data = null;
    private static long s_seed = System.currentTimeMillis();
    private static Random s_random = new Random(s_seed);
    private int m_index = 0;
    protected CLogger log = CLogger.getCLogger(this.getClass());

    public MAttachmentEntry(String name, byte[] data, int index) {
        this.setName(name);
        this.setData(data);
        if (index > 0) {
            this.m_index = index;
        } else {
            long now = System.currentTimeMillis();
            if (s_seed + 3600000L < now) {
                s_seed = now;
                s_random = new Random(s_seed);
            }
            this.m_index = s_random.nextInt();
        }
    }

    public MAttachmentEntry(String name, byte[] data) {
        this(name, data, 0);
    }

    public byte[] getData() {
        return this.m_data;
    }

    public void setData(byte[] data) {
        this.m_data = data;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        if (name != null) {
            this.m_name = name;
        }
        if (this.m_name == null) {
            this.m_name = "?";
        }
    }

    public int getIndex() {
        return this.m_index;
    }

    public String toString() {
        return this.m_name;
    }

    public String toStringX() {
        StringBuffer sb = new StringBuffer(this.m_name);
        if (this.m_data != null) {
            sb.append(" (");
            float size = this.m_data.length;
            if (size <= 1024.0f) {
                sb.append(this.m_data.length).append(" B");
            } else if ((size /= 1024.0f) > 1024.0f) {
                sb.append(size /= 1024.0f).append(" MB");
            } else {
                sb.append(size).append(" kB");
            }
            sb.append(")");
        }
        sb.append(" - ").append(this.getContentType());
        return sb.toString();
    }

    public void dump() {
        String hdr = "----- " + this.getName() + " -----";
        System.out.println(hdr);
        if (this.m_data == null) {
            System.out.println("----- no data -----");
            return;
        }
        for (int i = 0; i < this.m_data.length; ++i) {
            char data = (char)this.m_data[i];
            System.out.print(data);
        }
        System.out.println();
        System.out.println(hdr);
        int ii = this.m_data.length - 1;
        int nullCount = 0;
        while (this.m_data[ii--] == 0) {
            ++nullCount;
        }
        System.out.println("----- Length=" + this.m_data.length + ", EndNulls=" + nullCount + ", RealLength=" + (this.m_data.length - nullCount));
    }

    public File getFile() {
        return this.getFile(this.getName());
    }

    public File getFile(String fileName) {
        if (fileName == null || fileName.length() == 0) {
            fileName = this.getName();
        }
        return this.getFile(new File(fileName));
    }

    public File getFile(File file) {
        if (this.m_data == null || this.m_data.length == 0) {
            return null;
        }
        try {
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(this.m_data);
            fos.close();
        }
        catch (IOException ioe) {
            this.log.log(Level.SEVERE, "getFile", ioe);
            throw new RuntimeException(ioe);
        }
        return file;
    }

    public boolean isPDF() {
        return this.m_name.toLowerCase().endsWith(".pdf");
    }

    public boolean isGraphic() {
        String m_lowname = this.m_name.toLowerCase();
        return m_lowname.endsWith(".gif") || m_lowname.endsWith(".jpg") || m_lowname.endsWith(".png");
    }

    public String getContentType() {
        return MimeType.getMimeType(this.m_name);
    }

    public InputStream getInputStream() {
        if (this.m_data == null) {
            return null;
        }
        return new ByteArrayInputStream(this.m_data);
    }
}

