/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.core.domains.models.X_C_CommissionRun;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.model.MView;
import org.compiere.model.MBPartner;
import org.compiere.model.MCommission;
import org.compiere.model.MCommissionAmt;
import org.compiere.model.MCommissionDetail;
import org.compiere.model.MCommissionGroup;
import org.compiere.model.MCommissionLine;
import org.compiere.model.MCommissionType;
import org.compiere.model.MDocType;
import org.compiere.model.MPeriod;
import org.compiere.model.MSalesRegion;
import org.compiere.model.MTree;
import org.compiere.model.MUser;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.Query;
import org.compiere.process.DocAction;
import org.compiere.process.DocOptions;
import org.compiere.process.DocumentEngine;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class MCommissionRun
extends X_C_CommissionRun
implements DocAction,
DocOptions {
    private static final long serialVersionUID = 20170318L;
    private String m_processMsg = null;
    private boolean m_justPrepared = false;

    public MCommissionRun(Properties ctx, int C_CommissionRun_ID, String trxName) {
        super(ctx, C_CommissionRun_ID, trxName);
    }

    public MCommissionRun(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MCommissionRun(MCommission commission) {
        this(commission.getCtx(), 0, commission.get_TrxName());
        this.setClientOrg(commission);
        this.setC_Commission_ID(commission.getC_Commission_ID());
    }

    public MCommissionAmt[] getAmts() {
        String whereClause = "C_CommissionRun_ID=?";
        List<MCommissionAmt> list = new Query(this.getCtx(), "C_CommissionAmt", "C_CommissionRun_ID=?", this.get_TrxName()).setParameters(this.getC_CommissionRun_ID()).list();
        MCommissionAmt[] retValue = new MCommissionAmt[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public void updateFromAmt() {
        MCommissionAmt[] amts = this.getAmts();
        BigDecimal GrandTotal = Env.ZERO;
        for (int i = 0; i < amts.length; ++i) {
            MCommissionAmt amt = amts[i];
            GrandTotal = GrandTotal.add(amt.getCommissionAmt());
        }
        this.setGrandTotal(GrandTotal);
    }

    @Override
    public String getDocumentInfo() {
        MDocType dt = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        return dt.getName() + " " + this.getDocumentNo();
    }

    @Override
    public File createPDF() {
        try {
            File temp = File.createTempFile(this.get_TableName() + this.get_ID() + "_", ".pdf");
            return this.createPDF(temp);
        }
        catch (Exception e) {
            this.log.severe("Could not create PDF - " + e.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        return null;
    }

    @Override
    public boolean processIt(String processAction) {
        this.m_processMsg = null;
        DocumentEngine engine = new DocumentEngine(this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    @Override
    public boolean unlockIt() {
        this.log.info("unlockIt - " + this.toString());
        return true;
    }

    @Override
    public boolean invalidateIt() {
        this.log.info("invalidateIt - " + this.toString());
        this.setDocAction("PR");
        return true;
    }

    @Override
    public String prepareIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        MDocType dt = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        if (!MPeriod.isOpen(this.getCtx(), this.getDateDoc(), dt.getDocBaseType(), this.getAD_Org_ID())) {
            this.m_processMsg = "@PeriodClosed@";
            return "IN";
        }
        if (this.getDocStatus().equals("DR") || this.getDocStatus().equals("IN") || this.getDocStatus().equals("IP") && this.isReCalculate()) {
            try {
                this.createMovements();
            }
            catch (Exception e) {
                this.m_processMsg = e.getMessage();
                return "IN";
            }
            this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 8);
            if (this.m_processMsg != null) {
                return "IN";
            }
        }
        this.m_justPrepared = true;
        if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("CO");
        }
        return "IP";
    }

    private void deleteMovements() {
        int no = DB.executeUpdateEx("DELETE FROM C_CommissionAmt c WHERE C_CommissionRun_ID = ?", new Object[]{this.getC_CommissionRun_ID()}, this.get_TrxName());
        this.log.info("C_CommissionAmt deleted #" + no);
    }

    private void createMovements() throws Exception {
        String frequencyType = null;
        List<Object> commissionList = new ArrayList<MCommission>();
        if (this.getC_Commission_ID() != 0) {
            MCommission commission = new MCommission(this.getCtx(), this.getC_Commission_ID(), this.get_TrxName());
            if (commission.isActive()) {
                commissionList.add(commission);
                frequencyType = commission.getFrequencyType();
            }
        } else if (this.getC_CommissionGroup_ID() != 0) {
            MCommissionGroup group = new MCommissionGroup(this.getCtx(), this.getC_CommissionGroup_ID(), this.get_TrxName());
            commissionList = group.getLines(null);
            frequencyType = group.getFrequencyType();
        }
        if (commissionList.size() == 0) {
            throw new AdempiereException("@NoCommissionDefined@");
        }
        this.deleteMovements();
        this.setStartEndDate(frequencyType);
        this.log.info("StartDate = " + this.getStartDate() + ", EndDate = " + this.getEndDate());
        for (MCommission mCommission : commissionList) {
            for (MBPartner salesRep : mCommission.getSalesRepsOfCommission()) {
                this.processCommissionLine(salesRep, mCommission);
                if (!mCommission.isAllowRMA()) continue;
            }
        }
        this.saveEx();
    }

    private boolean isCustom(String docBasisType) {
        if (Util.isEmpty(docBasisType)) {
            return false;
        }
        return !docBasisType.equals("O") && !docBasisType.equals("I") && !docBasisType.equals("R") && !docBasisType.equals("F") && !docBasisType.equals("G");
    }

    private void createDetail(String sql, MCommission commission, MCommissionLine line, MCommissionAmt commissionAmt, MCommissionType commissionType) {
        String language = Env.getAD_Language(this.getCtx());
        int invoiceLineId = 0;
        int orderLineId = 0;
        BigDecimal qtyReturned = Env.ZERO;
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, this.getAD_Client_ID());
            pstmt.setTimestamp(2, this.getStartDate());
            pstmt.setTimestamp(3, this.getEndDate());
            if (commission.getDocBasisType().equals("R") && commission.isTotallyPaid()) {
                pstmt.setTimestamp(4, this.getEndDate());
                pstmt.setTimestamp(5, this.getStartDate());
                pstmt.setTimestamp(6, this.getEndDate());
            }
            rs = pstmt.executeQuery();
            while (rs.next()) {
                String columnName = this.getColumnName("C_InvoiceLine_ID", commissionType);
                if (!Util.isEmpty(columnName)) {
                    invoiceLineId = rs.getInt("C_InvoiceLine_ID");
                }
                int currencyId = 0;
                BigDecimal amount = Env.ZERO;
                BigDecimal quantity = Env.ZERO;
                String reference = null;
                String info = null;
                Timestamp date = null;
                if (this.isCustom(commission.getDocBasisType())) {
                    currencyId = rs.getInt(commissionType.getCurrencyColumnName());
                    amount = rs.getBigDecimal(commissionType.getAmountColumnName());
                    quantity = rs.getBigDecimal(commissionType.getQuantityColumnName());
                    date = rs.getTimestamp(commissionType.getDateDocColumnName());
                    columnName = this.getColumnName("Reference", commissionType);
                    if (!Util.isEmpty(columnName)) {
                        reference = rs.getString(columnName);
                    }
                    if (!Util.isEmpty(columnName = this.getColumnName("Info", commissionType))) {
                        info = rs.getString(columnName);
                    }
                    if (!Util.isEmpty(columnName = this.getColumnName("C_OrderLine_ID", commissionType))) {
                        orderLineId = rs.getInt(columnName);
                    }
                } else {
                    currencyId = rs.getInt("C_Currency_ID");
                    amount = rs.getBigDecimal("Amt");
                    quantity = rs.getBigDecimal("Qty");
                    date = rs.getTimestamp("DateDoc");
                    reference = rs.getString("Reference");
                    info = rs.getString("Info");
                    orderLineId = rs.getInt("C_OrderLine_ID");
                    invoiceLineId = rs.getInt("C_InvoiceLine_ID");
                }
                if (quantity == null) {
                    quantity = Env.ZERO;
                }
                if (amount == null) {
                    amount = Env.ZERO;
                }
                MCommissionDetail commissionDetail = new MCommissionDetail(commissionAmt, currencyId, amount, quantity);
                commissionDetail.setLineIDs(orderLineId, invoiceLineId);
                if (!Util.isEmpty(reference)) {
                    commissionDetail.setReference(Msg.translate(language, "Payment") + "_" + Msg.translate(language, "Invoice") + ": " + reference);
                }
                if (!Util.isEmpty(info)) {
                    commissionDetail.setInfo(Msg.translate(language, "ProductValue") + ": " + info);
                }
                commissionDetail.setConvertedAmt(date);
                commissionDetail.calculateCommission();
                commissionDetail.saveEx();
                if (this.isCustom(commission.getDocBasisType()) || !commission.isAllowRMA() || (qtyReturned = this.returnedItemsQty(invoiceLineId)).compareTo(Env.ZERO) != 1) continue;
                MCommissionDetail compensationCD = MCommissionDetail.copy(this.getCtx(), commissionDetail, this.get_TrxName());
                compensationCD.setInfo(Msg.translate(language, "CompensationFor") + " " + commissionDetail.getInfo() + " (" + Msg.translate(language, "QtyReturned") + ": " + qtyReturned + "), ");
                compensationCD.correctForRMA(qtyReturned);
                compensationCD.saveEx();
            }
        }
        catch (Exception e) {
            try {
                throw new AdempiereException(e.getLocalizedMessage(), e);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
    }

    private BigDecimal returnedItemsQty(int C_IvoiceLine_ID) {
        BigDecimal qtyReturned = Env.ZERO;
        StringBuffer sql = new StringBuffer();
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        sql.append("SELECT iol2.movementqty, i.documentno as invoice, rma.documentno as rma, io.documentno as io  FROM C_InvoiceLine il  INNER JOIN C_Invoice i ON (il.C_Invoice_ID=i.C_Invoice_ID AND i.DocStatus NOT IN ('DR', 'IP', 'VO', 'RE') )  INNER JOIN M_InOutLine iol1 ON (il.C_OrderLine_ID=iol1.C_OrderLine_ID)  INNER JOIN M_RMALine rmal ON (iol1.M_InOutLine_ID=rmal.M_InOutLine_ID)  INNER JOIN M_RMA rma ON (rmal.M_RMA_ID=rma.M_RMA_ID AND rma.DocStatus NOT IN ('DR', 'IP', 'VO', 'RE') )  INNER JOIN M_InOutLine iol2 ON (rmal.M_RMALine_ID=iol2.M_RMALine_ID)  INNER JOIN M_InOut io ON (iol2.M_InOut_ID=io.M_InOut_ID AND io.DocStatus NOT IN ('DR', 'IP', 'VO', 'RE') )  WHERE il.C_InvoiceLine_ID=" + C_IvoiceLine_ID + " AND i.AD_Client_ID = ?  AND i.IsSOTrx='Y'");
        try {
            pstmt = DB.prepareStatement(sql.toString(), this.get_TrxName());
            pstmt.setInt(1, this.getAD_Client_ID());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                qtyReturned = qtyReturned.add(rs.getBigDecimal(1));
            }
        }
        catch (Exception e) {
            try {
                throw new AdempiereException("System Error: " + e.getLocalizedMessage(), e);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return qtyReturned;
    }

    private BigDecimal getAmountPercentage(MCommission commission, boolean isPercentageFromPrice, StringBuffer sqlWhere) {
        if (!commission.getDocBasisType().equals("F") && !commission.getDocBasisType().equals("G")) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        if (commission.getDocBasisType().equals("F")) {
            if (!isPercentageFromPrice) {
                sql.append("SELECT ((SUM(l.QtyInvoiced) / MAX(fl.ForecastQty)) * 100) FROM C_Invoice h INNER JOIN C_InvoiceLine l ON (h.C_Invoice_ID = l.C_Invoice_ID) INNER JOIN (SELECT fl.M_Product_ID, fl.SalesRep_ID, pd.PP_Period_ID, \t\t\t\tpd.Name, pd.StartDate, pd.EndDate, SUM(fl.Qty) ForecastQty \t\t\t\tFROM M_Forecast f \t\t\t\tINNER JOIN M_ForecastLine fl ON(fl.M_Forecast_ID = f.M_Forecast_ID)\t\t\t\tINNER JOIN PP_Period pd ON(pd.PP_Period_ID = fl.PP_Period_ID)\t\t\t\tGROUP BY fl.M_Product_ID, fl.SalesRep_ID, pd.PP_Period_ID, pd.Name, pd.StartDate, pd.EndDate) fl ON(fl.M_Product_ID = l.M_Product_ID AND fl.SalesRep_ID = h.SalesRep_ID) WHERE h.AD_Client_ID = ? AND h.DocStatus IN('CO', 'CL') AND h.DateInvoiced BETWEEN fl.StartDate AND fl.EndDate AND h.DateInvoiced BETWEEN ? AND ?");
            } else {
                sql.append("SELECT ((SUM(linenetamtrealinvoiceline(l.c_Invoiceline_ID)) / MAX(fl.ForecastAmt)) * 100) FROM C_Invoice h INNER JOIN C_InvoiceLine l ON (h.C_Invoice_ID = l.C_Invoice_ID) INNER JOIN (SELECT f.M_Product_ID, f.SalesRep_ID, pd.PP_Period_ID, \t\t\t\tpd.Name, pd.StartDate, pd.EndDate, SUM(f.Qty * f.PriceList) ForecastAmt \t\t\t\tFROM RV_M_Forecast f \t\t\t\tINNER JOIN PP_Period pd ON(pd.PP_Period_ID = f.PP_Period_ID)\t\t\t\tGROUP BY f.M_Product_ID, f.SalesRep_ID, pd.PP_Period_ID, pd.Name, pd.StartDate, pd.EndDate) fl ON(fl.M_Product_ID = l.M_Product_ID AND fl.SalesRep_ID = h.SalesRep_ID) WHERE h.AD_Client_ID = ? AND h.DocStatus IN('CO', 'CL') AND h.DateInvoiced BETWEEN fl.StartDate AND fl.EndDate AND h.DateInvoiced BETWEEN ? AND ?");
            }
        } else if (commission.getDocBasisType().equals("G")) {
            if (!isPercentageFromPrice) {
                sql.append("SELECT ((SUM(l.QtyOrdered) / MAX(fl.ForecastQty)) * 100) FROM C_Order h INNER JOIN C_OrderLine l ON (h.C_Order_ID = l.C_Order_ID) INNER JOIN (SELECT fl.M_Product_ID, fl.SalesRep_ID, pd.PP_Period_ID, \t\t\t\tpd.Name, pd.StartDate, pd.EndDate, SUM(fl.Qty) ForecastQty \t\t\t\tFROM M_Forecast f \t\t\t\tINNER JOIN M_ForecastLine fl ON(fl.M_Forecast_ID = f.M_Forecast_ID)\t\t\t\tINNER JOIN PP_Period pd ON(pd.PP_Period_ID = fl.PP_Period_ID)\t\t\t\tGROUP BY fl.M_Product_ID, fl.SalesRep_ID, pd.PP_Period_ID, pd.Name, pd.StartDate, pd.EndDate) fl ON(fl.M_Product_ID = l.M_Product_ID AND fl.SalesRep_ID = h.SalesRep_ID) WHERE h.AD_Client_ID = ? AND h.DocStatus IN('CO', 'CL') AND h.DateOrdered BETWEEN fl.StartDate AND fl.EndDate AND h.DateOrdered BETWEEN ? AND ?");
            } else {
                sql.append("SELECT ((SUM(linenetamtrealorderline(l.c_Invoiceline_ID)) / MAX(fl.ForecastAmt)) * 100) FROM C_Order h INNER JOIN C_OrderLine l ON (h.C_Order_ID = l.C_Order_ID) INNER JOIN (SELECT f.M_Product_ID, f.SalesRep_ID, pd.PP_Period_ID, \t\t\t\tpd.Name, pd.StartDate, pd.EndDate, SUM(f.Qty * f.PriceList) ForecastAmt \t\t\t\tFROM RV_M_Forecast f \t\t\t\tINNER JOIN PP_Period pd ON(pd.PP_Period_ID = f.PP_Period_ID)\t\t\t\tGROUP BY f.M_Product_ID, f.SalesRep_ID, pd.PP_Period_ID, pd.Name, pd.StartDate, pd.EndDate) fl ON(fl.M_Product_ID = l.M_Product_ID AND fl.SalesRep_ID = h.SalesRep_ID) WHERE h.AD_Client_ID = ? AND h.DocStatus IN('CO', 'CL') AND h.DateOrdered BETWEEN fl.StartDate AND fl.EndDate AND h.DateOrdered BETWEEN ? AND ?");
            }
        }
        sql.append(sqlWhere);
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(this.getAD_Client_ID());
        params.add(this.getStartDate());
        params.add(this.getEndDate());
        if (commission.isTotallyPaid()) {
            params.add(this.getEndDate());
            params.add(this.getEndDate());
            params.add(this.getEndDate());
        }
        BigDecimal percentage = DB.getSQLValueBD(this.get_TrxName(), sql.toString(), params);
        return percentage;
    }

    private String processCommissionLine(MBPartner salesRep, MCommission commission) {
        MCommissionLine[] commissionLines;
        for (MCommissionLine commissionLine : commissionLines = commission.getLines()) {
            String columnName;
            String columnName2;
            ArrayList<Integer> salesRegion = new ArrayList<Integer>();
            MCommissionAmt commissionAmt = new MCommissionAmt(this, commissionLine.getC_CommissionLine_ID());
            commissionAmt.setC_BPartner_ID(salesRep.getC_BPartner_ID());
            commissionAmt.saveEx();
            StringBuffer sql = new StringBuffer();
            StringBuffer sqlWhere = new StringBuffer();
            MCommissionType commissionType = null;
            if ("R".equals(commission.getDocBasisType())) {
                String transactionDate;
                String sqlAppend = "";
                sqlAppend = commission.isTotallyPaid() ? " AND (p.DateTrx <= ? OR p.DateTrx <= ?) AND InvoiceopenToDate(h.C_Invoice_ID, null, ?) = 0 AND maxPayDate(h.c_Invoice_ID) BETWEEN ? AND ? " : " AND p.DateTrx BETWEEN ? AND ? ";
                if (commission.isListDetails()) {
                    sql.append("SELECT h.C_Currency_ID, (linenetamtrealinvoiceline(l.c_Invoiceline_ID) * (Currencyconvert(al.Amount + al.DisCountAmt + al.WriteOffAmt, p.C_Currency_ID, h.C_Currency_ID, p.DateTrx, h.C_ConversionType_ID, al.AD_Client_ID, al.AD_Org_ID)/h.GrandTotal)) AS Amt, (l.QtyInvoiced*Currencyconvert(al.Amount + al.DisCountAmt + al.WriteOffAmt, p.C_Currency_ID, h.C_Currency_ID, p.DateTrx, h.C_ConversionType_ID, al.AD_Client_ID, al.AD_Org_ID)/h.GrandTotal) AS Qty, NULL, l.C_InvoiceLine_ID, l.C_OrderLine_ID, (p.DocumentNo || '_' || h.DocumentNo) AS Reference, COALESCE(prd.Value,l.Description) AS Info, h.DateInvoiced AS DateDoc FROM C_Payment p INNER JOIN C_AllocationLine al ON (p.C_Payment_ID=al.C_Payment_ID) INNER JOIN C_Invoice h ON (al.C_Invoice_ID = h.C_Invoice_ID) INNER JOIN C_InvoiceLine l ON (h.C_Invoice_ID = l.C_Invoice_ID)  LEFT OUTER JOIN M_Product prd ON (l.M_Product_ID = prd.M_Product_ID) WHERE p.DocStatus IN ('CL','CO') AND h.IsSOTrx='Y' AND p.AD_Client_ID = ?  AND al.C_Charge_ID IS NULL " + sqlAppend);
                } else {
                    sql.append("SELECT h.C_Currency_ID, SUM(linenetamtrealinvoiceline(l.c_Invoiceline_ID) *(Currencyconvert(al.Amount + al.DisCountAmt + al.WriteOffAmt, p.C_Currency_ID, h.C_Currency_ID, p.DateTrx, h.C_ConversionType_ID, al.AD_Client_ID, al.AD_Org_ID)/h.GrandTotal)) AS Amt, SUM(l.QtyInvoiced*Currencyconvert(al.Amount + al.DisCountAmt + al.WriteOffAmt, p.C_Currency_ID, h.C_Currency_ID, p.DateTrx, h.C_ConversionType_ID, al.AD_Client_ID, al.AD_Org_ID)/h.GrandTotal) AS Qty, NULL, NULL AS C_InvoiceLine_ID, NULL AS C_OrderLine_ID, NULL AS Reference, NULL AS Info, MAX(h.DateInvoiced) AS DateDoc FROM C_Payment p INNER JOIN C_AllocationLine al ON (p.C_Payment_ID=al.C_Payment_ID) INNER JOIN C_Invoice h ON (al.C_Invoice_ID = h.C_Invoice_ID) INNER JOIN C_InvoiceLine l ON (h.C_Invoice_ID = l.C_Invoice_ID) WHERE p.DocStatus IN ('CL','CO') AND h.IsSOTrx='Y' AND p.AD_Client_ID = ?  AND al.C_Charge_ID IS NULL " + sqlAppend);
                }
                if (commissionLine.getDaysFrom() != 0) {
                    transactionDate = "p.DateTrx";
                    if (commission.isTotallyPaid()) {
                        transactionDate = "maxPayDate(h.c_Invoice_ID)";
                    }
                    if (commission.isDaysDueFromPaymentTerm()) {
                        sqlWhere.append(" AND paymenttermduedays(h.C_PaymentTerm_ID, h.DateInvoiced, " + transactionDate + ") >= ").append(commissionLine.get_ValueAsInt("DaysFrom"));
                    } else {
                        sqlWhere.append(" AND daysbetween(" + transactionDate + ", h.DateInvoiced) >= ").append(commissionLine.get_ValueAsInt("DaysFrom"));
                    }
                }
                if (commissionLine.getDaysTo() != 0) {
                    transactionDate = "p.DateTrx";
                    if (commission.isTotallyPaid()) {
                        transactionDate = "maxPayDate(h.c_Invoice_ID)";
                    }
                    if (commission.isDaysDueFromPaymentTerm()) {
                        sqlWhere.append(" AND paymenttermduedays(h.C_PaymentTerm_ID, h.DateInvoiced, " + transactionDate + ") <= ").append(commissionLine.get_ValueAsInt("DaysTo"));
                    } else {
                        sqlWhere.append(" AND daysbetween(" + transactionDate + ", h.DateInvoiced) <= ").append(commissionLine.get_ValueAsInt("DaysTo"));
                    }
                }
            } else if ("O".equals(commission.getDocBasisType()) || "G".equals(commission.getDocBasisType())) {
                if (commission.isListDetails()) {
                    sql.append("SELECT h.C_Currency_ID, linenetamtrealorderline(l.c_OrderLine_ID) AS Amt, l.QtyOrdered AS Qty, l.C_OrderLine_ID, NULL AS C_InvoiceLine_ID, h.DocumentNo AS Reference, COALESCE(prd.Value,l.Description) AS Info,h.DateOrdered AS DateDoc FROM C_Order h INNER JOIN C_OrderLine l ON (h.C_Order_ID = l.C_Order_ID) LEFT OUTER JOIN M_Product prd ON (l.M_Product_ID = prd.M_Product_ID) WHERE h.DocStatus IN ('CL','CO') AND h.IsSOTrx='Y' AND h.AD_Client_ID = ? AND h.DateOrdered BETWEEN ? AND ?");
                } else {
                    sql.append("SELECT h.C_Currency_ID, SUM(linenetamtrealorderline(l.c_OrderLine_ID)) AS Amt, SUM(l.QtyOrdered) AS Qty, NULL AS C_OrderLine_ID, NULL AS C_InvoiceLine_ID, NULL AS Reference, NULL AS Info, MAX(h.DateOrdered) AS DateDoc FROM C_Order h INNER JOIN C_OrderLine l ON (h.C_Order_ID = l.C_Order_ID) WHERE h.DocStatus IN ('CL','CO') AND h.IsSOTrx='Y' AND h.AD_Client_ID = ? AND h.DateOrdered BETWEEN ? AND ?");
                }
            } else if ("I".equals(commission.getDocBasisType()) || "F".equals(commission.getDocBasisType())) {
                if (commission.isListDetails()) {
                    sql.append("SELECT h.C_Currency_ID, linenetamtrealinvoiceline(l.c_Invoiceline_ID) AS Amt, l.QtyInvoiced AS Qty, NULL AS C_OrderLine_ID, l.C_InvoiceLine_ID, h.DocumentNo AS Reference, COALESCE(prd.Value,l.Description) AS Info,h.DateInvoiced AS DateDoc FROM C_Invoice h INNER JOIN C_InvoiceLine l ON (h.C_Invoice_ID = l.C_Invoice_ID) LEFT OUTER JOIN M_Product prd ON (l.M_Product_ID = prd.M_Product_ID) WHERE h.DocStatus IN ('CL','CO') AND h.IsSOTrx='Y' AND h.AD_Client_ID = ? AND h.DateInvoiced BETWEEN ? AND ?");
                } else {
                    sql.append("SELECT h.C_Currency_ID, SUM(linenetamtrealinvoiceline(l.c_Invoiceline_ID)) AS Amt, SUM(l.QtyInvoiced) AS Qty, NULL AS C_OrderLine_ID, NULL AS C_InvoiceLine_ID, NULL AS Reference, NULL AS Info, MAX(h.DateInvoiced) AS DateDoc FROM C_Invoice h INNER JOIN C_InvoiceLine l ON (h.C_Invoice_ID = l.C_Invoice_ID) WHERE h.DocStatus IN ('CL','CO') AND h.IsSOTrx='Y' AND h.AD_Client_ID = ? AND h.DateInvoiced BETWEEN ? AND ?");
                }
                if (commissionLine.getC_DunningLevel_ID() != 0) {
                    sqlWhere.append(" AND h.C_DunningLevel_ID=").append(commissionLine.getC_DunningLevel_ID());
                }
                if (commissionLine.getInvoiceCollectionType() != null) {
                    sqlWhere.append(" AND h.InvoiceCollectionType='").append(commissionLine.getInvoiceCollectionType()).append("'");
                }
            } else if (this.isCustom(commission.getDocBasisType())) {
                String whereClauseView;
                commissionType = MCommissionType.getById(this.getCtx(), commission.getC_CommissionType_ID(), this.get_TrxName());
                if (commissionType == null) {
                    throw new AdempiereException("@C_CommissionType_ID@ @NotFound@");
                }
                String sqlView = MView.getSQLFromView(commissionType.getAD_View_ID(), this.get_TrxName());
                sqlView = Env.parseContext(Env.getCtx(), 0, sqlView, false, false);
                sql.append(sqlView);
                if (!Util.isEmpty(commissionType.getWhereClause()) && !Util.isEmpty(whereClauseView = Env.parseContext(Env.getCtx(), 0, commissionType.getWhereClause(), false, false))) {
                    sqlWhere.append(whereClauseView);
                }
                columnName2 = this.getSQLColumnName("AD_Client_ID", commissionType);
                if (sqlWhere.length() > 0) {
                    sqlWhere.append(" AND ");
                } else {
                    sqlWhere.append(" WHERE ");
                }
                sqlWhere.append(columnName2).append("=?");
                columnName2 = commissionType.getSQLCurrencyColumnName();
                if (Util.isEmpty(columnName2)) {
                    throw new AdempiereException("@C_CommissionType_ID@ @C_Currency_ID@ @AD_Column_ID@ @NotFound@");
                }
                columnName2 = commissionType.getSQLQuantityColumnName();
                if (Util.isEmpty(columnName2)) {
                    throw new AdempiereException("@C_CommissionType_ID@ @Qty@ @AD_Column_ID@ @NotFound@");
                }
                columnName2 = commissionType.getSQLAmountColumnName();
                if (Util.isEmpty(columnName2)) {
                    throw new AdempiereException("@C_CommissionType_ID@ @Amount@ @AD_Column_ID@ @NotFound@");
                }
                columnName2 = commissionType.getSQLDateDocColumnName();
                if (Util.isEmpty(columnName2)) {
                    throw new AdempiereException("@C_CommissionType_ID@ @DateDoc@ @AD_Column_ID@ @NotFound@");
                }
                sqlWhere.append(" AND ").append(columnName2).append(">=?");
                sqlWhere.append(" AND ").append(columnName2).append("<=?");
            }
            if ("F".equals(commission.getDocBasisType())) {
                if (!commissionLine.isPercentageFromPrice()) {
                    if (commissionLine.getMinCompliance() != null && commissionLine.getMinCompliance().compareTo(Env.ZERO) > 0) {
                        sql.append(" AND EXISTS(SELECT 1 FROM C_Invoice i INNER JOIN C_InvoiceLine il ON(il.C_Invoice_ID = i.C_Invoice_ID)\tINNER JOIN (SELECT fl.M_Product_ID, fl.SalesRep_ID, pd.PP_Period_ID, \t            pd.Name, pd.StartDate, pd.EndDate, SUM(fl.Qty) ForecastQty \t\tFROM M_Forecast f \t\tINNER JOIN M_ForecastLine fl ON(fl.M_Forecast_ID = f.M_Forecast_ID) \t\tINNER JOIN PP_Period pd ON(pd.PP_Period_ID = fl.PP_Period_ID) \t\tWHERE f.IsActive = 'Y' \t\tAND fl.IsActive = 'Y' \t    GROUP BY fl.M_Product_ID, fl.SalesRep_ID, pd.PP_Period_ID, pd.Name, pd.StartDate, pd.EndDate \t) fl ON(fl.M_Product_ID = il.M_Product_ID AND fl.SalesRep_ID = i.SalesRep_ID \t        AND i.DateInvoiced BETWEEN fl.StartDate AND fl.EndDate\t\t\tAND h.DateInvoiced BETWEEN fl.StartDate AND fl.EndDate) WHERE il.M_Product_ID = l.M_Product_ID AND i.DocStatus IN('CL','CO') AND i.SalesRep_ID = h.SalesRep_ID GROUP BY l.M_Product_ID, fl.ForecastQty HAVING(((SUM(il.QtyInvoiced) / fl.ForecastQty) * 100) >= " + DB.TO_NUMBER(commissionLine.getMinCompliance(), 12));
                        if (commissionLine.getMaxCompliance() != null && commissionLine.getMaxCompliance().compareTo(Env.ZERO) > 0) {
                            sql.append(" AND ((SUM(il.QtyInvoiced) / fl.ForecastQty) * 100) <= " + DB.TO_NUMBER(commissionLine.getMaxCompliance(), 12) + ")");
                        } else {
                            sql.append(")");
                        }
                        sql.append(")");
                    } else if (commissionLine.getMaxCompliance() != null && commissionLine.getMaxCompliance().compareTo(Env.ZERO) > 0) {
                        sql.append(" AND EXISTS(SELECT 1 FROM C_Invoice i INNER JOIN C_InvoiceLine il ON(il.C_Invoice_ID = i.C_Invoice_ID)\t\tINNER JOIN (SELECT fl.M_Product_ID, fl.SalesRep_ID, pd.PP_Period_ID, \t            pd.Name, pd.StartDate, pd.EndDate, SUM(fl.Qty) ForecastQty \t\tFROM M_Forecast f \t\tINNER JOIN M_ForecastLine fl ON(fl.M_Forecast_ID = f.M_Forecast_ID) \t\tINNER JOIN PP_Period pd ON(pd.PP_Period_ID = fl.PP_Period_ID) \t\tWHERE f.IsActive = 'Y' \t\tAND fl.IsActive = 'Y' \t    GROUP BY fl.M_Product_ID, fl.SalesRep_ID, pd.PP_Period_ID, pd.Name, pd.StartDate, pd.EndDate \t) fl ON(fl.M_Product_ID = il.M_Product_ID AND fl.SalesRep_ID = i.SalesRep_ID \t        AND i.DateInvoiced BETWEEN fl.StartDate AND fl.EndDate\t\t\tAND h.DateInvoiced BETWEEN fl.StartDate AND fl.EndDate) WHERE il.M_Product_ID = l.M_Product_ID AND i.DocStatus IN('CL','CO') AND i.SalesRep_ID = h.SalesRep_ID GROUP BY l.M_Product_ID, fl.ForecastQty HAVING(((SUM(il.QtyInvoiced) / fl.ForecastQty) * 100) <= " + DB.TO_NUMBER(commissionLine.getMaxCompliance(), 12) + "))");
                    }
                } else if (commissionLine.getMinCompliance() != null && commissionLine.getMinCompliance().compareTo(Env.ZERO) > 0) {
                    sql.append(" AND EXISTS(SELECT 1 FROM C_Invoice i INNER JOIN C_InvoiceLine il ON(il.C_Invoice_ID = i.C_Invoice_ID)\tINNER JOIN (SELECT f.M_Product_ID, f.SalesRep_ID, pd.PP_Period_ID, \t            pd.Name, pd.StartDate, pd.EndDate, SUM(f.Qty * f.PriceList) ForecastAmt \t\tFROM RV_M_Forecast f \t\tINNER JOIN PP_Period pd ON(pd.PP_Period_ID = f.PP_Period_ID) \t    GROUP BY f.M_Product_ID, f.SalesRep_ID, pd.PP_Period_ID, pd.Name, pd.StartDate, pd.EndDate \t) fl ON(fl.M_Product_ID = il.M_Product_ID AND fl.SalesRep_ID = i.SalesRep_ID \t        AND i.DateInvoiced BETWEEN fl.StartDate AND fl.EndDate\t\t\tAND h.DateInvoiced BETWEEN fl.StartDate AND fl.EndDate) WHERE il.M_Product_ID = l.M_Product_ID AND i.DocStatus IN('CL','CO') AND i.SalesRep_ID = h.SalesRep_ID GROUP BY l.M_Product_ID, fl.ForecastAmt HAVING(((SUM(linenetamtrealinvoiceline(il.c_Invoiceline_ID)) / fl.ForecastAmt) * 100) >= " + DB.TO_NUMBER(commissionLine.getMinCompliance(), 12));
                    if (commissionLine.getMaxCompliance() != null && commissionLine.getMaxCompliance().compareTo(Env.ZERO) > 0) {
                        sql.append(" AND ((SUM(linenetamtrealinvoiceline(il.c_Invoiceline_ID)) / fl.ForecastAmt) * 100) <= " + DB.TO_NUMBER(commissionLine.getMaxCompliance(), 12) + ")");
                    } else {
                        sql.append(")");
                    }
                    sql.append(")");
                } else if (commissionLine.getMaxCompliance() != null && commissionLine.getMaxCompliance().compareTo(Env.ZERO) > 0) {
                    sql.append(" AND EXISTS(SELECT 1 FROM C_Invoice i INNER JOIN C_InvoiceLine il ON(il.C_Invoice_ID = i.C_Invoice_ID)\t\tINNER JOIN (SELECT fl.M_Product_ID, fl.SalesRep_ID, pd.PP_Period_ID, \t            pd.Name, pd.StartDate, pd.EndDate, SUM(f.Qty * f.PriceList) ForecastAmt \t\tFROM RV_M_Forecast f \t\tINNER JOIN PP_Period pd ON(pd.PP_Period_ID = fl.PP_Period_ID) \t    GROUP BY fl.M_Product_ID, fl.SalesRep_ID, pd.PP_Period_ID, pd.Name, pd.StartDate, pd.EndDate \t) fl ON(fl.M_Product_ID = il.M_Product_ID AND fl.SalesRep_ID = i.SalesRep_ID \t        AND i.DateInvoiced BETWEEN fl.StartDate AND fl.EndDate\t\t\tAND h.DateInvoiced BETWEEN fl.StartDate AND fl.EndDate) WHERE il.M_Product_ID = l.M_Product_ID AND i.DocStatus IN('CL','CO') AND i.SalesRep_ID = h.SalesRep_ID GROUP BY l.M_Product_ID, fl.ForecastAmt HAVING(((SUM(linenetamtrealinvoiceline(il.c_Invoiceline_ID)) / fl.ForecastAmt) * 100) <= " + DB.TO_NUMBER(commissionLine.getMaxCompliance(), 12) + "))");
                }
            } else if ("G".equals(commission.getDocBasisType())) {
                if (!commissionLine.isPercentageFromPrice()) {
                    if (commissionLine.getMinCompliance() != null && commissionLine.getMinCompliance().compareTo(Env.ZERO) > 0) {
                        sql.append(" AND EXISTS(SELECT 1 FROM C_Order i INNER JOIN C_OrderLine il ON(il.C_Order_ID = i.C_Order_ID)\tINNER JOIN (SELECT fl.M_Product_ID, fl.SalesRep_ID, pd.PP_Period_ID, \t            pd.Name, pd.StartDate, pd.EndDate, SUM(fl.Qty) ForecastQty \t\tFROM M_Forecast f \t\tINNER JOIN M_ForecastLine fl ON(fl.M_Forecast_ID = f.M_Forecast_ID) \t\tINNER JOIN PP_Period pd ON(pd.PP_Period_ID = fl.PP_Period_ID) \t\tWHERE f.IsActive = 'Y' \t\tAND fl.IsActive = 'Y' \t    GROUP BY fl.M_Product_ID, fl.SalesRep_ID, pd.PP_Period_ID, pd.Name, pd.StartDate, pd.EndDate \t) fl ON(fl.M_Product_ID = il.M_Product_ID AND fl.SalesRep_ID = i.SalesRep_ID \t        AND i.DateOrdered BETWEEN fl.StartDate AND fl.EndDate\t\t\tAND h.DateOrdered BETWEEN fl.StartDate AND fl.EndDate) WHERE il.M_Product_ID = l.M_Product_ID AND i.DocStatus IN('CL','CO') AND i.SalesRep_ID = h.SalesRep_ID GROUP BY l.M_Product_ID, fl.ForecastQty HAVING(((SUM(il.QtyOrdered) / fl.ForecastQty) * 100) >= " + DB.TO_NUMBER(commissionLine.getMinCompliance(), 12));
                        if (commissionLine.getMaxCompliance() != null && commissionLine.getMaxCompliance().compareTo(Env.ZERO) > 0) {
                            sql.append(" AND ((SUM(il.QtyOrdered) / fl.ForecastQty) * 100) <= " + DB.TO_NUMBER(commissionLine.getMaxCompliance(), 12) + ")");
                        } else {
                            sql.append(")");
                        }
                        sql.append(")");
                    } else if (commissionLine.getMaxCompliance() != null && commissionLine.getMaxCompliance().compareTo(Env.ZERO) > 0) {
                        sql.append(" AND EXISTS(SELECT 1 FROM C_Order i INNER JOIN C_OrderLine il ON(il.C_Order_ID = i.C_Order_ID)\t\tINNER JOIN (SELECT fl.M_Product_ID, fl.SalesRep_ID, pd.PP_Period_ID, \t            pd.Name, pd.StartDate, pd.EndDate, SUM(fl.Qty) ForecastQty \t\tFROM M_Forecast f \t\tINNER JOIN M_ForecastLine fl ON(fl.M_Forecast_ID = f.M_Forecast_ID) \t\tINNER JOIN PP_Period pd ON(pd.PP_Period_ID = fl.PP_Period_ID) \t\tWHERE f.IsActive = 'Y' \t\tAND fl.IsActive = 'Y' \t    GROUP BY fl.M_Product_ID, fl.SalesRep_ID, pd.PP_Period_ID, pd.Name, pd.StartDate, pd.EndDate \t) fl ON(fl.M_Product_ID = il.M_Product_ID AND fl.SalesRep_ID = i.SalesRep_ID \t        AND i.DateOrdered BETWEEN fl.StartDate AND fl.EndDate\t\t\tAND h.DateOrdered BETWEEN fl.StartDate AND fl.EndDate) WHERE il.M_Product_ID = l.M_Product_ID AND i.DocStatus IN('CL','CO') AND i.SalesRep_ID = h.SalesRep_ID GROUP BY l.M_Product_ID, fl.ForecastQty HAVING(((SUM(il.QtyOrdered) / fl.ForecastQty) * 100) <= " + DB.TO_NUMBER(commissionLine.getMaxCompliance(), 12) + "))");
                    }
                } else if (commissionLine.getMinCompliance() != null && commissionLine.getMinCompliance().compareTo(Env.ZERO) > 0) {
                    sql.append(" AND EXISTS(SELECT 1 FROM C_Order i INNER JOIN C_OrderLine il ON(il.C_Order_ID = i.C_Order_ID)\tINNER JOIN (SELECT f.M_Product_ID, f.SalesRep_ID, pd.PP_Period_ID, \t            pd.Name, pd.StartDate, pd.EndDate, SUM(f.Qty * f.PriceList) ForecastAmt \t\tFROM RV_M_Forecast f \t\tINNER JOIN PP_Period pd ON(pd.PP_Period_ID = f.PP_Period_ID) \t    GROUP BY f.M_Product_ID, f.SalesRep_ID, pd.PP_Period_ID, pd.Name, pd.StartDate, pd.EndDate \t) fl ON(fl.M_Product_ID = il.M_Product_ID AND fl.SalesRep_ID = i.SalesRep_ID \t        AND i.DateOrdered BETWEEN fl.StartDate AND fl.EndDate\t\t\tAND h.DateOrdered BETWEEN fl.StartDate AND fl.EndDate) WHERE il.M_Product_ID = l.M_Product_ID AND i.DocStatus IN('CL','CO') AND i.SalesRep_ID = h.SalesRep_ID GROUP BY l.M_Product_ID, fl.ForecastAmt HAVING(((SUM(linenetamtrealorderline(il.C_Orderline_ID)) / fl.ForecastAmt) * 100) >= " + DB.TO_NUMBER(commissionLine.getMinCompliance(), 12));
                    if (commissionLine.getMaxCompliance() != null && commissionLine.getMaxCompliance().compareTo(Env.ZERO) > 0) {
                        sql.append(" AND ((SUM(linenetamtrealorderline(il.C_Orderline_ID)) / fl.ForecastAmt) * 100) <= " + DB.TO_NUMBER(commissionLine.getMaxCompliance(), 12) + ")");
                    } else {
                        sql.append(")");
                    }
                    sql.append(")");
                } else if (commissionLine.getMaxCompliance() != null && commissionLine.getMaxCompliance().compareTo(Env.ZERO) > 0) {
                    sql.append(" AND EXISTS(SELECT 1 FROM C_Order i INNER JOIN C_OrderLine il ON(il.C_Order_ID = i.C_Order_ID)\t\tINNER JOIN (SELECT fl.M_Product_ID, fl.SalesRep_ID, pd.PP_Period_ID, \t            pd.Name, pd.StartDate, pd.EndDate, SUM(f.Qty * f.PriceList) ForecastAmt \t\tFROM RV_M_Forecast f \t\tINNER JOIN PP_Period pd ON(pd.PP_Period_ID = fl.PP_Period_ID) \t    GROUP BY fl.M_Product_ID, fl.SalesRep_ID, pd.PP_Period_ID, pd.Name, pd.StartDate, pd.EndDate \t) fl ON(fl.M_Product_ID = il.M_Product_ID AND fl.SalesRep_ID = i.SalesRep_ID \t        AND i.DateOrdered BETWEEN fl.StartDate AND fl.EndDate\t\t\tAND h.DateOrdered BETWEEN fl.StartDate AND fl.EndDate) WHERE il.M_Product_ID = l.M_Product_ID AND i.DocStatus IN('CL','CO') AND i.SalesRep_ID = h.SalesRep_ID GROUP BY l.M_Product_ID, fl.ForecastAmt HAVING(((SUM(linenetamtrealorderline(il.C_Orderline_ID)) / fl.ForecastAmt) * 100) <= " + DB.TO_NUMBER(commissionLine.getMaxCompliance(), 12) + "))");
                }
            }
            if (commissionLine.isCommissionOrders()) {
                MUser[] users = MUser.getOfBPartner(this.getCtx(), salesRep.getC_BPartner_ID(), this.get_TrxName());
                if (users == null || users.length == 0) continue;
                columnName2 = this.getSQLColumnName("h.SalesRep_ID", commissionType);
                if (!Util.isEmpty(columnName2)) {
                    if (users.length == 1) {
                        int SalesRep_ID = users[0].getAD_User_ID();
                        sqlWhere.append(" AND ").append(columnName2).append("=").append(SalesRep_ID);
                    } else {
                        this.log.warning("Not 1 User/Contact for C_BPartner_ID=" + salesRep.getC_BPartner_ID() + " but " + users.length);
                        sqlWhere.append(" AND EXISTS(SELECT 1 FROM AD_User u WHERE u.AD_User_ID = " + columnName2 + " AND u.C_BPartner_ID=").append(salesRep.getC_BPartner_ID()).append(")");
                    }
                }
            }
            if (commissionLine.getOrg_ID() != 0 && !Util.isEmpty(columnName = this.getSQLColumnName("h.AD_Org_ID", commissionType))) {
                sqlWhere.append(" AND ").append(columnName).append("=").append(commissionLine.getOrg_ID());
            }
            if (commissionLine.getC_BPartner_ID() != 0 && !Util.isEmpty(columnName = this.getSQLColumnName("h.C_BPartner_ID", commissionType))) {
                sqlWhere.append(" AND ").append(columnName).append("=").append(commissionLine.getC_BPartner_ID());
            }
            if (commissionLine.getC_BP_Group_ID() != 0 && !Util.isEmpty(columnName = this.getSQLColumnName("C_BPartner_ID", commissionType))) {
                sqlWhere.append(" AND EXISTS(SELECT 1 FROM C_BPartner \t\t\t\t\t\tWHERE C_BPartner.C_BPartner_ID = " + columnName + " \t\t\t\t\t\tAND C_BP_Group_ID=").append(commissionLine.getC_BP_Group_ID()).append(")");
            }
            if (commissionLine.getC_SalesRegion_ID() != 0 && !Util.isEmpty(columnName = this.getSQLColumnName("l.C_Order_ID", commissionType))) {
                sqlWhere.append(" AND (h.C_BPartner_Location_ID IN (SELECT C_BPartner_Location_ID FROM C_BPartner_Location WHERE C_SalesRegion_ID ").append(this.getSalesRegionClause(salesRegion, commissionLine.getC_SalesRegion_ID())).append(") OR EXISTS(SELECT 1 FROM C_Order o \t\t\t\t\tINNER JOIN C_BPartner_Location bpl ON(bpl.C_BPartner_Location_ID = o.C_BPartner_Location_ID)\t\t\t\t\tWHERE o.C_Order_ID = " + columnName + " \t\t\t\t\tAND bpl.C_SalesRegion_ID " + this.getSalesRegionClause(salesRegion, commissionLine.getC_SalesRegion_ID()) + "))");
            }
            if (commissionLine.getM_Product_ID() != 0 && !Util.isEmpty(columnName = this.getSQLColumnName("l.M_Product_ID", commissionType))) {
                sqlWhere.append(" AND ").append(columnName).append("=").append(commissionLine.getM_Product_ID());
            }
            if (commissionLine.getM_Product_Category_ID() != 0 && !Util.isEmpty(columnName = this.getSQLColumnName("l.M_Product_ID", commissionType))) {
                sqlWhere.append(" AND EXISTS(SELECT 1 FROM M_Product \t\t\t\t\tWHERE M_Product.M_Product_ID = " + columnName + " \t\t\t\t\tAND M_Product_Category_ID=").append(commissionLine.getM_Product_Category_ID()).append(")");
            }
            if (commissionLine.getM_Product_Group_ID() != 0 && !Util.isEmpty(columnName = this.getSQLColumnName("l.M_Product_ID", commissionType))) {
                sqlWhere.append(" AND EXISTS(SELECT 1 FROM M_Product \t\t\t\t\tWHERE M_Product.M_Product_ID = " + columnName + " \t\t\t\t\tAND M_Product_Group_ID=").append(commissionLine.getM_Product_Group_ID()).append(")");
            }
            if (commissionLine.getM_Product_Class_ID() != 0 && !Util.isEmpty(columnName = this.getSQLColumnName("l.M_Product_ID", commissionType))) {
                sqlWhere.append(" AND EXISTS(SELECT 1 FROM M_Product \t\t\t\t\tWHERE M_Product.M_Product_ID = " + columnName + " \t\t\t\t\tAND M_Product_Class_ID=").append(commissionLine.getM_Product_Class_ID()).append(")");
            }
            if (commissionLine.getM_Product_Classification_ID() != 0 && !Util.isEmpty(columnName = this.getSQLColumnName("l.M_Product_ID", commissionType))) {
                sqlWhere.append(" AND EXISTS(SELECT 1 FROM M_Product \t\t\t\t\tWHERE M_Product.M_Product_ID = " + columnName + " \t\t\t\t\tAND M_Product_Classification_ID =").append(commissionLine.getM_Product_Classification_ID()).append(")");
            }
            if (commissionLine.getC_Project_ID() != 0 && !Util.isEmpty(columnName = this.getSQLColumnName("l.C_Project_ID", commissionType))) {
                sqlWhere.append(" AND ").append(columnName).append("=").append(commissionLine.getC_Project_ID());
            }
            if (commissionLine.getC_Campaign_ID() != 0 && !Util.isEmpty(columnName = this.getSQLColumnName("l.C_Campaign_ID", commissionType))) {
                sqlWhere.append(" AND ").append(columnName).append("=").append(commissionLine.getC_Campaign_ID());
            }
            if (commissionLine.getC_Channel_ID() != 0 && !Util.isEmpty(columnName = this.getSQLColumnName("l.C_Campaign_ID", commissionType))) {
                sqlWhere.append(" AND EXISTS(SELECT 1 FROM C_Campaign \t\t\t\t\tWHERE C_Campaign_ID = " + columnName + " \t\t\t\t\tAND C_Campaign.C_Channel_ID=").append(commissionLine.getC_Channel_ID()).append(")");
            }
            if (commissionLine.getPaymentRule() != null && !Util.isEmpty(columnName = this.getSQLColumnName("h.PaymentRule", commissionType))) {
                sqlWhere.append(" AND ").append(columnName).append("=").append(commissionLine.getPaymentRule()).append("'");
            }
            if (commissionLine.getC_PaymentTerm_ID() != 0 && !Util.isEmpty(columnName = this.getSQLColumnName("h.C_PaymentTerm_ID", commissionType))) {
                sqlWhere.append(" AND ").append(columnName).append("=").append(commissionLine.getC_PaymentTerm_ID());
            }
            if (commissionLine.get_ValueAsInt("S_Contract_ID") != 0 && !Util.isEmpty(columnName = this.getSQLColumnName("h.S_Contract_ID", commissionType))) {
                sqlWhere.append(" AND ").append(columnName).append("=").append(commissionLine.get_ValueAsInt("S_Contract_ID"));
            }
            sqlWhere.append(this.getExclusionWhere(commission.getDocBasisType(), commissionLine, commissionLines, commissionType));
            if (this.isCustom(commission.getDocBasisType())) {
                if (!commission.isListDetails() && !Util.isEmpty(columnName = this.getSQLColumnName("h.C_Currency_ID", commissionType))) {
                    sqlWhere.append(" ORDER BY ").append(columnName);
                }
            } else if (!commission.isListDetails()) {
                sqlWhere.append(" GROUP BY ").append("h.C_Currency_ID");
            }
            sql.append(sqlWhere);
            this.log.fine("Line=" + commissionLine.getLine() + " - " + sql);
            commissionAmt.setPercentage(this.getAmountPercentage(commission, commissionLine.isPercentageFromPrice(), sqlWhere));
            commissionAmt.setMaxPercentage(commissionLine.getMaxPercentage());
            this.createDetail(sql.toString(), commission, commissionLine, commissionAmt, commissionType);
            if (commissionAmt.getDetails().length == 0) {
                commissionAmt.deleteEx(true, this.get_TrxName());
                continue;
            }
            commissionAmt.updateCommissionAmount();
            commissionAmt.saveEx();
        }
        commission.setDateLastRun(this.getDateDoc());
        commission.saveEx();
        return "@C_CommissionRun_ID@ = " + this.getDocumentNo() + " - " + this.getDescription();
    }

    private String getSQLColumnName(String defaultColumnName, MCommissionType commissionType) {
        if (commissionType == null) {
            return defaultColumnName;
        }
        if (defaultColumnName.lastIndexOf(".") > 0) {
            defaultColumnName = defaultColumnName.substring(defaultColumnName.lastIndexOf(".") + 1);
        }
        return commissionType.getSQLColumnName(defaultColumnName);
    }

    private String getColumnName(String defaultColumnName, MCommissionType commissionType) {
        if (commissionType == null) {
            return defaultColumnName;
        }
        if (defaultColumnName.lastIndexOf(".") > 0) {
            defaultColumnName = defaultColumnName.substring(defaultColumnName.lastIndexOf(".") + 1);
        }
        return commissionType.getColumnName(defaultColumnName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSalesRegion(List<Integer> salesRegionList, int salesRegionId) {
        int m_Tree_ID = MTree.getDefaultTreeIdFromTableName(this.getAD_Client_ID(), "C_SalesRegion");
        String sql = "SELECT tn.Node_ID AS C_SalesRegion_ID FROM AD_Tree t INNER JOIN AD_TreeNode tn ON(t.AD_Tree_ID = tn.AD_Tree_ID) WHERE t.AD_Tree_ID = ? AND tn.Parent_ID = ?";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement("SELECT tn.Node_ID AS C_SalesRegion_ID FROM AD_Tree t INNER JOIN AD_TreeNode tn ON(t.AD_Tree_ID = tn.AD_Tree_ID) WHERE t.AD_Tree_ID = ? AND tn.Parent_ID = ?", null);
            pstmt.setInt(1, m_Tree_ID);
            pstmt.setInt(2, salesRegionId);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                MSalesRegion salesRegion = new MSalesRegion(this.getCtx(), rs.getInt("C_SalesRegion_ID"), this.get_TrxName());
                if (salesRegion.getC_SalesRegion_ID() <= 0) continue;
                if (!salesRegion.isSummary()) {
                    salesRegionList.add(salesRegion.getC_SalesRegion_ID());
                    continue;
                }
                this.loadSalesRegion(salesRegionList, salesRegion.getC_SalesRegion_ID());
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "SELECT tn.Node_ID AS C_SalesRegion_ID FROM AD_Tree t INNER JOIN AD_TreeNode tn ON(t.AD_Tree_ID = tn.AD_Tree_ID) WHERE t.AD_Tree_ID = ? AND tn.Parent_ID = ?", e);
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
    }

    private String getSalesRegionClause(List<Integer> salesRegionList, int salesRegionId) {
        if (salesRegionList.size() == 0) {
            this.loadSalesRegion(salesRegionList, salesRegionId);
        }
        StringBuffer srClause = new StringBuffer();
        if (salesRegionList.size() == 0) {
            srClause.append("= " + salesRegionId);
        } else {
            srClause = new StringBuffer("IN(");
            for (int i = 0; i < salesRegionList.size(); ++i) {
                if (i > 0) {
                    srClause.append(", ");
                }
                srClause.append(salesRegionList.get(i));
            }
            srClause.append(")");
        }
        return srClause.toString();
    }

    private String getExclusionWhere(String docBasisType, MCommissionLine currentLine, MCommissionLine[] lines, MCommissionType commissionType) {
        String columnName;
        ArrayList<Integer> orgId = new ArrayList<Integer>();
        ArrayList<Integer> bPartnerId = new ArrayList<Integer>();
        ArrayList<Integer> bPGroupId = new ArrayList<Integer>();
        ArrayList<Integer> salesRegionId = new ArrayList<Integer>();
        ArrayList<Integer> productId = new ArrayList<Integer>();
        ArrayList<Integer> productCategoryId = new ArrayList<Integer>();
        ArrayList<Integer> productGroupId = new ArrayList<Integer>();
        ArrayList<Integer> productClassId = new ArrayList<Integer>();
        ArrayList<Integer> productClassificationId = new ArrayList<Integer>();
        ArrayList<Integer> projectId = new ArrayList<Integer>();
        ArrayList<Integer> campaignId = new ArrayList<Integer>();
        ArrayList<Integer> channelId = new ArrayList<Integer>();
        ArrayList<String> paymentRule = new ArrayList<String>();
        ArrayList<Integer> dunningLevelId = new ArrayList<Integer>();
        ArrayList<String> invoiceCollectionType = new ArrayList<String>();
        for (MCommissionLine line : lines) {
            if (line.getC_CommissionLine_ID() == currentLine.getC_CommissionLine_ID()) continue;
            if (currentLine.getOrg_ID() == 0 && line.getOrg_ID() != 0) {
                orgId.add(line.getOrg_ID());
            }
            if (currentLine.getC_BPartner_ID() == 0 && line.getC_BPartner_ID() != 0) {
                bPartnerId.add(line.getC_BPartner_ID());
            }
            if (currentLine.getC_BP_Group_ID() == 0 && line.getC_BP_Group_ID() != 0) {
                bPGroupId.add(line.getC_BP_Group_ID());
            }
            if (currentLine.getC_SalesRegion_ID() == 0 && line.getC_SalesRegion_ID() != 0) {
                salesRegionId.add(line.getC_SalesRegion_ID());
            }
            if (currentLine.getM_Product_ID() == 0 && line.getM_Product_ID() != 0) {
                productId.add(line.getM_Product_ID());
            }
            if (currentLine.getM_Product_Category_ID() == 0 && line.getM_Product_Category_ID() != 0) {
                productCategoryId.add(line.getM_Product_Category_ID());
            }
            if (currentLine.getM_Product_Group_ID() == 0 && line.getM_Product_Group_ID() != 0) {
                productGroupId.add(line.getM_Product_Group_ID());
            }
            if (currentLine.getM_Product_Class_ID() == 0 && line.getM_Product_Class_ID() != 0) {
                productClassId.add(line.getM_Product_Class_ID());
            }
            if (currentLine.getM_Product_Classification_ID() == 0 && line.getM_Product_Classification_ID() != 0) {
                productClassificationId.add(line.getM_Product_Classification_ID());
            }
            if (currentLine.getPaymentRule() == null && line.getPaymentRule() != null) {
                paymentRule.add(line.getPaymentRule());
            }
            if (currentLine.getC_Project_ID() == 0 && line.getC_Project_ID() != 0) {
                projectId.add(line.getC_Project_ID());
            }
            if (currentLine.getC_Campaign_ID() == 0 && line.getC_Campaign_ID() != 0) {
                campaignId.add(line.getC_Campaign_ID());
            }
            if (currentLine.getC_Channel_ID() == 0 && line.getC_Channel_ID() != 0) {
                channelId.add(line.getC_Channel_ID());
            }
            if (!docBasisType.equals("I")) continue;
            if (currentLine.getC_DunningLevel_ID() == 0 && line.getC_DunningLevel_ID() != 0) {
                dunningLevelId.add(line.getC_DunningLevel_ID());
            }
            if (currentLine.getInvoiceCollectionType() != null || line.getInvoiceCollectionType() == null) continue;
            invoiceCollectionType.add(line.getInvoiceCollectionType());
        }
        StringBuffer sql = new StringBuffer();
        if (orgId.size() != 0 && currentLine.getAD_Org_ID() == 0 && !Util.isEmpty(columnName = this.getSQLColumnName("h.AD_Org_ID", commissionType))) {
            sql.append(" AND ").append(columnName).append(" NOT IN").append(((Object)orgId).toString().replace('[', '(').replace(']', ')'));
        }
        if (bPartnerId.size() != 0 && currentLine.getC_BPartner_ID() == 0 && !Util.isEmpty(columnName = this.getSQLColumnName("h.C_BPartner_ID", commissionType))) {
            sql.append(" AND ").append(columnName).append(" NOT IN").append(((Object)bPartnerId).toString().replace('[', '(').replace(']', ')'));
        }
        if (bPGroupId.size() != 0 && currentLine.getC_BPartner_ID() == 0 && currentLine.getC_BP_Group_ID() == 0 && !Util.isEmpty(columnName = this.getSQLColumnName("h.C_BPartner_ID", commissionType))) {
            sql.append(" AND EXISTS(SELECT 1 FROM C_BPartner bp \t\tWHERE bp.C_BPartner_ID = " + columnName + " \t\tAND bp.C_BP_Group_ID NOT IN").append(((Object)bPGroupId).toString().replace('[', '(').replace(']', ')')).append(")");
        }
        if (salesRegionId.size() != 0 && currentLine.getC_SalesRegion_ID() == 0 && !Util.isEmpty(columnName = this.getSQLColumnName("h.C_BPartner_Location_ID", commissionType))) {
            sql.append(" AND EXISTS(SELECT 1 FROM C_BPartner_Location l \t\tWHERE l.C_BPartner_Location_ID = " + columnName + " \t\tAND C_SalesRegion_ID NOT IN").append(((Object)salesRegionId).toString().replace('[', '(').replace(']', ')')).append(")");
        }
        if (productId.size() != 0 && currentLine.getM_Product_ID() == 0 && !Util.isEmpty(columnName = this.getSQLColumnName("l.M_Product_ID", commissionType))) {
            sql.append(" AND ").append(columnName).append(" NOT IN").append(((Object)productId).toString().replace('[', '(').replace(']', ')')).append(")");
        }
        if (productCategoryId.size() != 0 && currentLine.getM_Product_ID() == 0 && currentLine.getM_Product_Category_ID() == 0 && !Util.isEmpty(columnName = this.getSQLColumnName("l.M_Product_ID", commissionType))) {
            sql.append(" AND EXISTS(SELECT 1 FROM M_Product p \t\tWHERE p.M_Product_ID = " + columnName + " \t\tAND M_Product_Category_ID NOT IN").append(((Object)productCategoryId).toString().replace('[', '(').replace(']', ')')).append(")");
        }
        if (productGroupId.size() != 0 && currentLine.getM_Product_ID() == 0 && currentLine.getM_Product_Group_ID() == 0 && !Util.isEmpty(columnName = this.getSQLColumnName("l.M_Product_ID", commissionType))) {
            sql.append(" AND EXISTS(SELECT 1 FROM M_Product p \t\tWHERE p.M_Product_ID = " + columnName + " \t\tAND M_Product_Group_ID NOT IN").append(((Object)productGroupId).toString().replace('[', '(').replace(']', ')')).append(")");
        }
        if (productClassId.size() != 0 && currentLine.getM_Product_ID() == 0 && currentLine.getM_Product_Class_ID() == 0 && !Util.isEmpty(columnName = this.getSQLColumnName("l.M_Product_ID", commissionType))) {
            sql.append(" AND EXISTS(SELECT 1 FROM M_Product p \t\tWHERE p.M_Product_ID = " + columnName + " \t\tAND M_Product_Class_ID NOT IN").append(((Object)productClassId).toString().replace('[', '(').replace(']', ')')).append(")");
        }
        if (productClassificationId.size() != 0 && currentLine.getM_Product_ID() == 0 && currentLine.getM_Product_Classification_ID() == 0 && !Util.isEmpty(columnName = this.getSQLColumnName("l.M_Product_ID", commissionType))) {
            sql.append(" AND EXISTS(SELECT 1 FROM M_Product p \t\tWHERE p.M_Product_ID = " + columnName + " \t\tAND M_Product_Classification_ID NOT IN").append(((Object)productClassificationId).toString().replace('[', '(').replace(']', ')')).append(")");
        }
        if (projectId.size() != 0 && currentLine.getC_Project_ID() == 0 && !Util.isEmpty(columnName = this.getSQLColumnName("l.C_Project_ID", commissionType))) {
            sql.append(" AND ").append(columnName).append(" NOT IN").append(((Object)projectId).toString().replace('[', '(').replace(']', ')')).append(")");
        }
        if (campaignId.size() != 0 && currentLine.getC_Campaign_ID() == 0 && !Util.isEmpty(columnName = this.getSQLColumnName("l.C_Campaign_ID", commissionType))) {
            sql.append(" AND ").append(columnName).append(" NOT IN").append(((Object)campaignId).toString().replace('[', '(').replace(']', ')')).append(")");
        }
        if (channelId.size() != 0 && !Util.isEmpty(columnName = this.getSQLColumnName("l.C_Campaign_ID", commissionType))) {
            sql.append(" AND EXISTS(SELECT 1 FROM C_Campaign \t\t\t\t\tWHERE C_Campaign.C_Campaign_ID = " + columnName + " \t\t\t\t\tAND C_Campaign.C_Channel_ID NOT IN").append(((Object)channelId).toString().replace('[', '(').replace(']', ')')).append(")");
        }
        if (paymentRule.size() != 0 && Util.isEmpty(currentLine.getPaymentRule()) && !Util.isEmpty(columnName = this.getSQLColumnName("h.PaymentRule", commissionType))) {
            sql.append(" AND ").append(columnName).append(" NOT IN('").append(((Object)paymentRule).toString().replace('[', ' ').replace(']', ')').replaceAll(",", ",'")).append(")");
        }
        if (docBasisType.equals("I")) {
            if (dunningLevelId.size() != 0 && currentLine.getC_DunningLevel_ID() == 0 && !Util.isEmpty(columnName = this.getSQLColumnName("h.C_DunningLevel_ID", commissionType))) {
                sql.append(" AND ").append(columnName).append(" NOT IN").append(((Object)dunningLevelId).toString().replace('[', '(').replace(']', ')')).append(")");
            }
            if (invoiceCollectionType.size() != 0 && Util.isEmpty(currentLine.getInvoiceCollectionType()) && !Util.isEmpty(columnName = this.getSQLColumnName("h.InvoiceCollectionType", commissionType))) {
                sql.append(" AND ").append(columnName).append(" NOT IN('").append(((Object)invoiceCollectionType).toString().replace('[', ' ').replace(']', ')').replaceAll(",", ",'")).append(")");
            }
        }
        return sql.toString();
    }

    private void setStartEndDate(String frequencyType) {
        if (this.getStartDate() != null && this.getEndDate() != null || !this.isReCalculate()) {
            return;
        }
        GregorianCalendar cal = new GregorianCalendar(Language.getLoginLanguage().getLocale());
        cal.setTimeInMillis(this.getDateDoc().getTime());
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        if ("Y".equals(frequencyType)) {
            cal.set(6, 1);
            this.setStartDate(new Timestamp(cal.getTimeInMillis()));
            cal.add(1, 1);
            cal.add(6, -1);
        } else if ("S".equals(frequencyType)) {
            cal.set(5, 1);
            int month = cal.get(2);
            if (month <= 5) {
                cal.set(2, 0);
                this.setStartDate(new Timestamp(cal.getTimeInMillis()));
            } else {
                cal.set(2, 6);
                this.setStartDate(new Timestamp(cal.getTimeInMillis()));
            }
            cal.add(2, 6);
            cal.add(6, -1);
        } else if ("Q".equals(frequencyType)) {
            cal.set(5, 1);
            int month = cal.get(2);
            if (month < 3) {
                cal.set(2, 0);
            } else if (month < 6) {
                cal.set(2, 3);
            } else if (month < 9) {
                cal.set(2, 6);
            } else {
                cal.set(2, 9);
            }
            this.setStartDate(new Timestamp(cal.getTimeInMillis()));
            cal.add(2, 3);
            cal.add(6, -1);
        } else if ("W".equals(frequencyType)) {
            cal.set(7, 1);
            this.setStartDate(new Timestamp(cal.getTimeInMillis()));
            cal.add(6, 7);
        } else if ("B".equals(frequencyType)) {
            int dayOfMonth = cal.get(5);
            if (dayOfMonth <= 15) {
                cal.set(5, 1);
                this.setStartDate(new Timestamp(cal.getTimeInMillis()));
                cal.set(5, 15);
            } else {
                cal.set(5, 16);
                this.setStartDate(new Timestamp(cal.getTimeInMillis()));
                cal.set(5, 1);
                cal.add(2, 1);
                cal.add(6, -1);
            }
        } else {
            cal.set(5, 1);
            this.setStartDate(new Timestamp(cal.getTimeInMillis()));
            cal.add(2, 1);
            cal.add(6, -1);
        }
        this.setEndDate(new Timestamp(cal.getTimeInMillis()));
        this.log.fine("setStartEndDate = " + this.getStartDate() + " - " + this.getEndDate());
    }

    @Override
    public boolean approveIt() {
        this.log.info("approveIt - " + this.toString());
        this.setIsApproved(true);
        return true;
    }

    @Override
    public boolean rejectIt() {
        this.log.info("rejectIt - " + this.toString());
        this.setIsApproved(false);
        return true;
    }

    @Override
    public String completeIt() {
        String status;
        if (!this.m_justPrepared && !"IP".equals(status = this.prepareIt())) {
            return status;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 7);
        if (this.m_processMsg != null) {
            return "IN";
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        this.log.info(this.toString());
        String valid = ModelValidationEngine.get().fireDocValidate(this, 9);
        if (valid != null) {
            this.m_processMsg = valid;
            return "IN";
        }
        this.setDefiniteDocumentNo();
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    private void setDefiniteDocumentNo() {
        MDocType dt = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        if (dt.isOverwriteDateOnComplete()) {
            this.setStartDate(new Timestamp(System.currentTimeMillis()));
        }
        if (dt.isOverwriteSeqOnComplete()) {
            String value = null;
            int index = this.p_info.getColumnIndex("C_DocType_ID");
            if (index == -1) {
                index = this.p_info.getColumnIndex("C_DocTypeTarget_ID");
            }
            if (index != -1) {
                value = DB.getDocumentNo(this.get_ValueAsInt(index), this.get_TrxName(), true);
            }
            if (value != null) {
                this.setDocumentNo(value);
            }
        }
    }

    @Override
    public boolean voidIt() {
        this.log.info("voidIt - " + this.toString());
        Object processMsg = ModelValidationEngine.get().fireDocValidate(this, 2);
        if (processMsg != null) {
            return false;
        }
        if ("CL".equals(this.getDocStatus()) || "RE".equals(this.getDocStatus()) || "VO".equals(this.getDocStatus())) {
            processMsg = "Document Closed: " + this.getDocStatus();
            return false;
        }
        this.setProcessed(true);
        this.setDocStatus("VO");
        this.saveEx();
        processMsg = ModelValidationEngine.get().fireDocValidate(this, 10);
        return processMsg == null;
    }

    @Override
    public boolean closeIt() {
        this.log.info("closeIt - " + this.toString());
        this.setDocAction("--");
        return true;
    }

    @Override
    public boolean reverseCorrectIt() {
        this.log.info("reverseCorrectIt - " + this.toString());
        return false;
    }

    @Override
    public boolean reverseAccrualIt() {
        this.log.info("reverseAccrualIt - " + this.toString());
        return false;
    }

    @Override
    public boolean reActivateIt() {
        this.log.info("reActivateIt - " + this.toString());
        this.deleteMovements();
        this.setProcessed(false);
        return true;
    }

    @Override
    public String getSummary() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getDocumentNo());
        if (this.getDescription() != null && this.getDescription().length() > 0) {
            sb.append(" - ").append(this.getDescription());
        }
        return sb.toString();
    }

    @Override
    public String getProcessMsg() {
        return this.m_processMsg;
    }

    @Override
    public int getDoc_User_ID() {
        return 0;
    }

    @Override
    public BigDecimal getApprovalAmt() {
        return null;
    }

    @Override
    public int getC_Currency_ID() {
        return 0;
    }

    @Override
    public int customizeValidActions(String docStatus, Object processing, String orderType, String isSOTrx, int AD_Table_ID, String[] docAction, String[] options, int index) {
        if (docStatus.equals("CO")) {
            options[index++] = "RE";
            options[index++] = "VO";
            options[index++] = "CL";
        } else if (docStatus.equals("IP") || docStatus.equals("DR")) {
            options[index++] = "PR";
            options[index++] = "CO";
            options[index++] = "VO";
        }
        return index;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MCCommissionRun[").append(this.getSummary()).append("]");
        return sb.toString();
    }

    public List<MCommissionAmt> getCommissionAmtList() {
        return new Query(this.getCtx(), "C_CommissionAmt", "C_CommissionRun_ID = ?", this.get_TrxName()).setParameters(this.getC_CommissionRun_ID()).setOrderBy("C_BPartner_ID").list();
    }
}

