/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import org.adempiere.core.domains.models.X_M_CostType;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MProduct;
import org.compiere.model.MProductCategoryAcct;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.Msg;

public class MCostType
extends X_M_CostType {
    private static final long serialVersionUID = -2060640115481013228L;
    private static CCache<Integer, MCostType> s_cache = new CCache("MCostType", 3);

    public static MCostType get(MAcctSchema as, int M_Product_ID, int AD_Org_ID) {
        MProduct product = MProduct.get(as.getCtx(), M_Product_ID);
        MCostType ct = MCostType.getByOrg(as.getCtx(), AD_Org_ID, as.get_TrxName());
        if (product != null) {
            MProductCategoryAcct pca = MProductCategoryAcct.get(as.getCtx(), product.getM_Product_Category_ID(), as.getC_AcctSchema_ID(), AD_Org_ID, as.get_TrxName());
            if (pca != null && pca.getCostingMethod() != null && pca.getCostingMethod().length() > 0) {
                ct = MCostType.getByMethodCosting(as, pca.getCostingMethod());
            } else if (ct == null) {
                ct = MCostType.getByMethodCosting(as, as.getCostingMethod());
            }
        }
        if (ct == null) {
            throw new IllegalStateException("A Cost Type does not exist with this Costing method: " + as.getCostingMethod());
        }
        return ct;
    }

    public static MCostType get(Properties ctx, int M_CostType_ID) {
        return MCostType.get(ctx, M_CostType_ID, null);
    }

    public static MCostType get(Properties ctx, int M_CostType_ID, String trxName) {
        Integer key = M_CostType_ID;
        MCostType retValue = s_cache.get(key);
        if (retValue != null) {
            return retValue;
        }
        retValue = new MCostType(ctx, M_CostType_ID, trxName);
        if (trxName == null) {
            s_cache.put(key, retValue);
        }
        return retValue;
    }

    public static List<MCostType> get(Properties ctx, String trxName) {
        return new Query(ctx, "M_CostType", null, trxName).setOnlyActiveRecords(true).setClient_ID().setOrderBy("M_CostType_ID").list();
    }

    public static MCostType getByOrg(Properties ctx, int AD_Org_ID, String trxName) {
        return (MCostType)new Query(ctx, "M_CostType", "AD_Org_ID=?", trxName).setOnlyActiveRecords(true).setClient_ID().setParameters(AD_Org_ID).setOrderBy("M_CostType_ID").first();
    }

    public static MCostType getByMethodCosting(MAcctSchema accountSchema, String costingMethod) {
        return (MCostType)new Query(accountSchema.getCtx(), "M_CostType", "AD_Client_ID=? AND CostingMethod=?", accountSchema.get_TrxName()).setOnlyActiveRecords(true).setParameters(accountSchema.getAD_Client_ID(), costingMethod).setOrderBy("CostingMethod").first();
    }

    public MCostType(Properties ctx, int M_CostType_ID, String trxName) {
        super(ctx, M_CostType_ID, trxName);
    }

    public MCostType(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MCostType[");
        sb.append(this.get_ID()).append("-").append(this.getName()).append("]");
        return sb.toString();
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        return true;
    }

    @Override
    protected boolean beforeDelete() {
        MAcctSchema[] ass = MAcctSchema.getClientAcctSchema(this.getCtx(), this.getAD_Client_ID());
        for (int i = 0; i < ass.length; ++i) {
            if (ass[i].getM_CostType_ID() != this.getM_CostType_ID()) continue;
            this.log.saveError("CannotDelete", Msg.getElement(this.getCtx(), "C_AcctSchema_ID") + " - " + ass[i].getName());
            return false;
        }
        return true;
    }

    public boolean isAveragePO() {
        String cm = this.getCostingMethod();
        return cm != null && cm.equals("A");
    }

    public boolean isFifo() {
        String cm = this.getCostingMethod();
        return cm != null && cm.equals("F");
    }

    public boolean isLastInvoice() {
        String cm = this.getCostingMethod();
        return cm != null && cm.equals("i");
    }

    public boolean isLastPOPrice() {
        String cm = this.getCostingMethod();
        return cm != null && cm.equals("p");
    }

    public boolean isLifo() {
        String cm = this.getCostingMethod();
        return cm != null && cm.equals("L");
    }

    public boolean isStandardCosting() {
        String cm = this.getCostingMethod();
        return cm != null && cm.equals("S");
    }

    public boolean isAverageInvoice() {
        String cm = this.getCostingMethod();
        return cm != null && cm.equals("I");
    }

    public boolean isUserDefined() {
        String cm = this.getCostingMethod();
        return cm != null && cm.equals("U");
    }
}

