/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.Properties;
import org.adempiere.core.domains.models.X_C_Currency;
import org.compiere.model.Query;
import org.compiere.util.CCache;

public class MCurrency
extends X_C_Currency {
    private static final long serialVersionUID = 5549233389514285323L;
    private static CCache<Integer, MCurrency> s_currencies = new CCache("C_Currency", 50);
    private static CCache<String, MCurrency> s_currenciesISO = new CCache("C_CurrencyISO", 50);

    public MCurrency(Properties ctx, int C_Currency_ID, String trxName) {
        super(ctx, C_Currency_ID, trxName);
        if (C_Currency_ID == 0) {
            this.setIsEMUMember(false);
            this.setIsEuro(false);
            this.setStdPrecision(2);
            this.setCostingPrecision(4);
        }
    }

    public MCurrency(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MCurrency(Properties ctx, String ISO_Code, String Description, String CurSymbol, int StdPrecision, int CostingPrecision, String trxName) {
        super(ctx, 0, trxName);
        this.setISO_Code(ISO_Code);
        this.setDescription(Description);
        this.setCurSymbol(CurSymbol);
        this.setStdPrecision(StdPrecision);
        this.setCostingPrecision(CostingPrecision);
        this.setIsEMUMember(false);
        this.setIsEuro(false);
    }

    public static MCurrency get(Properties ctx, String ISOcode) {
        MCurrency retValue = s_currenciesISO.get(ISOcode);
        if (retValue != null) {
            return retValue;
        }
        Query query = new Query(ctx, "C_Currency", "ISO_Code=?", null);
        query.setParameters(ISOcode);
        retValue = (MCurrency)query.firstOnly();
        if (retValue != null) {
            s_currenciesISO.put(ISOcode, retValue);
        }
        return retValue;
    }

    public static MCurrency get(Properties ctx, int C_Currency_ID) {
        Integer key = C_Currency_ID;
        MCurrency retValue = s_currencies.get(key);
        if (retValue != null) {
            return retValue;
        }
        retValue = new MCurrency(ctx, C_Currency_ID, null);
        if (retValue.getAD_Client_ID() == 0) {
            s_currencies.put(key, retValue);
        }
        return retValue;
    }

    public static String getISO_Code(Properties ctx, int C_Currency_ID) {
        String contextKey = "C_Currency_" + C_Currency_ID;
        String retValue = ctx.getProperty(contextKey);
        if (retValue != null) {
            return retValue;
        }
        MCurrency c = MCurrency.get(ctx, C_Currency_ID);
        retValue = c.getISO_Code();
        ctx.setProperty(contextKey, retValue);
        return retValue;
    }

    public static int getStdPrecision(Properties ctx, int C_Currency_ID) {
        MCurrency c = MCurrency.get(ctx, C_Currency_ID);
        return c.getStdPrecision();
    }

    @Override
    public String toString() {
        return "MCurrency[" + this.getC_Currency_ID() + "-" + this.getISO_Code() + "-" + this.getCurSymbol() + "," + this.getDescription() + ",Precision=" + this.getStdPrecision() + "/" + this.getCostingPrecision();
    }
}

