/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.core.domains.models.X_GL_Distribution;
import org.adempiere.core.domains.models.X_GL_DistributionLine;
import org.compiere.model.MAccount;
import org.compiere.model.MCurrency;
import org.compiere.model.MDistributionLine;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.Env;

public class MDistribution
extends X_GL_Distribution {
    private static final long serialVersionUID = -906547096682610205L;
    private static CLogger logger = CLogger.getCLogger(MDistribution.class);
    private static CCache<Integer, List<MDistribution>> distributionCache = new CCache("GL_Distribution", 100);
    private List<MDistributionLine> distributionLines = null;
    Boolean isPercentage = false;
    Boolean isAmount = false;

    public static List<MDistribution> get(MAccount account, String postingType, int docTypeId, Timestamp accountDate) {
        return MDistribution.get(account.getCtx(), account.getC_AcctSchema_ID(), postingType, docTypeId, account.getAD_Org_ID(), account.getAccount_ID(), account.getM_Product_ID(), account.getC_BPartner_ID(), account.getC_Project_ID(), account.getC_Campaign_ID(), account.getC_Activity_ID(), account.getAD_OrgTrx_ID(), account.getC_SalesRegion_ID(), account.getC_LocTo_ID(), account.getC_LocFrom_ID(), account.getUser1_ID(), account.getUser2_ID(), account.getUser3_ID(), account.getUser4_ID(), accountDate);
    }

    public static List<MDistribution> get(Properties ctx, int acctSchemaId, String postingType, int docTypeId, int orgId, int accountId, int productId, int partnerId, int projectId, int campaignId, int activityId, int orgTrxId, int salesRegionId, int locToId, int locFromId, int user1Id, int user2Id, int user3Id, int user4Id, Timestamp accountDate) {
        List<MDistribution> distributions = MDistribution.get(ctx, accountId);
        if (distributions == null || distributions.size() == 0) {
            return null;
        }
        ArrayList<MDistribution> distributionList = new ArrayList<MDistribution>();
        for (MDistribution distribution : distributions) {
            if (!distribution.isValidFromTo(accountDate) || !distribution.isActive() || !distribution.isValid() || distribution.getC_AcctSchema_ID() != acctSchemaId || distribution.getPostingType() != null && !distribution.getPostingType().equals(postingType) || distribution.getC_DocType_ID() != 0 && distribution.getC_DocType_ID() != docTypeId || !distribution.isAnyOrg() && distribution.getOrg_ID() != orgId || !distribution.isAnyAcct() && distribution.getAccount_ID() != accountId || !distribution.isAnyProduct() && distribution.getM_Product_ID() != productId || !distribution.isAnyBPartner() && distribution.getC_BPartner_ID() != partnerId || !distribution.isAnyProject() && distribution.getC_Project_ID() != projectId || !distribution.isAnyCampaign() && distribution.getC_Campaign_ID() != campaignId || !distribution.isAnyActivity() && distribution.getC_Activity_ID() != activityId || !distribution.isAnyOrgTrx() && distribution.getAD_OrgTrx_ID() != orgTrxId || !distribution.isAnySalesRegion() && distribution.getC_SalesRegion_ID() != salesRegionId || !distribution.isAnyLocTo() && distribution.getC_LocTo_ID() != locToId || !distribution.isAnyLocFrom() && distribution.getC_LocFrom_ID() != locFromId || !distribution.isAnyUser1() && distribution.getUser1_ID() != user1Id || !distribution.isAnyUser2() && distribution.getUser2_ID() != user2Id || !distribution.isAnyUser3() && distribution.getUser3_ID() != user3Id || !distribution.isAnyUser4() && distribution.getUser4_ID() != user4Id) continue;
            distributionList.add(distribution);
        }
        return distributionList;
    }

    public static List<MDistribution> get(Properties ctx, int accountId) {
        Integer key = accountId;
        List<MDistribution> distributions = distributionCache.get(key);
        if (distributions != null) {
            return distributions;
        }
        String whereClause = "Account_ID=?";
        List<MDistribution> list = new Query(ctx, "GL_Distribution", "Account_ID=?", null).setClient_ID().setOnlyActiveRecords(true).setParameters(accountId).list();
        if (list != null && list.size() > 0) {
            distributionCache.put(key, list);
        }
        return list;
    }

    public MDistribution(Properties ctx, int distributionId, String trxName) {
        super(ctx, distributionId, trxName);
        if (distributionId == 0) {
            this.setAnyAcct(true);
            this.setAnyActivity(true);
            this.setAnyBPartner(true);
            this.setAnyCampaign(true);
            this.setAnyLocFrom(true);
            this.setAnyLocTo(true);
            this.setAnyOrg(true);
            this.setAnyOrgTrx(true);
            this.setAnyProduct(true);
            this.setAnyProject(true);
            this.setAnySalesRegion(true);
            this.setAnyUser1(true);
            this.setAnyUser2(true);
            this.setIsValid(false);
            this.setPercentTotal(Env.ZERO);
        }
    }

    public MDistribution(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public List<MDistributionLine> getLines(boolean reload) {
        if (this.distributionLines != null && !reload) {
            this.distributionLines.forEach(distributionLine -> distributionLine.set_TrxName(this.get_TrxName()));
            return this.distributionLines;
        }
        BigDecimal PercentTotal = Env.ZERO;
        String whereClause = "GL_Distribution_ID=?";
        this.distributionLines = new Query(this.getCtx(), "GL_DistributionLine", "GL_Distribution_ID=?", this.get_TrxName()).setClient_ID().setOnlyActiveRecords(true).setParameters(this.getGL_Distribution_ID()).setOrderBy("Line").list();
        boolean hasNullRemainder = false;
        BigDecimal amountCreditTotal = BigDecimal.ZERO;
        BigDecimal amountDebitTotal = BigDecimal.ZERO;
        for (MDistributionLine distributionLine2 : this.distributionLines) {
            if (!distributionLine2.isActive()) continue;
            BigDecimal amountCredit = distributionLine2.getAmtAcctCr();
            BigDecimal amountDebit = distributionLine2.getAmtAcctDr();
            if (amountCredit != null && amountCredit.signum() != 0) {
                amountCreditTotal = amountCreditTotal.add(distributionLine2.getAmtAcctCr());
                this.isAmount = true;
            } else if (amountDebit != null && amountDebit.signum() != 0) {
                amountDebitTotal = amountDebitTotal.add(distributionLine2.getAmtAcctDr());
                this.isAmount = true;
            } else {
                PercentTotal = PercentTotal.add(distributionLine2.getPercent());
                hasNullRemainder = Env.ZERO.compareTo(distributionLine2.getPercent()) == 0;
                this.isPercentage = true;
            }
            distributionLine2.setParent(this);
        }
        if (hasNullRemainder && this.isPercentage.booleanValue()) {
            PercentTotal = Env.ONEHUNDRED;
        }
        if (this.get_ID() != 0 && (PercentTotal.compareTo(this.getPercentTotal()) != 0 || this.isAmount.booleanValue())) {
            this.setPercentTotal(PercentTotal);
            this.saveEx();
        }
        return this.distributionLines;
    }

    public String validate() {
        List<MDistribution> distributions;
        Object retValue = null;
        this.getLines(true);
        if (this.distributionLines.size() == 0) {
            retValue = "@NoLines@";
        } else if (this.isPercentage.booleanValue() && this.getPercentTotal().compareTo(Env.ONEHUNDRED) != 0) {
            retValue = "@PercentTotal@ <> 100";
        } else if (this.isAmount.booleanValue() && this.getBalance().signum() != 0) {
            retValue = "Debit amount is not equal to credit amount";
        }
        Timestamp startDate = this.getValidFrom();
        Timestamp endDate = this.getValidTo();
        if (startDate != null && endDate != null && startDate.after(endDate)) {
            retValue = "Invalid Time range";
        }
        if ((distributions = MDistribution.getSameDistributions(this.getCtx(), this.getC_AcctSchema_ID(), this.getPostingType(), this.getC_DocType_ID(), this.getAD_Org_ID(), this.getAccount_ID(), this.getM_Product_ID(), this.getC_BPartner_ID(), this.getC_Project_ID(), this.getC_Campaign_ID(), this.getC_Activity_ID(), this.getAD_OrgTrx_ID(), this.getC_SalesRegion_ID(), this.getC_LocTo_ID(), this.getC_LocFrom_ID(), this.getUser1_ID(), this.getUser2_ID(), this.getUser3_ID(), this.getUser4_ID())) != null && distributions.size() > 0) {
            for (int i = 0; i < distributions.size(); ++i) {
                if (distributions.get(i).getGL_Distribution_ID() == this.get_ID()) continue;
                Timestamp curStartDate = distributions.get(i).getValidFrom();
                Timestamp curEndDate = distributions.get(i).getValidTo();
                if (startDate == null || endDate == null || curStartDate == null || curEndDate == null || startDate.after(curEndDate) || curStartDate.after(endDate)) continue;
                retValue = "Current date range Overlapping with GL Distribution :" + distributions.get(i).getName();
                break;
            }
        }
        this.setIsValid(retValue == null);
        return retValue;
    }

    public BigDecimal getBalance() {
        BigDecimal totalDebit = this.getLines(true).stream().map(X_GL_DistributionLine::getAmtAcctDr).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalCredit = this.getLines(true).stream().map(X_GL_DistributionLine::getAmtAcctCr).reduce(BigDecimal.ZERO, BigDecimal::add);
        return totalDebit.subtract(totalCredit);
    }

    public static List<MDistribution> getSameDistributions(Properties ctx, int acctSchemaId, String postingType, int docTypeId, int orgId, int accountId, int productId, int partnerId, int projectId, int campaignId, int activityId, int orgTrxId, int salesRegionId, int locToId, int locFromId, int user1Id, int user2Id, int user3Id, int user4Id) {
        List<MDistribution> distributions = MDistribution.getDistributions(ctx, acctSchemaId);
        if (distributions == null || distributions.size() == 0) {
            return null;
        }
        ArrayList<MDistribution> list = new ArrayList<MDistribution>();
        for (MDistribution distribution : distributions) {
            if (!distribution.isActive() || !distribution.isValid() || distribution.getPostingType() != null && !distribution.getPostingType().equals(postingType) || distribution.getC_DocType_ID() != 0 && distribution.getC_DocType_ID() != docTypeId || !distribution.isAnyOrg() && distribution.getOrg_ID() != orgId || !distribution.isAnyAcct() && distribution.getAccount_ID() != accountId || !distribution.isAnyProduct() && distribution.getM_Product_ID() != productId || !distribution.isAnyBPartner() && distribution.getC_BPartner_ID() != partnerId || !distribution.isAnyProject() && distribution.getC_Project_ID() != projectId || !distribution.isAnyCampaign() && distribution.getC_Campaign_ID() != campaignId || !distribution.isAnyActivity() && distribution.getC_Activity_ID() != activityId || !distribution.isAnyOrgTrx() && distribution.getAD_OrgTrx_ID() != orgTrxId || !distribution.isAnySalesRegion() && distribution.getC_SalesRegion_ID() != salesRegionId || !distribution.isAnyLocTo() && distribution.getC_LocTo_ID() != locToId || !distribution.isAnyLocFrom() && distribution.getC_LocFrom_ID() != locFromId || !distribution.isAnyUser1() && distribution.getUser1_ID() != user1Id || !distribution.isAnyUser2() && distribution.getUser2_ID() != user2Id || !distribution.isAnyUser3() && distribution.getUser3_ID() != user3Id || !distribution.isAnyUser4() && distribution.getUser4_ID() != user4Id && !distribution.isAnyUser3() && distribution.getUser3_ID() != user3Id || distribution.isAnyUser4() || distribution.getUser4_ID() == user4Id) continue;
            list.add(distribution);
        }
        return list;
    }

    public static List<MDistribution> getDistributions(Properties ctx, int acctSchemaId) {
        Integer key = acctSchemaId;
        List<MDistribution> retValue = distributionCache.get(key);
        if (retValue != null) {
            return retValue;
        }
        String whereClause = "C_AcctSchema_ID=?";
        List list = new Query(ctx, "GL_Distribution", "C_AcctSchema_ID=?", null).setClient_ID().setOnlyActiveRecords(true).setParameters(acctSchemaId).list();
        distributionCache.put(key, list);
        return retValue;
    }

    public void distribute(MAccount account, BigDecimal amount, BigDecimal quantity, int currencyId, int sign) {
        this.log.info("distribute - Amt=" + amount + " - Qty=" + quantity + " - " + account);
        this.getLines(false);
        int precision = MCurrency.getStdPrecision(this.getCtx(), currencyId);
        BigDecimal total = BigDecimal.ZERO;
        BigDecimal totalQty = BigDecimal.ZERO;
        int indexBiggest = -1;
        int indexZeroPercent = -1;
        boolean isPercentage = false;
        for (int i = 0; i < this.distributionLines.size(); ++i) {
            MDistributionLine distributionLine2 = this.distributionLines.get(i);
            if (!distributionLine2.isActive()) continue;
            distributionLine2.setAccount(account);
            if (distributionLine2.getAmtAcctDr() != null && distributionLine2.getAmtAcctDr().signum() != 0) {
                if (sign < 0) {
                    distributionLine2.setAmt(distributionLine2.getAmtAcctDr());
                    continue;
                }
                distributionLine2.setAmt(distributionLine2.getAmtAcctDr().negate());
                continue;
            }
            if (distributionLine2.getAmtAcctCr() != null && distributionLine2.getAmtAcctCr().signum() != 0) {
                if (sign > 0) {
                    distributionLine2.setAmt(distributionLine2.getAmtAcctCr());
                    continue;
                }
                distributionLine2.setAmt(distributionLine2.getAmtAcctCr().negate());
                continue;
            }
            if (distributionLine2.getPercent().signum() == 0) continue;
            distributionLine2.calculateAmt(amount, precision);
            distributionLine2.calculateQty(quantity);
            total = total.add(distributionLine2.getAmt());
            totalQty = totalQty.add(distributionLine2.getQty());
            if (distributionLine2.getPercent().signum() == 0) {
                indexZeroPercent = i;
            }
            if (indexZeroPercent == -1) {
                if (indexBiggest == -1) {
                    indexBiggest = i;
                } else if (distributionLine2.getAmt().compareTo(this.distributionLines.get(indexBiggest).getAmt()) > 0) {
                    indexBiggest = i;
                }
            }
            isPercentage = true;
        }
        if (isPercentage) {
            BigDecimal differenceQty;
            BigDecimal difference = amount.subtract(total);
            if (difference.compareTo(Env.ZERO) != 0) {
                if (indexZeroPercent != -1) {
                    this.distributionLines.get(indexZeroPercent).setAmt(difference);
                } else if (indexBiggest != -1) {
                    this.distributionLines.get(indexBiggest).setAmt(this.distributionLines.get(indexBiggest).getAmt().add(difference));
                } else {
                    this.log.warning("distribute - Remaining Difference=" + difference);
                }
            }
            if ((differenceQty = quantity.subtract(totalQty)).compareTo(Env.ZERO) != 0) {
                if (indexZeroPercent != -1) {
                    this.distributionLines.get(indexZeroPercent).setQty(differenceQty);
                } else if (indexBiggest != -1) {
                    this.distributionLines.get(indexBiggest).setQty(this.distributionLines.get(indexBiggest).getQty().add(differenceQty));
                } else {
                    this.log.warning("distribute - Remaining Qty Difference=" + differenceQty);
                }
            }
        } else {
            this.distributionLines.stream().filter(distributionLine -> distributionLine.isOverwritePostingType() && !distributionLine.getPostingType().equals(this.getPostingType())).forEach(distributionLine -> {
                if (!distributionLine.isInvertAccountSign()) {
                    distributionLine.setAmt(amount);
                    distributionLine.setQty(quantity);
                } else {
                    distributionLine.setAmt(amount.negate());
                    distributionLine.setQty(quantity.negate());
                }
            });
        }
        if (CLogMgt.isLevelFinest()) {
            for (MDistributionLine distributionLine2 : this.distributionLines) {
                if (!distributionLine2.isActive()) continue;
                this.log.fine("distribute = Amt=" + distributionLine2.getAmt() + " - " + distributionLine2.getAccount());
            }
        }
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.isAnyAcct() && this.getAccount_ID() != 0) {
            this.setAccount_ID(0);
        }
        if (this.isAnyActivity() && this.getC_Activity_ID() != 0) {
            this.setC_Activity_ID(0);
        }
        if (this.isAnyBPartner() && this.getC_BPartner_ID() != 0) {
            this.setC_BPartner_ID(0);
        }
        if (this.isAnyCampaign() && this.getC_Campaign_ID() != 0) {
            this.setC_Campaign_ID(0);
        }
        if (this.isAnyLocFrom() && this.getC_LocFrom_ID() != 0) {
            this.setC_LocFrom_ID(0);
        }
        if (this.isAnyLocTo() && this.getC_LocTo_ID() != 0) {
            this.setC_LocTo_ID(0);
        }
        if (this.isAnyOrg() && this.getOrg_ID() != 0) {
            this.setOrg_ID(0);
        }
        if (this.isAnyOrgTrx() && this.getAD_OrgTrx_ID() != 0) {
            this.setAD_OrgTrx_ID(0);
        }
        if (this.isAnyProduct() && this.getM_Product_ID() != 0) {
            this.setM_Product_ID(0);
        }
        if (this.isAnyProject() && this.getC_Project_ID() != 0) {
            this.setC_Project_ID(0);
        }
        if (this.isAnySalesRegion() && this.getC_SalesRegion_ID() != 0) {
            this.setC_SalesRegion_ID(0);
        }
        if (this.isAnyUser1() && this.getUser1_ID() != 0) {
            this.setUser1_ID(0);
        }
        if (this.isAnyUser2() && this.getUser2_ID() != 0) {
            this.setUser2_ID(0);
        }
        if (this.isAnyUser3() && this.getUser3_ID() != 0) {
            this.setUser3_ID(0);
        }
        if (this.isAnyUser4() && this.getUser4_ID() != 0) {
            this.setUser4_ID(0);
        }
        return true;
    }

    public int copyLinesFrom(MDistribution fromDistribution) {
        List<MDistributionLine> fromLines = fromDistribution.getLines(true);
        int count = 0;
        for (MDistributionLine distributionLine : fromLines) {
            MDistributionLine toLine = new MDistributionLine(this.getCtx(), 0, this.get_TrxName());
            PO.copyValues(distributionLine, toLine, this.getAD_Client_ID(), this.getAD_Org_ID());
            toLine.setGL_Distribution_ID(this.getGL_Distribution_ID());
            if (!toLine.save()) continue;
            ++count;
        }
        if (fromLines.size() != count) {
            this.log.log(Level.SEVERE, "Line difference - From=" + fromLines.size() + " <> Saved=" + count);
        }
        return count;
    }

    public boolean isValidFromTo(Timestamp date) {
        Timestamp validFrom = this.getValidFrom();
        Timestamp validTo = this.getValidTo();
        if (validFrom != null && date.before(validFrom)) {
            return false;
        }
        return validTo == null || !date.after(validTo);
    }
}

