/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import org.adempiere.core.domains.models.I_C_DunningLevel;
import org.adempiere.core.domains.models.X_C_DunningRunEntry;
import org.adempiere.exceptions.BPartnerNoAddressException;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MDunningRun;
import org.compiere.model.MDunningRunLine;
import org.compiere.model.MUser;
import org.compiere.model.Query;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MDunningRunEntry
extends X_C_DunningRunEntry {
    private static final long serialVersionUID = -3838792682143065656L;
    private MDunningRun m_parent = null;

    public MDunningRunEntry(Properties ctx, int C_DunningRunEntry_ID, String trxName) {
        super(ctx, C_DunningRunEntry_ID, trxName);
        if (C_DunningRunEntry_ID == 0) {
            this.setAmt(Env.ZERO);
            this.setQty(Env.ZERO);
            this.setProcessed(false);
        }
    }

    public MDunningRunEntry(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MDunningRunEntry(MDunningRun parent) {
        this(parent.getCtx(), 0, parent.get_TrxName());
        this.setClientOrg(parent);
        this.setC_DunningRun_ID(parent.getC_DunningRun_ID());
        this.m_parent = parent;
    }

    /*
     * WARNING - void declaration
     */
    public void setBPartner(MBPartner bp, boolean isSOTrx) {
        this.setC_BPartner_ID(bp.getC_BPartner_ID());
        MBPartnerLocation[] locations = bp.getLocations(false);
        if (locations.length == 1) {
            this.setC_BPartner_Location_ID(locations[0].getC_BPartner_Location_ID());
        } else {
            void var5_6;
            MBPartnerLocation firstActive = null;
            Object var5_5 = null;
            MBPartnerLocation[] mBPartnerLocationArray = locations;
            int n = mBPartnerLocationArray.length;
            for (int i = 0; i < n; ++i) {
                MBPartnerLocation location = mBPartnerLocationArray[i];
                if (!location.isActive()) continue;
                if (firstActive == null) {
                    firstActive = location;
                }
                if (location.isPayFrom() && isSOTrx || location.isRemitTo() && !isSOTrx) {
                    this.setC_BPartner_Location_ID(location.getC_BPartner_Location_ID());
                    break;
                }
                if (var5_6 != null || !location.isBillTo()) continue;
                MBPartnerLocation mBPartnerLocation = location;
            }
            if (this.getC_BPartner_Location_ID() == 0) {
                if (var5_6 != null) {
                    this.setC_BPartner_Location_ID(var5_6.getC_BPartner_Location_ID());
                } else if (firstActive != null) {
                    String msg = "@C_BPartner_ID@ " + bp.getName();
                    msg = isSOTrx ? msg + " @No@ @IsPayFrom@" : msg + " @No@ @IsRemitTo@";
                    msg = msg + " & @IsBillTo@";
                    this.log.info(msg);
                    this.setC_BPartner_Location_ID(firstActive.getC_BPartner_Location_ID());
                }
            }
        }
        if (this.getC_BPartner_Location_ID() == 0) {
            throw new BPartnerNoAddressException(bp);
        }
        MUser[] users = MUser.getOfBPartner(this.getCtx(), bp.getC_BPartner_ID(), this.get_TrxName());
        if (users.length == 1) {
            this.setAD_User_ID(users[0].getAD_User_ID());
        } else {
            for (MUser user : users) {
                if (user.getC_BPartner_Location_ID() != this.getC_BPartner_Location_ID()) continue;
                this.setAD_User_ID(user.getAD_User_ID());
                break;
            }
        }
        int n = bp.getSalesRep_ID();
        if (n != 0) {
            this.setSalesRep_ID(n);
        }
    }

    public List<MDunningRunLine> getLines() {
        return this.getLines(false);
    }

    public List<MDunningRunLine> getLines(boolean onlyInvoices) {
        Object whereClause = "C_DunningRunEntry_ID=?";
        if (onlyInvoices) {
            whereClause = (String)whereClause + " AND C_Invoice_ID IS NOT NULL";
        }
        return new Query(this.getCtx(), "C_DunningRunLine", (String)whereClause, this.get_TrxName()).setOnlyActiveRecords(true).setParameters(this.getC_DunningRunEntry_ID()).list();
    }

    public boolean hasInvoices() {
        String sql = "SELECT COUNT(*) FROM C_DunningRunLine WHERE C_DunningRunEntry_ID=? AND C_Invoice_ID IS NOT NULL";
        return DB.getSQLValue(this.get_TrxName(), sql, this.getC_DunningRunEntry_ID()) > 0;
    }

    public MDunningRun getParent() {
        if (this.m_parent == null) {
            this.m_parent = new MDunningRun(this.getCtx(), this.getC_DunningRun_ID(), this.get_TrxName());
        }
        return this.m_parent;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        I_C_DunningLevel level = this.getC_DunningLevel();
        if (this.isProcessed()) {
            this.getLines().stream().forEach(line -> {
                line.setProcessed(true);
                line.saveEx(this.get_TrxName());
            });
            if (level.isSetCreditStop() || level.isSetPaymentTerm()) {
                MBPartner thisBPartner = MBPartner.get(this.getCtx(), this.getC_BPartner_ID());
                if (level.isSetCreditStop()) {
                    thisBPartner.setSOCreditStatus("S");
                }
                if (level.isSetPaymentTerm()) {
                    thisBPartner.setC_PaymentTerm_ID(level.getC_PaymentTerm_ID());
                }
                thisBPartner.saveEx();
            }
        }
        return true;
    }
}

