/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.adempiere.core.domains.models.X_AD_EntityType;
import org.compiere.model.Query;
import org.compiere.util.CLogger;

public class MEntityType
extends X_AD_EntityType {
    private static final long serialVersionUID = 8906219523978497906L;
    private boolean isDeleteForced = false;
    private static MEntityType[] s_entityTypes = null;
    private static CLogger s_log = CLogger.getCLogger(MEntityType.class);
    private static final int s_maxAD_EntityType_ID = 1000000;

    public static MEntityType[] getEntityTypes(Properties ctx) {
        if (s_entityTypes != null) {
            return s_entityTypes;
        }
        List<MEntityType> list = new Query(ctx, "AD_EntityType", null, null).setOnlyActiveRecords(true).setOrderBy("AD_EntityType_ID").list();
        s_entityTypes = new MEntityType[list.size()];
        list.toArray(s_entityTypes);
        s_log.finer("# " + s_entityTypes.length);
        return s_entityTypes;
    }

    public static MEntityType get(Properties ctx, String entityType) {
        for (MEntityType entity : MEntityType.getEntityTypes(ctx)) {
            if (!entity.getEntityType().equals(entityType)) continue;
            return entity;
        }
        return null;
    }

    public static String[] getEntityTypeStrings(Properties ctx) {
        MEntityType[] entityTypes = MEntityType.getEntityTypes(ctx);
        ArrayList<String> list = new ArrayList<String>();
        String[] retValue = new String[entityTypes.length];
        for (int i = 0; i < entityTypes.length; ++i) {
            String s = entityTypes[i].getEntityType().trim();
            list.add(s);
            retValue[i] = s;
        }
        s_log.finer(list.toString());
        return retValue;
    }

    public static String[] getClasspaths(Properties ctx) {
        MEntityType[] entityTypes = MEntityType.getEntityTypes(ctx);
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < entityTypes.length; ++i) {
            String classpath = entityTypes[i].getClasspath();
            if (classpath == null || classpath.length() == 0) continue;
            StringTokenizer st = new StringTokenizer(classpath, ";, \t\n\r\f");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (token.length() <= 0 || list.contains(token)) continue;
                list.add(token);
            }
        }
        String[] retValue = new String[list.size()];
        list.toArray(retValue);
        s_log.finer(list.toString());
        return retValue;
    }

    public static String[] getModelPackages(Properties ctx) {
        MEntityType[] entityTypes = MEntityType.getEntityTypes(ctx);
        ArrayList<String> list = new ArrayList<String>();
        list.add("adempiere.model");
        for (int i = 0; i < entityTypes.length; ++i) {
            String modelPackage = entityTypes[i].getModelPackage();
            if (modelPackage == null || modelPackage.length() == 0) continue;
            StringTokenizer st = new StringTokenizer(modelPackage, ";, \t\n\r\f");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (token.length() <= 0 || list.contains(token)) continue;
                list.add(token);
            }
        }
        String[] retValue = new String[list.size()];
        list.toArray(retValue);
        s_log.finer(list.toString());
        return retValue;
    }

    public MEntityType(Properties ctx, int AD_EntityType_ID, String trxName) {
        super(ctx, AD_EntityType_ID, trxName);
    }

    public MEntityType(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public void setIsDeleteForced(boolean isDeleteForced) {
        this.isDeleteForced = isDeleteForced;
    }

    public boolean isDeleteForced() {
        return this.isDeleteForced;
    }

    public boolean isSystemMaintained() {
        int id = this.getAD_EntityType_ID();
        return id < 1000000;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (!newRecord) {
            boolean systemMaintained;
            int id = this.getAD_EntityType_ID();
            boolean bl = systemMaintained = id == 10 || id == 20;
            if (systemMaintained) {
                this.log.saveError("Error", "You cannot modify a System maintained entity");
                return false;
            }
            systemMaintained = this.is_ValueChanged("EntityType");
            if (systemMaintained) {
                this.log.saveError("Error", "You cannot modify EntityType");
                return false;
            }
            boolean bl2 = systemMaintained = this.isSystemMaintained() && (this.is_ValueChanged("Name") || this.is_ValueChanged("Description") || this.is_ValueChanged("Help") || this.is_ValueChanged("IsActive"));
            if (systemMaintained) {
                this.log.saveError("Error", "You cannot modify Name,Description,Help");
                return false;
            }
        }
        s_entityTypes = null;
        return true;
    }

    @Override
    protected boolean beforeDelete() {
        if (this.isDeleteForced()) {
            s_entityTypes = null;
            return true;
        }
        if (this.isSystemMaintained()) {
            this.log.saveError("Error", "You cannot delete a System maintained entity");
            return false;
        }
        s_entityTypes = null;
        return true;
    }
}

