/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Properties;
import org.adempiere.core.domains.models.X_C_InvoiceBatchLine;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class MInvoiceBatchLine
extends X_C_InvoiceBatchLine {
    private static final long serialVersionUID = -4022629343631759064L;

    public MInvoiceBatchLine(Properties ctx, int C_InvoiceBatchLine_ID, String trxName) {
        super(ctx, C_InvoiceBatchLine_ID, trxName);
        if (C_InvoiceBatchLine_ID == 0) {
            this.setDateAcct(new Timestamp(System.currentTimeMillis()));
            this.setDateInvoiced(new Timestamp(System.currentTimeMillis()));
            this.setIsTaxIncluded(false);
            this.setLineNetAmt(Env.ZERO);
            this.setLineTotalAmt(Env.ZERO);
            this.setPriceEntered(Env.ZERO);
            this.setQtyEntered(Env.ONE);
            this.setTaxAmt(Env.ZERO);
            this.setProcessed(false);
        }
    }

    public MInvoiceBatchLine(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.getPriceEntered().signum() == 0) {
            this.log.saveError("FillMandatory", Msg.getElement(this.getCtx(), "PriceEntered"));
            return false;
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (success) {
            String sql = "UPDATE C_InvoiceBatch h SET DocumentAmt = NVL((SELECT SUM(LineTotalAmt) FROM C_InvoiceBatchLine l WHERE h.C_InvoiceBatch_ID=l.C_InvoiceBatch_ID AND l.IsActive='Y'),0) WHERE C_InvoiceBatch_ID=" + this.getC_InvoiceBatch_ID();
            DB.executeUpdate(sql, this.get_TrxName());
        }
        return success;
    }
}

