/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.core.domains.models.X_AD_Language;
import org.adempiere.exceptions.DBException;
import org.compiere.Adempiere;
import org.compiere.model.Query;
import org.compiere.model.TranslationTable;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.Msg;

public class MLanguage
extends X_AD_Language {
    private static final long serialVersionUID = 6415602943484245447L;
    private Locale m_locale = null;
    private SimpleDateFormat m_dateFormat = null;

    public static MLanguage get(Properties ctx, Language lang) {
        return MLanguage.get(ctx, lang.getAD_Language());
    }

    public static MLanguage get(Properties ctx, String AD_Language) {
        return (MLanguage)new Query(ctx, "AD_Language", "AD_Language=?", null).setParameters(AD_Language).firstOnly();
    }

    public static MLanguage[] getWithLanguage(Properties ctx, String LanguageISO) {
        List<MLanguage> list = new Query(ctx, "AD_Language", "LanguageISO=?", null).setParameters(LanguageISO).list();
        return list.toArray(new MLanguage[list.size()]);
    }

    public static void maintain(Properties ctx) {
        MLanguage[] languages;
        for (MLanguage language : languages = MLanguage.getMaintainLanguage(ctx)) {
            language.maintain(true);
        }
    }

    public static MLanguage[] getMaintainLanguage(Properties ctx) {
        List<MLanguage> list = new Query(ctx, "AD_Language", "IsSystemLanguage=? AND IsBaseLanguage=?", null).setParameters(true, false).setOnlyActiveRecords(true).list();
        return list.toArray(new MLanguage[list.size()]);
    }

    public MLanguage(Properties ctx, int AD_Language_ID, String trxName) {
        super(ctx, AD_Language_ID, trxName);
    }

    public MLanguage(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    private MLanguage(Properties ctx, String AD_Language, String Name2, String CountryCode, String LanguageISO, String trxName) {
        super(ctx, 0, trxName);
        this.setAD_Language(AD_Language);
        this.setIsBaseLanguage(false);
        this.setIsSystemLanguage(false);
        this.setName(Name2);
        this.setCountryCode(CountryCode);
        this.setLanguageISO(LanguageISO);
    }

    @Override
    public String toString() {
        return "MLanguage[" + this.getAD_Language() + "-" + this.getName() + ",Language=" + this.getLanguageISO() + ",Country=" + this.getCountryCode() + "]";
    }

    public Locale getLocale() {
        if (this.m_locale == null) {
            this.m_locale = new Locale(this.getLanguageISO(), this.getCountryCode());
        }
        return this.m_locale;
    }

    public SimpleDateFormat getDateFormat() {
        if (this.m_dateFormat != null) {
            return this.m_dateFormat;
        }
        if (this.getDatePattern() != null) {
            this.m_dateFormat = (SimpleDateFormat)DateFormat.getDateInstance(3, this.getLocale());
            try {
                this.m_dateFormat.applyPattern(this.getDatePattern());
            }
            catch (Exception e) {
                this.log.severe(this.getDatePattern() + " - " + e);
                this.m_dateFormat = null;
            }
        }
        if (this.m_dateFormat == null) {
            int i;
            Object nFormat;
            this.m_dateFormat = (SimpleDateFormat)DateFormat.getDateInstance(3, this.getLocale());
            String sFormat = this.m_dateFormat.toPattern();
            if (sFormat.indexOf("MM") == -1 && sFormat.indexOf("dd") == -1) {
                nFormat = "";
                for (i = 0; i < sFormat.length(); ++i) {
                    nFormat = sFormat.charAt(i) == 'M' ? (String)nFormat + "MM" : (sFormat.charAt(i) == 'd' ? (String)nFormat + "dd" : (String)nFormat + sFormat.charAt(i));
                }
                this.m_dateFormat.applyPattern((String)nFormat);
            }
            if (this.m_dateFormat.toPattern().length() != 8) {
                this.m_dateFormat.applyPattern("yyyy-MM-dd");
            }
            if (this.m_dateFormat.toPattern().indexOf("yyyy") == -1) {
                sFormat = this.m_dateFormat.toPattern();
                nFormat = "";
                for (i = 0; i < sFormat.length(); ++i) {
                    nFormat = sFormat.charAt(i) == 'y' ? (String)nFormat + "yy" : (String)nFormat + sFormat.charAt(i);
                }
                this.m_dateFormat.applyPattern((String)nFormat);
            }
        }
        this.m_dateFormat.setLenient(true);
        return this.m_dateFormat;
    }

    private void setAD_Language_ID() {
        int AD_Language_ID = this.getAD_Language_ID();
        if (AD_Language_ID == 0) {
            String sql = "SELECT NVL(MAX(AD_Language_ID), 999999) FROM AD_Language WHERE AD_Language_ID > 1000";
            AD_Language_ID = DB.getSQLValue(this.get_TrxName(), sql);
            this.setAD_Language_ID(AD_Language_ID + 1);
        }
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        String dp = this.getDatePattern();
        if (this.is_ValueChanged("DatePattern") && dp != null && dp.length() > 0) {
            if (dp.indexOf("MM") == -1) {
                this.log.saveError("Error", Msg.parseTranslation(this.getCtx(), "@Error@ @DatePattern@ - No Month (MM)"));
                return false;
            }
            if (dp.indexOf("dd") == -1) {
                this.log.saveError("Error", Msg.parseTranslation(this.getCtx(), "@Error@ @DatePattern@ - No Day (dd)"));
                return false;
            }
            if (dp.indexOf("yy") == -1) {
                this.log.saveError("Error", Msg.parseTranslation(this.getCtx(), "@Error@ @DatePattern@ - No Year (yy)"));
                return false;
            }
            this.m_dateFormat = (SimpleDateFormat)DateFormat.getDateInstance(3, this.getLocale());
            try {
                this.m_dateFormat.applyPattern(dp);
            }
            catch (Exception e) {
                this.log.saveError("Error", Msg.parseTranslation(this.getCtx(), "@Error@ @DatePattern@ - " + e.getMessage()));
                this.m_dateFormat = null;
                return false;
            }
        }
        if (newRecord) {
            this.setAD_Language_ID();
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        int no = TranslationTable.getActiveLanguages(true);
        this.log.fine("Active Languages=" + no);
        return true;
    }

    public int maintain(boolean add) {
        String sql = "SELECT TableName FROM AD_Table WHERE TableName LIKE '%_Trl' ORDER BY TableName";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        int retNo = 0;
        try {
            pstmt = DB.prepareStatement(sql, null);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                if (add) {
                    retNo += this.addTable(rs.getString(1));
                    continue;
                }
                retNo += this.deleteTable(rs.getString(1));
            }
        }
        catch (SQLException e) {
            try {
                throw new DBException(e, sql);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return retNo;
    }

    private int deleteTable(String tableName) {
        String sql = "DELETE  FROM  " + tableName + " WHERE AD_Language=?";
        int no = DB.executeUpdateEx(sql, new Object[]{this.getAD_Language()}, this.get_TrxName());
        this.log.fine(tableName + " #" + no);
        return no;
    }

    private int addTable(String tableName) {
        String baseTable = tableName.substring(0, tableName.length() - 4);
        String sql = "SELECT c.ColumnName FROM AD_Column c INNER JOIN AD_Table t ON (c.AD_Table_ID=t.AD_Table_ID) WHERE t.TableName=?  AND c.IsTranslated='Y' AND c.IsActive='Y' ORDER BY c.ColumnName";
        ArrayList<String> columns = new ArrayList<String>(5);
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setString(1, baseTable);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                columns.add(rs.getString(1));
            }
        }
        catch (SQLException e) {
            try {
                throw new DBException(e, sql);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        if (columns.size() == 0) {
            this.log.log(Level.SEVERE, "No Columns found for " + baseTable);
            return 0;
        }
        StringBuffer cols = new StringBuffer();
        for (int i = 0; i < columns.size(); ++i) {
            cols.append(",").append((String)columns.get(i));
        }
        int AD_User_ID = Env.getAD_User_ID(this.getCtx());
        String keyColumn = baseTable + "_ID";
        String insert = "INSERT INTO " + tableName + "(AD_Language,IsTranslated, AD_Client_ID,AD_Org_ID, Created,Updated, Createdby,UpdatedBy, " + keyColumn + cols + ") SELECT '" + this.getAD_Language() + "','N', AD_Client_ID,AD_Org_ID, SYSDATE, SYSDATE ," + AD_User_ID + "," + AD_User_ID + ", " + keyColumn + cols + " FROM " + baseTable + " WHERE " + keyColumn + " NOT IN (SELECT " + keyColumn + " FROM " + tableName + " WHERE AD_Language='" + this.getAD_Language() + "')";
        int no = DB.executeUpdateEx(insert, null, this.get_TrxName());
        this.log.fine(tableName + " #" + no);
        return no;
    }

    public static void main(String[] args) {
        System.out.println("Language");
        Adempiere.startup(true);
        System.out.println(MLanguage.get(Env.getCtx(), "de_DE"));
        System.out.println(MLanguage.get(Env.getCtx(), "en_US"));
    }
}

