/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.core.domains.models.X_C_OrderLine;
import org.adempiere.core.domains.models.X_C_Tax;
import org.adempiere.engine.IDocumentLine;
import org.adempiere.exceptions.ProductNotOnPriceListException;
import org.compiere.model.MAttributeSet;
import org.compiere.model.MCharge;
import org.compiere.model.MCurrency;
import org.compiere.model.MDocType;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MLocator;
import org.compiere.model.MOrder;
import org.compiere.model.MPriceList;
import org.compiere.model.MProduct;
import org.compiere.model.MProductPricing;
import org.compiere.model.MRequisitionLine;
import org.compiere.model.MResourceAssignment;
import org.compiere.model.MStorage;
import org.compiere.model.MTax;
import org.compiere.model.MTaxCategory;
import org.compiere.model.MUOM;
import org.compiere.model.MWarehouse;
import org.compiere.model.Tax;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class MOrderLine
extends X_C_OrderLine
implements IDocumentLine {
    private static final long serialVersionUID = 7305265800857547603L;
    private static CLogger s_log = CLogger.getCLogger(MOrderLine.class);
    private int m_M_PriceList_ID = 0;
    private boolean m_IsSOTrx = true;
    private MProductPricing m_productPrice = null;
    private MTax m_tax = null;
    private Integer m_precision = null;
    private MProduct m_product = null;
    private MCharge m_charge = null;
    private MOrder m_parent = null;

    public static BigDecimal getNotReserved(Properties ctx, int M_Warehouse_ID, int M_Product_ID, int M_AttributeSetInstance_ID, int excludeC_OrderLine_ID) {
        BigDecimal retValue = Env.ZERO;
        Object sql = "SELECT SUM(QtyOrdered-QtyDelivered-QtyReserved) FROM C_OrderLine ol INNER JOIN C_Order o ON (ol.C_Order_ID=o.C_Order_ID) WHERE ol.M_Warehouse_ID=? AND M_Product_ID=? AND o.IsSOTrx='Y' AND o.DocStatus='DR' AND QtyOrdered-QtyDelivered-QtyReserved<>0 AND ol.C_OrderLine_ID<>?";
        if (M_AttributeSetInstance_ID != 0) {
            sql = (String)sql + " AND M_AttributeSetInstance_ID=?";
        }
        CPreparedStatement pstmt = null;
        try {
            ResultSet rs;
            pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, M_Warehouse_ID);
            pstmt.setInt(2, M_Product_ID);
            pstmt.setInt(3, excludeC_OrderLine_ID);
            if (M_AttributeSetInstance_ID != 0) {
                pstmt.setInt(4, M_AttributeSetInstance_ID);
            }
            if ((rs = pstmt.executeQuery()).next()) {
                retValue = rs.getBigDecimal(1);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, (String)sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        if (retValue == null) {
            s_log.fine("-");
        } else {
            s_log.fine(retValue.toString());
        }
        return retValue;
    }

    public MOrderLine(Properties ctx, int C_OrderLine_ID, String trxName) {
        super(ctx, C_OrderLine_ID, trxName);
        if (C_OrderLine_ID == 0) {
            this.setFreightAmt(Env.ZERO);
            this.setLineNetAmt(Env.ZERO);
            this.setPriceEntered(Env.ZERO);
            this.setPriceActual(Env.ZERO);
            this.setPriceLimit(Env.ZERO);
            this.setPriceList(Env.ZERO);
            this.setM_AttributeSetInstance_ID(0);
            this.setQtyEntered(Env.ZERO);
            this.setQtyOrdered(Env.ZERO);
            this.setQtyDelivered(Env.ZERO);
            this.setQtyInvoiced(Env.ZERO);
            this.setQtyReserved(Env.ZERO);
            this.setIsDescription(false);
            this.setProcessed(false);
            this.setLine(0);
        }
    }

    public MOrderLine(MOrder order) {
        this(order.getCtx(), 0, order.get_TrxName());
        if (order.get_ID() == 0) {
            throw new IllegalArgumentException("Header not saved");
        }
        this.setC_Order_ID(order.getC_Order_ID());
        this.setOrder(order);
    }

    public MOrderLine(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public void setOrder(MOrder order) {
        this.setClientOrg(order);
        this.setC_BPartner_ID(order.getC_BPartner_ID());
        this.setC_BPartner_Location_ID(order.getC_BPartner_Location_ID());
        this.setM_Warehouse_ID(order.getM_Warehouse_ID());
        this.setDateOrdered(order.getDateOrdered());
        this.setDatePromised(order.getDatePromised());
        this.setC_Currency_ID(order.getC_Currency_ID());
        this.setHeaderInfo(order);
    }

    public void setHeaderInfo(MOrder order) {
        this.m_parent = order;
        this.m_precision = order.getPrecision();
        this.m_M_PriceList_ID = order.getM_PriceList_ID();
        this.m_IsSOTrx = order.isSOTrx();
    }

    public MOrder getParent() {
        if (this.m_parent == null) {
            this.m_parent = new MOrder(this.getCtx(), this.getC_Order_ID(), this.get_TrxName());
        }
        return this.m_parent;
    }

    public void setPrice(BigDecimal PriceActual) {
        this.setPriceEntered(PriceActual);
        this.setPriceActual(PriceActual);
    }

    @Override
    public void setPriceActual(BigDecimal PriceActual) {
        if (PriceActual == null) {
            throw new IllegalArgumentException("PriceActual is mandatory");
        }
        this.set_ValueNoCheck("PriceActual", PriceActual);
    }

    public void setPrice() {
        if (this.getM_Product_ID() == 0) {
            return;
        }
        if (this.m_M_PriceList_ID == 0) {
            throw new IllegalStateException("PriceList unknown!");
        }
        this.setPrice(this.m_M_PriceList_ID);
    }

    public void setPrice(int M_PriceList_ID) {
        if (this.getM_Product_ID() == 0) {
            return;
        }
        this.log.fine(this.toString() + " - M_PriceList_ID=" + M_PriceList_ID);
        this.getProductPricing(M_PriceList_ID);
        this.setPriceActual(this.m_productPrice.getPriceStd());
        this.setPriceList(this.m_productPrice.getPriceList());
        this.setPriceLimit(this.m_productPrice.getPriceLimit());
        if (this.getQtyEntered().compareTo(this.getQtyOrdered()) == 0) {
            this.setPriceEntered(this.getPriceActual());
        } else {
            this.setPriceEntered(this.getPriceActual().multiply(this.getQtyOrdered().divide(this.getQtyEntered(), 12, RoundingMode.HALF_UP)));
        }
        this.setDiscount(this.m_productPrice.getDiscount());
        if (this.getC_UOM_ID() == 0) {
            this.setC_UOM_ID(this.m_productPrice.getC_UOM_ID());
        }
    }

    private MProductPricing getProductPricing(int M_PriceList_ID) {
        this.m_productPrice = new MProductPricing(this.getM_Product_ID(), this.getC_BPartner_ID(), this.getQtyOrdered(), this.m_IsSOTrx, this.get_TrxName());
        this.m_productPrice.setM_PriceList_ID(M_PriceList_ID);
        this.m_productPrice.setPriceDate(this.getDateOrdered());
        this.m_productPrice.calculatePrice();
        return this.m_productPrice;
    }

    public boolean setTax() {
        int ii = Tax.get(this.getCtx(), this.getM_Product_ID(), this.getC_Charge_ID(), this.getDateOrdered(), this.getDateOrdered(), this.getAD_Org_ID(), this.getM_Warehouse_ID(), this.getC_BPartner_Location_ID(), this.getC_BPartner_Location_ID(), this.m_IsSOTrx, this.get_TrxName());
        if (ii == 0) {
            this.log.log(Level.SEVERE, "No Tax found");
            return false;
        }
        this.setC_Tax_ID(ii);
        return true;
    }

    public void setLineNetAmt() {
        MProduct product;
        BigDecimal lineNetAmount = null;
        if (this.getM_Product_ID() != 0 && (product = MProduct.get(this.getCtx(), this.getM_Product_ID(), this.get_TrxName())).getC_UOM_ID() != this.getC_UOM_ID() && this.getPriceEntered() != null && !this.getPriceEntered().equals(Env.ZERO) && this.getQtyEntered() != null && !this.getQtyEntered().equals(Env.ZERO)) {
            lineNetAmount = this.getQtyEntered().multiply(this.getPriceEntered());
        }
        if (lineNetAmount == null) {
            lineNetAmount = this.getPriceActual().multiply(this.getQtyOrdered());
        }
        boolean documentLevel = this.getTax().isDocumentLevel();
        if (this.isTaxIncluded() && !documentLevel) {
            BigDecimal taxStdAmt = Env.ZERO;
            BigDecimal taxThisAmt = Env.ZERO;
            MTax orderTax = this.getTax();
            X_C_Tax stdTax = null;
            if (this.getProduct() == null) {
                if (this.getCharge() != null) {
                    stdTax = new MTax(this.getCtx(), ((MTaxCategory)this.getCharge().getC_TaxCategory()).getDefaultTax().getC_Tax_ID(), this.get_TrxName());
                }
            } else {
                stdTax = new MTax(this.getCtx(), ((MTaxCategory)this.getProduct().getC_TaxCategory()).getDefaultTax().getC_Tax_ID(), this.get_TrxName());
            }
            if (stdTax != null) {
                this.log.fine("stdTax rate is " + stdTax.getRate());
                this.log.fine("orderTax rate is " + orderTax.getRate());
                taxThisAmt = taxThisAmt.add(orderTax.calculateTax(lineNetAmount, this.isTaxIncluded(), this.getPrecision()));
                taxStdAmt = taxStdAmt.add(((MTax)stdTax).calculateTax(lineNetAmount, this.isTaxIncluded(), this.getPrecision()));
                lineNetAmount = lineNetAmount.subtract(taxStdAmt).add(taxThisAmt);
                this.log.fine("Price List includes Tax and Tax Changed on Order Line: New Tax Amt: " + taxThisAmt + " Standard Tax Amt: " + taxStdAmt + " Line Net Amt: " + lineNetAmount);
            }
        }
        if (lineNetAmount.scale() > this.getPrecision()) {
            lineNetAmount = lineNetAmount.setScale(this.getPrecision(), RoundingMode.HALF_UP);
        }
        super.setLineNetAmt(lineNetAmount);
    }

    public MCharge getCharge() {
        if (this.m_charge == null && this.getC_Charge_ID() != 0) {
            this.m_charge = MCharge.get(this.getCtx(), this.getC_Charge_ID());
        }
        return this.m_charge;
    }

    protected MTax getTax() {
        if (this.m_tax == null) {
            this.m_tax = MTax.get(this.getCtx(), this.getC_Tax_ID());
        }
        return this.m_tax;
    }

    public int getPrecision() {
        MCurrency cur;
        if (this.m_precision != null) {
            return this.m_precision;
        }
        if (this.getC_Currency_ID() == 0) {
            this.setOrder(this.getParent());
            if (this.m_precision != null) {
                return this.m_precision;
            }
        }
        if (this.getC_Currency_ID() != 0 && (cur = MCurrency.get(this.getCtx(), this.getC_Currency_ID())).get_ID() != 0) {
            this.m_precision = cur.getStdPrecision();
            return this.m_precision;
        }
        String sql = "SELECT c.StdPrecision FROM C_Currency c INNER JOIN C_Order x ON (x.C_Currency_ID=c.C_Currency_ID) WHERE x.C_Order_ID=?";
        int i2 = DB.getSQLValue(this.get_TrxName(), sql, this.getC_Order_ID());
        this.m_precision = i2;
        return this.m_precision;
    }

    public void setProduct(MProduct product) {
        this.m_product = product;
        if (this.m_product != null) {
            this.setM_Product_ID(this.m_product.getM_Product_ID());
            this.setC_UOM_ID(this.m_product.getC_UOM_ID());
        } else {
            this.setM_Product_ID(0);
            this.set_ValueNoCheck("C_UOM_ID", null);
        }
        this.setM_AttributeSetInstance_ID(0);
    }

    public void setM_Product_ID(int M_Product_ID, boolean setUOM) {
        if (setUOM) {
            this.setProduct(MProduct.get(this.getCtx(), M_Product_ID));
        } else {
            super.setM_Product_ID(M_Product_ID);
        }
        this.setM_AttributeSetInstance_ID(0);
    }

    public void setM_Product_ID(int M_Product_ID, int C_UOM_ID) {
        super.setM_Product_ID(M_Product_ID);
        if (C_UOM_ID != 0) {
            super.setC_UOM_ID(C_UOM_ID);
        }
        this.setM_AttributeSetInstance_ID(0);
    }

    public MProduct getProduct() {
        if (this.m_product == null && this.getM_Product_ID() != 0) {
            this.m_product = MProduct.get(this.getCtx(), this.getM_Product_ID(), this.get_TrxName());
        }
        return this.m_product;
    }

    @Override
    public void setM_AttributeSetInstance_ID(int M_AttributeSetInstance_ID) {
        if (M_AttributeSetInstance_ID == 0) {
            this.set_Value("M_AttributeSetInstance_ID", (Object)0);
        } else {
            super.setM_AttributeSetInstance_ID(M_AttributeSetInstance_ID);
        }
    }

    @Override
    public void setM_Warehouse_ID(int M_Warehouse_ID) {
        if (this.getM_Warehouse_ID() > 0 && this.getM_Warehouse_ID() != M_Warehouse_ID && !this.canChangeWarehouse()) {
            this.log.severe("Ignored - Already Delivered/Invoiced/Reserved");
        } else {
            super.setM_Warehouse_ID(M_Warehouse_ID);
        }
    }

    public boolean canChangeWarehouse() {
        if (this.getQtyDelivered().signum() != 0) {
            this.log.saveError("Error", Msg.translate(this.getCtx(), "QtyDelivered") + "=" + this.getQtyDelivered());
            return false;
        }
        if (this.getQtyReserved().signum() != 0) {
            this.log.saveError("Error", Msg.translate(this.getCtx(), "QtyReserved") + "=" + this.getQtyReserved());
            return false;
        }
        return true;
    }

    @Override
    public int getAD_OrgTrx_ID() {
        int ii = super.getAD_OrgTrx_ID();
        if (ii == 0) {
            ii = this.getParent().getAD_OrgTrx_ID();
        }
        return ii;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MOrderLine[").append(this.get_ID()).append(", Line=").append(this.getLine()).append(", Ordered=").append(this.getQtyOrdered()).append(", Delivered=").append(this.getQtyDelivered()).append(", Invoiced=").append(this.getQtyInvoiced()).append(", Reserved=").append(this.getQtyReserved()).append(", LineNet=").append(this.getLineNetAmt()).append("]");
        return sb.toString();
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            this.setDescription(desc + " | " + description);
        }
    }

    public String getDescriptionText() {
        return super.getDescription();
    }

    public String getName() {
        this.getProduct();
        if (this.m_product != null) {
            return this.m_product.getName();
        }
        if (this.getC_Charge_ID() != 0) {
            MCharge charge = MCharge.get(this.getCtx(), this.getC_Charge_ID());
            return charge.getName();
        }
        return "";
    }

    @Override
    public void setC_Charge_ID(int C_Charge_ID) {
        super.setC_Charge_ID(C_Charge_ID);
        if (C_Charge_ID > 0) {
            this.set_ValueNoCheck("C_UOM_ID", null);
        }
    }

    public void setDiscount() {
        BigDecimal list = this.getPriceList();
        if (Env.ZERO.compareTo(list) == 0) {
            return;
        }
        BigDecimal discount = list.subtract(this.getPriceActual()).multiply(new BigDecimal(100)).divide(list, this.getPrecision(), RoundingMode.HALF_UP);
        this.setDiscount(discount);
    }

    public boolean isTaxIncluded() {
        if (this.m_M_PriceList_ID == 0) {
            this.m_M_PriceList_ID = DB.getSQLValue(this.get_TrxName(), "SELECT M_PriceList_ID FROM C_Order WHERE C_Order_ID=?", this.getC_Order_ID());
        }
        MPriceList pl = MPriceList.get(this.getCtx(), this.m_M_PriceList_ID, this.get_TrxName());
        return pl.isTaxIncluded();
    }

    public void setQty(BigDecimal Qty) {
        super.setQtyEntered(Qty);
        super.setQtyOrdered(this.getQtyEntered());
    }

    @Override
    public void setQtyEntered(BigDecimal QtyEntered) {
        if (QtyEntered != null && this.getC_UOM_ID() != 0) {
            int precision = MUOM.getPrecision(this.getCtx(), this.getC_UOM_ID());
            QtyEntered = QtyEntered.setScale(precision, RoundingMode.HALF_UP);
        }
        super.setQtyEntered(QtyEntered);
    }

    @Override
    public void setQtyOrdered(BigDecimal QtyOrdered) {
        MProduct product = this.getProduct();
        if (QtyOrdered != null && product != null) {
            int precision = product.getUOMPrecision();
            QtyOrdered = QtyOrdered.setScale(precision, RoundingMode.HALF_UP);
        }
        super.setQtyOrdered(QtyOrdered);
    }

    public void setRef_InOutLine(MInOutLine inOutLineReference) {
        int invoiceLineReferenceId;
        this.setRef_InOutLine_ID(inOutLineReference.getM_InOutLine_ID());
        if (inOutLineReference.getC_Charge_ID() != 0) {
            this.setC_Charge_ID(inOutLineReference.getC_Charge_ID());
        }
        if (inOutLineReference.getM_Product_ID() != 0) {
            this.setM_Product_ID(inOutLineReference.getM_Product_ID());
            if (inOutLineReference.getM_AttributeSetInstance_ID() > 0) {
                this.setM_AttributeSetInstance_ID(inOutLineReference.getM_AttributeSetInstance_ID());
            }
        }
        if (inOutLineReference.getC_UOM_ID() != 0) {
            this.setC_UOM_ID(inOutLineReference.getC_UOM_ID());
        }
        if (inOutLineReference.getAD_OrgTrx_ID() != 0) {
            this.setAD_OrgTrx_ID(inOutLineReference.getAD_OrgTrx_ID());
        }
        if (inOutLineReference.getC_Project_ID() != 0) {
            this.setC_Project_ID(inOutLineReference.getC_Project_ID());
        }
        if (inOutLineReference.getC_Campaign_ID() != 0) {
            this.setC_Campaign_ID(inOutLineReference.getC_Campaign_ID());
        }
        if (inOutLineReference.getC_Activity_ID() != 0) {
            this.setC_Activity_ID(inOutLineReference.getC_Activity_ID());
        }
        if (inOutLineReference.getUser1_ID() != 0) {
            this.setUser1_ID(inOutLineReference.getUser1_ID());
        }
        if (inOutLineReference.getUser2_ID() != 0) {
            this.setUser2_ID(inOutLineReference.getUser2_ID());
        }
        if (inOutLineReference.getUser3_ID() != 0) {
            this.setUser3_ID(inOutLineReference.getUser3_ID());
        }
        if (inOutLineReference.getUser4_ID() != 0) {
            this.setUser4_ID(inOutLineReference.getUser4_ID());
        }
        if ((invoiceLineReferenceId = inOutLineReference.getInvoiceLineId()) != 0) {
            MInvoiceLine invoiceLine = new MInvoiceLine(this.getCtx(), invoiceLineReferenceId, this.get_TrxName());
            this.setPriceList(invoiceLine.getPriceList());
            this.setPriceEntered(invoiceLine.getPriceEntered());
            this.setPriceActual(invoiceLine.getPriceActual());
            this.setC_Tax_ID(invoiceLine.getC_Tax_ID());
        } else if (inOutLineReference.getC_OrderLine_ID() != 0) {
            MOrderLine orderLine = new MOrderLine(this.getCtx(), inOutLineReference.getC_OrderLine_ID(), this.get_TrxName());
            this.setPriceList(orderLine.getPriceList());
            this.setPriceEntered(orderLine.getPriceEntered());
            this.setPriceActual(orderLine.getPriceActual());
            this.setC_Tax_ID(orderLine.getC_Tax_ID());
        }
    }

    public void setRef_InvoiceLine(MInvoiceLine invoiceLineReference) {
        if (invoiceLineReference.getC_Charge_ID() != 0) {
            this.setC_Charge_ID(invoiceLineReference.getC_Charge_ID());
        }
        if (invoiceLineReference.getM_Product_ID() != 0) {
            this.setM_Product_ID(invoiceLineReference.getM_Product_ID());
            if (invoiceLineReference.getM_AttributeSetInstance_ID() > 0) {
                this.setM_AttributeSetInstance_ID(invoiceLineReference.getM_AttributeSetInstance_ID());
            }
        }
        if (invoiceLineReference.getC_UOM_ID() != 0) {
            this.setC_UOM_ID(invoiceLineReference.getC_UOM_ID());
        }
        if (invoiceLineReference.getAD_OrgTrx_ID() != 0) {
            this.setAD_OrgTrx_ID(invoiceLineReference.getAD_OrgTrx_ID());
        }
        if (invoiceLineReference.getC_Project_ID() != 0) {
            this.setC_Project_ID(invoiceLineReference.getC_Project_ID());
        }
        if (invoiceLineReference.getC_Campaign_ID() != 0) {
            this.setC_Campaign_ID(invoiceLineReference.getC_Campaign_ID());
        }
        if (invoiceLineReference.getC_Activity_ID() != 0) {
            this.setC_Activity_ID(invoiceLineReference.getC_Activity_ID());
        }
        if (invoiceLineReference.getUser1_ID() != 0) {
            this.setUser1_ID(invoiceLineReference.getUser1_ID());
        }
        if (invoiceLineReference.getUser2_ID() != 0) {
            this.setUser2_ID(invoiceLineReference.getUser2_ID());
        }
        if (invoiceLineReference.getUser3_ID() != 0) {
            this.setUser3_ID(invoiceLineReference.getUser3_ID());
        }
        if (invoiceLineReference.getUser4_ID() != 0) {
            this.setUser4_ID(invoiceLineReference.getUser4_ID());
        }
        this.setRef_InvoiceLine_ID(invoiceLineReference.getC_InvoiceLine_ID());
        this.setPriceList(invoiceLineReference.getPriceList());
        this.setPriceEntered(invoiceLineReference.getPriceEntered());
        this.setPriceActual(invoiceLineReference.getPriceActual());
        this.setC_Tax_ID(invoiceLineReference.getC_Tax_ID());
        int inOutLineReferenceId = invoiceLineReference.getM_InOutLine_ID();
        if (inOutLineReferenceId == 0) {
            inOutLineReferenceId = invoiceLineReference.getInOutLineId();
        }
        if (inOutLineReferenceId != 0) {
            this.setRef_InOutLine_ID(inOutLineReferenceId);
        }
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        MProduct product;
        int C_UOM_ID;
        if (newRecord && this.getParent().isComplete()) {
            this.log.saveError("ParentComplete", Msg.translate(this.getCtx(), "C_OrderLine"));
            return false;
        }
        if (this.getC_BPartner_ID() == 0 || this.getC_BPartner_Location_ID() == 0 || this.getM_Warehouse_ID() == 0 || this.getC_Currency_ID() == 0) {
            this.setOrder(this.getParent());
        }
        if (this.m_M_PriceList_ID == 0) {
            this.setHeaderInfo(this.getParent());
        }
        if (!newRecord && (this.is_ValueChanged("M_Product_ID") || this.is_ValueChanged("M_Warehouse_ID")) && !this.canChangeWarehouse()) {
            return false;
        }
        if (this.getC_Charge_ID() != 0 && this.getM_Product_ID() != 0) {
            this.setM_Product_ID(0);
        }
        if (this.getM_Product_ID() == 0) {
            this.setM_AttributeSetInstance_ID(0);
        } else {
            MDocType documentType;
            if (this.m_productPrice == null && Env.ZERO.compareTo(this.getPriceActual()) == 0 && Env.ZERO.compareTo(this.getPriceList()) == 0) {
                this.setPrice();
            }
            if (this.m_productPrice == null) {
                this.getProductPricing(this.m_M_PriceList_ID);
            }
            if (!this.m_productPrice.isCalculated() && !this.isProcessed() && (newRecord || this.is_ValueChanged("M_Product_ID") || this.is_ValueChanged("C_UOM_ID") || this.is_ValueChanged("QtyEntered") || this.is_ValueChanged("PriceEntered") || this.is_ValueChanged("Discount") || this.is_ValueChanged("PriceEntered")) && (Util.isEmpty((documentType = MDocType.get(this.getCtx(), this.getParent().getC_DocTypeTarget_ID())).getDocSubTypeSO()) || !documentType.getDocSubTypeSO().equals("RM"))) {
                throw new ProductNotOnPriceListException(this.m_productPrice, this.getLine());
            }
        }
        if (this.getC_UOM_ID() == 0 && (this.getM_Product_ID() != 0 || this.getPriceEntered().compareTo(Env.ZERO) != 0 || this.getC_Charge_ID() != 0) && (C_UOM_ID = MUOM.getDefault_UOM_ID(this.getCtx())) > 0) {
            this.setC_UOM_ID(C_UOM_ID);
        }
        if (newRecord || this.is_ValueChanged("QtyEntered")) {
            this.setQtyEntered(this.getQtyEntered());
        }
        if (newRecord || this.is_ValueChanged("QtyOrdered")) {
            this.setQtyOrdered(this.getQtyOrdered());
        }
        if (this.getParent().isSOTrx() && this.getM_AttributeSetInstance_ID() != 0 && (newRecord || this.is_ValueChanged("M_Product_ID") || this.is_ValueChanged("M_AttributeSetInstance_ID") || this.is_ValueChanged("M_Warehouse_ID")) && (product = this.getProduct()).isStocked()) {
            boolean isInstance;
            int M_AttributeSet_ID = product.getM_AttributeSet_ID();
            boolean bl = isInstance = M_AttributeSet_ID != 0;
            if (isInstance) {
                MAttributeSet mas = MAttributeSet.get(this.getCtx(), M_AttributeSet_ID);
                isInstance = mas.isInstanceAttribute();
            }
            if (isInstance) {
                MStorage[] storages = MStorage.getWarehouse(this.getCtx(), this.getM_Warehouse_ID(), this.getM_Product_ID(), this.getM_AttributeSetInstance_ID(), M_AttributeSet_ID, false, null, true, this.get_TrxName());
                BigDecimal qty = Env.ZERO;
                for (int i2 = 0; i2 < storages.length; ++i2) {
                    if (storages[i2].getM_AttributeSetInstance_ID() != this.getM_AttributeSetInstance_ID()) continue;
                    qty = qty.add(storages[i2].getQtyOnHand());
                }
                if (this.getQtyOrdered().compareTo(qty) > 0) {
                    this.log.warning("Qty - Stock=" + qty + ", Ordered=" + this.getQtyOrdered());
                    this.log.saveError("QtyInsufficient", "=" + qty);
                    return false;
                }
            }
        }
        if (Env.ZERO.compareTo(this.getFreightAmt()) != 0) {
            this.setFreightAmt(Env.ZERO);
        }
        if (this.getC_Tax_ID() == 0) {
            this.setTax();
        }
        if (this.getLine() == 0) {
            String sql = "SELECT COALESCE(MAX(Line),0)+10 FROM C_OrderLine WHERE C_Order_ID=?";
            int ii = DB.getSQLValue(this.get_TrxName(), sql, this.getC_Order_ID());
            this.setLine(ii);
        }
        this.setLineNetAmt();
        this.setDiscount();
        return true;
    }

    @Override
    protected boolean beforeDelete() {
        if (Env.ZERO.compareTo(this.getQtyDelivered()) != 0) {
            this.log.saveError("DeleteError", Msg.translate(this.getCtx(), "QtyDelivered") + "=" + this.getQtyDelivered());
            return false;
        }
        if (Env.ZERO.compareTo(this.getQtyInvoiced()) != 0) {
            this.log.saveError("DeleteError", Msg.translate(this.getCtx(), "QtyInvoiced") + "=" + this.getQtyInvoiced());
            return false;
        }
        if (Env.ZERO.compareTo(this.getQtyReserved()) != 0) {
            this.log.saveError("DeleteError", Msg.translate(this.getCtx(), "QtyReserved") + "=" + this.getQtyReserved());
            return false;
        }
        MRequisitionLine.unlinkC_OrderLine_ID(this.getCtx(), this.get_ID(), this.get_TrxName());
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success) {
            return success;
        }
        if (newRecord || !newRecord && this.is_ValueChanged("C_Tax_ID") && !this.getParent().isProcessed() || !newRecord && this.is_ValueChanged("QtyEntered") && !this.getParent().isProcessed() || !newRecord && this.is_ValueChanged("PriceActual") && !this.getParent().isProcessed()) {
            return this.updateHeaderTax();
        }
        return true;
    }

    @Override
    protected boolean afterDelete(boolean success) {
        if (!success) {
            return success;
        }
        if (this.getS_ResourceAssignment_ID() != 0) {
            MResourceAssignment ra = new MResourceAssignment(this.getCtx(), this.getS_ResourceAssignment_ID(), this.get_TrxName());
            ra.delete(true);
        }
        return this.updateHeaderTax();
    }

    private boolean updateHeaderTax() {
        String sql;
        int no;
        if (!this.getParent().isProcessed()) {
            this.getParent().calculateTaxTotal();
        }
        if ((no = DB.executeUpdate(sql = "UPDATE C_Order i SET TotalLines=(SELECT COALESCE(SUM(LineNetAmt),0) FROM C_OrderLine il WHERE i.C_Order_ID=il.C_Order_ID) WHERE C_Order_ID=" + this.getC_Order_ID(), this.get_TrxName())) != 1) {
            this.log.warning("(1) #" + no);
        }
        if ((no = DB.executeUpdate(sql = this.isTaxIncluded() ? "UPDATE C_Order i  SET GrandTotal=TotalLines WHERE C_Order_ID=" + this.getC_Order_ID() : "UPDATE C_Order i  SET GrandTotal=TotalLines+(SELECT COALESCE(SUM(TaxAmt),0) FROM C_OrderTax it WHERE i.C_Order_ID=it.C_Order_ID) WHERE C_Order_ID=" + this.getC_Order_ID(), this.get_TrxName())) != 1) {
            this.log.warning("(2) #" + no);
        }
        this.m_parent = null;
        return no == 1;
    }

    public void reserveStock() {
        BigDecimal target = this.getParent().isBinding() ? this.getQtyOrdered() : Env.ZERO;
        BigDecimal difference = target.subtract(this.getQtyReserved()).subtract(this.getQtyDelivered());
        if (difference.signum() == 0) {
            return;
        }
        this.log.fine("Line=" + this.getLine() + " - Target=" + target + ",Difference=" + difference + " - Ordered=" + this.getQtyOrdered() + ",Reserved=" + this.getQtyReserved() + ",Delivered=" + this.getQtyDelivered());
        MProduct product = this.getProduct();
        if (product != null && product.isStocked()) {
            MAttributeSet.validateAttributeSetInstanceMandatory(product, Table_ID, this.isSOTrx(), this.getM_AttributeSetInstance_ID());
            BigDecimal ordered = this.isSOTrx() ? Env.ZERO : difference;
            BigDecimal reserved = this.isSOTrx() ? difference : Env.ZERO;
            this.setQtyReserved(this.getQtyReserved().add(difference));
            int locatorId = 0;
            if (this.getM_AttributeSetInstance_ID() != 0) {
                locatorId = MStorage.getM_Locator_ID(this.getM_Warehouse_ID(), this.getM_Product_ID(), this.getM_AttributeSetInstance_ID(), ordered, this.get_TrxName());
            }
            if (locatorId == 0) {
                MWarehouse warehouse = MWarehouse.get(this.getCtx(), this.getM_Warehouse_ID());
                locatorId = product.getM_Locator_ID();
                if (locatorId != 0) {
                    MLocator locator = new MLocator(this.getCtx(), product.getM_Locator_ID(), this.get_TrxName());
                    if (locator.getM_Warehouse_ID() != warehouse.get_ID()) {
                        locatorId = warehouse.getDefaultLocator().getM_Locator_ID();
                    }
                } else {
                    locatorId = warehouse.getDefaultLocator().getM_Locator_ID();
                }
            }
            MStorage.add(this.getCtx(), this.getM_Warehouse_ID(), locatorId, this.getM_Product_ID(), this.getM_AttributeSetInstance_ID(), this.getM_AttributeSetInstance_ID(), Env.ZERO, reserved, ordered, this.get_TrxName());
        }
    }

    @Override
    public int getM_Locator_ID() {
        return 0;
    }

    @Override
    public BigDecimal getMovementQty() {
        return this.getQtyEntered();
    }

    public BigDecimal getQtyToDelivery() {
        return this.getQtyOrdered().subtract(this.getQtyDelivered());
    }

    @Override
    public int getReversalLine_ID() {
        return 0;
    }

    @Override
    public boolean isSOTrx() {
        return this.getParent().isSOTrx();
    }

    @Override
    public void setM_Locator_ID(int M_Locator_ID) {
    }

    @Override
    public Timestamp getDateAcct() {
        return this.getParent().getDateAcct();
    }

    @Override
    public IDocumentLine getReversalDocumentLine() {
        return null;
    }

    @Override
    public int getM_AttributeSetInstanceTo_ID() {
        return -1;
    }

    @Override
    public int getM_LocatorTo_ID() {
        return -1;
    }

    @Override
    public int getC_DocType_ID() {
        return this.getParent().getC_DocType_ID();
    }

    @Override
    public BigDecimal getPriceActualCurrency() {
        return this.getPriceActual();
    }

    @Override
    public int getC_Currency_ID() {
        return this.getParent().getC_Currency_ID();
    }

    @Override
    public int getC_ConversionType_ID() {
        return this.getParent().getC_ConversionType_ID();
    }

    @Override
    public boolean isReversalParent() {
        return this.getC_OrderLine_ID() < this.getReversalLine_ID();
    }
}

