/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.core.domains.models.X_C_OrderTax;
import org.compiere.model.MOrderLine;
import org.compiere.model.MTax;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MOrderTax
extends X_C_OrderTax {
    private static final long serialVersionUID = -6776007249310373908L;
    private static CLogger s_log = CLogger.getCLogger(MOrderTax.class);
    private MTax m_tax = null;
    private Integer m_precision = null;

    public static MOrderTax get(MOrderLine line, int precision, boolean oldTax, String trxName) {
        boolean isOldTax;
        MOrderTax retValue = null;
        if (line == null || line.getC_Order_ID() == 0) {
            s_log.fine("No Order");
            return null;
        }
        int C_Tax_ID = line.getC_Tax_ID();
        boolean bl = isOldTax = oldTax && line.is_ValueChanged("C_Tax_ID");
        if (isOldTax) {
            Object old = line.get_ValueOld("C_Tax_ID");
            if (old == null) {
                s_log.fine("No Old Tax");
                return null;
            }
            C_Tax_ID = (Integer)old;
        }
        if (C_Tax_ID == 0) {
            s_log.fine("No Tax");
            return null;
        }
        String sql = "SELECT * FROM C_OrderTax WHERE C_Order_ID=? AND C_Tax_ID=?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, trxName);
            pstmt.setInt(1, line.getC_Order_ID());
            pstmt.setInt(2, C_Tax_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue = new MOrderTax(line.getCtx(), rs, trxName);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        if (retValue != null) {
            retValue.setPrecision(precision);
            retValue.set_TrxName(trxName);
            s_log.fine("(old=" + oldTax + ") " + retValue);
            return retValue;
        }
        if (isOldTax) {
            return null;
        }
        retValue = new MOrderTax(line.getCtx(), 0, trxName);
        retValue.set_TrxName(trxName);
        retValue.setClientOrg(line);
        retValue.setC_Order_ID(line.getC_Order_ID());
        retValue.setC_Tax_ID(line.getC_Tax_ID());
        retValue.setPrecision(precision);
        retValue.setIsTaxIncluded(line.isTaxIncluded());
        s_log.fine("(new) " + retValue);
        return retValue;
    }

    public MOrderTax(Properties ctx, int ignored, String trxName) {
        super(ctx, 0, trxName);
        if (ignored != 0) {
            throw new IllegalArgumentException("Multi-Key");
        }
        this.setTaxAmt(Env.ZERO);
        this.setTaxBaseAmt(Env.ZERO);
        this.setIsTaxIncluded(false);
    }

    public MOrderTax(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    private int getPrecision() {
        if (this.m_precision == null) {
            return 2;
        }
        return this.m_precision;
    }

    protected void setPrecision(int precision) {
        this.m_precision = precision;
    }

    protected MTax getTax() {
        if (this.m_tax == null) {
            this.m_tax = MTax.get(this.getCtx(), this.getC_Tax_ID());
        }
        return this.m_tax;
    }

    public boolean calculateTaxFromLines() {
        BigDecimal taxBaseAmt = Env.ZERO;
        BigDecimal taxAmt = Env.ZERO;
        boolean documentLevel = this.getTax().isDocumentLevel();
        MTax tax = this.getTax();
        String sql = "SELECT LineNetAmt FROM C_OrderLine WHERE C_Order_ID=? AND C_Tax_ID=?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, this.getC_Order_ID());
            pstmt.setInt(2, this.getC_Tax_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                BigDecimal baseAmt = rs.getBigDecimal(1);
                taxBaseAmt = taxBaseAmt.add(baseAmt);
                if (documentLevel) continue;
                taxAmt = taxAmt.add(tax.calculateTax(baseAmt, this.isTaxIncluded(), this.getPrecision()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, this.get_TrxName(), e);
            taxBaseAmt = null;
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        if (taxBaseAmt == null) {
            return false;
        }
        if (documentLevel) {
            taxAmt = tax.calculateTax(taxBaseAmt, this.isTaxIncluded(), this.getPrecision());
        }
        this.setTaxAmt(taxAmt);
        if (this.isTaxIncluded()) {
            this.setTaxBaseAmt(taxBaseAmt.subtract(taxAmt));
        } else {
            this.setTaxBaseAmt(taxBaseAmt);
        }
        this.log.fine(this.toString());
        return true;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MOrderTax[").append("C_Order_ID=").append(this.getC_Order_ID()).append(", C_Tax_ID=").append(this.getC_Tax_ID()).append(", Base=").append(this.getTaxBaseAmt()).append(", Tax=").append(this.getTaxAmt()).append("]");
        return sb.toString();
    }
}

