/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import org.adempiere.core.domains.models.X_C_PaymentAllocate;
import org.compiere.model.MInvoice;
import org.compiere.model.MPayment;
import org.compiere.model.MTable;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class MPaymentAllocate
extends X_C_PaymentAllocate {
    private static final long serialVersionUID = 2894385378672375131L;
    private MInvoice m_invoice = null;

    public static MPaymentAllocate[] get(MPayment parent) {
        String whereClause = "C_Payment_ID=?";
        Query query = MTable.get(parent.getCtx(), Table_ID).createQuery("C_Payment_ID=?", parent.get_TrxName());
        query.setParameters(parent.getC_Payment_ID()).setOnlyActiveRecords(true);
        List<MPaymentAllocate> list = query.list();
        return list.toArray(new MPaymentAllocate[list.size()]);
    }

    public MPaymentAllocate(Properties ctx, int C_PaymentAllocate_ID, String trxName) {
        super(ctx, C_PaymentAllocate_ID, trxName);
        if (C_PaymentAllocate_ID == 0) {
            this.setAmount(Env.ZERO);
            this.setDiscountAmt(Env.ZERO);
            this.setOverUnderAmt(Env.ZERO);
            this.setWriteOffAmt(Env.ZERO);
            this.setInvoiceAmt(Env.ZERO);
        }
    }

    public MPaymentAllocate(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    @Override
    public void setC_Invoice_ID(int C_Invoice_ID) {
        super.setC_Invoice_ID(C_Invoice_ID);
        this.m_invoice = null;
    }

    public MInvoice getInvoice() {
        if (this.m_invoice == null && this.getC_Invoice_ID() != 0) {
            this.m_invoice = new MInvoice(this.getCtx(), this.getC_Invoice_ID(), this.get_TrxName());
        }
        return this.m_invoice;
    }

    public int getC_BPartner_ID() {
        if (this.m_invoice == null) {
            this.getInvoice();
        }
        if (this.m_invoice == null) {
            return 0;
        }
        return this.m_invoice.getC_BPartner_ID();
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        BigDecimal check;
        MPayment payment = new MPayment(this.getCtx(), this.getC_Payment_ID(), this.get_TrxName());
        if ((newRecord || this.is_ValueChanged("C_Invoice_ID")) && (payment.getC_Charge_ID() != 0 || payment.getC_Invoice_ID() != 0 || payment.getC_Order_ID() != 0)) {
            this.log.saveError("PaymentIsAllocated", "");
            return false;
        }
        if (this.getC_Invoice_ID() != 0 && (check = this.getAmount().add(this.getDiscountAmt()).add(this.getWriteOffAmt()).add(this.getOverUnderAmt())).compareTo(this.getInvoiceAmt()) != 0) {
            this.log.saveError("Error", Msg.parseTranslation(this.getCtx(), "@InvoiceAmt@(" + this.getInvoiceAmt() + ") <> @Totals@(" + check + ")"));
            return false;
        }
        if (newRecord || this.is_ValueChanged("C_Invoice_ID")) {
            this.getInvoice();
            if (this.m_invoice != null) {
                this.setAD_Org_ID(this.m_invoice.getAD_Org_ID());
            }
        }
        return true;
    }
}

