/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.core.domains.models.X_AD_Process;
import org.adempiere.util.ProcessUtil;
import org.compiere.model.MClient;
import org.compiere.model.MMenu;
import org.compiere.model.MPInstance;
import org.compiere.model.MProcessAccess;
import org.compiere.model.MProcessPara;
import org.compiere.model.MRole;
import org.compiere.model.MWindow;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfo;
import org.compiere.util.CCache;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Trx;
import org.compiere.wf.MWFNode;

public class MProcess
extends X_AD_Process {
    private static final long serialVersionUID = 6665942554198058466L;
    private static CCache<Integer, MProcess> s_cache = new CCache("AD_Process", 20);
    private static CCache<String, List<MProcessPara>> cacheASPParameters = new CCache("AD_Process_Para", 20);
    private List<MProcessPara> parameters = null;

    public static MProcess getUsingJavaClass(Class<?> processClass) {
        String className = processClass.getCanonicalName();
        if (className == null) {
            return null;
        }
        return (MProcess)new Query(Env.getCtx(), "AD_Process", "Classname=?", null).setParameters(className).first();
    }

    public static MProcess get(Properties ctx, int AD_Process_ID) {
        Integer key = AD_Process_ID;
        MProcess retValue = s_cache.get(key);
        if (retValue != null) {
            return retValue;
        }
        retValue = new MProcess(ctx, AD_Process_ID, null);
        if (retValue.get_ID() != 0) {
            s_cache.put(key, retValue);
        }
        return retValue;
    }

    public static MProcess getFromInstance(Properties ctx, int processInstanceId) {
        return (MProcess)new Query(Env.getCtx(), "AD_Process", "EXISTS(SELECT 1 FROM AD_PInstance pi WHERE pi.AD_Process_ID = AD_Process.AD_Process_ID AND pi.AD_PInstance_ID = ?)", null).setParameters(processInstanceId).first();
    }

    public static MProcess getFromMenu(Properties ctx, int AD_Menu_ID) {
        String whereClause = "EXISTS (SELECT 1 FROM AD_Menu m WHERE m.AD_Process_ID=AD_Process.AD_Process_ID AND m.AD_Menu_ID=?)";
        MProcess p = (MProcess)new Query(ctx, "AD_Process", "EXISTS (SELECT 1 FROM AD_Menu m WHERE m.AD_Process_ID=AD_Process.AD_Process_ID AND m.AD_Menu_ID=?)", null).setParameters(AD_Menu_ID).firstOnly();
        if (p != null) {
            s_cache.put(p.get_ID(), p);
        }
        return p;
    }

    public MProcess(Properties ctx, int AD_Process_ID, String trxName) {
        super(ctx, AD_Process_ID, trxName);
        if (AD_Process_ID == 0) {
            this.setIsReport(false);
            this.setIsServerProcess(false);
            this.setAccessLevel("7");
            this.setEntityType("U");
            this.setIsBetaFunctionality(false);
        }
    }

    public MProcess(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public List<MProcessPara> getParametersAsList() {
        if (this.parameters != null) {
            return this.parameters;
        }
        this.parameters = this.getParametersAsList(null);
        return this.parameters;
    }

    public MProcessPara[] getParameters() {
        List<MProcessPara> parametersList = this.getParametersAsList();
        MProcessPara[] retValue = new MProcessPara[parametersList.size()];
        parametersList.toArray(retValue);
        return retValue;
    }

    public List<MProcessPara> getASPParameters() {
        MClient client = MClient.get(Env.getCtx());
        String key = this.getAD_Process_ID() + "|" + client.getAD_Client_ID() + "|" + Env.getAD_Language(this.getCtx());
        List<MProcessPara> retValue = cacheASPParameters.get(key);
        if (retValue != null) {
            return retValue;
        }
        String aSPFilter = null;
        if (client.isUseASP()) {
            aSPFilter = "(\tEXISTS(SELECT 1 FROM ASP_Process p \t\t\t\t\tINNER JOIN ASP_Process_Para pp ON(pp.ASP_Process_ID = p.ASP_Process_ID) \t\t\t\t\tINNER JOIN ASP_Level l ON(l.ASP_Level_ID = p.ASP_Level_ID) \t\t\t\t\tINNER JOIN ASP_ClientLevel cl ON(cl.ASP_Level_ID = l.ASP_Level_ID) \t\t\t\tWHERE pp.AD_Process_Para_ID = AD_Process_Para.AD_Process_Para_ID \t\t\t\tAND cl.AD_Client_ID = " + client.getAD_Client_ID() + "\t\t\t\tAND pp.IsActive = 'Y' \t\t\t\tAND p.IsActive = 'Y' \t\t\t\tAND l.IsActive = 'Y' \t\t\t\tAND cl.IsActive = 'Y' \t\t\t\tAND pp.ASP_Status = 'S') OR \tEXISTS(SELECT 1 FROM ASP_ClientException ce \t\t\t\tWHERE ce.AD_Process_Para_ID = AD_Process_Para.AD_Process_Para_ID \t\t\t\tAND ce.AD_Client_ID = " + client.getAD_Client_ID() + "\t\t\t\tAND ce.IsActive = 'Y' \t\t\t\tAND ce.AD_Process_Para_ID IS NOT NULL \t\t\t\tAND ce.AD_Tab_ID IS NULL \t\t\t\tAND ce.AD_Field_ID IS NULL \t\t\t\tAND ce.ASP_Status = 'S')AND EXISTS(SELECT 1 FROM ASP_ClientException ce \t\t\t\tWHERE ce.AD_Process_Para_ID = AD_Process_Para.AD_Process_Para_ID \t\t\t\tAND ce.AD_Client_ID = " + client.getAD_Client_ID() + "\t\t\t\tAND ce.IsActive = 'Y' \t\t\t\tAND ce.AD_Process_Para_ID IS NOT NULL \t\t\t\tAND ce.AD_Tab_ID IS NULL \t\t\t\tAND ce.AD_Field_ID IS NULL \t\t\t\tAND ce.ASP_Status = 'H') OR EXISTS(SELECT 1 FROM ASP_Level l \t\t\t\t\tINNER JOIN ASP_ClientLevel cl ON(cl.ASP_Level_ID = l.ASP_Level_ID) \t\t\t\tWHERE cl.AD_Client_ID = " + client.getAD_Client_ID() + "\t\t\t\tAND l.IsActive = 'Y' \t\t\t\tAND cl.IsActive = 'Y' \t\t\t\tAND l.Type = 'C') ) ";
        }
        if ((retValue = this.getParametersAsList(aSPFilter)) != null && retValue.size() > 0) {
            cacheASPParameters.put(key, retValue);
        }
        return retValue;
    }

    public List<MProcessPara> getParametersAsList(String optionalWhereClause) {
        StringBuffer whereClause = new StringBuffer("AD_Process_ID=?");
        if (optionalWhereClause != null && optionalWhereClause.trim().length() > 0) {
            whereClause.append(" AND ").append(optionalWhereClause);
        }
        List<MProcessPara> list = new Query(this.getCtx(), "AD_Process_Para", whereClause.toString(), this.get_TrxName()).setParameters(this.get_ID()).setOnlyActiveRecords(true).setOrderBy("SeqNo").list();
        return list;
    }

    public MProcessPara[] getParameters(String optionalWhereClause) {
        List<MProcessPara> parametersList = this.getParametersAsList(optionalWhereClause);
        MProcessPara[] retValue = new MProcessPara[parametersList.size()];
        parametersList.toArray(retValue);
        return retValue;
    }

    public MProcessPara getParameter(String name) {
        this.getParameters();
        for (MProcessPara parameter : this.parameters) {
            if (!parameter.getColumnName().equals(name)) continue;
            return parameter;
        }
        return null;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MProcess[").append(this.get_ID()).append("-").append(this.getName()).append("]");
        return sb.toString();
    }

    public MPInstance processIt(int Record_ID, Trx trx) {
        return this.processIt(Record_ID, trx, true);
    }

    public MPInstance processIt(int Record_ID, Trx trx, boolean managedTrx) {
        MPInstance pInstance = new MPInstance(this, Record_ID);
        pInstance.setIsProcessing(true);
        pInstance.saveEx();
        boolean ok = true;
        ProcessInfo processInfo = new ProcessInfo("", this.getAD_Process_ID());
        processInfo.setAD_PInstance_ID(pInstance.getAD_PInstance_ID());
        processInfo.setRecord_ID(Record_ID);
        ok = this.processIt(processInfo, trx, managedTrx);
        pInstance.setResult(ok ? 1 : 0);
        pInstance.setErrorMsg(processInfo.getSummary());
        pInstance.setIsProcessing(false);
        pInstance.saveEx();
        pInstance.log();
        return pInstance;
    }

    public boolean processIt(ProcessInfo pi, Trx trx) {
        return this.processIt(pi, trx, true);
    }

    public boolean processIt(ProcessInfo pi, Trx trx, boolean managedTrx) {
        if (pi.getAD_PInstance_ID() == 0) {
            MPInstance pInstance = new MPInstance(this, pi.getRecord_ID());
            pInstance.setIsProcessing(true);
            pInstance.saveEx();
        }
        boolean ok = false;
        String Classname = this.getClassname();
        if (Classname != null && Classname.length() > 0 && Classname.toLowerCase().startsWith("@script:")) {
            pi.setClassName(Classname);
            ProcessUtil.startScriptProcess(Env.getCtx(), pi, trx);
        } else if (Classname != null && Classname.length() > 0 && !Classname.toLowerCase().startsWith("@script:")) {
            pi.setClassName(Classname);
            ok = this.startClass(pi, trx, managedTrx);
        } else {
            String ProcedureName = this.getProcedureName();
            if (ProcedureName != null && ProcedureName.length() > 0) {
                ok = this.startProcess(ProcedureName, pi, trx, managedTrx);
            } else if (this.isReport()) {
                ok = true;
            } else {
                String msg = "No Classname or ProcedureName for " + this.getName();
                pi.setSummary(msg, ok);
                this.log.warning(msg);
            }
        }
        return ok;
    }

    public boolean isJavaProcess() {
        String Classname = this.getClassname();
        return Classname != null && Classname.length() > 0;
    }

    public boolean isJasper() {
        return this.getJasperReport() != null && this.getJasperReport().trim().length() > 0;
    }

    private boolean startProcess(String ProcedureName, ProcessInfo processInfo, Trx trx, boolean managedTrx) {
        int AD_PInstance_ID = processInfo.getAD_PInstance_ID();
        this.log.info(ProcedureName + "(" + AD_PInstance_ID + ")");
        return ProcessUtil.startDatabaseProcedure(processInfo, ProcedureName, trx, managedTrx);
    }

    private boolean startClass(ProcessInfo pi, Trx trx, boolean managedTrx) {
        this.log.info(pi.getClassName());
        return ProcessUtil.startJavaProcess(this.getCtx(), pi, trx, managedTrx);
    }

    public boolean isWorkflow() {
        return this.getAD_Workflow_ID() > 0;
    }

    public void addStatistics(int seconds) {
        this.setStatistic_Count(this.getStatistic_Count() + 1);
        this.setStatistic_Seconds(this.getStatistic_Seconds() + seconds);
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        block6: {
            block5: {
                if (!newRecord) break block5;
                MRole[] roles = MRole.getOf(this.getCtx(), "IsManual='N'");
                for (int i = 0; i < roles.length; ++i) {
                    MProcessAccess pa = new MProcessAccess(this, roles[i].getAD_Role_ID());
                    pa.saveEx();
                }
                break block6;
            }
            if (!this.is_ValueChanged("IsActive") && !this.is_ValueChanged("Name") && !this.is_ValueChanged("Description") && !this.is_ValueChanged("Help")) break block6;
            MMenu[] menues = MMenu.get(this.getCtx(), "AD_Process_ID=" + this.getAD_Process_ID(), this.get_TrxName());
            for (int i = 0; i < menues.length; ++i) {
                menues[i].setIsActive(this.isActive());
                menues[i].setName(this.getName());
                menues[i].setDescription(this.getDescription());
                menues[i].saveEx();
            }
            MWFNode[] nodes = MWindow.getWFNodes(this.getCtx(), "AD_Process_ID=" + this.getAD_Process_ID(), this.get_TrxName());
            for (int i = 0; i < nodes.length; ++i) {
                boolean changed = false;
                if (nodes[i].isActive() != this.isActive()) {
                    nodes[i].setIsActive(this.isActive());
                    changed = true;
                }
                if (nodes[i].isCentrallyMaintained()) {
                    nodes[i].setName(this.getName());
                    nodes[i].setDescription(this.getDescription());
                    nodes[i].setHelp(this.getHelp());
                    changed = true;
                }
                if (!changed) continue;
                nodes[i].saveEx();
            }
        }
        return success;
    }

    public static int getProcess_ID(String value, String trxName) {
        int retValue = DB.getSQLValueEx(trxName, "SELECT AD_Process_ID FROM AD_Process WHERE Value=?", value);
        return retValue;
    }

    public void copyFrom(MProcess source) {
        this.log.log(Level.FINE, "Copying from:" + source + ", to: " + this);
        this.setAccessLevel(source.getAccessLevel());
        this.setAD_Form_ID(source.getAD_Form_ID());
        this.setAD_PrintFormat_ID(source.getAD_PrintFormat_ID());
        this.setAD_ReportView_ID(source.getAD_ReportView_ID());
        this.setAD_Workflow_ID(source.getAD_Workflow_ID());
        this.setClassname(source.getClassname());
        this.setDescription(source.getDescription());
        this.setHelp(source.getHelp());
        this.setIsBetaFunctionality(source.isBetaFunctionality());
        this.setIsDirectPrint(source.isDirectPrint());
        this.setIsReport(source.isReport());
        this.setIsServerProcess(source.isServerProcess());
        this.setJasperReport(source.getJasperReport());
        this.setProcedureName(source.getProcedureName());
        this.setShowHelp(source.getShowHelp());
        this.saveEx();
        List<MProcessPara> parameters = source.getParametersAsList();
        for (MProcessPara sourcePara : parameters) {
            MProcessPara targetPara = new MProcessPara(this);
            targetPara.copyFrom(sourcePara);
        }
    }

    public boolean processItWithoutTrxClose(ProcessInfo pi, Trx trx) {
        return this.processIt(pi, trx, false);
    }

    public int getEstimatedSeconds() {
        if (this.getStatistic_Count() == 0) {
            return 0;
        }
        return this.getStatistic_Seconds() / this.getStatistic_Count();
    }

    public MProcess getDuplicated() {
        try {
            return (MProcess)super.clone();
        }
        catch (CloneNotSupportedException e) {
            this.log.warning("Error " + e.getLocalizedMessage());
            return null;
        }
    }
}

