/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.model.MDiscountSchema;
import org.compiere.model.MPriceList;
import org.compiere.model.MProduct;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Trace;

public class MProductPricing {
    private int productId;
    private int partnerId;
    private BigDecimal quantity = Env.ONE;
    private boolean isSOTrx = true;
    private int priceListId = 0;
    private int priceListVersionId = 0;
    private Timestamp priceDate;
    private int precision = -1;
    private boolean calculated = false;
    private boolean vendorBreak = false;
    private boolean useVendorBreak;
    private Boolean found = null;
    private BigDecimal priceList = Env.ZERO;
    private BigDecimal priceStd = Env.ZERO;
    private BigDecimal priceLimit = Env.ZERO;
    private int currencyId = 0;
    private boolean isEnforcePriceLimit = false;
    private int uomId = 0;
    private int productCategoryId;
    private boolean discountSchema = false;
    private boolean isTaxIncluded = false;
    private String trxName = null;
    protected CLogger log = CLogger.getCLogger(this.getClass());

    @Deprecated
    public MProductPricing(int productId, int partnerId, BigDecimal quantity, boolean isSOTrx) {
        this(productId, partnerId, quantity, isSOTrx, null);
    }

    public MProductPricing(int productId, int partnerId, BigDecimal quantity, boolean isSOTrx, String trxName) {
        this.productId = productId;
        this.partnerId = partnerId;
        this.trxName = trxName;
        if (quantity != null && Env.ZERO.compareTo(quantity) != 0) {
            this.quantity = quantity;
        }
        this.isSOTrx = isSOTrx;
        int thereAreVendorBreakRecords = DB.getSQLValue(trxName, "SELECT count(M_Product_ID) FROM M_ProductPriceVendorBreak WHERE M_Product_ID=? AND (BreakValue > 0 OR C_BPartner_ID=?)", this.productId, this.partnerId);
        this.useVendorBreak = thereAreVendorBreakRecords > 0;
    }

    public boolean calculatePrice() {
        if (this.productId == 0 || this.found != null && !this.found.booleanValue()) {
            return false;
        }
        if (this.useVendorBreak) {
            if (!this.calculated) {
                this.calculated = this.calculatePriceBasedOnPriceListVersionAndProductBreak();
                if (this.calculated) {
                    this.vendorBreak = true;
                }
            }
            if (!this.calculated) {
                this.calculated = this.calculatePriceBasedOnPriceListAndProductBreak();
                if (this.calculated) {
                    this.vendorBreak = true;
                }
            }
            if (!this.calculated) {
                this.calculated = this.calculatePriceBasedOnBasedPriceListAndProductBreak();
                if (this.calculated) {
                    this.vendorBreak = true;
                }
            }
        }
        if (!this.calculated) {
            this.calculated = this.calculatePriceBasedOnPriceListVersion();
        }
        if (!this.calculated) {
            this.calculated = this.calculatePriceBasedOnPriceList();
        }
        if (!this.calculated) {
            this.calculated = this.calculatePriceBasedOnBasePriceList();
        }
        if (!this.calculated) {
            this.setBaseInfo();
        }
        if (this.calculated && !this.vendorBreak) {
            this.calculateDiscount();
        }
        this.setPrecision();
        this.found = this.calculated;
        return this.calculated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean calculatePriceBasedOnPriceListVersion() {
        if (this.productId == 0 || this.priceListVersionId == 0) {
            return false;
        }
        String sql = "SELECT bomPriceStd(p.M_Product_ID,pv.M_PriceList_Version_ID) AS PriceStd, bomPriceList(p.M_Product_ID,pv.M_PriceList_Version_ID) AS PriceList, bomPriceLimit(p.M_Product_ID,pv.M_PriceList_Version_ID) AS PriceLimit, p.C_UOM_ID,pv.ValidFrom,pl.C_Currency_ID,p.M_Product_Category_ID, pl.EnforcePriceLimit, pl.IsTaxIncluded FROM M_Product p INNER JOIN M_ProductPrice pp ON (p.M_Product_ID=pp.M_Product_ID) INNER JOIN  M_PriceList_Version pv ON (pp.M_PriceList_Version_ID=pv.M_PriceList_Version_ID) INNER JOIN M_Pricelist pl ON (pv.M_PriceList_ID=pl.M_PriceList_ID) WHERE pv.IsActive='Y' AND pp.IsActive='Y' AND p.M_Product_ID=? AND pv.M_PriceList_Version_ID=?";
        this.calculated = false;
        CPreparedStatement statement = null;
        ResultSet rs = null;
        try {
            statement = DB.prepareStatement(sql, this.trxName);
            statement.setInt(1, this.productId);
            statement.setInt(2, this.priceListVersionId);
            rs = statement.executeQuery();
            if (rs.next()) {
                this.priceStd = rs.getBigDecimal(1);
                if (rs.wasNull()) {
                    this.priceStd = Env.ZERO;
                }
                this.priceList = rs.getBigDecimal(2);
                if (rs.wasNull()) {
                    this.priceList = Env.ZERO;
                }
                this.priceLimit = rs.getBigDecimal(3);
                if (rs.wasNull()) {
                    this.priceLimit = Env.ZERO;
                }
                this.uomId = rs.getInt(4);
                this.currencyId = rs.getInt(6);
                this.productCategoryId = rs.getInt(7);
                this.isEnforcePriceLimit = "Y".equals(rs.getString(8));
                this.isTaxIncluded = "Y".equals(rs.getString(9));
                this.log.fine("M_PriceList_Version_ID=" + this.priceListVersionId + " - " + this.priceStd);
                this.calculated = true;
            }
            DB.close(rs, statement);
            rs = null;
            statement = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
            this.calculated = false;
        }
        finally {
            DB.close(rs, statement);
            rs = null;
            statement = null;
        }
        return this.calculated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean calculatePriceBasedOnPriceList() {
        if (this.productId == 0) {
            return false;
        }
        if (this.priceListId == 0) {
            this.log.log(Level.SEVERE, "No PriceList");
            Trace.printStack();
            return false;
        }
        String sql = "SELECT bomPriceStd(p.M_Product_ID,pv.M_PriceList_Version_ID) AS PriceStd, bomPriceList(p.M_Product_ID,pv.M_PriceList_Version_ID) AS PriceList, bomPriceLimit(p.M_Product_ID,pv.M_PriceList_Version_ID) AS PriceLimit, p.C_UOM_ID,pv.ValidFrom,pl.C_Currency_ID,p.M_Product_Category_ID,pl.EnforcePriceLimit FROM M_Product p INNER JOIN M_ProductPrice pp ON (p.M_Product_ID=pp.M_Product_ID) INNER JOIN  M_PriceList_Version pv ON (pp.M_PriceList_Version_ID=pv.M_PriceList_Version_ID) INNER JOIN M_Pricelist pl ON (pv.M_PriceList_ID=pl.M_PriceList_ID) WHERE pv.IsActive='Y' AND pp.IsActive='Y' AND p.M_Product_ID=? AND pv.M_PriceList_ID=? ORDER BY pv.ValidFrom DESC";
        this.calculated = false;
        if (this.priceDate == null) {
            this.priceDate = new Timestamp(System.currentTimeMillis());
        }
        CPreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = DB.prepareStatement(sql, this.trxName);
            statement.setInt(1, this.productId);
            statement.setInt(2, this.priceListId);
            resultSet = statement.executeQuery();
            while (!this.calculated && resultSet.next()) {
                Timestamp priceListDate = resultSet.getTimestamp(5);
                if (priceListDate != null && this.priceDate.before(priceListDate)) continue;
                this.priceStd = resultSet.getBigDecimal(1);
                if (resultSet.wasNull()) {
                    this.priceStd = Env.ZERO;
                }
                this.priceList = resultSet.getBigDecimal(2);
                if (resultSet.wasNull()) {
                    this.priceList = Env.ZERO;
                }
                this.priceLimit = resultSet.getBigDecimal(3);
                if (resultSet.wasNull()) {
                    this.priceLimit = Env.ZERO;
                }
                this.uomId = resultSet.getInt(4);
                this.currencyId = resultSet.getInt(6);
                this.productCategoryId = resultSet.getInt(7);
                this.isEnforcePriceLimit = "Y".equals(resultSet.getString(8));
                this.log.fine("M_PriceList_ID=" + this.priceListId + "(" + priceListDate + ") - " + this.priceStd);
                this.calculated = true;
                break;
            }
            DB.close(resultSet, statement);
            resultSet = null;
            statement = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
            this.calculated = false;
        }
        finally {
            DB.close(resultSet, statement);
            resultSet = null;
            statement = null;
        }
        if (!this.calculated) {
            this.log.finer("Not found (PL)");
        }
        return this.calculated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean calculatePriceBasedOnBasePriceList() {
        if (this.productId == 0 || this.priceListId == 0) {
            return false;
        }
        String sql = "SELECT bomPriceStd(p.M_Product_ID,pv.M_PriceList_Version_ID) AS PriceStd, bomPriceList(p.M_Product_ID,pv.M_PriceList_Version_ID) AS PriceList, bomPriceLimit(p.M_Product_ID,pv.M_PriceList_Version_ID) AS PriceLimit, p.C_UOM_ID,pv.ValidFrom,pl.C_Currency_ID,p.M_Product_Category_ID, pl.EnforcePriceLimit, pl.IsTaxIncluded FROM M_Product p INNER JOIN M_ProductPrice pp ON (p.M_Product_ID=pp.M_Product_ID) INNER JOIN M_PriceList_Version pv ON (pp.M_PriceList_Version_ID=pv.M_PriceList_Version_ID) INNER JOIN M_PriceList pl ON (pv.M_PriceList_ID=pl.M_PriceList_ID)WHERE pv.IsActive='Y' AND pp.IsActive='Y' AND p.M_Product_ID=? AND EXISTS (SELECT 1 FROM M_PriceList_Version plv WHERE plv.IsActive='Y'  AND plv.M_PriceList_ID=? AND pp.M_PriceList_Version_ID=plv.M_PriceList_Version_Base_ID) ORDER BY pv.ValidFrom DESC";
        this.calculated = false;
        if (this.priceDate == null) {
            this.priceDate = new Timestamp(System.currentTimeMillis());
        }
        CPreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = DB.prepareStatement(sql, this.trxName);
            statement.setInt(1, this.productId);
            statement.setInt(2, this.priceListId);
            resultSet = statement.executeQuery();
            while (!this.calculated && resultSet.next()) {
                Timestamp plDate = resultSet.getTimestamp(5);
                if (plDate != null && this.priceDate.before(plDate)) continue;
                this.priceStd = resultSet.getBigDecimal(1);
                if (resultSet.wasNull()) {
                    this.priceStd = Env.ZERO;
                }
                this.priceList = resultSet.getBigDecimal(2);
                if (resultSet.wasNull()) {
                    this.priceList = Env.ZERO;
                }
                this.priceLimit = resultSet.getBigDecimal(3);
                if (resultSet.wasNull()) {
                    this.priceLimit = Env.ZERO;
                }
                this.uomId = resultSet.getInt(4);
                this.currencyId = resultSet.getInt(6);
                this.productCategoryId = resultSet.getInt(7);
                this.isEnforcePriceLimit = "Y".equals(resultSet.getString(8));
                this.isTaxIncluded = "Y".equals(resultSet.getString(9));
                this.log.fine("M_PriceList_ID=" + this.priceListId + "(" + plDate + ") - " + this.priceStd);
                this.calculated = true;
                break;
            }
            DB.close(resultSet, statement);
            resultSet = null;
            statement = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
            this.calculated = false;
        }
        finally {
            DB.close(resultSet, statement);
            resultSet = null;
            statement = null;
        }
        if (!this.calculated) {
            this.log.finer("Not found (BPL)");
        }
        return this.calculated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean calculatePriceBasedOnPriceListVersionAndProductBreak() {
        ResultSet resultSet;
        CPreparedStatement statement;
        block8: {
            if (this.productId == 0 || this.priceListVersionId == 0 || !this.useVendorBreak) {
                return false;
            }
            StringBuilder sql = new StringBuilder("SELECT pp.PriceStd,");
            sql.append(" pp.PriceList,").append(" pp.PriceLimit,").append(" p.C_UOM_ID,pv.ValidFrom,pl.C_Currency_ID,p.M_Product_Category_ID,").append(" pl.EnforcePriceLimit, pl.IsTaxIncluded ").append("FROM M_Product p").append(" INNER JOIN M_ProductPriceVendorBreak pp ON (p.M_Product_ID=pp.M_Product_ID)").append(" INNER JOIN  M_PriceList_Version pv ON (pp.M_PriceList_Version_ID=pv.M_PriceList_Version_ID)").append(" INNER JOIN M_PriceList pl ON (pv.M_PriceList_ID=pl.M_PriceList_ID) ").append("WHERE pv.IsActive='Y'").append(" AND pp.IsActive='Y'").append(" AND p.M_Product_ID=?").append(" AND pv.M_PriceList_Version_ID=? AND (pp.C_BPartner_ID=? OR pp.C_BPartner_ID IS NULL) ").append(" AND ?>=pp.BreakValue").append(" ORDER BY pp.BreakValue DESC, pp.C_BPartner_ID ASC");
            this.calculated = false;
            statement = null;
            resultSet = null;
            try {
                statement = DB.prepareStatement(sql.toString(), this.trxName);
                int count = 0;
                statement.setInt(++count, this.productId);
                statement.setInt(++count, this.priceListVersionId);
                statement.setInt(++count, this.partnerId);
                statement.setBigDecimal(++count, this.quantity);
                resultSet = statement.executeQuery();
                if (!resultSet.next()) break block8;
                this.priceStd = resultSet.getBigDecimal(1);
                if (resultSet.wasNull()) {
                    this.priceStd = Env.ZERO;
                }
                this.priceList = resultSet.getBigDecimal(2);
                if (resultSet.wasNull()) {
                    this.priceList = Env.ZERO;
                }
                this.priceLimit = resultSet.getBigDecimal(3);
                if (resultSet.wasNull()) {
                    this.priceLimit = Env.ZERO;
                }
                this.uomId = resultSet.getInt(4);
                this.currencyId = resultSet.getInt(6);
                this.productCategoryId = resultSet.getInt(7);
                this.isEnforcePriceLimit = "Y".equals(resultSet.getString(8));
                this.isTaxIncluded = "Y".equals(resultSet.getString(9));
                this.log.fine("M_PriceList_Version_ID=" + this.priceListVersionId + " - " + this.priceStd);
                this.calculated = true;
            }
            catch (Exception e) {
                try {
                    this.log.log(Level.SEVERE, sql.toString(), e);
                    this.calculated = false;
                }
                catch (Throwable throwable) {
                    DB.close(resultSet, statement);
                    resultSet = null;
                    statement = null;
                    throw throwable;
                }
                DB.close(resultSet, statement);
                resultSet = null;
                statement = null;
            }
        }
        DB.close(resultSet, statement);
        resultSet = null;
        statement = null;
        return this.calculated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean calculatePriceBasedOnPriceListAndProductBreak() {
        if (this.productId == 0 || !this.useVendorBreak) {
            return false;
        }
        if (this.priceListId == 0) {
            this.log.log(Level.SEVERE, "No PriceList");
            Trace.printStack();
            return false;
        }
        StringBuilder sql = new StringBuilder("SELECT pp.PriceStd,");
        sql.append(" pp.PriceList,").append(" pp.PriceLimit,").append(" p.C_UOM_ID,pv.ValidFrom,pl.C_Currency_ID,p.M_Product_Category_ID,pl.EnforcePriceLimit ").append(" FROM M_Product p").append(" INNER JOIN M_ProductPriceVendorBreak pp ON (p.M_Product_ID=pp.M_Product_ID)").append(" INNER JOIN  M_PriceList_Version pv ON (pp.M_PriceList_Version_ID=pv.M_PriceList_Version_ID)").append(" INNER JOIN M_PriceList pl ON (pv.M_PriceList_ID=pl.M_PriceList_ID) ").append(" WHERE pv.IsActive='Y'").append(" AND pp.IsActive='Y'").append(" AND p.M_Product_ID=?").append(" AND pv.M_PriceList_ID=? AND (pp.C_BPartner_ID=? OR pp.C_BPartner_ID IS NULL) ").append(" AND ?>=pp.BreakValue").append(" ORDER BY pv.ValidFrom DESC, pp.BreakValue DESC, pp.C_BPartner_ID ASC");
        this.calculated = false;
        if (this.priceDate == null) {
            this.priceDate = new Timestamp(System.currentTimeMillis());
        }
        CPreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = DB.prepareStatement(sql.toString(), this.trxName);
            int count = 0;
            statement.setInt(++count, this.productId);
            statement.setInt(++count, this.priceListId);
            statement.setInt(++count, this.partnerId);
            statement.setBigDecimal(++count, this.quantity);
            resultSet = statement.executeQuery();
            while (!this.calculated && resultSet.next()) {
                Timestamp plDate = resultSet.getTimestamp(5);
                if (plDate != null && this.priceDate.before(plDate)) continue;
                this.priceStd = resultSet.getBigDecimal(1);
                if (resultSet.wasNull()) {
                    this.priceStd = Env.ZERO;
                }
                this.priceList = resultSet.getBigDecimal(2);
                if (resultSet.wasNull()) {
                    this.priceList = Env.ZERO;
                }
                this.priceLimit = resultSet.getBigDecimal(3);
                if (resultSet.wasNull()) {
                    this.priceLimit = Env.ZERO;
                }
                this.uomId = resultSet.getInt(4);
                this.currencyId = resultSet.getInt(6);
                this.productCategoryId = resultSet.getInt(7);
                this.isEnforcePriceLimit = "Y".equals(resultSet.getString(8));
                this.log.fine("M_PriceList_ID=" + this.priceListId + "(" + plDate + ") - " + this.priceStd);
                this.calculated = true;
                break;
            }
        }
        catch (Exception e) {
            try {
                this.log.log(Level.SEVERE, sql.toString(), e);
                this.calculated = false;
            }
            catch (Throwable throwable) {
                DB.close(resultSet, statement);
                resultSet = null;
                statement = null;
                throw throwable;
            }
            DB.close(resultSet, statement);
            resultSet = null;
            statement = null;
        }
        DB.close(resultSet, statement);
        resultSet = null;
        statement = null;
        if (!this.calculated) {
            this.log.finer("Not found (PL)");
        }
        return this.calculated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean calculatePriceBasedOnBasedPriceListAndProductBreak() {
        if (this.productId == 0 || this.priceListId == 0 || !this.useVendorBreak) {
            return false;
        }
        StringBuilder sql = new StringBuilder("SELECT pp.PriceStd,");
        sql.append(" pp.PriceList,").append(" pp.PriceLimit,").append(" p.C_UOM_ID,pv.ValidFrom,pl.C_Currency_ID,p.M_Product_Category_ID,").append(" pl.EnforcePriceLimit, pl.IsTaxIncluded ").append(" FROM M_Product p").append(" INNER JOIN M_ProductPriceVendorBreak pp ON (p.M_Product_ID=pp.M_Product_ID)").append(" INNER JOIN M_PriceList_Version pv ON (pp.M_PriceList_Version_ID=pv.M_PriceList_Version_ID)").append(" INNER JOIN M_PriceList pl ON (pv.M_PriceList_ID=pl.M_PriceList_ID)").append(" WHERE pv.IsActive='Y'").append(" AND pp.IsActive='Y'").append(" AND p.M_Product_ID=?").append(" AND EXISTS (SELECT 1 FROM M_PriceList_Version plv WHERE plv.IsActive='Y' ").append(" AND plv.M_PriceList_ID=? AND pp.M_PriceList_Version_ID=plv.M_PriceList_Version_Base_ID) AND (pp.C_BPartner_ID=? OR pp.C_BPartner_ID IS NULL)").append(" AND ?>=pp.BreakValue").append(" ORDER BY pv.ValidFrom DESC, BreakValue DESC");
        this.calculated = false;
        if (this.priceDate == null) {
            this.priceDate = new Timestamp(System.currentTimeMillis());
        }
        CPreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = DB.prepareStatement(sql.toString(), this.trxName);
            int count = 0;
            statement.setInt(++count, this.productId);
            statement.setInt(++count, this.priceListId);
            statement.setInt(++count, this.partnerId);
            statement.setBigDecimal(++count, this.quantity);
            resultSet = statement.executeQuery();
            while (!this.calculated && resultSet.next()) {
                Timestamp plDate = resultSet.getTimestamp(5);
                if (plDate != null && this.priceDate.before(plDate)) continue;
                this.priceStd = resultSet.getBigDecimal(1);
                if (resultSet.wasNull()) {
                    this.priceStd = Env.ZERO;
                }
                this.priceList = resultSet.getBigDecimal(2);
                if (resultSet.wasNull()) {
                    this.priceList = Env.ZERO;
                }
                this.priceLimit = resultSet.getBigDecimal(3);
                if (resultSet.wasNull()) {
                    this.priceLimit = Env.ZERO;
                }
                this.uomId = resultSet.getInt(4);
                this.currencyId = resultSet.getInt(6);
                this.productCategoryId = resultSet.getInt(7);
                this.isEnforcePriceLimit = "Y".equals(resultSet.getString(8));
                this.isTaxIncluded = "Y".equals(resultSet.getString(9));
                this.log.fine("M_PriceList_ID=" + this.priceListId + "(" + plDate + ") - " + this.priceStd);
                this.calculated = true;
                break;
            }
        }
        catch (Exception e) {
            try {
                this.log.log(Level.SEVERE, sql.toString(), e);
                this.calculated = false;
            }
            catch (Throwable throwable) {
                DB.close(resultSet, statement);
                resultSet = null;
                statement = null;
                throw throwable;
            }
            DB.close(resultSet, statement);
            resultSet = null;
            statement = null;
        }
        DB.close(resultSet, statement);
        resultSet = null;
        statement = null;
        if (!this.calculated) {
            this.log.finer("Not found (BPL)");
        }
        return this.calculated;
    }

    private void setBaseInfo() {
        if (this.productId == 0) {
            return;
        }
        MProduct product = new MProduct(Env.getCtx(), this.productId, this.trxName);
        if (product != null) {
            this.uomId = product.getC_UOM_ID();
            this.productCategoryId = product.getM_Product_Category_ID();
        }
    }

    public boolean isTaxIncluded() {
        return this.isTaxIncluded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calculateDiscount() {
        this.discountSchema = false;
        if (this.partnerId == 0 || this.productId == 0) {
            return;
        }
        int discountSchemaId = 0;
        BigDecimal flatDiscount = null;
        String sql = "SELECT COALESCE(p.M_DiscountSchema_ID,g.M_DiscountSchema_ID), COALESCE(p.PO_DiscountSchema_ID,g.PO_DiscountSchema_ID), p.FlatDiscount FROM C_BPartner p INNER JOIN C_BP_Group g ON (p.C_BP_Group_ID=g.C_BP_Group_ID) WHERE p.C_BPartner_ID=?";
        CPreparedStatement statement = null;
        ResultSet rs = null;
        try {
            statement = DB.prepareStatement(sql, this.trxName);
            statement.setInt(1, this.partnerId);
            rs = statement.executeQuery();
            if (rs.next()) {
                discountSchemaId = rs.getInt(this.isSOTrx ? 1 : 2);
                flatDiscount = rs.getBigDecimal(3);
                if (flatDiscount == null) {
                    flatDiscount = Env.ZERO;
                }
            }
            DB.close(rs, statement);
            rs = null;
            statement = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        finally {
            DB.close(rs, statement);
            rs = null;
            statement = null;
        }
        if (discountSchemaId == 0) {
            return;
        }
        MDiscountSchema discountSchema = new MDiscountSchema(Env.getCtx(), discountSchemaId, this.trxName);
        if (discountSchema.get_ID() == 0) {
            return;
        }
        this.discountSchema = true;
        this.priceStd = discountSchema.calculatePrice(this.quantity, this.priceStd, this.productId, this.productCategoryId, flatDiscount);
    }

    public BigDecimal getDiscount() {
        BigDecimal discount = Env.ZERO;
        if (this.priceList.intValue() != 0) {
            discount = new BigDecimal((this.priceList.doubleValue() - this.priceStd.doubleValue()) / this.priceList.doubleValue() * 100.0);
        }
        if (discount.scale() > 2) {
            discount = discount.setScale(2, RoundingMode.HALF_UP);
        }
        return discount;
    }

    public int getM_Product_ID() {
        return this.productId;
    }

    public int getM_PriceList_ID() {
        return this.priceListId;
    }

    public void setM_PriceList_ID(int M_PriceList_ID) {
        this.priceListId = M_PriceList_ID;
        this.calculated = false;
    }

    public int getM_PriceList_Version_ID() {
        return this.priceListVersionId;
    }

    public void setM_PriceList_Version_ID(int M_PriceList_Version_ID) {
        this.priceListVersionId = M_PriceList_Version_ID;
        this.calculated = false;
    }

    public Timestamp getPriceDate() {
        return this.priceDate;
    }

    public void setPriceDate(Timestamp priceDate) {
        this.priceDate = priceDate;
        this.calculated = false;
    }

    private void setPrecision() {
        if (this.priceListId != 0) {
            this.precision = MPriceList.getPricePrecision(Env.getCtx(), this.getM_PriceList_ID());
        }
    }

    public int getPrecision() {
        return this.precision;
    }

    private BigDecimal round(BigDecimal price) {
        if (this.precision >= 0 && price.scale() > this.precision) {
            return price.setScale(this.precision, RoundingMode.HALF_UP);
        }
        return price;
    }

    public int getC_UOM_ID() {
        if (!this.calculated) {
            this.calculatePrice();
        }
        return this.uomId;
    }

    public BigDecimal getPriceList() {
        if (!this.calculated) {
            this.calculatePrice();
        }
        return this.round(this.priceList);
    }

    public BigDecimal getPriceStd() {
        if (!this.calculated) {
            this.calculatePrice();
        }
        return this.round(this.priceStd);
    }

    public BigDecimal getPriceLimit() {
        if (!this.calculated) {
            this.calculatePrice();
        }
        return this.round(this.priceLimit);
    }

    public int getC_Currency_ID() {
        if (!this.calculated) {
            this.calculatePrice();
        }
        return this.currencyId;
    }

    public boolean isEnforcePriceLimit() {
        if (!this.calculated) {
            this.calculatePrice();
        }
        return this.isEnforcePriceLimit;
    }

    public boolean isDiscountSchema() {
        return this.discountSchema || this.useVendorBreak;
    }

    public boolean isCalculated() {
        return this.calculated;
    }
}

