/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.File;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import org.adempiere.core.domains.models.I_M_ProductionLine;
import org.adempiere.core.domains.models.X_M_Production;
import org.adempiere.core.domains.models.X_PP_Product_BOM;
import org.adempiere.core.domains.models.X_PP_Product_BOMLine;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.PeriodClosedException;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MAttributeSet;
import org.compiere.model.MAttributeSetInstance;
import org.compiere.model.MClient;
import org.compiere.model.MCostType;
import org.compiere.model.MDocType;
import org.compiere.model.MLocator;
import org.compiere.model.MMovement;
import org.compiere.model.MMovementLine;
import org.compiere.model.MOrderLine;
import org.compiere.model.MPeriod;
import org.compiere.model.MProduct;
import org.compiere.model.MProductionBatch;
import org.compiere.model.MProductionBatchLine;
import org.compiere.model.MProductionLine;
import org.compiere.model.MProductionLineMA;
import org.compiere.model.MProductionPlan;
import org.compiere.model.MStorage;
import org.compiere.model.MTransaction;
import org.compiere.model.MUOM;
import org.compiere.model.MWarehouse;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.process.DocAction;
import org.compiere.process.DocumentEngine;
import org.compiere.process.DocumentReversalEnabled;
import org.compiere.process.ProcessInfo;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.CLogger;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.eevolution.services.dsl.ProcessBuilder;

public class MProduction
extends X_M_Production
implements DocAction,
DocumentReversalEnabled {
    private static final long serialVersionUID = -8141439503963346402L;
    private static CLogger log = CLogger.getCLogger(MProduction.class);
    private int lineno;
    private MProductionBatch parent = null;
    private String m_processMsg = null;
    private boolean m_justPrepared = false;
    private boolean m_reversal = false;

    public MProduction(Properties ctx, int M_Production_ID, String trxName) {
        super(ctx, M_Production_ID, trxName);
        if (M_Production_ID == 0) {
            this.setDocStatus("DR");
            this.setDocAction("PR");
        }
    }

    public MProduction(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MProduction(MOrderLine line) {
        super(line.getCtx(), 0, line.get_TrxName());
        MProduct product = MProduct.get(this.getCtx(), line.getM_Product_ID());
        this.setAD_Client_ID(line.getAD_Client_ID());
        this.setAD_Org_ID(line.getAD_Org_ID());
        this.setMovementDate(line.getDatePromised());
        this.setM_Product_ID(line.getM_Product_ID());
        this.setProductionQty(line.getQtyOrdered().subtract(line.getQtyDelivered()));
        this.setDatePromised(line.getDatePromised());
        int locator = product.getM_Locator_ID();
        if (locator == 0) {
            locator = MWarehouse.get(this.getCtx(), line.getM_Warehouse_ID()).getDefaultLocator().get_ID();
        }
        this.setM_Locator_ID(locator);
        this.setC_OrderLine_ID(line.getC_OrderLine_ID());
    }

    public MProduction(MProductionBatch batch) {
        super(batch.getCtx(), 0, batch.get_TrxName());
        this.setFromBatch(batch);
    }

    public MProductionBatch getParent(boolean reload) {
        if (this.parent == null && this.getM_ProductionBatch_ID() != 0) {
            this.parent = (MProductionBatch)this.getM_ProductionBatch();
        }
        return this.parent;
    }

    public MProductionBatch getParent() {
        return this.getParent(false);
    }

    private void processFromBatch() {
        MMovement[] moves;
        MProductionLine[] lines;
        if (this.getParent() == null) {
            throw new AdempiereException("@M_ProductionBatch_ID@ @NotFound@");
        }
        if (this.parent.isProcessed()) {
            if (this.parent.getDocStatus().equals("CL")) {
                throw new AdempiereException("@M_ProductionBatch_ID@ @closed@");
            }
            if (this.parent.getDocStatus().equals("VO")) {
                throw new AdempiereException("@M_ProductionBatch_ID@ @Voided@");
            }
            if (this.parent.getDocStatus().equals("CO") && this.parent.getQtyCompleted().compareTo(this.parent.getTargetQty()) > 0) {
                throw new AdempiereException("@QtyCompleted@ > @TargetQty@");
            }
        } else {
            throw new AdempiereException("@M_ProductionBatch_ID@ @Unprocessed@");
        }
        StringBuilder errors = new StringBuilder();
        for (MProductionLine line : lines = this.getLines_OrderedByIsEndProduct()) {
            MProduct product = (MProduct)line.getM_Product();
            MAttributeSet as = product.getAttributeSet();
            if (as != null && (as.isMandatoryAlways() || as.isSerNo() && as.isSerNoMandatory() || as.isLot() && as.isLotMandatory()) && line.getM_AttributeSetInstance_ID() == 0) {
                errors.append("@M_AttributeSet_ID@ @IsMandatory@ (@Line@ #" + line.getLine() + ", @M_Product_ID@ = " + product.getValue() + ")").append(Env.NL);
            }
            if (!this.isMustBeStocked() || line.isEndProduct() || this.isReversal() || !product.isStocked() || !line.isActive()) continue;
            String MMPolicy = product.getMMPolicy();
            MStorage[] storages = MStorage.getWarehouse(this.getCtx(), 0, product.getM_Product_ID(), line.getM_AttributeSetInstance_ID(), null, "F".equals(MMPolicy), true, line.getM_Locator_ID(), this.get_TrxName());
            BigDecimal qtyOnHand = Env.ZERO;
            if (storages != null && storages.length > 0) {
                for (MStorage storage : storages) {
                    qtyOnHand = qtyOnHand.add(storage.getQtyOnHand());
                }
            }
            log.config("qtyOnHand=" + qtyOnHand + " movementQty=" + line.getMovementQty() + " " + product);
            if (qtyOnHand.add(line.getMovementQty()).compareTo(Env.ZERO) >= 0) continue;
            errors.append(Msg.translate(this.getCtx(), "NotEnoughStocked") + " " + product.getName() + ": " + Msg.translate(this.getCtx(), "QtyAvailable") + " " + qtyOnHand.toString() + ".\n");
        }
        if (errors.length() > 0) {
            throw new AdempiereException(errors.toString());
        }
        for (MMovement move : moves = this.parent.getMovements(true)) {
            if (move.isProcessed()) continue;
            errors.append("@M_Movement_ID@ =" + move.getDocumentNo() + " @Unprocessed@");
        }
        if (errors.length() > 0) {
            throw new AdempiereException(errors.toString());
        }
        Arrays.asList(lines).forEach(productionLine -> this.createTransaction((MProductionLine)productionLine));
        this.updateQtyHeader(false);
        this.parent.createComplementProduction();
    }

    private void updateQtyHeader(boolean isVoid) {
        if (this.getParent() == null) {
            return;
        }
        BigDecimal productionQty = this.getProductionQty();
        if (isVoid) {
            productionQty = productionQty.negate();
        }
        this.parent.setQtyReserved(this.parent.getQtyReserved().subtract(productionQty));
        this.parent.setQtyCompleted(this.parent.getQtyCompleted().add(productionQty));
        this.parent.saveEx(this.get_TrxName());
    }

    private String processFromPlan() {
        return null;
    }

    private void createTransaction(MProductionLine productionLine) {
        MProduct product = productionLine.getProduct();
        MLocator locator = MLocator.get(this.getCtx(), productionLine.getM_Locator_ID());
        String movementType = productionLine.isEndProduct() ? "P+" : "P-";
        BigDecimal quantity = productionLine.getMovementQty();
        log.info("Line=" + productionLine.getLine() + " - Qty=" + productionLine.getMovementQty());
        if (product != null && product.isStocked() && product != null) {
            if (this.getReversal_ID() == 0) {
                this.checkMaterialPolicy(productionLine, movementType);
            }
            log.fine("Material Transaction");
            MTransaction transaction = null;
            if (productionLine.getM_AttributeSetInstance_ID() == 0) {
                MProductionLineMA[] list;
                for (MProductionLineMA ma : list = MProductionLineMA.get(this.getCtx(), productionLine.getM_ProductionLine_ID(), this.get_TrxName())) {
                    if (productionLine.getM_AttributeSetInstance_ID() != 0 && productionLine.getM_AttributeSetInstance_ID() != ma.getM_AttributeSetInstance_ID()) continue;
                    BigDecimal quantityMA = ma.getMovementQty();
                    if (!MStorage.add(this.getCtx(), locator.getM_Warehouse_ID(), productionLine.getM_Locator_ID(), productionLine.getM_Product_ID(), ma.getM_AttributeSetInstance_ID(), 0, quantityMA.negate(), Env.ZERO, Env.ZERO, this.get_TrxName())) {
                        throw new AdempiereException("@M_Transaction_ID@ @no@ @Created@");
                    }
                    transaction = new MTransaction(this.getCtx(), productionLine.getAD_Org_ID(), movementType, productionLine.getM_Locator_ID(), productionLine.getM_Product_ID(), ma.getM_AttributeSetInstance_ID(), quantityMA.negate(), productionLine.getParent().getMovementDate(), this.get_TrxName());
                    transaction.setM_ProductionLine_ID(productionLine.getM_ProductionLine_ID());
                    BigDecimal quantityReserved = productionLine.getMovementQty();
                    MProductionBatchLine pbLine = MProductionBatchLine.getbyProduct(this.getM_ProductionBatch_ID(), productionLine.getM_Product_ID(), this.getCtx(), this.get_TrxName());
                    pbLine.setQtyReserved(pbLine.getQtyReserved().add(quantityReserved));
                    pbLine.saveEx();
                    transaction.saveEx();
                }
            }
            if (transaction == null) {
                MAttributeSetInstance asi = null;
                int reservationAttributeSetInstance_ID = productionLine.getM_AttributeSetInstance_ID();
                int transactionAttributeSetInstance_ID = productionLine.getM_AttributeSetInstance_ID();
                if (productionLine.getM_AttributeSetInstance_ID() == 0) {
                    MAttributeSet.validateAttributeSetInstanceMandatory(product, MProductionLine.Table_ID, false, productionLine.getM_AttributeSetInstance_ID());
                    asi = MAttributeSetInstance.create(this.getCtx(), product, this.get_TrxName());
                    productionLine.setM_AttributeSetInstance_ID(asi.getM_AttributeSetInstance_ID());
                    transactionAttributeSetInstance_ID = asi.getM_AttributeSetInstance_ID();
                    log.config("New ASI=" + productionLine);
                }
                if (!MStorage.add(this.getCtx(), locator.getM_Warehouse_ID(), productionLine.getM_Locator_ID(), productionLine.getM_Product_ID(), transactionAttributeSetInstance_ID, reservationAttributeSetInstance_ID, quantity, Env.ZERO, Env.ZERO, this.get_TrxName())) {
                    throw new AdempiereException("@M_Transaction_ID@ @no@ @Created@");
                }
                transaction = new MTransaction(this.getCtx(), productionLine.getAD_Org_ID(), movementType, productionLine.getM_Locator_ID(), productionLine.getM_Product_ID(), productionLine.getM_AttributeSetInstance_ID(), quantity, productionLine.getParent().getMovementDate(), this.get_TrxName());
                transaction.setM_ProductionLine_ID(productionLine.getM_ProductionLine_ID());
                transaction.saveEx();
                BigDecimal qtyreserved = productionLine.isEndProduct() ? productionLine.getMovementQty() : productionLine.getMovementQty().negate();
                MProductionBatchLine pbLine = MProductionBatchLine.getbyProduct(this.getM_ProductionBatch_ID(), this.getM_Product_ID(), this.getCtx(), this.get_TrxName());
                pbLine.setQtyReserved(pbLine.getQtyReserved().subtract(qtyreserved));
                pbLine.saveEx();
            }
        }
        productionLine.setQtyReserved(productionLine.getQtyReserved().add(productionLine.getMovementQty()));
        productionLine.setProcessed(true);
        productionLine.saveEx(this.get_TrxName());
    }

    @Override
    public void setProcessed(boolean Processed) {
        super.setProcessed(Processed);
        for (MProductionPlan plan : this.getProductionPlan()) {
            plan.setProcessed(Processed);
            plan.saveEx();
        }
        for (MProductionLine line : this.getLines()) {
            line.setProcessed(Processed);
            line.saveEx();
        }
    }

    public List<MProductionPlan> getProductionPlan() {
        String whereClause = "M_Production_ID=? ";
        return new Query(this.getCtx(), "M_ProductionPlan", whereClause, this.get_TrxName()).setParameters(this.getM_Production_ID()).setOrderBy("Line").list();
    }

    public MProductionLine[] getLines() {
        String whereClause = "M_Production_ID=? ";
        List<MProductionLine> list = new Query(this.getCtx(), "M_ProductionLine", whereClause, this.get_TrxName()).setParameters(this.getM_Production_ID()).setOrderBy("Line").list();
        return list.toArray(new MProductionLine[list.size()]);
    }

    public MProductionLine[] getLines_OrderedByIsEndProduct() {
        String whereClause = "M_Production_ID=? ";
        List<MProductionLine> list = new Query(this.getCtx(), "M_ProductionLine", whereClause, this.get_TrxName()).setParameters(this.getM_Production_ID()).setOrderBy("IsEndProduct,Line").list();
        return list.toArray(new MProductionLine[list.size()]);
    }

    private void deleteLines() {
        for (MProductionLine line : this.getLines()) {
            line.deleteEx(true);
        }
    }

    @Override
    protected boolean beforeDelete() {
        if (this.isProcessed()) {
            return false;
        }
        this.deleteLines();
        return true;
    }

    @Override
    public boolean processIt(String processAction) {
        this.m_processMsg = null;
        DocumentEngine engine = new DocumentEngine(this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    @Override
    public boolean unlockIt() {
        if (log.isLoggable(Level.INFO)) {
            log.info("unlockIt - " + this.toString());
        }
        return true;
    }

    @Override
    public boolean invalidateIt() {
        if (log.isLoggable(Level.INFO)) {
            log.info(this.toString());
        }
        this.setDocAction("PR");
        return true;
    }

    @Override
    public String completeIt() {
        String status;
        if (!this.m_justPrepared && !"IP".equals(status = this.prepareIt())) {
            return status;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 7);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_processMsg = this.validateHeader();
        if (this.getM_ProductionBatch_ID() != 0) {
            this.processFromBatch();
        } else {
            this.m_processMsg = this.processFromPlan();
        }
        if (this.m_processMsg != null) {
            return "IN";
        }
        String valid = ModelValidationEngine.get().fireDocValidate(this, 9);
        if (valid != null) {
            this.m_processMsg = valid;
            return "IN";
        }
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    @Override
    public String prepareIt() {
        if (log.isLoggable(Level.INFO)) {
            log.info(this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        MPeriod.testPeriodOpen(this.getCtx(), this.getMovementDate(), "MOP", this.getAD_Org_ID());
        this.m_processMsg = this.validateEndProduct(this.getM_Product_ID());
        if (!Util.isEmpty(this.m_processMsg)) {
            return "IN";
        }
        this.m_processMsg = this.validateHeader();
        if (this.m_processMsg != null) {
            return "IN";
        }
        if (!this.isReversal()) {
            this.createLines();
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 8);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_justPrepared = true;
        if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("CO");
        }
        return "IP";
    }

    private String validateHeader() {
        if (this.getM_Product_ID() != 0) {
            if (this.getProductionQty() == null || this.getProductionQty().equals(Env.ZERO)) {
                return "@ProductionQty@ = 0";
            }
            if (this.getM_Locator_ID() == 0) {
                return "@M_Locator_ID@ @NotFound@";
            }
        }
        return null;
    }

    private String validateEndProduct(int M_Product_ID) {
        String msg = this.isBOM(M_Product_ID);
        if (!Util.isEmpty(msg)) {
            return msg;
        }
        return null;
    }

    private String isBOM(int M_Product_ID) {
        MProduct product = MProduct.get(this.getCtx(), M_Product_ID);
        if (!product.isBOM()) {
            return "@NotBOM@ [" + product.getValue() + "-" + product.getName() + "]";
        }
        if (this.getDefaultProductBom(product, this.get_TrxName()) == null) {
            return "@NotBOMProducts@";
        }
        return null;
    }

    @Override
    public boolean approveIt() {
        return true;
    }

    @Override
    public boolean rejectIt() {
        return true;
    }

    @Override
    public boolean voidIt() {
        if (log.isLoggable(Level.INFO)) {
            log.info(this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 2);
        if (this.m_processMsg != null) {
            return false;
        }
        if ("CL".equals(this.getDocStatus()) || "RE".equals(this.getDocStatus()) || "VO".equals(this.getDocStatus())) {
            this.m_processMsg = "Document Closed: " + this.getDocStatus();
            this.setDocAction("--");
            return false;
        }
        if (this.isProcessed()) {
            boolean accrual = false;
            try {
                MPeriod.testPeriodOpen(this.getCtx(), this.getMovementDate(), "MOP", this.getAD_Org_ID());
            }
            catch (PeriodClosedException e) {
                accrual = true;
            }
            if (accrual) {
                return this.reverseAccrualIt();
            }
            return this.reverseCorrectIt();
        }
        this.setIsCreated(false);
        this.deleteLines();
        this.setProductionQty(BigDecimal.ZERO);
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 10);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        return true;
    }

    @Override
    public boolean closeIt() {
        if (log.isLoggable(Level.INFO)) {
            log.info(this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 3);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 11);
        return this.m_processMsg == null;
    }

    @Override
    public MProduction reverseIt(boolean isAccrual) {
        Timestamp currentDate = new Timestamp(System.currentTimeMillis());
        Optional<Timestamp> loginDateOptional = Optional.of(Env.getContextAsDate(this.getCtx(), "#Date"));
        Timestamp reversalDate = isAccrual ? loginDateOptional.orElseGet(() -> currentDate) : this.getMovementDate();
        MPeriod.testPeriodOpen(this.getCtx(), reversalDate, this.getC_DocType_ID(), this.getAD_Org_ID());
        MProduction reversal = null;
        reversal = this.copyFrom(reversalDate);
        MDocType docType = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        if (docType.isCopyDocNoOnReversal()) {
            reversal.setDocumentNo(this.getDocumentNo() + Msg.getMsg(this.getCtx(), "^"));
        }
        StringBuilder msgadd = new StringBuilder("{->").append(this.getDocumentNo()).append(")");
        reversal.addDescription(msgadd.toString());
        reversal.setReversal_ID(this.getM_Production_ID());
        reversal.saveEx(this.get_TrxName());
        if (!reversal.processIt("CO")) {
            this.m_processMsg = "@Reversal@ @Error@ " + reversal.getProcessMsg();
            return null;
        }
        reversal.closeIt();
        reversal.setDocStatus("RE");
        reversal.setDocAction("--");
        reversal.saveEx(this.get_TrxName());
        msgadd = new StringBuilder("(").append(reversal.getDocumentNo()).append("<-)");
        this.addDescription(msgadd.toString());
        this.setProcessed(true);
        this.setReversal_ID(reversal.getM_Production_ID());
        this.setDocStatus("RE");
        this.setDocAction("--");
        MProductionBatch pBatch = this.getParent();
        pBatch.saveEx(this.get_TrxName());
        return reversal;
    }

    private MProduction copyFrom(Timestamp reversalDate) {
        MProduction to = new MProduction(this.getCtx(), 0, this.get_TrxName());
        PO.copyValues(this, to, this.getAD_Client_ID(), this.getAD_Org_ID());
        to.set_ValueNoCheck("DocumentNo", null);
        to.setDocStatus("DR");
        to.setDocAction("CO");
        to.setMovementDate(reversalDate);
        to.setIsCreated(true);
        to.setPosted(false);
        to.setProcessed(false);
        to.setReversal(true);
        to.setProductionQty(this.getProductionQty().negate());
        to.saveEx();
        for (MProductionLine fline : this.getLines()) {
            MProductionLine tline = new MProductionLine(to);
            PO.copyValues(fline, tline, this.getAD_Client_ID(), this.getAD_Org_ID());
            tline.setM_Production_ID(to.getM_Production_ID());
            tline.setMovementQty(fline.getMovementQty().negate());
            tline.setPlannedQty(fline.getPlannedQty().negate());
            tline.setQtyUsed(fline.getQtyUsed().negate());
            tline.setReversalLine_ID(fline.getM_ProductionLine_ID());
            tline.saveEx();
            if (tline.getM_AttributeSetInstance_ID() != 0) continue;
            MProductionLineMA[] mas = MProductionLineMA.get(this.getCtx(), fline.getM_ProductionLine_ID(), this.get_TrxName());
            for (int j = 0; j < mas.length; ++j) {
                MProductionLineMA ma = new MProductionLineMA(tline, mas[j].getM_AttributeSetInstance_ID(), mas[j].getMovementQty().negate());
                ma.saveEx();
            }
        }
        return to;
    }

    @Override
    public boolean reverseCorrectIt() {
        if (log.isLoggable(Level.INFO)) {
            log.info(this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 5);
        if (this.m_processMsg != null) {
            return false;
        }
        MProduction reversal = this.reverseIt(false);
        if (reversal == null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 13);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = reversal.getDocumentNo();
        return true;
    }

    @Override
    public boolean reverseAccrualIt() {
        if (log.isLoggable(Level.INFO)) {
            log.info(this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 6);
        if (this.m_processMsg != null) {
            return false;
        }
        MProduction reversal = this.reverseIt(true);
        if (reversal == null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 14);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = reversal.getDocumentNo();
        return true;
    }

    public MMovement createMovement() throws Exception {
        MProductionLine[] lines = this.getLines();
        if (lines.length == 0) {
            return null;
        }
        MProductionBatch batch = this.getParent();
        MMovement move = new MMovement(this.getCtx(), 0, this.get_TrxName());
        MWarehouse wh = (MWarehouse)this.getM_Locator().getM_Warehouse();
        boolean allowSameLocator = wh.get_ValueAsBoolean("IsAllowSameLocatorMove");
        move.setClientOrg(this);
        move.setDescription(Msg.parseTranslation(this.getCtx(), "@Created@ @from@ @M_ProductionBatch_ID@ " + batch.getDocumentNo()));
        move.set_Value("M_Warehouse_ID", (Object)wh.getM_Warehouse_ID());
        move.set_Value("M_Warehouse_To_ID", (Object)wh.getM_Warehouse_ID());
        move.set_Value("M_ProductionBatch_ID", (Object)batch.getM_ProductionBatch_ID());
        move.saveEx();
        log.fine("Movement Documentno=" + move.getDocumentNo() + " created for Production Batch=" + batch.getDocumentNo());
        for (MProductionLine line : lines) {
            if (line.isEndProduct() || line.getM_Product().isBOM() || !line.getM_Product().isStocked()) {
                log.fine("End Product. No need to move." + line.getM_Product().getValue());
                continue;
            }
            if (Env.ZERO.compareTo(line.getMovementQty()) == 0) {
                log.fine("No quantity to to move." + line.getM_Product().getValue());
                continue;
            }
            if (this.getM_Locator_ID() == line.getM_Product().getM_Locator_ID() && !allowSameLocator) {
                throw new AdempiereUserError("CannotUseSameLocator");
            }
            MMovementLine moveLine = new MMovementLine(move);
            moveLine.setM_LocatorTo_ID(this.getM_Locator_ID());
            moveLine.setM_Locator_ID(line.getM_Product().getM_Locator_ID());
            moveLine.setM_Product_ID(line.getM_Product_ID());
            moveLine.setM_AttributeSetInstance_ID(line.getM_AttributeSetInstance_ID());
            moveLine.setM_AttributeSetInstanceTo_ID(line.getM_AttributeSetInstance_ID());
            moveLine.setMovementQty(line.getMovementQty().negate());
            moveLine.saveEx();
        }
        return move;
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            StringBuilder msgd = new StringBuilder(desc).append(" | ").append(description);
            this.setDescription(msgd.toString());
        }
    }

    @Override
    public boolean reActivateIt() {
        return false;
    }

    @Override
    public String getSummary() {
        return this.getDocumentNo();
    }

    @Override
    public String getDocumentInfo() {
        return this.getDocumentNo();
    }

    @Override
    public File createPDF() {
        return null;
    }

    @Override
    public String getProcessMsg() {
        return this.m_processMsg;
    }

    @Override
    public int getDoc_User_ID() {
        return this.getCreatedBy();
    }

    @Override
    public int getC_Currency_ID() {
        return MClient.get(this.getCtx()).getC_Currency_ID();
    }

    @Override
    public BigDecimal getApprovalAmt() {
        return BigDecimal.ZERO;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.getReversal_ID() != 0) {
            return true;
        }
        if (this.getC_DocType_ID() == 0) {
            int C_DocType_ID = MDocType.getDocType("MMP", this.getAD_Org_ID());
            if (C_DocType_ID == 0) {
                C_DocType_ID = MDocType.getDocType("MMP");
            }
            if (C_DocType_ID == 0) {
                throw new AdempiereException("@C_DocType_ID@ @NotFound@");
            }
            this.setC_DocType_ID(C_DocType_ID);
        }
        if (this.is_ValueChanged("M_ProductionBatch_ID") && !this.isProcessed() && !this.isReversal()) {
            this.setFromBatch(this.getParent(true));
        }
        if (this.is_ValueChanged("ProductionQty") && !this.isProcessed() && this.isCreated() && !this.isReversal()) {
            this.setIsCreated(false);
        }
        return true;
    }

    private void setFromBatch(MProductionBatch batch) {
        if (batch.getPP_Product_BOM_ID() != 0) {
            this.setPP_Product_BOM_ID(batch.getPP_Product_BOM_ID());
        }
        this.setM_ProductionBatch_ID(batch.getM_ProductionBatch_ID());
        this.setClientOrg(batch);
        this.setM_Product_ID(batch.getM_Product_ID());
        this.setDatePromised(batch.getMovementDate());
        this.setMovementDate(batch.getMovementDate());
        this.setM_Locator_ID(batch.getM_Locator_ID());
        this.setProductionQty(batch.getTargetQty().subtract(batch.getQtyCompleted()));
        this.setC_Activity_ID(batch.getC_Activity_ID());
        this.setC_Project_ID(batch.getC_Project_ID());
        this.setC_Campaign_ID(batch.getC_Campaign_ID());
        this.setUser1_ID(batch.getUser1_ID());
        this.setUser2_ID(batch.getUser2_ID());
        if (this.getDescription() == null) {
            this.setDescription(Msg.parseTranslation(this.getCtx(), "@Created@ @from@ @M_ProductionBatch_ID@ " + batch.getDocumentNo()));
        }
        log.info("M_Production_ID=" + this.getM_Production_ID() + " created");
    }

    @Override
    public void setReversal(boolean reversal) {
        this.m_reversal = reversal;
    }

    @Override
    public boolean isReversal() {
        return this.m_reversal;
    }

    public void checkMaterialPolicy(MProductionLine pLine, String MovementType) {
        int no = pLine.deleteMA();
        if (no > 0) {
            log.config("Delete old #" + no);
        }
        boolean needSave = false;
        MProduct product = pLine.getProduct();
        String MMPolicy = product.getMMPolicy();
        Timestamp minGuaranteeDate = this.getMovementDate();
        MStorage[] storages = MStorage.getWarehouse(this.getCtx(), pLine.getM_Locator().getM_Warehouse_ID(), pLine.getM_Product_ID(), pLine.getM_AttributeSetInstance_ID(), minGuaranteeDate, "F".equals(MMPolicy), true, pLine.getM_Locator_ID(), this.get_TrxName());
        BigDecimal qtyToDeliver = pLine.getMovementQty().negate();
        for (MStorage storage : storages) {
            MProductionLineMA ma;
            if (storage.getQtyOnHand().compareTo(qtyToDeliver) >= 0) {
                ma = new MProductionLineMA(pLine, storage.getM_AttributeSetInstance_ID(), qtyToDeliver);
                ma.saveEx();
                qtyToDeliver = Env.ZERO;
            } else {
                ma = new MProductionLineMA(pLine, storage.getM_AttributeSetInstance_ID(), storage.getQtyOnHand());
                ma.saveEx();
                qtyToDeliver = qtyToDeliver.subtract(storage.getQtyOnHand());
                log.fine(ma + ", QtyToDeliver=" + qtyToDeliver);
            }
            if (qtyToDeliver.signum() == 0) break;
        }
        if (qtyToDeliver.signum() != 0) {
            MAttributeSet.validateAttributeSetInstanceMandatory(product, I_M_ProductionLine.Table_ID, false, pLine.getM_AttributeSetInstance_ID());
            MAttributeSetInstance asi = MAttributeSetInstance.create(this.getCtx(), product, this.get_TrxName());
            int M_AttributeSetInstance_ID = asi.getM_AttributeSetInstance_ID();
            MProductionLineMA ma = new MProductionLineMA(pLine, M_AttributeSetInstance_ID, qtyToDeliver);
            ma.saveEx();
            log.fine("##: " + ma);
        }
        if (needSave) {
            pLine.saveEx();
        }
    }

    private void createLines() {
        if (this.isCreated()) {
            return;
        }
        this.isBOM(this.getM_Product_ID());
        this.recalculate();
        if (this.getM_ProductionBatch_ID() > 0) {
            BigDecimal cntQty = Env.ZERO;
            MProductionBatch pBatch = (MProductionBatch)this.getM_ProductionBatch();
            for (MProduction p : pBatch.getProductionArray(true)) {
                if (p.getM_Production_ID() == this.getM_Production_ID()) continue;
                cntQty = cntQty.add(p.getProductionQty());
            }
            BigDecimal maxPlanQty = pBatch.getTargetQty().subtract(cntQty);
            if (this.getProductionQty().compareTo(maxPlanQty) > 0) {
                DecimalFormat format = DisplayType.getNumberFormat(29);
                throw new AdempiereException("@Total@ @ProductionQty@ > @TargetQty@ [@TargetQty@ = " + format.format(pBatch.getTargetQty()) + " @Total@ @ProductionQty@ = " + format.format(cntQty) + " @Max@ = " + format.format(maxPlanQty));
            }
        }
        this.deleteLines();
        this.createLines(this.isMustBeStocked());
        this.setIsCreated(true);
        this.saveEx();
        MProductionBatch batch = this.getParent();
        if (batch != null) {
            batch.setQtyOrdered(this.getProductionQty());
            batch.saveEx();
        }
    }

    public String createLines(boolean mustBeStocked) {
        this.lineno = 100;
        String error = "";
        MProduct finishedProduct = new MProduct(this.getCtx(), this.getM_Product_ID(), this.get_TrxName());
        MAttributeSet as = finishedProduct.getAttributeSet();
        if (as != null && as.isSerNo()) {
            for (int i = 0; i < this.getProductionQty().intValue(); ++i) {
                if (i > 0) {
                    this.lineno += 10;
                }
                MProductionLine line = new MProductionLine(this);
                line.setLine(this.lineno);
                line.setM_Product_ID(finishedProduct.get_ID());
                line.setM_Locator_ID(this.getM_Locator_ID());
                line.setMovementQty(Env.ONE);
                line.setPlannedQty(Env.ONE);
                line.saveEx();
            }
        } else {
            MProductionLine line = new MProductionLine(this);
            line.setLine(this.lineno);
            line.setM_Product_ID(finishedProduct.getM_Product_ID());
            line.setM_Locator_ID(this.getM_Locator_ID());
            line.setMovementQty(this.getProductionQty());
            line.setPlannedQty(this.getProductionQty());
            line.saveEx();
        }
        error = this.createBOM(mustBeStocked, finishedProduct, this.getProductionQty());
        return error;
    }

    private List<Integer> getProductBomLines(int productBomId) {
        return new Query(this.getCtx(), "PP_Product_BOMLine", "PP_Product_BOM_ID=?", this.get_TrxName()).setParameters(productBomId).setClient_ID().setOnlyActiveRecords(true).setOrderBy("Line").getIDsAsList();
    }

    private X_PP_Product_BOM getDefaultProductBom(MProduct product, String trxName) {
        return (X_PP_Product_BOM)new Query(product.getCtx(), "PP_Product_BOM", "M_Product_ID=? AND Value=?", trxName).setParameters(product.getM_Product_ID(), product.getValue()).setOnlyActiveRecords(true).setOnlyActiveRecords(true).setClient_ID().first();
    }

    private String createBOM(boolean mustBeStocked, MProduct finishedProduct, BigDecimal requiredQty) {
        AtomicInteger defaultLocator = new AtomicInteger(0);
        X_PP_Product_BOM bom = null;
        bom = this.getPP_Product_BOM_ID() != 0 ? new X_PP_Product_BOM(this.getCtx(), this.getPP_Product_BOM_ID(), this.get_TrxName()) : this.getDefaultProductBom(finishedProduct, this.get_TrxName());
        this.getProductBomLines(bom.getPP_Product_BOM_ID()).forEach(productBomLineId -> {
            MProduct bomproduct;
            X_PP_Product_BOMLine bomLine = new X_PP_Product_BOMLine(this.getCtx(), (int)productBomLineId, this.get_TrxName());
            BigDecimal BOMMovementQty = this.getQty(bomLine, true).multiply(requiredQty);
            int precision = MUOM.getPrecision(this.getCtx(), bomLine.getC_UOM_ID());
            if (BOMMovementQty.scale() > precision) {
                BOMMovementQty = BOMMovementQty.setScale(precision, RoundingMode.HALF_UP);
            }
            if ((bomproduct = new MProduct(this.getCtx(), bomLine.getM_Product_ID(), this.get_TrxName())).isBOM() && bomproduct.isPhantom()) {
                this.createBOM(mustBeStocked, bomproduct, BOMMovementQty);
            } else {
                defaultLocator.set(bomproduct.getM_Locator_ID());
                if (defaultLocator.get() == 0) {
                    defaultLocator.set(this.getM_Locator_ID());
                }
                if (!bomproduct.isStocked()) {
                    MProductionLine BOMLine = null;
                    BOMLine = new MProductionLine(this);
                    BOMLine.setLine(this.lineno);
                    BOMLine.setM_Product_ID(bomproduct.getM_Product_ID());
                    BOMLine.setM_Locator_ID(defaultLocator.get());
                    BOMLine.setQtyUsed(BOMMovementQty);
                    BOMLine.setPlannedQty(BOMMovementQty);
                    BOMLine.setMovementQty(BOMMovementQty.negate());
                    BOMLine.saveEx(this.get_TrxName());
                    this.lineno += 10;
                } else if (BOMMovementQty.signum() == 0) {
                    MProductionLine BOMLine = null;
                    BOMLine = new MProductionLine(this);
                    BOMLine.setLine(this.lineno);
                    BOMLine.setM_Product_ID(bomproduct.getM_Product_ID());
                    BOMLine.setM_Locator_ID(defaultLocator.get());
                    BOMLine.setQtyUsed(BOMMovementQty);
                    BOMLine.setPlannedQty(BOMMovementQty);
                    BOMLine.saveEx(this.get_TrxName());
                    this.lineno += 10;
                } else {
                    MProductionLine BOMLine = null;
                    BOMLine = new MProductionLine(this);
                    BOMLine.setLine(this.lineno);
                    BOMLine.setM_Product_ID(bomproduct.getM_Product_ID());
                    BOMLine.setM_Locator_ID(defaultLocator.get());
                    BOMLine.setPlannedQty(BOMMovementQty);
                    BOMLine.setQtyReserved(BOMMovementQty);
                    BOMLine.setMovementQty(BOMMovementQty.negate());
                    BOMLine.saveEx(this.get_TrxName());
                    this.lineno += 10;
                }
            }
        });
        return "";
    }

    private String recalculate() {
        int M_Warehouse_ID;
        MProduct product = MProduct.get(this.getCtx(), this.getM_Product_ID());
        MAcctSchema as = MClient.get(this.getCtx()).getAcctSchema();
        MCostType ct = MCostType.getByMethodCosting(as, as.getCostingMethod());
        String costingLevel = product.getCostingLevel(as);
        if (!as.getM_CostType().getCostingMethod().equals("S")) {
            return "";
        }
        int AD_Org_ID = costingLevel.equals("O") ? this.getAD_Org_ID() : 0;
        int n = M_Warehouse_ID = costingLevel.equals("W") ? this.getM_Locator().getM_Warehouse_ID() : 0;
        if (!as.getM_CostType().getCostingMethod().equals("S")) {
            return "";
        }
        ProcessInfo processInfo = ProcessBuilder.create(this.getCtx()).process(53062).withRecordId(Table_ID, this.getM_Product_ID()).withParameter("C_AcctSchema_ID", as.getC_AcctSchema_ID()).withParameter("S_Resource_ID", as.getC_AcctSchema_ID()).withParameter("", as.getCostingMethod()).withParameter("M_CostType_ID", ct.getM_CostType_ID()).withParameter("ADOrg_ID", AD_Org_ID).withParameter("M_Warehouse_ID", M_Warehouse_ID).withParameter("CostingMethod", as.getCostingMethod()).withoutTransactionClose().execute(this.get_TrxName());
        if (processInfo.isError()) {
            throw new AdempiereException(processInfo.getSummary());
        }
        log.info(processInfo.getSummary());
        return "";
    }

    public BigDecimal getQty(X_PP_Product_BOMLine bLine, boolean includeScrapQty) {
        int precision = MUOM.getPrecision(this.getCtx(), bLine.getC_UOM_ID());
        BigDecimal qty = bLine.isQtyPercentage() ? bLine.getQtyBatch().divide(Env.ONEHUNDRED, precision += 2, RoundingMode.HALF_UP) : bLine.getQtyBOM();
        if (includeScrapQty) {
            BigDecimal scrapDec = bLine.getScrap().divide(Env.ONEHUNDRED, 12, RoundingMode.UP);
            qty = qty.divide(Env.ONE.subtract(scrapDec), precision, RoundingMode.HALF_UP);
        }
        return qty;
    }
}

