/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Properties;
import org.adempiere.core.domains.models.X_M_ProductionBatchLine;
import org.compiere.model.MStorage;
import org.compiere.model.Query;
import org.compiere.util.Env;

public class MProductionBatchLine
extends X_M_ProductionBatchLine {
    private static final long serialVersionUID = 8836637198723346713L;

    public MProductionBatchLine(Properties ctx, int M_PBatch_Line_ID, String trxName) {
        super(ctx, M_PBatch_Line_ID, trxName);
    }

    public MProductionBatchLine(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public static MProductionBatchLine getbyProduct(int M_ProductionBatch_ID, int M_Product_ID, Properties ctx, String TrxName) {
        String whereClause = "M_ProductionBatch_ID=? and M_Product_ID =?";
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(M_ProductionBatch_ID);
        params.add(M_Product_ID);
        MProductionBatchLine pbLine = (MProductionBatchLine)new Query(Env.getCtx(), "M_ProductionBatchLine", whereClause, TrxName).setParameters(params).first();
        return pbLine;
    }

    @Override
    protected boolean afterDelete(boolean success) {
        if (this.getQtyReserved().signum() == 0) {
            return true;
        }
        BigDecimal diff = this.getQtyReserved();
        BigDecimal reservedQty = Env.ZERO;
        BigDecimal orderedQty = Env.ZERO;
        if (this.isEndProduct()) {
            orderedQty = diff;
        } else {
            reservedQty = diff.negate();
        }
        return MStorage.add(this.getCtx(), this.getM_ProductionBatch().getM_Locator().getM_Warehouse_ID(), this.getM_ProductionBatch().getM_Locator_ID(), this.getM_Product_ID(), 0, 0, Env.ZERO, reservedQty, orderedQty, this.get_TrxName());
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        BigDecimal oldValue = (BigDecimal)this.get_ValueOld("QtyReserved");
        BigDecimal diff = newRecord ? oldValue : this.getQtyReserved().subtract(oldValue);
        BigDecimal reservedQty = Env.ZERO;
        BigDecimal orderedQty = Env.ZERO;
        if (this.isEndProduct()) {
            orderedQty = diff;
        } else {
            reservedQty = diff;
        }
        MStorage.add(this.getCtx(), this.getM_ProductionBatch().getM_Locator().getM_Warehouse_ID(), this.getM_ProductionBatch().getM_Locator_ID(), this.getM_Product_ID(), 0, 0, Env.ZERO, reservedQty, orderedQty.negate(), this.get_TrxName());
        return true;
    }
}

