/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.adempiere.core.domains.models.X_AD_Column;
import org.adempiere.core.domains.models.X_AD_RecentItem;
import org.compiere.model.MMenu;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTable;
import org.compiere.model.MUser;
import org.compiere.model.MWindow;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Util;

public class MRecentItem
extends X_AD_RecentItem {
    private static final long serialVersionUID = 8337619537799431984L;
    private static CLogger log = CLogger.getCLogger(MRecentItem.class);
    private static CCache<String, MRecentItem> cache = new CCache("AD_RecentItem", 10);
    private static CCache<Integer, Integer> windowcache = new CCache("AD_Window", 10);

    public MRecentItem(Properties ctx, int AD_RecentItem_ID, String trxName) {
        super(ctx, AD_RecentItem_ID, trxName);
    }

    public MRecentItem(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public static MRecentItem get(Properties ctx, int AD_RecentItem_ID) {
        Integer ii = AD_RecentItem_ID;
        MRecentItem recentItem = cache.get(ii);
        if (recentItem == null) {
            recentItem = new MRecentItem(ctx, AD_RecentItem_ID, null);
        }
        if (recentItem.getAD_RecentItem_ID() > 0 && recentItem.getAD_Window_ID() != 0 && recentItem.getAD_Menu_ID() != 0) {
            windowcache.put(recentItem.getAD_Window_ID(), recentItem.getAD_Menu_ID());
        }
        return recentItem;
    }

    public static MRecentItem getFromMenuOption(Properties ctx, int userId, int roleId, int menuId) {
        String key = "OptionMenu|" + userId + "|" + roleId + "|" + menuId;
        MRecentItem item = cache.get(key);
        if (item == null) {
            item = (MRecentItem)new Query(ctx, "AD_RecentItem", "AD_User_ID = " + userId + " AND AD_Role_ID = " + roleId + " AND AD_Menu_ID = " + menuId, null).setClient_ID().setOrderBy("Updated DESC").first();
            if (item == null) {
                return new MRecentItem(ctx, 0, null);
            }
            cache.put(key, item);
        }
        return item;
    }

    public static MRecentItem getFromWindowChange(Properties ctx, int userId, int roleId, int tableId, int recordId, int windowId) {
        String key = "WindowChange|" + userId + "|" + roleId + "|" + tableId + "|" + recordId + "|" + windowId;
        MRecentItem item = cache.get(key);
        if (item == null) {
            item = (MRecentItem)new Query(ctx, "AD_RecentItem", "AD_User_ID = " + userId + " AND AD_Role_ID = " + roleId + " AND AD_Window_ID = " + windowId + " AND (AD_Table_ID = " + tableId + " OR AD_Table_ID IS NULL) AND (Record_ID = " + recordId + " OR Record_ID IS NULL)", null).first();
            if (item == null) {
                return new MRecentItem(ctx, 0, null);
            }
            cache.put(key, item);
        }
        return item;
    }

    public static int getMaxRecentItemsToSave(Properties ctx, int userId) {
        MUser user = MUser.get(ctx, userId);
        int maxRecentItems = 0;
        if (user != null) {
            maxRecentItems = user.getRecentItemsMaxSaved();
        }
        if (maxRecentItems <= 0) {
            maxRecentItems = MSysConfig.getIntValue("RecentItems_MaxSaved", 50, Env.getAD_Client_ID(ctx));
        }
        return maxRecentItems;
    }

    public static int getMaxRecentItemsToShown(Properties ctx, int userId) {
        MUser user = MUser.get(ctx, userId);
        int maxRecentItems = 0;
        if (user != null) {
            maxRecentItems = user.getRecentItemsMaxShown();
        }
        if (maxRecentItems <= 0) {
            maxRecentItems = MSysConfig.getIntValue("RecentItems_MaxShown", 50, Env.getAD_Client_ID(ctx));
        }
        return maxRecentItems;
    }

    public static void addChange(Properties ctx, int userId, int roleId, int tableId, int recordId, int windowId, int tabId, int menuId) {
        if (userId < 0) {
            return;
        }
        MRecentItem recentItem = null;
        String key = null;
        if (menuId != 0) {
            recentItem = MRecentItem.getFromMenuOption(ctx, userId, roleId, menuId);
            key = "OptionMenu|" + userId + "|" + roleId + "|" + menuId;
        } else {
            recentItem = MRecentItem.getFromWindowChange(ctx, userId, roleId, tableId, recordId, windowId);
            key = "WindowChange|" + userId + "|" + roleId + "|" + tableId + "|" + recordId + "|" + windowId;
        }
        recentItem.setAD_User_ID(userId);
        recentItem.setAD_Role_ID(roleId);
        if (menuId != 0) {
            recentItem.setAD_Menu_ID(menuId);
            recentItem.setAD_Window_ID(windowId);
            windowcache.put(windowId, menuId);
        } else {
            if (menuId == 0) {
                menuId = windowcache.get(windowId);
            }
            recentItem.setAD_Table_ID(tableId);
            recentItem.setRecord_ID(recordId);
            recentItem.setAD_Window_ID(windowId);
            recentItem.setAD_Tab_ID(tabId);
            recentItem.setAD_Menu_ID(menuId);
        }
        if (!recentItem.is_new() && !recentItem.is_Changed()) {
            MRecentItem.touchUpdatedRecord(recentItem.getAD_RecentItem_ID());
        } else if (recentItem.save()) {
            cache.put(key, recentItem);
        }
    }

    public static void addWindowChange(Properties ctx, int userId, int roleId, int tableId, int recordId, int windowId, int tabId) {
        MRecentItem.addChange(ctx, userId, roleId, tableId, recordId, windowId, tabId, 0);
    }

    public static void addWindowChange(Properties ctx, int tableId, int recordId, int windowId, int tabId) {
        try {
            MRecentItem.addWindowChange(ctx, Env.getAD_User_ID(ctx), Env.getAD_Role_ID(ctx), tableId, recordId, windowId, tabId);
        }
        catch (Exception e) {
            log.warning(e.getLocalizedMessage());
        }
    }

    public static void addMenuOption(Properties ctx, int userId, int roleId, int menuId, int windowId) {
        try {
            MRecentItem.addChange(ctx, userId, roleId, 0, 0, windowId, 0, menuId);
        }
        catch (Exception e) {
            log.warning(e.getLocalizedMessage());
        }
    }

    public static void addMenuOption(Properties ctx, int menuId, int windowId) {
        try {
            MRecentItem.addMenuOption(ctx, Env.getAD_User_ID(ctx), Env.getAD_Role_ID(ctx), menuId, windowId);
        }
        catch (Exception e) {
            log.warning(e.getLocalizedMessage());
        }
    }

    public static void touchUpdatedRecord(int recentItemId) {
        if (recentItemId != 0) {
            DB.executeUpdate("UPDATE AD_RecentItem SET Updated=SYSDATE WHERE AD_RecentItem_ID=?", recentItemId, null);
        }
    }

    @Override
    public boolean delete(boolean force) {
        Integer ii = this.getAD_RecentItem_ID();
        cache.remove(ii);
        return super.delete(force);
    }

    public static List<MRecentItem> getFromUserAndRole(Properties ctx, int userId, int roleId, boolean isForShow) {
        int limit;
        List<MRecentItem> recentItems = new Query(ctx, "AD_RecentItem", "AD_User_ID = ? AND AD_Role_ID = ?", null).setOnlyActiveRecords(true).setClient_ID().setParameters(userId, roleId).setOrderBy("Updated DESC").list();
        if (isForShow && (limit = MRecentItem.getMaxRecentItemsToShown(ctx, userId)) > 0) {
            return recentItems.stream().limit(limit).collect(Collectors.toList());
        }
        return recentItems;
    }

    public static List<MRecentItem> getFromUserAndRole(Properties ctx) {
        try {
            return MRecentItem.getFromUserAndRole(ctx, Env.getAD_User_ID(ctx), Env.getAD_Role_ID(ctx), true);
        }
        catch (Exception e) {
            log.warning(e.getLocalizedMessage());
            return null;
        }
    }

    public boolean isOptionMenu() {
        return this.getAD_Menu_ID() != 0 && this.getRecord_ID() == 0;
    }

    public String getLabel() {
        String optionName = null;
        StringBuffer identifier = new StringBuffer();
        if (this.isOptionMenu()) {
            MMenu menu = MMenu.getFromId(this.getCtx(), this.getAD_Menu_ID());
            optionName = menu.get_Translation("Name");
        } else {
            MWindow win = new MWindow(this.getCtx(), this.getAD_Window_ID(), null);
            optionName = win.get_Translation("Name");
            MTable table2 = MTable.get(this.getCtx(), this.getAD_Table_ID());
            PO po = table2.getPO(this.getRecord_ID(), null);
            if (po == null) {
                return null;
            }
            identifier.append(": ");
            table2.getColumnsAsList().stream().sorted(Comparator.comparing(X_AD_Column::getSeqNo)).filter(entry -> entry.isIdentifier() && po.get_Value(entry.getColumnName()) != null && !Util.isEmpty(po.get_DisplayValue(entry.getColumnName(), true))).forEach(column -> {
                String displayColumn = po.get_DisplayValue(column.getColumnName(), true);
                if (identifier.length() > 0) {
                    identifier.append("_");
                }
                identifier.append(displayColumn);
            });
            if (identifier.length() == 0) {
                identifier.append("<").append(po.get_ID()).append(">");
            }
        }
        return optionName + identifier;
    }

    public static int deleteExtraItems(Properties ctx, int userId, int roleId) {
        ArrayList<Integer> recentItemId = new ArrayList<Integer>();
        int maxRecentItems = MRecentItem.getMaxRecentItemsToSave(ctx, userId);
        if (maxRecentItems <= 0) {
            return 0;
        }
        List<MRecentItem> items = MRecentItem.getFromUserAndRole(ctx, userId, roleId, false);
        if (items != null && items.size() > maxRecentItems) {
            for (int i2 = maxRecentItems - 1; i2 < items.size(); ++i2) {
                recentItemId.add(items.get(i2).getAD_RecentItem_ID());
            }
        }
        if (recentItemId.size() == 0) {
            return 0;
        }
        int deleted = DB.executeUpdate("DELETE FROM AD_RecentItem WHERE AD_RecentItem_ID IN" + ((Object)recentItemId).toString().replace('[', '(').replace(']', ')'), null);
        return deleted;
    }

    public static int deleteExtraItems(Properties ctx) {
        try {
            return MRecentItem.deleteExtraItems(ctx, Env.getAD_User_ID(ctx), Env.getAD_Role_ID(ctx));
        }
        catch (Exception e) {
            log.warning(e.getLocalizedMessage());
            return 0;
        }
    }
}

