/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.core.domains.models.X_R_RequestProcessor;
import org.compiere.model.AdempiereProcessor;
import org.compiere.model.AdempiereProcessorLog;
import org.compiere.model.MClient;
import org.compiere.model.MRequestProcessorLog;
import org.compiere.model.MRequestProcessorRoute;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Msg;

public class MRequestProcessor
extends X_R_RequestProcessor
implements AdempiereProcessor {
    private static final long serialVersionUID = -3149710397208186523L;
    private static CLogger s_log = CLogger.getCLogger(MRequestProcessor.class);
    private MRequestProcessorRoute[] m_routes = null;

    public static MRequestProcessor[] getActive(Properties ctx) {
        ArrayList<MRequestProcessor> list = new ArrayList<MRequestProcessor>();
        String sql = "SELECT * FROM R_RequestProcessor WHERE IsActive='Y'";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MRequestProcessor(ctx, rs, null));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        MRequestProcessor[] retValue = new MRequestProcessor[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public MRequestProcessor(Properties ctx, int R_RequestProcessor_ID, String trxName) {
        super(ctx, R_RequestProcessor_ID, trxName);
        if (R_RequestProcessor_ID == 0) {
            this.setFrequencyType("D");
            this.setFrequency(0);
            this.setKeepLogDays(7);
            this.setOverdueAlertDays(0);
            this.setOverdueAssignDays(0);
            this.setRemindDays(0);
        }
    }

    public MRequestProcessor(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MRequestProcessor(MClient parent, int Supervisor_ID) {
        this(parent.getCtx(), 0, parent.get_TrxName());
        this.setClientOrg(parent);
        this.setName(parent.getName() + " - " + Msg.translate(this.getCtx(), "R_RequestProcessor_ID"));
        this.setSupervisor_ID(Supervisor_ID);
    }

    public MRequestProcessorRoute[] getRoutes(boolean reload) {
        if (this.m_routes != null && !reload) {
            return this.m_routes;
        }
        String sql = "SELECT * FROM R_RequestProcessor_Route WHERE R_RequestProcessor_ID=? ORDER BY SeqNo";
        ArrayList<MRequestProcessorRoute> list = new ArrayList<MRequestProcessorRoute>();
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, this.getR_RequestProcessor_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MRequestProcessorRoute(this.getCtx(), rs, this.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        this.m_routes = new MRequestProcessorRoute[list.size()];
        list.toArray(this.m_routes);
        return this.m_routes;
    }

    @Override
    public AdempiereProcessorLog[] getLogs() {
        ArrayList<MRequestProcessorLog> list = new ArrayList<MRequestProcessorLog>();
        String sql = "SELECT * FROM R_RequestProcessorLog WHERE R_RequestProcessor_ID=? ORDER BY Created DESC";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, this.getR_RequestProcessor_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MRequestProcessorLog(this.getCtx(), rs, this.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        AdempiereProcessorLog[] retValue = new MRequestProcessorLog[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public int deleteLog() {
        if (this.getKeepLogDays() < 1) {
            return 0;
        }
        String sql = "DELETE R_RequestProcessorLog WHERE R_RequestProcessor_ID=" + this.getR_RequestProcessor_ID() + " AND (Created+" + this.getKeepLogDays() + ") < SysDate";
        int no = DB.executeUpdate(sql, this.get_TrxName());
        return no;
    }

    @Override
    public Timestamp getDateNextRun(boolean requery) {
        if (requery) {
            this.load(this.get_TrxName());
        }
        return this.getDateNextRun();
    }

    @Override
    public String getServerID() {
        return "RequestProcessor" + this.get_ID();
    }
}

