/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.core.domains.models.X_R_StatusCategory;
import org.compiere.model.MStatus;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class MStatusCategory
extends X_R_StatusCategory {
    private static final long serialVersionUID = -7538457243144691380L;
    private static CCache<Integer, MStatusCategory> s_cache = new CCache("R_StatusCategory", 20);
    private static CLogger s_log = CLogger.getCLogger(MStatusCategory.class);
    private MStatus[] m_status = null;

    public static MStatusCategory getDefault(Properties ctx) {
        int AD_Client_ID = Env.getAD_Client_ID(ctx);
        String sql = "SELECT * FROM R_StatusCategory WHERE AD_Client_ID in (0,?) AND IsDefault='Y' ORDER BY AD_Client_ID DESC";
        MStatusCategory retValue = null;
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, AD_Client_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue = new MStatusCategory(ctx, rs, null);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        return retValue;
    }

    public static MStatusCategory createDefault(Properties ctx) {
        int AD_Client_ID = Env.getAD_Client_ID(ctx);
        MStatusCategory retValue = new MStatusCategory(ctx, 0, null);
        retValue.setClientOrg(AD_Client_ID, 0);
        retValue.setName(Msg.getMsg(ctx, "Standard"));
        retValue.setIsDefault(true);
        if (!retValue.save()) {
            return null;
        }
        String sql = "UPDATE R_Status SET R_StatusCategory_ID=" + retValue.getR_StatusCategory_ID() + " WHERE R_StatusCategory_ID IS NULL AND AD_Client_ID=" + AD_Client_ID;
        int no = DB.executeUpdate(sql, null);
        s_log.info("Default for AD_Client_ID=" + AD_Client_ID + " - Status #" + no);
        return retValue;
    }

    public static MStatusCategory get(Properties ctx, int R_StatusCategory_ID) {
        Integer key = R_StatusCategory_ID;
        MStatusCategory retValue = s_cache.get(key);
        if (retValue != null) {
            return retValue;
        }
        retValue = new MStatusCategory(ctx, R_StatusCategory_ID, null);
        if (retValue.get_ID() != 0) {
            s_cache.put(key, retValue);
        }
        return retValue;
    }

    public MStatusCategory(Properties ctx, int R_StatusCategory_ID, String trxName) {
        super(ctx, R_StatusCategory_ID, trxName);
        if (R_StatusCategory_ID == 0) {
            this.setIsDefault(false);
        }
    }

    public MStatusCategory(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MStatus[] getStatus(boolean reload) {
        if (this.m_status != null && !reload) {
            return this.m_status;
        }
        String sql = "SELECT * FROM R_Status WHERE R_StatusCategory_ID=? ORDER BY SeqNo";
        ArrayList<MStatus> list = new ArrayList<MStatus>();
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, this.getR_StatusCategory_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MStatus(this.getCtx(), rs, null));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        this.m_status = new MStatus[list.size()];
        list.toArray(this.m_status);
        return this.m_status;
    }

    public int getDefaultR_Status_ID() {
        if (this.m_status == null) {
            this.getStatus(false);
        }
        for (int i = 0; i < this.m_status.length; ++i) {
            if (!this.m_status[i].isDefault() || !this.m_status[i].isActive()) continue;
            return this.m_status[i].getR_Status_ID();
        }
        if (this.m_status.length > 0 && this.m_status[0].isActive()) {
            return this.m_status[0].getR_Status_ID();
        }
        return 0;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("RStatusCategory[");
        sb.append(this.get_ID()).append("-").append(this.getName()).append("]");
        return sb.toString();
    }
}

