/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.adempiere.core.domains.models.X_AD_Table_ScriptValidator;
import org.apache.commons.collections4.keyvalue.MultiKey;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.DB;

public class MTableScriptValidator
extends X_AD_Table_ScriptValidator {
    private static final long serialVersionUID = 6272423660330749776L;
    private static CCache<Integer, MTableScriptValidator> s_cache = new CCache("AD_Table_ScriptValidator", 20);
    private static CCache<MultiKey, List<MTableScriptValidator>> s_cacheTableEvent = new CCache("AD_Table_ScriptValidator_TableEvent", 20);

    public static MTableScriptValidator get(Properties ctx, int AD_Table_ScriptValidator_ID) {
        Integer key = AD_Table_ScriptValidator_ID;
        MTableScriptValidator retValue = s_cache.get(key);
        if (retValue != null) {
            return retValue;
        }
        retValue = new MTableScriptValidator(ctx, AD_Table_ScriptValidator_ID, null);
        if (retValue.get_ID() != 0) {
            s_cache.put(key, retValue);
        }
        return retValue;
    }

    public static List<MTableScriptValidator> getModelValidatorRules(Properties ctx, int tableId, String event) {
        MultiKey multiKey = new MultiKey((Object)tableId, (Object)event);
        List<MTableScriptValidator> tableScriptValidators = s_cacheTableEvent.get(multiKey);
        if (tableScriptValidators != null) {
            if (tableScriptValidators.size() > 0) {
                return tableScriptValidators;
            }
            return new ArrayList<MTableScriptValidator>();
        }
        String whereClause = "AD_Table_ID=? AND EventModelValidator=?";
        tableScriptValidators = new Query(ctx, "AD_Table_ScriptValidator", "AD_Table_ID=? AND EventModelValidator=?", null).setParameters(tableId, event).setOnlyActiveRecords(true).setOrderBy("SeqNo").list();
        for (MTableScriptValidator rule : tableScriptValidators) {
            s_cache.put(rule.get_ID(), rule);
        }
        if (tableScriptValidators != null) {
            s_cacheTableEvent.put(multiKey, tableScriptValidators);
        }
        if (tableScriptValidators != null && tableScriptValidators.size() > 0) {
            return tableScriptValidators;
        }
        return new ArrayList<MTableScriptValidator>();
    }

    public MTableScriptValidator(Properties ctx, int AD_Table_ScriptValidator_ID, String trxName) {
        super(ctx, AD_Table_ScriptValidator_ID, trxName);
    }

    public MTableScriptValidator(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.getSeqNo() == 0) {
            String sql = "SELECT COALESCE(MAX(SeqNo),0) + 10 FROM AD_Table_ScriptValidator WHERE AD_Table_ID=? AND EventModelValidator=?";
            int seqNo = DB.getSQLValueEx(this.get_TrxName(), "SELECT COALESCE(MAX(SeqNo),0) + 10 FROM AD_Table_ScriptValidator WHERE AD_Table_ID=? AND EventModelValidator=?", this.getAD_Table_ID(), this.getEventModelValidator());
            this.setSeqNo(seqNo);
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MTableScriptValidator[");
        sb.append(this.get_ID()).append("-").append(this.getAD_Table_ID()).append("-").append(this.getEventModelValidator()).append("]");
        return sb.toString();
    }
}

