/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.adempiere.core.domains.models.X_M_Transaction;
import org.adempiere.engine.CostEngineFactory;
import org.adempiere.engine.IDocumentLine;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInOutLineMA;
import org.compiere.model.Query;
import org.compiere.util.Env;

public class MTransaction
extends X_M_Transaction {
    private static final long serialVersionUID = 3411351000865493212L;

    public static MTransaction getByDocumentLine(IDocumentLine model, String type) {
        String column_id = model.get_TableName() + "_ID";
        String whereClause = column_id + "=? AND MovementType=? ";
        return (MTransaction)new Query(model.getCtx(), "M_Transaction", whereClause, model.get_TrxName()).setClient_ID().setParameters(model.get_ID(), type).first();
    }

    public static List<MTransaction> getAfterDateAcct(Properties ctx, int M_Product_ID, Timestamp dateAcct, String trxName) {
        ArrayList<MTransaction> list = new ArrayList<MTransaction>();
        String whereClause = "M_Product_ID=?";
        List trxs = new Query(ctx, "M_Transaction", "M_Product_ID=?", trxName).setClient_ID().setParameters(M_Product_ID).list();
        for (MTransaction trx : trxs) {
            IDocumentLine model = trx.getDocumentLine();
            if (model.getDateAcct().compareTo(dateAcct) <= 0) continue;
            list.add(trx);
        }
        return list;
    }

    public static List<MTransaction> getByInOutLine(MInOutLine line) {
        ArrayList<MTransaction> transactions = new ArrayList<MTransaction>();
        List<MInOutLineMA> lines = MInOutLineMA.get(line.getCtx(), line.getM_InOutLine_ID(), line.get_TrxName());
        if (lines != null && lines.size() == 0) {
            MTransaction transaction = MTransaction.get(line, line.getM_AttributeSetInstance_ID());
            if (transaction != null && transaction.get_ID() > 0) {
                transactions.add(transaction);
            }
            return transactions;
        }
        for (MInOutLineMA ma : lines) {
            MTransaction transaction = MTransaction.get(line, ma.getM_AttributeSetInstance_ID());
            if (transaction == null || transaction.get_ID() <= 0) continue;
            transactions.add(transaction);
        }
        return transactions;
    }

    public static MTransaction get(MInOutLine line, int M_ASI_ID) {
        String whereClause = "M_Product_ID=? AND M_InOutLine_ID=? AND M_AttributeSetInstance_ID=?";
        return (MTransaction)new Query(line.getCtx(), "M_Transaction", "M_Product_ID=? AND M_InOutLine_ID=? AND M_AttributeSetInstance_ID=?", line.get_TrxName()).setClient_ID().setParameters(line.getM_Product_ID(), line.getM_InOutLine_ID(), M_ASI_ID).firstOnly();
    }

    public static MTransaction getByDocumentLine(MTransaction trx) {
        IDocumentLine reversal = trx.getDocumentLine().getReversalDocumentLine();
        ArrayList<Object> parameters = new ArrayList<Object>();
        String columnName = reversal.get_TableName() + "_ID";
        StringBuffer whereClause = new StringBuffer("M_Product_ID");
        whereClause.append("=? AND ");
        parameters.add(reversal.getM_Product_ID());
        whereClause.append(columnName).append("=? AND ");
        parameters.add(reversal.get_ID());
        if (trx.getM_AttributeSetInstance_ID() > 0) {
            whereClause.append("M_AttributeSetInstance_ID").append("=? AND ");
            parameters.add(trx.getM_AttributeSetInstance_ID());
        }
        whereClause.append("MovementType").append("=? AND ");
        if ("I+".equals(trx.getMovementType())) {
            parameters.add("I-");
        } else if ("I-".equals(trx.getMovementType())) {
            parameters.add("I+");
        } else {
            parameters.add(trx.getMovementType());
        }
        whereClause.append("M_Transaction_ID").append("<>?");
        parameters.add(trx.getM_Transaction_ID());
        return (MTransaction)new Query(trx.getCtx(), "M_Transaction", whereClause.toString(), trx.get_TrxName()).setClient_ID().setParameters(parameters).first();
    }

    public MTransaction(Properties ctx, int M_Transaction_ID, String trxName) {
        super(ctx, M_Transaction_ID, trxName);
        if (M_Transaction_ID == 0) {
            this.setMovementDate(new Timestamp(System.currentTimeMillis()));
            this.setMovementQty(Env.ZERO);
        }
    }

    public MTransaction(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MTransaction(Properties ctx, int AD_Org_ID, String MovementType, int M_Locator_ID, int M_Product_ID, int M_AttributeSetInstance_ID, BigDecimal MovementQty, Timestamp MovementDate, String trxName) {
        super(ctx, 0, trxName);
        this.setAD_Org_ID(AD_Org_ID);
        this.setMovementType(MovementType);
        if (M_Locator_ID == 0) {
            throw new IllegalArgumentException("No Locator");
        }
        this.setM_Locator_ID(M_Locator_ID);
        if (M_Product_ID == 0) {
            throw new IllegalArgumentException("No Product");
        }
        this.setM_Product_ID(M_Product_ID);
        this.setM_AttributeSetInstance_ID(M_AttributeSetInstance_ID);
        if (MovementQty != null) {
            this.setMovementQty(MovementQty);
        }
        if (MovementDate == null) {
            this.setMovementDate(new Timestamp(System.currentTimeMillis()));
        } else {
            this.setMovementDate(MovementDate);
        }
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (newRecord) {
            CostEngineFactory.getCostEngine(this.getAD_Client_ID()).createCostDetail(this, this.getDocumentLine());
        }
        return true;
    }

    public IDocumentLine getDocumentLine() {
        if (this.getM_InOutLine_ID() > 0) {
            return (IDocumentLine)((Object)this.getM_InOutLine());
        }
        if (this.getM_InventoryLine_ID() > 0) {
            return (IDocumentLine)((Object)this.getM_InventoryLine());
        }
        if (this.getM_MovementLine_ID() > 0) {
            return (IDocumentLine)((Object)this.getM_MovementLine());
        }
        if (this.getM_ProductionLine_ID() > 0) {
            return (IDocumentLine)((Object)this.getM_ProductionLine());
        }
        if (this.getPP_Cost_Collector_ID() > 0) {
            return (IDocumentLine)((Object)this.getPP_Cost_Collector());
        }
        if (this.getC_ProjectIssue_ID() > 0) {
            return (IDocumentLine)((Object)this.getC_ProjectIssue());
        }
        return null;
    }

    public int getM_Warehouse_ID() {
        return this.getM_Locator().getM_Warehouse_ID();
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MTransaction[");
        sb.append(this.get_ID()).append(",").append(this.getMovementType()).append(",MovementDate=").append(this.getMovementDate()).append(",Qty=").append(this.getMovementQty()).append(",M_Product_ID=").append(this.getM_Product_ID()).append(",ASI=").append(this.getM_AttributeSetInstance_ID()).append("]");
        return sb.toString();
    }

    public Timestamp getDateAcct() {
        if (this.getM_InOutLine_ID() != 0) {
            return this.getM_InOutLine().getM_InOut().getDateAcct();
        }
        if (this.getM_InventoryLine_ID() != 0) {
            return this.getM_InventoryLine().getM_Inventory().getMovementDate();
        }
        if (this.getM_MovementLine_ID() != 0) {
            return this.getM_MovementLine().getM_Movement().getMovementDate();
        }
        if (this.getM_ProductionLine_ID() != 0) {
            return this.getM_ProductionLine().getM_Production().getMovementDate();
        }
        if (this.getC_ProjectIssue_ID() != 0) {
            return this.getC_ProjectIssue().getMovementDate();
        }
        if (this.getPP_Cost_Collector_ID() != 0) {
            return this.getPP_Cost_Collector().getDateAcct();
        }
        return null;
    }
}

