/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import org.adempiere.core.domains.models.X_C_UOM;
import org.compiere.model.MTable;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Ini;

public class MUOM
extends X_C_UOM {
    private static final long serialVersionUID = -7248044516358949324L;
    public static final String X12_SECOND = "03";
    public static final String X12_MINUTE = "MJ";
    public static final String X12_HOUR = "HR";
    public static final String X12_DAY = "DA";
    public static final String X12_DAY_WORK = "WD";
    public static final String X12_WEEK = "WK";
    public static final String X12_MONTH = "MO";
    public static final String X12_MONTH_WORK = "WM";
    public static final String X12_YEAR = "YR";
    private static CCache<Integer, MUOM> s_cache = new CCache("C_UOM", 30);

    public static int getMinute_UOM_ID(Properties ctx) {
        if (Ini.isClient()) {
            for (MUOM uom : s_cache.values()) {
                if (!uom.isMinute()) continue;
                return uom.getC_UOM_ID();
            }
        }
        String sql = "SELECT C_UOM_ID FROM C_UOM WHERE IsActive='Y' AND X12DE355=?";
        return DB.getSQLValue(null, sql, X12_MINUTE);
    }

    public static int getDefault_UOM_ID(Properties ctx) {
        String sql = "SELECT C_UOM_ID FROM C_UOM WHERE AD_Client_ID IN (0,?) ORDER BY IsDefault DESC, AD_Client_ID DESC, C_UOM_ID";
        return DB.getSQLValue(null, sql, Env.getAD_Client_ID(ctx));
    }

    public static MUOM get(Properties ctx, int C_UOM_ID) {
        MUOM uom;
        if (s_cache.size() == 0) {
            MUOM.loadUOMs(ctx);
        }
        if ((uom = s_cache.get(C_UOM_ID)) != null) {
            return uom;
        }
        uom = new MUOM(ctx, C_UOM_ID, null);
        s_cache.put(C_UOM_ID, uom);
        return uom;
    }

    public static MUOM get(Properties ctx, String name, String trxName) {
        MTable table2 = MTable.get(Env.getCtx(), Table_ID);
        MUOM uom = (MUOM)table2.getPO("Name = ?", new Object[]{name}, trxName);
        return uom;
    }

    public static int getPrecision(Properties ctx, int C_UOM_ID) {
        MUOM uom = MUOM.get(ctx, C_UOM_ID);
        return uom.getStdPrecision();
    }

    private static void loadUOMs(Properties ctx) {
        List list = new Query(ctx, "C_UOM", "IsActive='Y'", null).setApplyAccessFilter(false, false).list();
        for (MUOM uom : list) {
            s_cache.put(uom.get_ID(), uom);
        }
    }

    public MUOM(Properties ctx, int C_UOM_ID, String trxName) {
        super(ctx, C_UOM_ID, trxName);
        if (C_UOM_ID == 0) {
            this.setIsDefault(false);
            this.setStdPrecision(2);
            this.setCostingPrecision(6);
        }
    }

    public MUOM(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("UOM[");
        sb.append("ID=").append(this.get_ID()).append(", Name=").append(this.getName());
        return sb.toString();
    }

    public BigDecimal round(BigDecimal qty, boolean stdPrecision) {
        int precision = this.getStdPrecision();
        if (!stdPrecision) {
            precision = this.getCostingPrecision();
        }
        if (qty.scale() > precision) {
            return qty.setScale(this.getStdPrecision(), RoundingMode.HALF_UP);
        }
        return qty;
    }

    public boolean isSecond() {
        return X12_SECOND.equals(this.getX12DE355());
    }

    public boolean isMinute() {
        return X12_MINUTE.equals(this.getX12DE355());
    }

    public boolean isHour() {
        return X12_HOUR.equals(this.getX12DE355());
    }

    public boolean isDay() {
        return X12_DAY.equals(this.getX12DE355());
    }

    public boolean isWorkDay() {
        return X12_DAY_WORK.equals(this.getX12DE355());
    }

    public boolean isWeek() {
        return X12_WEEK.equals(this.getX12DE355());
    }

    public boolean isMonth() {
        return X12_MONTH.equals(this.getX12DE355());
    }

    public boolean isWorkMonth() {
        return X12_MONTH_WORK.equals(this.getX12DE355());
    }

    public boolean isYear() {
        return X12_YEAR.equals(this.getX12DE355());
    }
}

