/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.script.ScriptEngine;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.model.ImportValidator;
import org.adempiere.process.ImportProcess;
import org.compiere.acct.Fact;
import org.compiere.model.FactsValidator;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MClient;
import org.compiere.model.MRule;
import org.compiere.model.MSystem;
import org.compiere.model.MTableScriptValidator;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Util;

public class ModelValidationEngine {
    private static ModelValidationEngine modelValidatorEngine = null;
    private static String missingModelValidationMessage = null;
    private static CLogger log = CLogger.getCLogger(ModelValidationEngine.class);
    private List<String> validatorClasses = new ArrayList<String>();
    private List<ModelValidator> validators = new ArrayList<ModelValidator>();
    private Hashtable<String, List<ModelValidator>> modelChangeListeners = new Hashtable();
    private Hashtable<String, List<ModelValidator>> documentValidateListeners = new Hashtable();
    private Hashtable<String, List<FactsValidator>> factsValidateListeners = new Hashtable();
    private Hashtable<String, List<ImportValidator>> importValidateListeners = new Hashtable();
    private List<ModelValidator> globalValidators = new ArrayList<ModelValidator>();

    public static synchronized ModelValidationEngine get() {
        if (modelValidatorEngine == null) {
            modelValidatorEngine = new ModelValidationEngine();
        }
        return modelValidatorEngine;
    }

    private ModelValidationEngine() {
        try {
            List entityTypes = new Query(Env.getCtx(), "AD_ModelValidator", null, null).setOnlyActiveRecords(true).setOrderBy("SeqNo").list();
            entityTypes.stream().filter(validator -> !Util.isEmpty(validator.getModelValidationClass())).forEach(validator -> this.loadValidatorClass(validator.getAD_Client_ID() == 0 ? null : MClient.get(Env.getCtx(), validator.getAD_Client_ID()), validator.getModelValidationClass()));
        }
        catch (Exception e) {
            missingModelValidationMessage = missingModelValidationMessage + e.toString() + " global\n";
        }
        Optional.ofNullable(MClient.getAll(Env.getCtx())).ifPresent(clientList -> Arrays.stream(clientList).filter(client -> client.getModelValidationClasses() != null && client.getModelValidationClasses().length() > 0).forEach(client -> this.loadValidatorClasses((MClient)client, client.getModelValidationClasses())));
    }

    private void loadValidatorClasses(MClient client, String classNames) {
        StringTokenizer st = new StringTokenizer(classNames, ";");
        while (st.hasMoreTokens()) {
            String className = null;
            try {
                className = st.nextToken();
                if (className == null || (className = className.trim()).length() == 0) continue;
                this.loadValidatorClass(client, className);
            }
            catch (Exception e) {
                missingModelValidationMessage = missingModelValidationMessage + e.toString() + " on client " + client.getName() + "\n";
            }
        }
    }

    private void loadValidatorClass(MClient client, String className) {
        if (this.existValidatorClass(className)) {
            log.warning((String)(client != null ? "client " + client.getName() : " global") + " already exists for class: " + className);
            return;
        }
        try {
            Class<?> clazz = Class.forName(className);
            ModelValidator validator = (ModelValidator)clazz.newInstance();
            this.initialize(validator, client);
        }
        catch (Exception e) {
            missingModelValidationMessage = missingModelValidationMessage + e.toString() + (String)(client != null ? " on client " + client.getName() : " global") + "\n";
        }
    }

    private void initialize(ModelValidator validator, MClient client) {
        if (client == null) {
            this.globalValidators.add(validator);
        }
        this.validators.add(validator);
        validator.initialize(this, client);
    }

    private boolean existValidatorClass(String validatorClass) {
        if (Util.isEmpty(validatorClass)) {
            return true;
        }
        boolean alreadyExist = this.validatorClasses.stream().filter(validatorClassToFind -> validatorClassToFind.equals(validatorClass)).findFirst().isPresent();
        if (!alreadyExist) {
            this.validatorClasses.add(validatorClass);
        }
        return alreadyExist;
    }

    public String loginComplete(int clientId, int orgId, int roleId, int userId) {
        MSystem system;
        Optional.ofNullable(this.validators).ifPresent(ValidatorList -> ValidatorList.stream().filter(modelValidator -> modelValidator.getAD_Client_ID() == clientId || this.globalValidators.contains(modelValidator)).forEach(modelValidator -> {
            String error = modelValidator.login(orgId, roleId, userId);
            if (error != null && error.length() > 0) {
                throw new AdempiereException(error);
            }
        }));
        Optional.ofNullable(MRule.getModelValidatorLoginRules(Env.getCtx())).ifPresent(rules -> rules.stream().filter(Objects::nonNull).filter(loginRule -> loginRule.getRuleType().equals("S") && loginRule.getEventType().equals("L")).forEach(loginRule -> {
            String error;
            try {
                ScriptEngine engine = loginRule.getScriptEngine();
                MRule.setContext(engine, Env.getCtx(), 0);
                engine.put("A_Ctx", Env.getCtx());
                engine.put("A_AD_Client_ID", clientId);
                engine.put("A_AD_Org_ID", orgId);
                engine.put("A_AD_Role_ID", roleId);
                engine.put("A_AD_User_ID", userId);
                Object retval = engine.eval(loginRule.getScript());
                error = retval == null ? "" : retval.toString();
            }
            catch (Exception e) {
                throw new AdempiereException(e);
            }
            if (error != null && error.length() > 0) {
                throw new AdempiereException(error);
            }
        }));
        if ((userId != 0 || roleId != 0) && missingModelValidationMessage != null && (system = MSystem.get(Env.getCtx())).isFailOnMissingModelValidator()) {
            return missingModelValidationMessage;
        }
        return null;
    }

    public void addModelChange(String tableName, ModelValidator listener) {
        if (tableName == null || listener == null) {
            return;
        }
        String propertyName = this.globalValidators.contains(listener) ? tableName + "*" : tableName + listener.getAD_Client_ID();
        List<ModelValidator> modelValidators = this.modelChangeListeners.get(propertyName);
        if (modelValidators == null) {
            modelValidators = new ArrayList<ModelValidator>();
            modelValidators.add(listener);
            this.modelChangeListeners.put(propertyName, modelValidators);
        } else {
            modelValidators.add(listener);
        }
    }

    public void removeModelChange(String tableName, ModelValidator listener) {
        if (tableName == null || listener == null) {
            return;
        }
        String propertyName = this.globalValidators.contains(listener) ? tableName + "*" : tableName + listener.getAD_Client_ID();
        List<ModelValidator> modelValidators = this.modelChangeListeners.get(propertyName);
        if (modelValidators == null) {
            return;
        }
        modelValidators.remove(listener);
        if (modelValidators.size() == 0) {
            this.modelChangeListeners.remove(propertyName);
        }
    }

    public String fireModelChange(PO po, int changeType) {
        String error;
        if (po == null || this.modelChangeListeners.size() == 0) {
            return null;
        }
        String propertyName = po.get_TableName() + "*";
        List<ModelValidator> modelValidators = this.modelChangeListeners.get(propertyName);
        if (modelValidators != null && (error = this.fireModelChange(po, changeType, modelValidators)) != null && error.length() > 0) {
            return error;
        }
        propertyName = po.get_TableName() + po.getAD_Client_ID();
        modelValidators = this.modelChangeListeners.get(propertyName);
        if (modelValidators != null && (error = this.fireModelChange(po, changeType, modelValidators)) != null && error.length() > 0) {
            return error;
        }
        Optional.ofNullable(MTableScriptValidator.getModelValidatorRules(po.getCtx(), po.get_Table_ID(), ModelValidator.tableEventValidators[changeType])).ifPresent(tableScriptValidatorList -> tableScriptValidatorList.stream().filter(Objects::nonNull).forEach(tableScriptValidator -> {
            MRule rule = MRule.get(po.getCtx(), tableScriptValidator.getAD_Rule_ID());
            if (rule != null && rule.isActive() && rule.getRuleType().equals("S") && rule.getEventType().equals("T")) {
                String error;
                try {
                    ScriptEngine engine = rule.getScriptEngine();
                    MRule.setContext(engine, po.getCtx(), 0);
                    engine.put("A_Ctx", po.getCtx());
                    engine.put("A_PO", po);
                    engine.put("A_Type", changeType);
                    engine.put("A_Event", ModelValidator.tableEventValidators[changeType]);
                    Object retval = engine.eval(rule.getScript());
                    error = retval == null ? "" : retval.toString();
                }
                catch (Exception e) {
                    throw new AdempiereException(e);
                }
                if (error != null && error.length() > 0) {
                    throw new AdempiereException(error);
                }
            }
        }));
        return null;
    }

    private String fireModelChange(PO po, int changeType, List<ModelValidator> modelValidators) {
        Optional.ofNullable(modelValidators).ifPresent(modelValidatorList -> modelValidatorList.stream().filter(modelValidator -> modelValidator.getAD_Client_ID() == po.getAD_Client_ID() || this.globalValidators.contains(modelValidator)).forEach(modelValidator -> {
            try {
                String error = modelValidator.modelChange(po, changeType);
                if (error != null && error.length() > 0) {
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "po=" + po + " validator=" + modelValidator + " changeType=" + changeType);
                    }
                    throw new AdempiereException(error);
                }
            }
            catch (Exception e) {
                log.log(Level.SEVERE, e.getLocalizedMessage(), e);
                String error = e.getLocalizedMessage();
                if (error == null) {
                    error = e.toString();
                }
                throw new AdempiereException(error);
            }
        }));
        return null;
    }

    public void addDocValidate(String tableName, ModelValidator listener) {
        if (tableName == null || listener == null) {
            return;
        }
        String propertyName = this.globalValidators.contains(listener) ? tableName + "*" : tableName + listener.getAD_Client_ID();
        List<ModelValidator> modelValidators = this.documentValidateListeners.get(propertyName);
        if (modelValidators == null) {
            modelValidators = new ArrayList<ModelValidator>();
            modelValidators.add(listener);
            this.documentValidateListeners.put(propertyName, modelValidators);
        } else if (!modelValidators.contains(listener)) {
            modelValidators.add(listener);
        }
    }

    public void removeDocValidate(String tableName, ModelValidator listener) {
        if (tableName == null || listener == null) {
            return;
        }
        String propertyName = this.globalValidators.contains(listener) ? tableName + "*" : tableName + listener.getAD_Client_ID();
        List<ModelValidator> modelValidators = this.documentValidateListeners.get(propertyName);
        if (modelValidators == null) {
            return;
        }
        modelValidators.remove(listener);
        if (modelValidators.size() == 0) {
            this.documentValidateListeners.remove(propertyName);
        }
    }

    public String fireDocValidate(PO po, int docTiming) {
        String error;
        if (po == null || this.documentValidateListeners.size() == 0) {
            return null;
        }
        String propertyName = po.get_TableName() + "*";
        List<ModelValidator> modelValidators = this.documentValidateListeners.get(propertyName);
        if (modelValidators != null && (error = this.fireDocValidate(po, docTiming, modelValidators)) != null && error.length() > 0) {
            return error;
        }
        propertyName = po.get_TableName() + po.getAD_Client_ID();
        modelValidators = this.documentValidateListeners.get(propertyName);
        if (modelValidators != null && (error = this.fireDocValidate(po, docTiming, modelValidators)) != null && error.length() > 0) {
            return error;
        }
        List<MTableScriptValidator> tableScriptValidators = MTableScriptValidator.getModelValidatorRules(po.getCtx(), po.get_Table_ID(), ModelValidator.documentEventValidators[docTiming]);
        Optional.ofNullable(tableScriptValidators).ifPresent(tableScriptValidatorList -> tableScriptValidatorList.stream().filter(Objects::nonNull).forEach(tableScriptValidator -> {
            MRule rule = MRule.get(po.getCtx(), tableScriptValidator.getAD_Rule_ID());
            if (rule != null && rule.isActive() && rule.getRuleType().equals("S") && rule.getEventType().equals("D")) {
                String error;
                try {
                    ScriptEngine engine = rule.getScriptEngine();
                    MRule.setContext(engine, po.getCtx(), 0);
                    engine.put("A_Ctx", po.getCtx());
                    engine.put("A_PO", po);
                    engine.put("A_Type", docTiming);
                    engine.put("A_Event", ModelValidator.documentEventValidators[docTiming]);
                    Object retval = engine.eval(rule.getScript());
                    error = retval == null ? "" : retval.toString();
                }
                catch (Exception e) {
                    throw new AdempiereException(e);
                }
                if (error != null && error.length() > 0) {
                    throw new AdempiereException(error);
                }
            }
        }));
        return null;
    }

    private String fireDocValidate(PO po, int docTiming, List<ModelValidator> modelValidators) {
        Optional.ofNullable(modelValidators).ifPresent(modelValidatorList -> modelValidatorList.stream().filter(modelValidator -> modelValidator.getAD_Client_ID() == po.getAD_Client_ID() || this.globalValidators.contains(modelValidator)).forEach(modelValidator -> {
            try {
                String error = modelValidator.docValidate(po, docTiming);
                if (error != null && error.length() > 0) {
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "po=" + po + " validator=" + modelValidator + " timing=" + docTiming);
                    }
                    throw new AdempiereException(error);
                }
            }
            catch (Exception e) {
                log.log(Level.SEVERE, e.getLocalizedMessage(), e);
                String error = e.getLocalizedMessage();
                if (error == null) {
                    error = e.toString();
                }
                throw new AdempiereException(error);
            }
        }));
        return null;
    }

    public void addFactsValidate(String tableName, FactsValidator listener) {
        if (tableName == null || listener == null) {
            return;
        }
        String propertyName = this.globalValidators.contains(listener) ? tableName + "*" : tableName + listener.getAD_Client_ID();
        List<FactsValidator> factsValidators = this.factsValidateListeners.get(propertyName);
        if (factsValidators == null) {
            factsValidators = new ArrayList<FactsValidator>();
            factsValidators.add(listener);
            this.factsValidateListeners.put(propertyName, factsValidators);
        } else {
            factsValidators.add(listener);
        }
    }

    public void addImportValidate(String importTableName, ImportValidator listener) {
        String propertyName = importTableName + "*";
        List<ImportValidator> importValidators = this.importValidateListeners.get(propertyName);
        if (importValidators == null) {
            importValidators = new ArrayList<ImportValidator>();
            importValidators.add(listener);
            this.importValidateListeners.put(propertyName, importValidators);
        } else {
            importValidators.add(listener);
        }
    }

    public void removeFactsValidate(String tableName, FactsValidator listener) {
        if (tableName == null || listener == null) {
            return;
        }
        String propertyName = this.globalValidators.contains(listener) ? tableName + "*" : tableName + listener.getAD_Client_ID();
        List<FactsValidator> factsValidators = this.factsValidateListeners.get(propertyName);
        if (factsValidators == null) {
            return;
        }
        factsValidators.remove(listener);
        if (factsValidators.size() == 0) {
            this.factsValidateListeners.remove(propertyName);
        }
    }

    public String fireFactsValidate(MAcctSchema schema, List<Fact> facts, PO po) {
        String error;
        if (schema == null || facts == null || po == null || this.factsValidateListeners.size() == 0) {
            return null;
        }
        String propertyName = po.get_TableName() + "*";
        List<FactsValidator> factsValidators = this.factsValidateListeners.get(propertyName);
        if (factsValidators != null && (error = this.fireFactsValidate(schema, facts, po, factsValidators)) != null && error.length() > 0) {
            return error;
        }
        propertyName = po.get_TableName() + po.getAD_Client_ID();
        factsValidators = this.factsValidateListeners.get(propertyName);
        if (factsValidators != null && (error = this.fireFactsValidate(schema, facts, po, factsValidators)) != null && error.length() > 0) {
            return error;
        }
        return null;
    }

    private String fireFactsValidate(MAcctSchema schema, List<Fact> facts, PO po, List<FactsValidator> factsValidators) {
        Optional.ofNullable(factsValidators).ifPresent(factsValidatorList -> factsValidatorList.stream().filter(factsValidator -> factsValidator.getAD_Client_ID() == po.getAD_Client_ID() || this.globalValidators.contains(factsValidator)).forEach(factsValidator -> {
            try {
                String error = factsValidator.factsValidate(schema, facts, po);
                if (error != null && error.length() > 0) {
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "po=" + po + " schema=" + schema + " validator=" + factsValidator);
                    }
                    throw new AdempiereException(error);
                }
            }
            catch (Exception e) {
                log.log(Level.SEVERE, e.getLocalizedMessage(), e);
                String error = e.getLocalizedMessage();
                if (error == null) {
                    error = e.toString();
                }
                throw new AdempiereException(error);
            }
        }));
        return null;
    }

    public void fireImportValidate(ImportProcess process, PO importModel, PO targetModel, int timing) {
        String propertyName = process.getImportTableName() + "*";
        Optional.ofNullable(this.importValidateListeners.get(propertyName)).ifPresent(importValidateListenerList -> importValidateListenerList.stream().filter(Objects::nonNull).forEach(importValidator -> importValidator.validate(process, importModel, targetModel, timing)));
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelValidationEngine[");
        sb.append("Validators=#").append(this.validators.size()).append(", ModelChange=#").append(this.modelChangeListeners.size()).append(", DocValidate=#").append(this.documentValidateListeners.size()).append("]");
        return sb.toString();
    }

    public StringBuffer getInfoDetail(StringBuffer sb, Properties ctx) {
        List<ModelValidator> list;
        if (sb == null) {
            sb = new StringBuffer();
        }
        sb.append("=== ModelValidationEngine ===").append(Env.NL);
        sb.append("Validators #").append(this.validators.size()).append(Env.NL);
        for (ModelValidator modelValidator : this.validators) {
            sb.append(modelValidator.toString()).append(Env.NL);
        }
        sb.append(Env.NL).append(Env.NL);
        sb.append("ModelChange #").append(this.modelChangeListeners.size()).append(Env.NL);
        for (String key : this.modelChangeListeners.keySet()) {
            list = this.modelChangeListeners.get(key);
            for (ModelValidator modelValidator : list) {
                sb.append(key).append(": ").append(modelValidator.toString()).append(Env.NL);
            }
        }
        sb.append(Env.NL).append(Env.NL);
        sb.append("DocValidate #").append(this.documentValidateListeners.size()).append(Env.NL);
        for (String key : this.documentValidateListeners.keySet()) {
            list = this.documentValidateListeners.get(key);
            for (ModelValidator modelValidator : list) {
                sb.append(key).append(": ").append(modelValidator.toString()).append(Env.NL);
            }
        }
        sb.append(Env.NL).append(Env.NL);
        return sb;
    }

    public void afterLoadPreferences(Properties ctx) {
        int clientId = Env.getAD_Client_ID(ctx);
        Optional.ofNullable(this.validators).ifPresent(validatorList -> validatorList.stream().filter(modelValidator -> modelValidator.getAD_Client_ID() == clientId || this.globalValidators.contains(modelValidator)).forEach(modelValidator -> {
            Method method = null;
            try {
                method = modelValidator.getClass().getMethod("afterLoadPreferences", Properties.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            try {
                if (method != null) {
                    method.invoke(modelValidator, ctx);
                }
            }
            catch (Exception e) {
                log.warning(modelValidator + ": " + e.getLocalizedMessage());
            }
        }));
    }

    public void beforeSaveProperties() {
        int clientId = Env.getAD_Client_ID(Env.getCtx());
        Optional.ofNullable(this.validators).ifPresent(validatorList -> validatorList.stream().filter(modelValidator -> modelValidator.getAD_Client_ID() == clientId || this.globalValidators.contains(modelValidator)).forEach(modelValidator -> {
            Method method = null;
            try {
                method = modelValidator.getClass().getMethod("beforeSaveProperties", new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            try {
                if (method != null) {
                    method.invoke(modelValidator, new Object[0]);
                }
            }
            catch (Exception e) {
                log.warning(modelValidator + ": " + e.getLocalizedMessage());
            }
        }));
    }
}

