/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.print;

public class PrintDataColumn {
    private int columnId;
    private String columnName;
    private int displayType;
    private int columnSize;
    private String alias;
    private boolean pageBreak;
    private String formatPattern;
    private int printFormatItemId;
    private boolean isHideGrandTotal;
    private int sortOrderIndex = -1;
    private int displayOrderIndex = -1;

    public PrintDataColumn(int columnId, String columnName, int displayType, int columnSize, String alias, boolean isPageBreak, int printFormatItemId, boolean isHideGrandTotal) {
        this.columnId = columnId;
        this.columnName = columnName;
        this.displayType = displayType;
        this.columnSize = columnSize;
        this.alias = alias;
        if (alias == null) {
            alias = columnName;
        }
        this.pageBreak = isPageBreak;
        this.printFormatItemId = printFormatItemId;
        this.isHideGrandTotal = isHideGrandTotal;
    }

    public int getAD_Column_ID() {
        return this.columnId;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public int getDisplayType() {
        return this.displayType;
    }

    public String getAlias() {
        return this.alias;
    }

    public boolean hasAlias() {
        return !this.columnName.equals(this.alias);
    }

    public boolean isPageBreak() {
        return this.pageBreak;
    }

    public int getPrinformatItemId() {
        return this.printFormatItemId;
    }

    public boolean isHideGrandTotal() {
        return this.isHideGrandTotal;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("PrintDataColumn[");
        sb.append("ID=").append(this.columnId).append("-").append(this.columnName);
        if (this.hasAlias()) {
            sb.append("(").append(this.alias).append(")");
        }
        sb.append(",DisplayType=").append(this.displayType).append(",Size=").append(this.columnSize).append("]");
        return sb.toString();
    }

    public void setFormatPattern(String formatPattern) {
        this.formatPattern = formatPattern;
    }

    public String getFormatPattern() {
        return this.formatPattern;
    }

    public int getSortOrderIndex() {
        return this.sortOrderIndex;
    }

    public void setSortOrderIndex(int sortOrderIndex) {
        this.sortOrderIndex = sortOrderIndex;
    }

    public int getDisplayOrderIndex() {
        return this.displayOrderIndex;
    }

    public void setDisplayOrderIndex(int displayOrderIndex) {
        this.displayOrderIndex = displayOrderIndex;
    }
}

