/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.print.layout;

import com.itextpdf.io.IOException;
import java.awt.Container;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import java.util.logging.Level;
import javax.imageio.ImageIO;
import org.compiere.model.MAttachment;
import org.compiere.model.MImage;
import org.compiere.print.MPrintFormatItem;
import org.compiere.print.PrintDataElement;
import org.compiere.print.layout.PrintElement;
import org.compiere.util.CCache;
import org.compiere.util.Env;

public class ImageElement
extends PrintElement {
    private static CCache<Object, ImageElement> s_cache = new CCache("ImageElement", 10, 60);
    private Image m_image = null;
    private double m_scaleFactor = 1.0;

    public static ImageElement get(String imageURLString) {
        String key = imageURLString;
        ImageElement image = s_cache.get(key);
        if (image == null) {
            image = new ImageElement(imageURLString);
            s_cache.put(key, image);
        }
        return new ImageElement(image.getImage());
    }

    public static ImageElement get(URL imageURL) {
        URL key = imageURL;
        ImageElement image = s_cache.get(key);
        if (image == null) {
            image = new ImageElement(imageURL);
            s_cache.put(key, image);
        }
        return new ImageElement(image.getImage());
    }

    public static ImageElement get(int AD_PrintFormatItem_ID) {
        Integer key = AD_PrintFormatItem_ID;
        ImageElement image = s_cache.get(key);
        if (image == null) {
            image = new ImageElement(AD_PrintFormatItem_ID);
            s_cache.put(key, image);
        }
        return new ImageElement(image.getImage());
    }

    public static ImageElement get(PrintDataElement data, String imageURLString) {
        BigDecimal key = (BigDecimal)data.getValue();
        ImageElement image = s_cache.get(key);
        if (image == null) {
            BigDecimal imkeybd = (BigDecimal)data.getValue();
            int imkeyint = 0;
            if (imkeybd != null) {
                imkeyint = imkeybd.intValue();
            }
            image = new ImageElement(imkeyint, false);
            s_cache.put(key, image);
        }
        return new ImageElement(image.getImage());
    }

    public ImageElement(Image image) {
        this.m_image = image;
        if (this.m_image != null) {
            this.log.fine("Image=" + image);
        } else {
            this.log.log(Level.WARNING, "Image is NULL");
        }
    }

    private ImageElement(String imageURLstring) {
        URL imageURL = this.getURL(imageURLstring);
        if (imageURL != null) {
            try {
                Toolkit tk = Toolkit.getDefaultToolkit();
                this.m_image = tk.getDefaultToolkit().getImage(imageURL);
                MediaTracker mediaTracker = new MediaTracker(new Container());
                mediaTracker.addImage(this.m_image, 0);
                mediaTracker.waitForID(0);
            }
            catch (Exception e) {
                this.log.log(Level.WARNING, "(byteArray)", e);
            }
            if (this.m_image != null) {
                this.log.fine("URL=" + imageURL);
            } else {
                this.log.log(Level.WARNING, "Not loaded - URL=" + imageURL);
            }
        } else {
            this.log.log(Level.WARNING, "Invalid URL=" + imageURLstring);
        }
    }

    private ImageElement(URL imageURL) {
        if (imageURL != null) {
            try {
                Toolkit tk = Toolkit.getDefaultToolkit();
                this.m_image = tk.getDefaultToolkit().getImage(imageURL);
                MediaTracker mediaTracker = new MediaTracker(new Container());
                mediaTracker.addImage(this.m_image, 0);
                mediaTracker.waitForID(0);
            }
            catch (Exception e) {
                this.log.log(Level.WARNING, "(byteArray)", e);
            }
            if (this.m_image != null) {
                this.log.fine("URL=" + imageURL);
            } else {
                this.log.log(Level.WARNING, "Not loaded - URL=" + imageURL);
            }
        } else {
            this.log.severe("ImageURL is NULL");
        }
    }

    private ImageElement(int AD_PrintFormatItem_ID) {
        this.loadAttachment(AD_PrintFormatItem_ID);
    }

    public ImageElement(int record_ID, boolean isAttachment) {
        if (isAttachment) {
            this.loadAttachment(record_ID);
        } else {
            this.loadFromDB(record_ID);
        }
    }

    private URL getURL(String urlString) {
        URL url = null;
        if (urlString.indexOf("://") == -1) {
            ClassLoader cl = this.getClass().getClassLoader();
            url = cl.getResource(urlString);
            if (url != null) {
                return url;
            }
            this.log.log(Level.WARNING, "Not found - " + urlString);
            return null;
        }
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException ex) {
            this.log.log(Level.WARNING, urlString, ex);
        }
        return url;
    }

    private void loadFromDB(int record_ID) {
        MImage mimage = MImage.get(Env.getCtx(), record_ID);
        if (mimage == null) {
            this.log.log(Level.WARNING, "No Image - record_ID=" + record_ID);
            return;
        }
        byte[] imageData = mimage.getData();
        if (imageData != null) {
            try {
                BufferedImage bufferedImage = ImageIO.read(new ByteArrayInputStream(imageData));
                this.m_image = bufferedImage;
            }
            catch (Exception e) {
                this.log.log(Level.WARNING, "(byteArray)", e);
            }
        }
        if (this.m_image != null) {
            this.log.fine(mimage.toString() + " - Size=" + imageData.length);
        } else {
            this.log.log(Level.WARNING, mimage.toString() + " - not loaded (must be gif or jpg) - record_ID=" + record_ID);
        }
    }

    private void loadAttachment(int AD_PrintFormatItem_ID) {
        MAttachment attachment = MAttachment.get(Env.getCtx(), MPrintFormatItem.Table_ID, AD_PrintFormatItem_ID);
        if (attachment == null) {
            this.log.log(Level.WARNING, "No Attachment - AD_PrintFormatItem_ID=" + AD_PrintFormatItem_ID);
            return;
        }
        if (attachment.getEntryCount() != 1) {
            this.log.log(Level.WARNING, "Need just 1 Attachment Entry = " + attachment.getEntryCount());
            return;
        }
        byte[] imageData = attachment.getEntryData(0);
        if (imageData != null) {
            try {
                BufferedImage bufferedImage = ImageIO.read(new ByteArrayInputStream(imageData));
                if (bufferedImage != null) {
                    this.m_image = bufferedImage;
                    MPrintFormatItem printFormatItem = MPrintFormatItem.getById(Env.getCtx(), AD_PrintFormatItem_ID, null);
                    if (printFormatItem.getMaxWidth() > 0 && printFormatItem.getMaxHeight() > 0) {
                        this.p_maxHeight = printFormatItem.getMaxHeight();
                        this.p_maxWidth = printFormatItem.getMaxWidth();
                        this.calculateSize();
                        this.m_image = this.resizeImage(bufferedImage, (int)this.p_width, (int)this.p_height);
                    }
                }
            }
            catch (Exception e) {
                this.log.log(Level.WARNING, "(byteArray)", e);
            }
        }
        if (this.m_image != null) {
            this.log.fine(attachment.getEntryName(0) + " - Size=" + imageData.length);
        } else {
            this.log.log(Level.WARNING, attachment.getEntryName(0) + " - not loaded (must be gif or jpg) - AD_PrintFormatItem_ID=" + AD_PrintFormatItem_ID);
        }
    }

    private BufferedImage resizeImage(BufferedImage originalImage, int targetWidth, int targetHeight) throws IOException {
        Image resultingImage = originalImage.getScaledInstance(targetWidth, targetHeight, 2);
        BufferedImage outputImage = new BufferedImage(targetWidth, targetHeight, 1);
        outputImage.getGraphics().drawImage(resultingImage, 0, 0, null);
        return outputImage;
    }

    @Override
    protected boolean calculateSize() {
        this.p_width = 0.0f;
        this.p_height = 0.0f;
        if (this.m_image == null) {
            return true;
        }
        if (this.waitForLoad(this.m_image) && this.m_image != null) {
            this.p_width = this.m_image.getWidth(this);
            this.p_height = this.m_image.getHeight(this);
            if (this.p_width * this.p_height == 0.0f) {
                return true;
            }
            this.m_scaleFactor = 1.0;
            if (this.p_maxWidth != 0.0f && this.p_width > this.p_maxWidth) {
                this.m_scaleFactor = this.p_maxWidth / this.p_width;
            }
            if (this.p_maxHeight != 0.0f && this.p_height > this.p_maxHeight && (double)(this.p_maxHeight / this.p_height) < this.m_scaleFactor) {
                this.m_scaleFactor = this.p_maxHeight / this.p_height;
            }
            this.p_width = (float)this.m_scaleFactor * this.p_width;
            this.p_height = (float)this.m_scaleFactor * this.p_height;
        } else {
            this.m_image = null;
        }
        return true;
    }

    public Image getImage() {
        return this.m_image;
    }

    public double getScaleFactor() {
        if (!this.p_sizeCalculated) {
            this.p_sizeCalculated = this.calculateSize();
        }
        return this.m_scaleFactor;
    }

    @Override
    public void paint(Graphics2D g2D, int pageNo, Point2D pageStart, Properties ctx, boolean isView) {
        if (this.m_image == null) {
            return;
        }
        Point2D.Double location = this.getAbsoluteLocation(pageStart);
        int x = (int)location.x;
        if ("T".equals(this.p_FieldAlignmentType)) {
            x = (int)((float)x + (this.p_maxWidth - this.p_width));
        } else if ("C".equals(this.p_FieldAlignmentType)) {
            x = (int)((float)x + (this.p_maxWidth - this.p_width) / 2.0f);
        }
        int y = (int)location.y;
        AffineTransform transform = new AffineTransform();
        transform.translate(x, y);
        transform.scale(this.m_scaleFactor, this.m_scaleFactor);
        g2D.drawImage(this.m_image, transform, this);
    }
}

