/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.model.MAllocationHdr;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;

public class AllocationReset
extends SvrProcess {
    private int p_C_BP_Group_ID = 0;
    private int p_C_BPartner_ID = 0;
    private Timestamp p_DateAcct_From = null;
    private Timestamp p_DateAcct_To = null;
    private int p_C_AllocationHdr_ID = 0;
    private boolean p_AllAllocations = false;
    private Trx m_trx = null;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i = 0; i < para.length; ++i) {
            this.log.fine("prepare - " + para[i]);
            String name = para[i].getParameterName();
            if (para[i].getParameter() == null) continue;
            if (name.equals("C_BP_Group_ID")) {
                this.p_C_BP_Group_ID = para[i].getParameterAsInt();
                continue;
            }
            if (name.equals("C_BPartner_ID")) {
                this.p_C_BPartner_ID = para[i].getParameterAsInt();
                continue;
            }
            if (name.equals("C_AllocationHdr_ID")) {
                this.p_C_AllocationHdr_ID = para[i].getParameterAsInt();
                continue;
            }
            if (name.equals("DateAcct")) {
                this.p_DateAcct_From = (Timestamp)para[i].getParameter();
                this.p_DateAcct_To = (Timestamp)para[i].getParameter_To();
                continue;
            }
            if (name.equals("AllAllocations")) {
                this.p_AllAllocations = "Y".equals(para[i].getParameter());
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
        if (!this.p_AllAllocations && this.getTable_ID() == MAllocationHdr.Table_ID && this.getRecord_ID() > 0) {
            this.p_C_AllocationHdr_ID = this.getRecord_ID();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String doIt() throws Exception {
        this.log.info("C_BP_Group_ID=" + this.p_C_BP_Group_ID + ", C_BPartner_ID=" + this.p_C_BPartner_ID + ", DateAcct= " + this.p_DateAcct_From + " - " + this.p_DateAcct_To + ", C_AllocationHdr_ID=" + this.p_C_AllocationHdr_ID + ", AllAllocations=" + this.p_AllAllocations);
        if (this.p_C_AllocationHdr_ID == 0 && !this.p_AllAllocations) {
            throw new AdempiereUserError(Msg.parseTranslation(this.getCtx(), "@Mandatory@: @C_AllocationHdr_ID@"));
        }
        this.m_trx = Trx.get(Trx.createTrxName("AllocReset"), true);
        int count = 0;
        if (this.p_C_AllocationHdr_ID != 0) {
            MAllocationHdr hdr = new MAllocationHdr(this.getCtx(), this.p_C_AllocationHdr_ID, this.m_trx.getTrxName());
            if (this.delete(hdr)) {
                ++count;
            }
            this.m_trx.close();
            return "@Deleted@ #" + count;
        }
        StringBuffer sql = new StringBuffer("SELECT * FROM C_AllocationHdr ah WHERE EXISTS (SELECT * FROM C_AllocationLine al WHERE ah.C_AllocationHdr_ID=al.C_AllocationHdr_ID");
        if (this.p_C_BPartner_ID != 0) {
            sql.append(" AND al.C_BPartner_ID=?");
        } else if (this.p_C_BP_Group_ID != 0) {
            sql.append(" AND EXISTS (SELECT * FROM C_BPartner bp WHERE bp.C_BPartner_ID=al.C_BPartner_ID AND bp.C_BP_Group_ID=?)");
        } else {
            sql.append(" AND AD_Client_ID=?");
        }
        if (this.p_DateAcct_From != null) {
            sql.append(" AND TRIM(ah.DateAcct) >= ?");
        }
        if (this.p_DateAcct_To != null) {
            sql.append(" AND TRIM(ah.DateAcct) <= ?");
        }
        sql.append(" AND al.C_CashLine_ID IS NULL)");
        sql.append(" AND EXISTS (SELECT * FROM C_Period p INNER JOIN C_PeriodControl pc ON (p.C_Period_ID=pc.C_Period_ID AND pc.DocBaseType='CMA') WHERE ah.DateAcct BETWEEN p.StartDate AND p.EndDate)");
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql.toString(), this.m_trx.getTrxName());
            int index = 1;
            if (this.p_C_BPartner_ID != 0) {
                pstmt.setInt(index++, this.p_C_BPartner_ID);
            } else if (this.p_C_BP_Group_ID != 0) {
                pstmt.setInt(index++, this.p_C_BP_Group_ID);
            } else {
                pstmt.setInt(index++, Env.getAD_Client_ID(this.getCtx()));
            }
            if (this.p_DateAcct_From != null) {
                pstmt.setTimestamp(index++, this.p_DateAcct_From);
            }
            if (this.p_DateAcct_To != null) {
                pstmt.setTimestamp(index++, this.p_DateAcct_To);
            }
            rs = pstmt.executeQuery();
            while (rs.next()) {
                MAllocationHdr hdr = new MAllocationHdr(this.getCtx(), rs, this.m_trx.getTrxName());
                if (!this.delete(hdr)) continue;
                ++count;
            }
        }
        catch (Exception e) {
            try {
                this.log.log(Level.SEVERE, sql.toString(), e);
                this.m_trx.rollback();
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        this.m_trx.close();
        return "@Deleted@ #" + count;
    }

    private boolean delete(MAllocationHdr hdr) {
        boolean success = false;
        if (hdr.delete(true, this.m_trx.getTrxName())) {
            this.log.fine(hdr.toString());
            success = true;
        }
        if (success) {
            success = this.m_trx.commit();
        } else {
            this.m_trx.rollback();
        }
        return success;
    }

    private void setBPartner() {
    }
}

