/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.util.logging.Level;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MLocator;
import org.compiere.model.MOrg;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MRole;
import org.compiere.model.MRoleOrgAccess;
import org.compiere.model.MWarehouse;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereUserError;

public class BPartnerOrgLink
extends SvrProcess {
    private int p_AD_Org_ID;
    private int p_AD_OrgType_ID;
    private int p_C_BPartner_ID;
    private int p_AD_Role_ID;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i = 0; i < para.length; ++i) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() == null) continue;
            if (name.equals("AD_Org_ID")) {
                this.p_AD_Org_ID = para[i].getParameterAsInt();
                continue;
            }
            if (name.equals("AD_OrgType_ID")) {
                this.p_AD_OrgType_ID = para[i].getParameterAsInt();
                continue;
            }
            if (name.equals("AD_Role_ID")) {
                this.p_AD_Role_ID = para[i].getParameterAsInt();
                continue;
            }
            this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + name);
        }
        this.p_C_BPartner_ID = this.getRecord_ID();
    }

    @Override
    protected String doIt() throws Exception {
        MWarehouse[] whs;
        this.log.info("C_BPartner_ID=" + this.p_C_BPartner_ID + ", AD_Org_ID=" + this.p_AD_Org_ID + ", AD_OrgType_ID=" + this.p_AD_OrgType_ID + ", AD_Role_ID=" + this.p_AD_Role_ID);
        if (this.p_C_BPartner_ID == 0) {
            throw new AdempiereUserError("No Business Partner ID");
        }
        MBPartner bp = new MBPartner(this.getCtx(), this.p_C_BPartner_ID, this.get_TrxName());
        if (bp.get_ID() == 0) {
            throw new AdempiereUserError("Business Partner not found - C_BPartner_ID=" + this.p_C_BPartner_ID);
        }
        MBPartnerLocation[] locs = bp.getLocations(false);
        if (locs == null || locs.length == 0) {
            throw new IllegalArgumentException("Business Partner has no Location");
        }
        int C_Location_ID = locs[0].getC_Location_ID();
        if (C_Location_ID == 0) {
            throw new IllegalArgumentException("Business Partner Location has no Address");
        }
        boolean newOrg = this.p_AD_Org_ID == 0;
        MOrg org = new MOrg(this.getCtx(), this.p_AD_Org_ID, this.get_TrxName());
        if (newOrg) {
            org.setValue(bp.getValue());
            org.setName(bp.getName());
            org.setDescription(bp.getDescription());
            if (!org.save()) {
                throw new Exception("Organization not saved");
            }
        } else {
            int C_BPartner_ID = org.getLinkedC_BPartner_ID(this.get_TrxName());
            if (C_BPartner_ID > 0) {
                throw new IllegalArgumentException("Organization '" + org.getName() + "' already linked (to C_BPartner_ID=" + C_BPartner_ID + ")");
            }
        }
        this.p_AD_Org_ID = org.getAD_Org_ID();
        MOrgInfo oInfo = org.getInfo();
        oInfo.setAD_OrgType_ID(this.p_AD_OrgType_ID);
        if (newOrg) {
            oInfo.setC_Location_ID(C_Location_ID);
        }
        MWarehouse wh = null;
        if (!newOrg && (whs = MWarehouse.getForOrg(this.getCtx(), this.p_AD_Org_ID)) != null && whs.length > 0) {
            wh = whs[0];
        }
        if (wh == null && !(wh = new MWarehouse(org)).save(this.get_TrxName())) {
            throw new Exception("Warehouse not saved");
        }
        MLocator mLoc = wh.getDefaultLocator();
        if (mLoc == null) {
            mLoc = new MLocator(wh, "Standard");
            mLoc.setIsDefault(true);
            mLoc.save(this.get_TrxName());
        }
        oInfo.setM_Warehouse_ID(wh.getM_Warehouse_ID());
        if (!oInfo.save(this.get_TrxName())) {
            throw new Exception("Organization Info not saved");
        }
        bp.setAD_OrgBP_ID(this.p_AD_Org_ID);
        if (bp.getAD_Org_ID() != 0) {
            bp.setClientOrg(bp.getAD_Client_ID(), 0);
        }
        if (!bp.save()) {
            throw new Exception("Business Partner not updated");
        }
        if (this.p_AD_Role_ID != 0) {
            boolean found = false;
            MRoleOrgAccess[] orgAccesses = MRoleOrgAccess.getOfOrg(this.getCtx(), this.p_AD_Org_ID);
            for (int i = 0; i < orgAccesses.length; ++i) {
                if (orgAccesses[i].getAD_Role_ID() == this.p_AD_Role_ID) {
                    found = true;
                    continue;
                }
                orgAccesses[i].delete(true);
            }
            if (!found) {
                MRoleOrgAccess orgAccess = new MRoleOrgAccess(org, this.p_AD_Role_ID);
                orgAccess.save(this.get_TrxName());
            }
        }
        MRole.getDefault(this.getCtx(), true);
        return "Business Partner - Organization Link created";
    }
}

