/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.logging.Level;
import org.compiere.model.MBPartner;
import org.compiere.model.MInvoice;
import org.compiere.model.MPayment;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.Msg;

public class BPartnerValidate
extends SvrProcess {
    int p_C_BPartner_ID = 0;
    int p_C_BP_Group_ID = 0;

    @Override
    protected void prepare() {
        this.p_C_BPartner_ID = this.getRecord_ID();
        ProcessInfoParameter[] para = this.getParameter();
        for (int i = 0; i < para.length; ++i) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() == null) continue;
            if (name.equals("C_BPartner_ID")) {
                this.p_C_BPartner_ID = para[i].getParameterAsInt();
                continue;
            }
            if (name.equals("C_BP_Group_ID")) {
                this.p_C_BP_Group_ID = para[i].getParameterAsInt();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
    }

    @Override
    protected String doIt() throws Exception {
        this.log.info("C_BPartner_ID=" + this.p_C_BPartner_ID + ", C_BP_Group_ID=" + this.p_C_BP_Group_ID);
        if (this.p_C_BPartner_ID == 0 && this.p_C_BP_Group_ID == 0) {
            throw new AdempiereUserError("No Business Partner/Group selected");
        }
        if (this.p_C_BP_Group_ID == 0) {
            MBPartner bp = new MBPartner(this.getCtx(), this.p_C_BPartner_ID, this.get_TrxName());
            if (bp.get_ID() == 0) {
                throw new AdempiereUserError("Business Partner not found - C_BPartner_ID=" + this.p_C_BPartner_ID);
            }
            this.checkBP(bp);
        } else {
            String whereClause = "C_BP_Group_ID=?";
            Iterator it = new Query(this.getCtx(), "C_BPartner", "C_BP_Group_ID=?", this.get_TrxName()).setParameters(this.p_C_BP_Group_ID).setOnlyActiveRecords(true).iterate();
            while (it.hasNext()) {
                this.checkBP((MBPartner)it.next());
            }
        }
        return "OK";
    }

    private void checkBP(MBPartner bp) throws SQLException {
        this.addLog(0, null, null, bp.getName() + ":");
        this.checkPayments(bp);
        this.checkInvoices(bp);
        bp.setTotalOpenBalance();
        bp.setActualLifeTimeValue();
        bp.saveEx();
        this.addLog(0, null, bp.getSO_CreditUsed(), Msg.getElement(this.getCtx(), "SO_CreditUsed"));
        this.addLog(0, null, bp.getTotalOpenBalance(), Msg.getElement(this.getCtx(), "TotalOpenBalance"));
        this.addLog(0, null, bp.getActualLifeTimeValue(), Msg.getElement(this.getCtx(), "ActualLifeTimeValue"));
        this.commitEx();
    }

    private void checkPayments(MBPartner bp) {
        int changed = 0;
        MPayment[] payments = MPayment.getOfBPartner(this.getCtx(), bp.getC_BPartner_ID(), this.get_TrxName());
        for (int i = 0; i < payments.length; ++i) {
            MPayment payment = payments[i];
            if (!payment.testAllocation()) continue;
            payment.saveEx();
            ++changed;
        }
        if (changed != 0) {
            this.addLog(0, null, new BigDecimal(payments.length), Msg.getElement(this.getCtx(), "C_Payment_ID") + " - #" + changed);
        }
    }

    private void checkInvoices(MBPartner bp) {
        int changed = 0;
        MInvoice[] invoices = MInvoice.getOfBPartner(this.getCtx(), bp.getC_BPartner_ID(), this.get_TrxName());
        for (int i = 0; i < invoices.length; ++i) {
            MInvoice invoice = invoices[i];
            if (!invoice.testAllocation()) continue;
            invoice.saveEx();
            ++changed;
        }
        if (changed != 0) {
            this.addLog(0, null, new BigDecimal(invoices.length), Msg.getElement(this.getCtx(), "C_Invoice_ID") + " - #" + changed);
        }
    }
}

