/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.util.logging.Level;
import org.compiere.model.MBPartner;
import org.compiere.model.MCommission;
import org.compiere.model.MCommissionRun;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Env;

public class CommissionAPInvoice
extends SvrProcess {
    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i = 0; i < para.length; ++i) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() == null) continue;
            this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + name);
        }
    }

    @Override
    protected String doIt() throws Exception {
        this.log.info("doIt - C_CommissionRun_ID=" + this.getRecord_ID());
        MCommissionRun comRun = new MCommissionRun(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
        if (comRun.get_ID() == 0) {
            throw new IllegalArgumentException("CommissionAPInvoice - No Commission Run");
        }
        if (Env.ZERO.compareTo(comRun.getGrandTotal()) == 0) {
            throw new IllegalArgumentException("@GrandTotal@ = 0");
        }
        MCommission com = new MCommission(this.getCtx(), comRun.getC_Commission_ID(), this.get_TrxName());
        if (com.get_ID() == 0) {
            throw new IllegalArgumentException("CommissionAPInvoice - No Commission");
        }
        if (com.getC_Charge_ID() == 0) {
            throw new IllegalArgumentException("CommissionAPInvoice - No Charge on Commission");
        }
        MBPartner bp = new MBPartner(this.getCtx(), com.getC_BPartner_ID(), this.get_TrxName());
        if (bp.get_ID() == 0) {
            throw new IllegalArgumentException("CommissionAPInvoice - No BPartner");
        }
        MInvoice invoice = new MInvoice(this.getCtx(), 0, null);
        invoice.setClientOrg(com.getAD_Client_ID(), com.getAD_Org_ID());
        invoice.setC_DocTypeTarget_ID("API");
        invoice.setBPartner(bp);
        invoice.setSalesRep_ID(this.getAD_User_ID());
        if (com.getC_Currency_ID() != invoice.getC_Currency_ID()) {
            throw new IllegalArgumentException("CommissionAPInvoice - Currency of PO Price List not Commission Currency");
        }
        if (!invoice.save()) {
            throw new IllegalStateException("CommissionAPInvoice - cannot save Invoice");
        }
        MInvoiceLine iLine = new MInvoiceLine(invoice);
        iLine.setC_Charge_ID(com.getC_Charge_ID());
        iLine.setQty(1);
        iLine.setPrice(comRun.getGrandTotal());
        iLine.setTax();
        if (!iLine.save()) {
            throw new IllegalStateException("CommissionAPInvoice - cannot save Invoice Line");
        }
        return "@C_Invoice_ID@ = " + invoice.getDocumentNo();
    }
}

