/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.util.logging.Level;
import org.compiere.model.MColumn;
import org.compiere.model.MTable;
import org.compiere.model.M_Element;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereSystemError;

public class CopyColumnsFromTable
extends SvrProcess {
    private int p_target_AD_Table_ID = 0;
    private int p_source_AD_Table_ID = 0;
    private int m_count = 0;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i = 0; i < para.length; ++i) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() == null) continue;
            if (name.equals("AD_Table_ID")) {
                this.p_source_AD_Table_ID = para[i].getParameterAsInt();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
        this.p_target_AD_Table_ID = this.getRecord_ID();
    }

    @Override
    protected String doIt() throws Exception {
        if (this.p_target_AD_Table_ID == 0) {
            throw new AdempiereSystemError("@NotFound@ @AD_Table_ID@ " + this.p_target_AD_Table_ID);
        }
        if (this.p_source_AD_Table_ID == 0) {
            throw new AdempiereSystemError("@NotFound@ @AD_Table_ID@ " + this.p_source_AD_Table_ID);
        }
        this.log.info("Source AD_Table_ID=" + this.p_source_AD_Table_ID + ", Target AD_Table_ID=" + this.p_target_AD_Table_ID);
        MTable targetTable = new MTable(this.getCtx(), this.p_target_AD_Table_ID, this.get_TrxName());
        MColumn[] targetColumns = targetTable.getColumns(true);
        MTable sourceTable = new MTable(this.getCtx(), this.p_source_AD_Table_ID, this.get_TrxName());
        MColumn[] sourceColumns = sourceTable.getColumns(true);
        for (int i = 0; i < sourceColumns.length; ++i) {
            boolean foundColumn = false;
            MColumn colTarget = new MColumn(targetTable);
            for (MColumn col : targetColumns) {
                String columnName = null;
                columnName = sourceColumns[i].getColumnName().equals(sourceTable.getTableName() + "_ID") ? new String(targetTable.getTableName() + "_ID") : sourceColumns[i].getColumnName();
                if (!col.getColumnName().equals(columnName)) continue;
                foundColumn = true;
                break;
            }
            if (foundColumn) continue;
            if (sourceColumns[i].getColumnName().equals(sourceTable.getTableName() + "_ID")) {
                String targetColumnName = new String(targetTable.getTableName() + "_ID");
                colTarget.setColumnName(targetColumnName);
                M_Element element = M_Element.get(this.getCtx(), targetColumnName);
                if (element == null) {
                    element = new M_Element(this.getCtx(), targetColumnName, targetTable.getEntityType(), this.get_TrxName());
                    if (targetColumnName.equalsIgnoreCase(targetTable.getTableName() + "_ID")) {
                        element.setColumnName(targetTable.getTableName() + "_ID");
                        element.setName(targetTable.getName());
                        element.setPrintName(targetTable.getName());
                    }
                    element.save(this.get_TrxName());
                }
                colTarget.setAD_Element_ID(element.getAD_Element_ID());
                colTarget.setName(targetTable.getName());
                colTarget.setDescription(targetTable.getDescription());
                colTarget.setHelp(targetTable.getHelp());
            } else {
                colTarget.setColumnName(sourceColumns[i].getColumnName());
                colTarget.setAD_Element_ID(sourceColumns[i].getAD_Element_ID());
                colTarget.setName(sourceColumns[i].getName());
                colTarget.setDescription(sourceColumns[i].getDescription());
                colTarget.setHelp(sourceColumns[i].getHelp());
            }
            colTarget.setVersion(sourceColumns[i].getVersion());
            colTarget.setAD_Val_Rule_ID(sourceColumns[i].getAD_Val_Rule_ID());
            colTarget.setDefaultValue(sourceColumns[i].getDefaultValue());
            colTarget.setFieldLength(sourceColumns[i].getFieldLength());
            colTarget.setIsKey(sourceColumns[i].isKey());
            colTarget.setIsParent(sourceColumns[i].isParent());
            colTarget.setIsMandatory(sourceColumns[i].isMandatory());
            colTarget.setIsTranslated(sourceColumns[i].isTranslated());
            colTarget.setIsIdentifier(sourceColumns[i].isIdentifier());
            colTarget.setSeqNo(sourceColumns[i].getSeqNo());
            colTarget.setIsEncrypted(sourceColumns[i].getIsEncrypted());
            colTarget.setAD_Reference_ID(sourceColumns[i].getAD_Reference_ID());
            colTarget.setAD_Reference_Value_ID(sourceColumns[i].getAD_Reference_Value_ID());
            colTarget.setIsActive(sourceColumns[i].isActive());
            colTarget.setVFormat(sourceColumns[i].getVFormat());
            colTarget.setCallout(sourceColumns[i].getCallout());
            colTarget.setIsUpdateable(sourceColumns[i].isUpdateable());
            colTarget.setAD_Process_ID(sourceColumns[i].getAD_Process_ID());
            colTarget.setValueMin(sourceColumns[i].getValueMin());
            colTarget.setValueMax(sourceColumns[i].getValueMax());
            colTarget.setIsSelectionColumn(sourceColumns[i].isSelectionColumn());
            colTarget.setReadOnlyLogic(sourceColumns[i].getReadOnlyLogic());
            colTarget.setIsSyncDatabase(sourceColumns[i].getIsSyncDatabase());
            colTarget.setIsAlwaysUpdateable(sourceColumns[i].isAlwaysUpdateable());
            colTarget.setColumnSQL(sourceColumns[i].getColumnSQL());
            colTarget.save(this.get_TrxName());
            ++this.m_count;
        }
        return "#" + this.m_count;
    }
}

