/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.logging.Level;
import org.compiere.model.MBPartner;
import org.compiere.model.MDistributionList;
import org.compiere.model.MDistributionListLine;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Env;

public class DistributionCreate
extends SvrProcess {
    private int p_M_Product_ID = 0;
    private BigDecimal p_Qty;
    private boolean p_IsCreateSingleOrder;
    private int p_Bill_BPartner_ID;
    private int p_Bill_Location_ID;
    private boolean p_IsTest;
    private int p_M_DistributionList_ID;
    private MDistributionList m_dl;
    private MOrder m_singleOrder = null;
    private MProduct m_product = null;
    private BigDecimal m_totalQty = Env.ZERO;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i = 0; i < para.length; ++i) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() == null) continue;
            if (name.equals("M_Product_ID")) {
                this.p_M_Product_ID = para[i].getParameterAsInt();
                continue;
            }
            if (name.equals("Qty")) {
                this.p_Qty = (BigDecimal)para[i].getParameter();
                continue;
            }
            if (name.equals("IsCreateSingleOrder")) {
                this.p_IsCreateSingleOrder = "Y".equals(para[i].getParameter());
                continue;
            }
            if (name.equals("Bill_BPartner_ID")) {
                this.p_Bill_BPartner_ID = para[i].getParameterAsInt();
                continue;
            }
            if (name.equals("p_Bill_Location_ID")) {
                this.p_Bill_Location_ID = para[i].getParameterAsInt();
                continue;
            }
            if (name.equals("IsTest")) {
                this.p_IsTest = "Y".equals(para[i].getParameter());
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
        this.p_M_DistributionList_ID = this.getRecord_ID();
    }

    @Override
    protected String doIt() throws Exception {
        this.log.info("M_DistributionList_ID=" + this.p_M_DistributionList_ID + ", M_Product_ID=" + this.p_M_Product_ID + ", Qty=" + this.p_Qty + ", Test=" + this.p_IsTest);
        if (this.p_IsCreateSingleOrder) {
            this.log.info("SingleOrder=" + this.p_IsCreateSingleOrder + ", BPartner_ID=" + this.p_Bill_BPartner_ID + ", Location_ID=" + this.p_Bill_Location_ID);
        }
        if (this.p_M_DistributionList_ID == 0) {
            throw new IllegalArgumentException("No Distribution List ID");
        }
        this.m_dl = new MDistributionList(this.getCtx(), this.p_M_DistributionList_ID, this.get_TrxName());
        if (this.m_dl.get_ID() == 0) {
            throw new Exception("Distribution List not found -  M_DistributionList_ID=" + this.p_M_DistributionList_ID);
        }
        if (this.p_M_Product_ID == 0) {
            throw new IllegalArgumentException("No Product");
        }
        this.m_product = MProduct.get(this.getCtx(), this.p_M_Product_ID);
        if (this.m_product.get_ID() == 0) {
            throw new Exception("Product not found -  M_Product_ID=" + this.p_M_Product_ID);
        }
        if (this.p_Qty == null || this.p_Qty.signum() != 1) {
            throw new IllegalArgumentException("No Quantity");
        }
        if (this.p_IsCreateSingleOrder && this.p_Bill_BPartner_ID == 0) {
            throw new IllegalArgumentException("Invoice Business Partner required for single Order");
        }
        if (!this.p_IsTest && this.p_IsCreateSingleOrder) {
            MBPartner bp = new MBPartner(this.getCtx(), this.p_Bill_BPartner_ID, this.get_TrxName());
            if (bp.get_ID() == 0) {
                throw new IllegalArgumentException("Single Business Partner not found - C_BPartner_ID=" + this.p_Bill_BPartner_ID);
            }
            this.m_singleOrder = new MOrder(this.getCtx(), 0, this.get_TrxName());
            this.m_singleOrder.setIsSOTrx(true);
            this.m_singleOrder.setC_DocTypeTarget_ID("SO");
            this.m_singleOrder.setBPartner(bp);
            if (this.p_Bill_Location_ID != 0) {
                this.m_singleOrder.setC_BPartner_Location_ID(this.p_Bill_Location_ID);
            }
            if (!this.m_singleOrder.save()) {
                throw new IllegalStateException("Single Order not created");
            }
        }
        MDistributionListLine[] lines = this.m_dl.getLines();
        int counter = 0;
        for (int i = 0; i < lines.length; ++i) {
            if (!this.createOrder(lines[i])) continue;
            ++counter;
        }
        if (this.m_singleOrder != null) {
            this.m_singleOrder.setDescription("# " + counter + " - " + this.m_totalQty);
            this.m_singleOrder.saveEx();
        }
        return "@Created@ #" + counter + " - @Qty@=" + this.m_totalQty;
    }

    private boolean createOrder(MDistributionListLine dll) {
        BigDecimal minQty;
        BigDecimal ratio;
        BigDecimal qty;
        MBPartner bp = new MBPartner(this.getCtx(), dll.getC_BPartner_ID(), this.get_TrxName());
        if (bp.get_ID() == 0) {
            throw new IllegalArgumentException("Business Partner not found - C_BPartner_ID=" + dll.getC_BPartner_ID());
        }
        MOrder order = this.m_singleOrder;
        if (!this.p_IsTest && order == null) {
            order = new MOrder(this.getCtx(), 0, this.get_TrxName());
            order.setIsSOTrx(true);
            order.setC_DocTypeTarget_ID("SO");
            order.setBPartner(bp);
            if (dll.getC_BPartner_Location_ID() != 0) {
                order.setC_BPartner_Location_ID(dll.getC_BPartner_Location_ID());
            }
            if (!order.save()) {
                this.log.log(Level.SEVERE, "Order not saved");
                return false;
            }
        }
        if ((qty = this.p_Qty.multiply(ratio = dll.getRatio())).compareTo(Env.ZERO) != 0) {
            qty = qty.divide(this.m_dl.getRatioTotal(), this.m_product.getUOMPrecision(), RoundingMode.HALF_UP);
        }
        if (qty.compareTo(minQty = dll.getMinQty()) < 0) {
            qty = minQty;
        }
        this.m_totalQty = this.m_totalQty.add(qty);
        if (this.p_IsTest) {
            this.addLog(0, null, qty, bp.getName());
            return false;
        }
        MOrderLine line = new MOrderLine(order);
        line.setC_BPartner_ID(dll.getC_BPartner_ID());
        if (dll.getC_BPartner_Location_ID() != 0) {
            line.setC_BPartner_Location_ID(dll.getC_BPartner_Location_ID());
        }
        line.setM_Product_ID(this.p_M_Product_ID, true);
        line.setQty(qty);
        line.setPrice();
        if (!line.save()) {
            this.log.log(Level.SEVERE, "OrderLine not saved");
            return false;
        }
        this.addLog(0, null, qty, order.getDocumentNo() + ": " + bp.getName());
        return true;
    }
}

