/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.logging.Level;
import org.adempiere.core.domains.models.X_I_InOutLineConfirm;
import org.compiere.model.MInOutLineConfirm;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class ImportInOutConfirm
extends SvrProcess {
    private int p_AD_Client_ID = 0;
    private boolean p_DeleteOldImported = false;
    private int p_I_InOutLineConfirm_ID = 0;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i = 0; i < para.length; ++i) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() == null) continue;
            if (name.equals("AD_Client_ID")) {
                this.p_AD_Client_ID = ((BigDecimal)para[i].getParameter()).intValue();
                continue;
            }
            if (name.equals("DeleteOldImported")) {
                this.p_DeleteOldImported = "Y".equals(para[i].getParameter());
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
        this.p_I_InOutLineConfirm_ID = this.getRecord_ID();
    }

    @Override
    protected String doIt() throws Exception {
        this.log.info("I_InOutLineConfirm_ID=" + this.p_I_InOutLineConfirm_ID);
        StringBuffer sql = null;
        int no = 0;
        String clientCheck = " AND AD_Client_ID=" + this.p_AD_Client_ID;
        if (this.p_DeleteOldImported) {
            sql = new StringBuffer("DELETE I_InOutLineConfirm WHERE I_IsImported='Y'").append(clientCheck);
            no = DB.executeUpdate(sql.toString(), this.get_TrxName());
            this.log.fine("Delete Old Impored =" + no);
        }
        sql = new StringBuffer("UPDATE I_InOutLineConfirm SET IsActive = COALESCE (IsActive, 'Y'), Created = COALESCE (Created, SysDate), CreatedBy = COALESCE (CreatedBy, 0), Updated = COALESCE (Updated, SysDate), UpdatedBy = COALESCE (UpdatedBy, 0), I_ErrorMsg = ' ', I_IsImported = 'N' WHERE I_IsImported<>'Y' OR I_IsImported IS NULL");
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        this.log.info("Reset=" + no);
        sql = new StringBuffer("UPDATE I_InOutLineConfirm i SET AD_Client_ID=COALESCE (AD_Client_ID,").append(this.p_AD_Client_ID).append(") WHERE (AD_Client_ID IS NULL OR AD_Client_ID=0) AND I_IsImported<>'Y'");
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        this.log.fine("Set Client from Value=" + no);
        sql = new StringBuffer("UPDATE I_InOutLineConfirm i SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid Confirmation Line, 'WHERE (M_InOutLineConfirm_ID IS NULL OR M_InOutLineConfirm_ID=0 OR NOT EXISTS (SELECT * FROM M_InOutLineConfirm c WHERE i.M_InOutLineConfirm_ID=c.M_InOutLineConfirm_ID)) AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        if (no != 0) {
            this.log.warning("Invalid InOutLineConfirm=" + no);
        }
        if ((no = DB.executeUpdate((sql = new StringBuffer("UPDATE I_InOutLineConfirm i SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Missing Confirmation No, 'WHERE (ConfirmationNo IS NULL OR ConfirmationNo='') AND I_IsImported<>'Y'").append(clientCheck)).toString(), this.get_TrxName())) != 0) {
            this.log.warning("Invalid ConfirmationNo=" + no);
        }
        if ((no = DB.executeUpdate((sql = new StringBuffer("UPDATE I_InOutLineConfirm i SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Target<>(Confirmed+Difference+Scrapped), ' WHERE EXISTS (SELECT * FROM M_InOutLineConfirm c WHERE i.M_InOutLineConfirm_ID=c.M_InOutLineConfirm_ID AND c.TargetQty<>(i.ConfirmedQty+i.ScrappedQty+i.DifferenceQty)) AND I_IsImported<>'Y'").append(clientCheck)).toString(), this.get_TrxName())) != 0) {
            this.log.warning("Invalid Qty=" + no);
        }
        this.commitEx();
        CPreparedStatement pstmt = null;
        sql = new StringBuffer("SELECT * FROM I_InOutLineConfirm WHERE I_IsImported='N'").append(clientCheck).append(" ORDER BY I_InOutLineConfirm_ID");
        no = 0;
        try {
            pstmt = DB.prepareStatement(sql.toString(), this.get_TrxName());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                X_I_InOutLineConfirm importLine = new X_I_InOutLineConfirm(this.getCtx(), rs, this.get_TrxName());
                MInOutLineConfirm confirmLine = new MInOutLineConfirm(this.getCtx(), importLine.getM_InOutLineConfirm_ID(), this.get_TrxName());
                if (confirmLine.get_ID() == 0 || confirmLine.get_ID() != importLine.getM_InOutLineConfirm_ID()) {
                    importLine.setI_IsImported(false);
                    importLine.setI_ErrorMsg("ID Not Found");
                    importLine.saveEx();
                    continue;
                }
                confirmLine.setConfirmationNo(importLine.getConfirmationNo());
                confirmLine.setConfirmedQty(importLine.getConfirmedQty());
                confirmLine.setDifferenceQty(importLine.getDifferenceQty());
                confirmLine.setScrappedQty(importLine.getScrappedQty());
                confirmLine.setDescription(importLine.getDescription());
                if (!confirmLine.save()) continue;
                importLine.setI_IsImported(true);
                importLine.setProcessed(true);
                if (!importLine.save()) continue;
                ++no;
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql.toString(), e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        return "@Updated@ #" + no;
    }
}

